#!/bin/bash
#
# NAME
#   multistation-audio-session-startup.sh
#
# AUTHOR
#   Rocky
#
# Maintainer
# 	Jason Kim <jason@userful.com>
#
# DESCRIPTION
# 	- This is run as login user, not root.
#   - Set the default volume of the assigned alsa device.
#
# Copyright (c) 2004-2007 by Userful Corporation.
#
# Called from: 
#   - multistation-devices-session-startup.sh (GNOME - default.session)
#   - kde-multistation-devices-session-startup.sh (KDE - Autostart)
#
# Call : oss_session_init.sh

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`
CONFIG_FILE="/etc/usbaudio"
DEFAULT_VOLUME="70%"

if [ ! -f /etc/userful/os-info ]; then
	/opt/userful/bin/dm-check-os.sh
fi
source /etc/userful/os-info

#Get current screen string to match in /etc/usbaudio
CUR_SCREEN_STR="Srn$DISPLAY" # Srn:#.0
ALSA_CARD_STR=`grep $CUR_SCREEN_STR $CONFIG_FILE | awk '{print $2}'` # hw:#

if [ -z "$ALSA_CARD_STR" ]; then
	# No audio deivce assigned on current screen.
	echo "`date +"%b %d %T"` $ProgramName: No audio device assigned for DISPLAY=$DISPLAY" >> $logfile

	exit 1

else 
	# found a assigned audio device, need to do some more stuff.
	echo "`date +"%b %d %T"` $ProgramName: Session start with DISPLAY=$DISPLAY, alsa device=$ALSA_CARD_STR" >> $logfile

	# getting alsa device number.
	ALSA_CARD=`echo $ALSA_CARD_STR | sed 's/^...//g'`
	#DEV_VENDOR=`grep $CUR_SCREEN_STR $CONFIG_FILE | awk '{print $1}'`

    ## Speaker Settings
	# Unmute audio device and set volume 
    # It might be needed to disable Master for builtin speaker 
	amixer set -c $ALSA_CARD Master $DEFAULT_VOLUME unmute > /dev/null 2>&1  
	amixer set -c $ALSA_CARD 'Master Mono' $DEFAULT_VOLUME unmute > /dev/null 2>&1
	amixer set -c $ALSA_CARD Headphone $DEFAULT_VOLUME unmute > /dev/null 2>&1
	amixer set -c $ALSA_CARD PCM $DEFAULT_VOLUME unmute > /dev/null 2>&1
	amixer set -c $ALSA_CARD Speaker $DEFAULT_VOLUME unmute > /dev/null 2>&1

    ## Micophone Settings
    ## mute playback and enable capture
	amixer set -c $ALSA_CARD 'Mic' 80% mute cap > /dev/null 2>&1


    # Check if Pulseaudio is installed 
    if which pulseaudio > /dev/null 2>&1; then
        # Create .asoundrc and .default.pa
        /opt/userful/bin/multistation-audio-gen-conf.sh $ALSA_CARD

        ## Ubuntu uses Xsession.d to start pulseaudio
        if [ -e /etc/X11/Xsession.d/*pulseaudio ]; then
            if `pulseaudio --check`; then
	            echo "`date +"%b %d %T"` $ProgramName: pulseaudio is already running. Need to restart.." >> $logfile
                pulseaudio --kill
            fi
	        echo "`date +"%b %d %T"` $ProgramName: Start pulseaudio.." >> $logfile
            pulseaudio --start --log-target=stderr 2>> $logfile

        else
	        echo "`date +"%b %d %T"` $ProgramName: Start pulseaudio manually.." >> $logfile
            pulseaudio -D true --use-pid-file=false >> $logfile 2>&1
        fi

    else
        # Pulseaudio is not founded. Configure .asoundrc
	   /opt/userful/bin/oss_session_init.sh $ALSA_CARD
    fi

    # Play login sound with default device
    aplay -Dplug:default /usr/share/sounds/userful-startup.wav

    # TODO:
    #   - It might be needed to configure application to use correct sound device
    #   - Rocky used following..
	#     /opt/userful/bin/audio_apps_init.sh $window_manager
fi

