#!/bin/bash
#
# 	multistation-audio-hotplug.sh
#
# 	Author:
# 		Jason Kim <jason@userful.com>
#
# 	Copyright (c) 2002-2007 by Userful Corporation
#
# 	Description:
# 		  This scipt is run as a HAL fdi callout function when a audio device is added/removed and should be
# 		located at /usr/$LIB/hal/scripts directory.
#
# 	Called from: 99-userful-policy.fdi

logfile="/var/log/userful-start.log"
CONFIG_FILE="/etc/usbaudio"
ProgramName=`basename $0`

if [ ! -e /var/run/x.pid -o ! -d /proc/`cat /var/run/x.pid` ]; then
	# If MX is not running, just exit.
	exit 1
fi


if [ "$HALD_ACTION" == "remove" ] ; then

	echo "`date +"%b %d %T"` $ProgramName:(Hotplug) $HAL_PROP_ALSA_DEVICE_FILE removed. hw:$HAL_PROP_ALSA_CARD" >> $logfile

	if [ -f $CONFIG_FILE ]; then
		#Remove device from usbaudio. add a new line if the removed device was configured manually.
		cp -f $CONFIG_FILE $CONFIG_FILE.old

		ALSA_DEV="hw:$HAL_PROP_ALSA_CARD"
		sed -i -e "/$ALSA_DEV/d" $CONFIG_FILE

		# Save the current device's configuration if it was manually configured.
		PRE_ASSIGNED_FLAG=`grep "$ALSA_DEV" $CONFIG_FILE.old | awk '{print $4}'`
		if [ "$PRE_ASSIGNED_FLAG" == "W" ]; then
			echo "`date +"%b %d %T"` $ProgramName: $ALSA_DEV has been manually configured." >> $logfile
    		grep "$ALSA_DEV" $CONFIG_FILE.old | awk '{print "N/A","N/A",$3,$4,$5}' >> $CONFIG_FILE
		fi

	else
		# Create /etc/usbaudio file
		/opt/userful/bin/multistation-audio-refresh.sh
	fi

    ##################################################
    # Abinav's update to enable audio without relogin
    ##################################################
	DEV_REMOVED="`diff $CONFIG_FILE $CONFIG_FILE.old`"
	SCREEN_INFO=`echo $DEV_REMOVED | awk '{print$5}'`
	SCREEN_NUM=`echo $SCREEN_INFO | awk -F':' '{print $2}' | awk -F'.' '{print $1}'`

	USER_NAME=`cat /opt/userful/locks/user.screen$SCREEN_NUM`

	#Kill the pulseaudio daemon for the existing user.

	`su $USER_NAME -c "pulseaudio -k"`

	#
	# Display message to user about dropped audio device 
	#
	#ZENITY_PID=`ps aux|grep $USER_NAME|grep zenity| awk '{print $2}'`

	export DISPLAY=:$SCREEN_NUM.0
	if [ -e /opt/userful/pixmaps/userful-logo-64.png ]; then
		`su $USER_NAME -c 'xhost local:$USER_NAME; zenity --warning --window-icon=/opt/userful/pixmaps/userful-logo-64.png \
		--title="Audio Device Disconnected" \
		--text "To continue using sound, please unplug and replug the audio device, then restart applications \
that use audio.

Examples: web browsers, media players, games" 2> /dev/null &'`
	
	elif [ -e /opt/userful/pixmaps/userful-logo-ubuntu.png ]; then
		`su $USER_NAME -c 'xhost local:$USER_NAME; zenity --warning --window-icon=/opt/userful/pixmaps/userful-logo-ubuntu.png \
		--title="Audio Device Disconnected" \
		--text "To continue using sound, please unplug and replug the audio device, then restart applications \
that use audio.

Examples: web browsers, media players, games" 2> /dev/null &'`

	else
		`su $USER_NAME -c 'xhost local:$USER_NAME; zenity --warning 
		--title="Audio Device Disconnected" \
		--text "To continue using sound, please unplug and replug the audio device, then restart applications \
that use audio.

Examples: web browsers, media players, games" 2> /dev/null &'`

	fi
    ##################################################
    # Abinav's update to enable audio without relogin
    ##################################################

elif [ "$HALD_ACTION" == "add" ] ; then
	echo "`date +"%b %d %T"` $ProgramName:(Hotplug) $HAL_PROP_ALSA_DEVICE_FILE added. hw:$HAL_PROP_ALSA_CARD" >> $logfile

	ALSA_CARD="$HAL_PROP_ALSA_CARD"

	# Find device vendor name
	PARENT_UDI="$HAL_PROP_INFO_PARENT"
	PARENT_SUBSYSTEM=`hal-get-property --udi "$PARENT_UDI" --key "linux.subsystem"`

	if [ "$PARENT_SUBSYSTEM" == "usb" ]; then
		# USB audio device
		DEV_VENDOR=`hal-get-property --udi "$PARENT_UDI" --key "usb.vendor"`

	elif [ "$PARENT_SUBSYSTEM" == "pci" ]; then
		# PCI audio device
		DEV_VENDOR=`hal-get-property --udi "$PARENT_UDI" --key "pci.vendor"`

	elif [ "$PARENT_SUBSYSTEM" == "sound" ]; then
		# Newer devices parents' subsystem is sound
		DEV_VENDOR=`hal-get-property --udi "$PARENT_UDI" --key "sound.card_id"`
	else
		# Unknown type audio device
		DEV_VENDOR=`hal-get-property --udi "$PARENT_UDI" --key "info.vendor"`
	fi

	if [ "$DEV_VENDOR" == "" ]; then
		DEV_VENDOR="Unkown"
	else # remove blank
		DEV_VENDOR=`echo $DEV_VENDOR | tr "[[:blank:]]" "_"`
	fi

	# Find device sys path
	DEV_PATH=`hal-get-property --udi "$PARENT_UDI" --key "linux.sysfs_path"`
	PRE_ASSIGNED_SCREEN=
	PRE_ASSIGNED_FLAG=

    #############################
    # Abinav's update
    ############################
## Info about preassigned screen was copied in $CONFIG_FILE.old when device was removed
## Why are we looking in $CONFIG_FILE??
#	if [ -f $CONFIG_FILE ]; then
#		PRE_ASSIGNED_SCREEN=`grep $DEV_PATH $CONFIG_FILE | awk '{print $3}'`
#		echo "$ProgramName: (Debug) Preassigned screen was $PRE_ASSIGNED_SCREEN" >>$logfile
#		PRE_ASSIGNED_FLAG=`grep $DEV_PATH $CONFIG_FILE | awk '{print $4}'`
#	fi
#
## TODO: Add support for manual configuration with flas "W" later

	if [ -f $CONFIG_FILE.old ]; then
		PRE_ASSIGNED_SCREEN=`grep $DEV_PATH $CONFIG_FILE.old | awk '{print $3}'`
		PRE_ASSIGNED_FLAG=`grep $DEV_PATH $CONFIG_FILE.old | awk '{print $4}'`
	fi

	if [ "$PRE_ASSIGNED_SCREEN" != "" -a "$PRE_ASSIGNED_FLAG" == "R/W" ] ; then
		# If the current audio device was configured manually before, follow the old configuration.
		echo "`date +"%b %d %T"` $ProgramName: Found $DEV_VENDOR($PARENT_SUBSYSTEM) on $CONFIG_FILE."  >> $logfile
		ASSIGNED_SCREEN="$PRE_ASSIGNED_SCREEN"
		ASSIGNED_FLAG="$PRE_ASSIGNED_FLAG"

##		ASSIGNED_FLAG="W" 	## Later when we support manual comnfiguration
		echo "$ProgramName: (Debug) Assigned Screen : $ASSIGNED_SCREEN Assigned Flag : $ASSIGNED_FLAG"

		if [ "${ASSIGNED_SCREEN:0:4}" == "Srn:" ]; then
			SCREEN_NUM=`echo $ASSIGNED_SCREEN | awk -F':' '{print $2}' | awk -F'.' '{print $1}'`
		else
			SCREEN_NUM="-1"
		fi

	else
		if [ "$PARENT_SUBSYSTEM" == "usb" -o "$PARENT_SUBSYSTEM" == "sound" ]; then
			# Find screen number base on the current audio device path

			SCREEN_NUM=`/opt/userful/bin/get-screen-num-from-devpath -T 12 -P $DEV_PATH 2>/dev/null`
			echo "Screen Num = $SCREEN_NUM"
			if [ "$SCREEN_NUM" == "-1" ]; then
				# Couldn't find screen number for the current audio device
				echo "no screen_num"  >> $logfile
				ASSIGNED_SCREEN="Disabled"
			else
				ASSIGNED_SCREEN="Srn:$SCREEN_NUM.0"
			fi

		else # It may not possible to get hotplug event from other device type than usb.
			echo "parent is not usb"  >> $logfile
			ASSIGNED_SCREEN="Disabled"
		fi

		ASSIGNED_FLAG="R/W"
	fi

	if [ "$ASSIGNED_SCREEN" != "Disabled" ]; then
		# Check if there is any audio device already assigned to the same screen.
		# If then, disable the old device.
		if [ -f $CONFIG_FILE ]; then
			CONFLICT=`grep -c $ASSIGNED_SCREEN $CONFIG_FILE`

			if [ $CONFLICT -gt 0 ]; then
				echo "`date +"%b %d %T"` $ProgramName:(Hotplug) Another audio device already assigned to screen $ASSIGNED_SCREEN" >> $logfile
				sed -i -e "s/$ASSIGNED_SCREEN/Disabled/g" $CONFIG_FILE
			fi
		fi

		#Deal with popup message when hotplug USB audio device only when station is log in.
   		if [ -f /etc/stations ] && [ -f /etc/startat ]; then
			STARTAT=`cat /etc/startat`
			REAL_STATION_NUM=`expr $SCREEN_NUM + $STARTAT`

           	if [ -e /opt/userful/locks/username$REAL_STATION_NUM ]; then
           		echo 1 > /opt/userful/locks/audio$REAL_STATION_NUM
			fi
		fi
	fi

	# remove same device entry(s) from /etc/usbaudio
	if [ -f $CONFIG_FILE -a "$DEV_PATH" != "" ]; then
		DEL_STR=`basename $DEV_PATH`
		sed -i -e "/$DEL_STR/d" $CONFIG_FILE
	fi

	# add current device to the config file /etc/usbaudio
	echo "`date +"%b %d %T"` $ProgramName:(Hotplug) Assign hw:$ALSA_CARD to $ASSIGNED_SCREEN." >> $logfile
	echo "$DEV_VENDOR($PARENT_SUBSYSTEM) hw:$ALSA_CARD $ASSIGNED_SCREEN $ASSIGNED_FLAG $DEV_PATH" >> $CONFIG_FILE
	chmod 644 $CONFIG_FILE


    ####################################
    ## Abinav's update
    ####################################
	## change ownership of alsa devices.

	USER_NAME=`cat /opt/userful/locks/user.screen$SCREEN_NUM`
	HOME_DIR=`su $USER_NAME -c "cd; pwd"`

		#
		# restart pulseaudio daemon to allow audio control
		# make sure that the hardware number assigned to the stations
		# and that specified in the pulseaudio config file are same.
		#

		if [ -d $HOME_DIR/.pulse ]; then
			 PRE_ASSIGNED_HW=`cat $HOME_DIR/.pulse/default.pa|grep module-alsa-sink|awk '{print $3}'|awk -F '=' '{print $2}'|awk -F ':' '{print $2}'`
		fi
		echo "$ProgramName: (Debug) Preassigned HW = $PRE_ASSIGNED_HW, Alsa Card = $ALSA_CARD" >> $logfile
	
			
		if [ $PRE_ASSIGNED_HW == $ALSA_CARD ] ; then
			`su $USER_NAME -c "pulseaudio -D true --use-pid-file=true"`
		else
			 # Change the pulseaudio config file to include the new hardware
                	 `su $USER_NAME -c "/opt/userful/bin/multistation-audio-gen-conf.sh $ALSA_CARD"`
	                 `su $USER_NAME -c "pulseaudio -D true --use-pid-file=true"`
		fi	
	
	
	if [ -n "$USER_NAME" -a $ASSIGNED_SCREEN != "Disabled" ]; then


		if [ "$ALSA_CARD" == "0" ]; then  ## The newer kernels dont append a 0 for ALSA_CARD # 0. 
			chown $USER_NAME /dev/dsp 2> /dev/null
	        	chmod 600 /dev/dsp 2> /dev/null

        		chown $USER_NAME /dev/audio 2> /dev/null
	        	chmod 600 /dev/audio 2> /dev/null

        		chown $USER_NAME /dev/mixer 2> /dev/null
	        	chmod 600 /dev/mixer 2> /dev/null
	 	else
			
	       		chown $USER_NAME /dev/dsp$ALSA_CARD 2> /dev/null
		        chmod 600 /dev/dsp$ALSA_CARD 2> /dev/null

        		chown $USER_NAME /dev/audio$ALSA_CARD 2> /dev/null
		        chmod 600 /dev/audio$ALSA_CARD 2> /dev/null

        		chown $USER_NAME /dev/mixer$ALSA_CARD 2> /dev/null
		        chmod 600 /dev/mixer$ALSA_CARD 2> /dev/null
		fi

        	chown $USER_NAME /dev/snd/controlC$ALSA_CARD 2> /dev/null
	        chmod 600 /dev/snd/controlC$ALSA_CARD 2> /dev/null

        	chown $USER_NAME /dev/snd/pcmC$ALSA_CARD* 2> /dev/null
	        chmod 600 /dev/snd/pcmC$ALSA_CARD* 2> /dev/null

		#
		# restart pulseaudio daemon to allow audio control
		# make sure that the hardware number assigned to the stations
		# and that specified in the pulseaudio config file are same.
		#

		if [ -d $HOME_DIR/.pulse ]; then
			 PRE_ASSIGNED_HW=`cat $HOME_DIR/.pulse/default.pa|grep module-alsa-sink|awk '{print $3}'|awk -F '=' '{print $2}'|awk -F ':' '{print $2}'`
		fi
		echo "$ProgramName: (Debug) Preassigned HW = $PRE_ASSIGNED_HW, Alsa Card = $ALSA_CARD" >> $logfile
	
			
		if [ $PRE_ASSIGNED_HW == $ALSA_CARD ] ; then
			`su $USER_NAME -c "pulseaudio -D true --use-pid-file=true"`
		else
			 # Change the pulseaudio config file to include the new hardware
                	 `su $USER_NAME -c "/opt/userful/bin/multistation-audio-gen-conf.sh $ALSA_CARD"`
	                 `su $USER_NAME -c "pulseaudio -D true --use-pid-file=true"`
		fi	
	
		#
		# Display message to user about dropped audio device and possible restart
		# of application. Also ensure that only a single message is displayed inspite
		# of multiple devices being dropped.
       		#
		
		#	
		# remove the previous warning about dropped audio.
		#
			
		ZENITY_PID=`ps aux|grep $USER_NAME|grep zenity| awk '{print $2}'`

	        if [ "$ZENITY_PID" !=  "" ]; then	
			`kill -9 $ZENITY_PID`
		fi

		export DISPLAY=:$SCREEN_NUM.0

		if [ -e /opt/userful/pixmaps/userful-logo-64.png ]; then
			`su $USER_NAME -c 'xhost local:$USER_NAME; zenity --info --title "Audio Device Reconnected" --window-icon=/opt/userful/pixmaps/userful-logo-64.png \
			--text "Please restart applications that use audio.

Examples: web browsers, media players, games" 2> /dev/null &'`
		elif [ -e /opt/userful/pixmaps/userful-logo-ubuntu.png ]; then
			`su $USER_NAME -c 'xhost local:$USER_NAME; zenity --info --title "Audio Device Reconnected" --window-icon=/opt/userful/pixmaps/userful-logo-ubuntu.png \
			--text "Please restart applications that use audio.

Examples: web browsers, media players, games" 2> /dev/null &'`
		else
			`su $USER_NAME -c 'xhost local:$USER_NAME; zenity --info --title "Audio Device Reconnected" 
			--text "Please restart applications that use audio.

Examples: web browsers, media players, games" 2> /dev/null &'`	
		fi

	fi


else
	echo "`date +"%b %d %T"` $ProgramName: Unkown action for the ALSA device $HAL_PROP_ALSA_DEVICE_FILE." >> $logfile

fi

