#!/bin/bash

# Copyright (c) 2002-2008 Userful Corporation. All rights reserved.
# http://www.userful.com/

# check-and-install-license.sh

# this script checks to see if there is already a license
# installed. If there is a license installed, makse sure the license
# details file is up to date and then runs the update-license
# program. If a license is not installed it runs the
# install-license.sh script.


INSTALL_LICENSE_SCRIPT=/usr/share/umx-utils/install-license.sh

if [ $UID != 0 ] ; then
	zenity --error --text "You must have administrator privledges to run this program"
	exit 1
fi

# this file might be hanging around from a previous license
# (if there is no license, then dm-gen-info wont overwrite it)
rm -f /etc/userful/userful-license-info

# update the license details file
/opt/userful/bin/dm-gen-info -licenseinfo

if [ ! -f /etc/userful/userful-license-info ] ; then
	exec $INSTALL_LICENSE_SCRIPT
fi

source /etc/userful/userful-license-info
# this file should look something like this:

SAMPLE_FILE_CONTENTS='
# Number of stations
NUM_OF_STATIONS=6

# MAC address
MAC=E00-556E-0566-15F6

# Issued date
ISSUED_DATE=2008-11-17

# Expiry date
EXPIRY_DATE=0

# Interval of trial message
INTERVAL=20

# Duration of trial message
DURATION=30

# Product Name
PRODUCT="DiscoverStation"

# Reseller Name
RESELLER="Userful"
'

if [ -z "$NUM_OF_STATIONS" ] ; then
	exec $INSTALL_LICENSE_SCRIPT
fi

if [ "$NUM_OF_STATIONS" == 0 ] ; then
	exec $INSTALL_LICENSE_SCRIPT
fi

if [ "$NUM_OF_STATIONS" -lt 0 ] ; then
	exec $INSTALL_LICENSE_SCRIPT
fi

if [ -z "$MAC" ] ; then
	exec $INSTALL_LICENSE_SCRIPT
fi


COLON_COUNT=`echo $MAC | grep -c ':'`

if [ "$COLON_COUNT" == 5 ] ; then
	# we have a MAC address we also need the System id
	SYSID=`/opt/userful/bin/dm-gen-info -encode $MAC`
else
	# we must have a system id, get the mac
	SYSID=$MAC
	MAC=`/opt/userful/bin/dm-gen-info -decode $SYSID`
fi

DETAILS_FILE=/tmp/${0##*/}-$$
: > $DETAILS_FILE
echo "Number of stations: $NUM_OF_STATIONS" >> $DETAILS_FILE
echo "MAC Address: $MAC" >> $DETAILS_FILE
echo "UMx System ID: $SYSID" >> $DETAILS_FILE
echo "Last issued: $ISSUED_DATE " >> $DETAILS_FILE
if [ $RESELLER != Userful ] ; then
	echo "Reseller: $RESELLER" >> $DETAILS_FILE
fi

trap "rm -vf $DETAILS_FILE" exit

/usr/share/umx-utils/update-license.py -s $NUM_OF_STATIONS -d $DETAILS_FILE

RET=$?

if [ $RET != 0 ] ; then
	zenity --error --text "Failed to run install license program"
	exit 0
fi

exit 0
