#!/usr/bin/env python

# Copyright (c) 2002-2009 Userful Corporation. All rights reserved.
# http://www.userful.com/

# update-license.py

# this program is run when the user clicks the "Install license"
# button in the Control Panel and there is already a license
# installed. It will

import gtk
import os
import time
import sys
import signal
import gettext
import getopt

gettext.bindtextdomain('userful-control-panel')
gettext.textdomain('userful-control-panel')
_ = gettext.gettext

def print_help():
    sys.stderr.write("run the program like this: " + sys.argv[0] + "\n")
    sys.stderr.write("no arguments are required at this time\n")
    return
def on_main_window_destroy(dialog):
    gtk.main_quit()

def main_window_response(dialog, response_id, station_select_spin):
    if response_id == 1:
        #sys.stderr.write("pressed the cancel button\n")
        gtk.main_quit()

    if response_id == 2:
        
        try:
            spin_value = station_select_spin.get_value_as_int()
        except TypeError:
            sys.stderr.write("non-int value\n")
            return

        sys.stderr.write("pressed the install button: has a value of " + str(spin_value) + "\n")
        gtk.main_quit()
        os.system("/usr/share/umx-utils/install-license.sh -s " + str(spin_value) + " &")

    return

def main():
    num_curr_stations = 1
    details_file = None

    try:
        optlist, args = getopt.getopt(sys.argv[1:], "hs:d:", ["help", "stations=", "detailsfile="])
    except getopt.GetoptError:
        # print help information and exit:
        self.usage("Error in parsing arguments")
        sys.exit(2)

    file_name = "/dev/stdout"

    instruction_text = ""

    for o, a in optlist:
        if o in ("-h", "--help"):
            print_help()
            sys.exit(0)
        if o in ("-s", "--stations"):
            try:
                num_curr_stations = int(a)
            except ValueError:
                sys.stderr.write("invalid type passed for number of stations\n")
                sys.exit(1)
        if o in ("-d", "--detailsfile"):
            sys.stderr.write("got details file arg: " + a + "\n")
            if os.access(a, os.R_OK):
                details_file = file(a)
            else:
                sys.stderr.write("cannot read details file\n")
                details_file = None

    # setup the interface

    # translator: the text "%(num_stations)d" is replaced with a number
    main_label_text =  _("You already have a valid license key installed. Your license is for %(num_stations)d stations. If you want to retrieve a license with a different number of stations, change the value below.") % { 'num_stations' : num_curr_stations }
    main_label = gtk.Label(main_label_text)
    main_label.set_alignment(0.0, 0.5)
    main_label.set_line_wrap(True)

    station_select_label =  _("Number of stations:\n<i>Note: you may only increase the number of stations</i>") 

    station_select_label = gtk.Label(_("Number of stations:\n<i>Note: you may only increase the number of stations</i>") )
    station_select_label.set_use_markup(True)
    station_select_label.set_alignment(0.0, 0.5)

    station_select_spin = gtk.SpinButton()
    adjust = station_select_spin.get_adjustment()
    # set_all(value, lower, upper, step_increment, page_increment, page_size)
    adjust.set_all(num_curr_stations, num_curr_stations, 100, 1, 1, 1)
    station_select_spin.set_adjustment(adjust)
    # this doesn't work on SLED 10
    #station_select_spin.set_tooltip_text(_("Change value to number of desired stations"))

    station_select_spin_alignment = gtk.Alignment(0, 0, 0, 0)
    station_select_spin_alignment
    station_select_spin_alignment.add(station_select_spin)

    station_select_hbox = gtk.HBox()
    station_select_hbox.set_spacing(10)
    station_select_hbox.pack_start(station_select_label)
    station_select_hbox.pack_end(station_select_spin_alignment)

    
    if details_file is None:
        details_label = gtk.Label( _("<i>no details available</i>"))
        sys.stderr.write("no license details file provided\n")
    else:
        details = ""
        for line in details_file:
            details = details + line
            #details = details + "\n"
        details_label = gtk.Label(details)

    details_label.set_use_markup(True)
    details_label.set_alignment(0.0, 0.5)

    details_expander_align = gtk.Alignment()
    details_expander_align.set_padding(0,0,12,0)
    details_expander_align.add(details_label)

    details_expander = gtk.Expander(label="Current License Details")
    details_expander.add(details_expander_align)

    main_vbox = gtk.VBox()
    main_vbox.set_spacing(10)
    main_vbox.pack_start(main_label)
    main_vbox.pack_end(details_expander)
    main_vbox.pack_end(station_select_hbox)

    main_frame_align = gtk.Alignment()
    main_frame_align.set_padding(0,0,12,0)
    main_frame_align.add(main_vbox)

    main_frame = gtk.Frame("<b>Update License</b>")
    main_frame.get_label_widget().set_use_markup(True)
    main_frame.set_shadow_type(gtk.SHADOW_NONE)
    main_frame.add(main_frame_align)

    main_window = gtk.Dialog()
    main_window.set_title("Update License")
    logo_path = "/usr/share/umx-utils/userful-logo.svg"
    if os.access(logo_path, os.R_OK) == 1:
        main_window.set_icon_from_file(logo_path)
    main_window.set_position(gtk.WIN_POS_CENTER_ALWAYS)
    main_window.set_type_hint(gtk.gdk.WINDOW_TYPE_HINT_DIALOG)
    main_window.set_border_width(10)
    main_window.set_has_separator(False)
    main_window.add_button(gtk.STOCK_CANCEL, 1)
    main_window.add_button("Retreive & Install License", 2)
    main_window.connect("response", main_window_response, station_select_spin)
    main_window.connect("destroy", on_main_window_destroy)
    main_window.vbox.pack_start(main_frame)
    main_window.show_all()

    gtk.main()
    return

if __name__ == "__main__":
    main()
    sys.exit(0)
