/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.ssh.Cipher;
import de.mud.ssh.SshMisc;
import java.math.BigInteger;

class SshCrypto {
    private Cipher sndCipher;
    private Cipher rcvCipher;

    public SshCrypto(String type, byte[] key) {
        this.sndCipher = Cipher.getInstance(type);
        this.rcvCipher = Cipher.getInstance(type);
        this.sndCipher.setKey(key);
        this.rcvCipher.setKey(key);
    }

    public byte[] encrypt(byte[] block) {
        return this.sndCipher.encrypt(block);
    }

    public byte[] decrypt(byte[] block) {
        return this.rcvCipher.decrypt(block);
    }

    public static byte[] encrypteRSAPkcs1Twice(byte[] clearData, byte[] server_key_public_exponent, byte[] server_key_public_modulus, byte[] host_key_public_exponent, byte[] host_key_public_modulus) {
        int offset = 0;
        byte[] EncryptionBlock = new byte[server_key_public_modulus.length];
        EncryptionBlock[0] = 0;
        EncryptionBlock[1] = 2;
        offset = 2;
        int i = 2;
        while (i < EncryptionBlock.length - clearData.length - 1) {
            EncryptionBlock[offset++] = SshMisc.getNotZeroRandomByte();
            ++i;
        }
        EncryptionBlock[offset++] = 0;
        int i2 = 0;
        while (i2 < clearData.length) {
            EncryptionBlock[offset++] = clearData[i2];
            ++i2;
        }
        BigInteger m = new BigInteger(1, server_key_public_modulus);
        BigInteger e = new BigInteger(1, server_key_public_exponent);
        BigInteger message = new BigInteger(1, EncryptionBlock);
        message = message.modPow(e, m);
        byte[] messageByteTemp = message.toByteArray();
        byte[] messageByte = new byte[server_key_public_modulus.length];
        int tempOffset = 0;
        while (messageByteTemp[tempOffset] == 0) {
            ++tempOffset;
        }
        int i3 = messageByte.length - messageByteTemp.length + tempOffset;
        while (i3 < messageByte.length) {
            messageByte[i3] = messageByteTemp[tempOffset++];
            ++i3;
        }
        clearData = messageByte;
        offset = 0;
        EncryptionBlock = new byte[host_key_public_modulus.length];
        EncryptionBlock[0] = 0;
        EncryptionBlock[1] = 2;
        offset = 2;
        int i4 = 2;
        while (i4 < EncryptionBlock.length - clearData.length - 1) {
            EncryptionBlock[offset++] = SshMisc.getNotZeroRandomByte();
            ++i4;
        }
        EncryptionBlock[offset++] = 0;
        int i5 = 0;
        while (i5 < clearData.length) {
            EncryptionBlock[offset++] = clearData[i5];
            ++i5;
        }
        m = new BigInteger(1, host_key_public_modulus);
        e = new BigInteger(1, host_key_public_exponent);
        message = new BigInteger(1, EncryptionBlock);
        message = message.modPow(e, m);
        messageByteTemp = message.toByteArray();
        messageByte = new byte[host_key_public_modulus.length];
        tempOffset = 0;
        while (messageByteTemp[tempOffset] == 0) {
            ++tempOffset;
        }
        int i6 = messageByte.length - messageByteTemp.length + tempOffset;
        while (i6 < messageByte.length) {
            messageByte[i6] = messageByteTemp[tempOffset++];
            ++i6;
        }
        byte[] encrypted_session_key = new byte[host_key_public_modulus.length + 2];
        encrypted_session_key[1] = (byte)(8 * host_key_public_modulus.length & 0xFF);
        encrypted_session_key[0] = (byte)(8 * host_key_public_modulus.length >> 8 & 0xFF);
        int i7 = 0;
        while (i7 < host_key_public_modulus.length) {
            encrypted_session_key[i7 + 2] = messageByte[i7];
            ++i7;
        }
        return encrypted_session_key;
    }
}

