/*
 * VRwaveReader.java
 * read streamed input data
 *
 * created: mpichler, 19970814
 *
 * changed: mpichler, 19970822
 *
 * $Id: VRwaveReader.java,v 1.2 1997/09/19 14:48:21 mpichler Exp $
 */


import iicm.vrml.vrwave.*;

import java.io.InputStream;

import vrml.external.Browser;  // Java-EAI


class VRwaveReader implements Runnable
{
  Scene scene_;
  InputStream in_;  // PipedInputStream
  String baseurl_;
  boolean acceptdata_;


  VRwaveReader (Scene scene, InputStream in, String baseurl)
  {
    scene_ = scene;
    in_ = in;
    baseurl_ = baseurl;
    acceptdata_ = true;  // will start to read data when running
  }


  public void run ()
  {
    try
    { scene_.readScene (in_, baseurl_, null);
    }
    catch (Throwable t)
    { System.err.println ("Error during reading of VRML data: " + t);
    }
    acceptdata_ = false;  // will read no more data from pipe

    try
    { in_.close ();
    }
    catch (Throwable t)
    { System.err.println ("Error: could not close input side of pipe" + t);
    }

    // now that we have read the scene, we can activate the EAI connection
    Browser.startVRwave (scene_);  // register for EAI connection
  }

} // VRwaveReader
