#!/usr/local/bin/perl
# stop_portsentry.cgi
# Stop portsentry daemon

require './sentry-lib.pl';
&error_setup($text{'portsentry_stoperr'});

if ($config{'portsentry_stop'}) {
	$out = &backquote_logged("($config{'portsentry_stop'}) 2>&1 </dev/null");
	&error("<tt>$out</tt>") if ($out =~ /error|failed/i);
	}
else {
	@pids = &get_portsentry_pids();
	if (@pids) {
		&kill_logged("TERM", @pids) ||
			&error(&text('portsentry_ekill', join(" ", @pids), $!));
		}
	else {
		&error($text{'portsentry_estopped'});
		}
	}
&webmin_log("stop", "portsentry");

&redirect("edit_portsentry.cgi");

