/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;

class AttributeEditor
extends FixedFrame
implements CbButtonCallback {
    FileManager filemgr;
    AttributesWindow attrwin;
    FileAttribute attr;
    boolean creating;
    CbButton ok;
    CbButton del;
    TextField name;
    TextArea value;

    AttributeEditor(AttributesWindow attributesWindow, FileAttribute fileAttribute) {
        this.attrwin = attributesWindow;
        this.attr = fileAttribute;
        this.filemgr = attributesWindow.filemgr;
        this.creating = false;
        this.makeUI();
    }

    AttributeEditor(AttributesWindow attributesWindow) {
        this.attrwin = attributesWindow;
        this.attr = new FileAttribute("", "");
        this.filemgr = attributesWindow.filemgr;
        this.creating = true;
        this.makeUI();
    }

    void makeUI() {
        this.setTitle(this.filemgr.text(this.creating ? "attr_create" : "attr_edit"));
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        panel.add(new Label(this.filemgr.text("attr_name")));
        this.name = new TextField(this.attr.name, 20);
        panel.add(this.name);
        this.name.setFont(this.filemgr.fixed);
        this.add("North", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2));
        panel2.add(new Label(this.filemgr.text("attr_value")));
        this.value = new TextArea(this.attr.value, 5, 20);
        panel2.add(this.value);
        this.add("Center", panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(2));
        this.ok = new CbButton(this.filemgr.get_image("save.gif"), this.filemgr.text("save"), 0, this);
        panel3.add(this.ok);
        if (!this.creating) {
            this.del = new CbButton(this.filemgr.get_image("cancel.gif"), this.filemgr.text("delete"), 0, this);
            panel3.add(this.del);
        }
        this.add("South", panel3);
        Util.recursiveBody(this);
        this.pack();
        this.show();
    }

    public void click(CbButton cbButton) {
        if (cbButton == this.ok) {
            if (this.name.getText().length() == 0) {
                new ErrorWindow(this.filemgr.text("attr_ename"));
                return;
            }
            this.attr.name = this.name.getText();
            this.attr.value = this.value.getText();
            if (this.creating) {
                this.attrwin.attrlist.addElement(this.attr);
                this.attrwin.attrtable.addItem(this.attr.getRow());
            } else {
                int n = this.attrwin.attrlist.indexOf(this.attr);
                this.attrwin.attrtable.modifyItem(this.attr.getRow(), n);
            }
            this.dispose();
        } else if (cbButton == this.del) {
            int n = this.attrwin.attrlist.indexOf(this.attr);
            this.attrwin.attrlist.removeElementAt(n);
            this.attrwin.attrtable.deleteItem(n);
            this.dispose();
        }
    }

    public void dispose() {
        this.attrwin.edmap.remove(this.attr);
        super.dispose();
    }
}

