/* Copyright (C) 2001, 2007 United States Government as represented by
   the Administrator of the National Aeronautics and Space Administration.
   All Rights Reserved.
*/
package gov.nasa.worldwind.servers.wms;

/**
 * A stub for a Container's ServletContext object. Implemented as a singleton.
 * The only "parameters" we keep here are the map-source and output-format
 * registries.
 * The intent is that if at a later point we implement the WMS for a Container,
 * we can extend this class from a J2EE ServletContext object to mimimize refactoring.
 *
 * @author brownrigg
 * @version $Id: WMSServletContext.java 3511 2007-11-14 20:21:38Z rick $
 */
public class WMSServletContext {
    
    public static WMSServletContext inst() {
        if (theInst == null)
            theInst = new WMSServletContext();
        return theInst;
    }
    
    private WMSServletContext() {
        // For now, just yank these from the application's static context
        mapRegistry = WMSServer.getMapSourceRegistry();
    }
    
    public Object getAttribute(String name) {
        // we only know two hardwired names...
        if (name.equals("MAPREGISTRY")) return mapRegistry;
        return null;
    }
    
    private MapRegistry mapRegistry;
    private static WMSServletContext theInst;
    
}
