/*****************************************************************************
 *
 *   Portable uPD7810/11, 7810H/11H, 78C10/C11/C14 disassembler
 *   Copyright (c) 2001 Juergen Buchmueller, all rights reserved.
 *
 *   NS20030112: added 7807.
 *
 *****************************************************************************/

#include <stdio.h>

#ifdef MAME_DEBUG
#include "driver.h"
#include "mamedbg.h"
#include "upd7810.h"

struct dasm_s {
	UINT8	token;
	const void	*args;
	UINT8	oplen;
	UINT8	cycles;
};

enum
{
	illegal=1,
	ACI,
	ADC,
	ADCW,
	ADCX,
	ADD,
	ADDNC,
	ADDNCW,
	ADDNCX,
	ADDW,
	ADDX,
	ADI,
	ADINC,
	ANA,
	ANAW,
	ANAX,
	AND,
	ANI,
	ANIW,
	BIT,
	BLOCK,
	CALB,
	CALF,
	CALL,
	CALT,
	CLC,
	CLR,	/* 7807 */
	CMC,	/* 7807 */
	DAA,
	DADC,
	DADD,
	DADDNC,
	DAN,
	DCR,
	DCRW,
	DCX,
	DEQ,
	DGT,
	DI,
	DIV,
	DLT,
	DMOV,
	DNE,
	DOFF,
	DON,
	DOR,
	DRLL,
	DRLR,
	DSBB,
	DSLL,
	DSLR,
	DSUB,
	DSUBNB,
	DXR,
	EADD,
	EI,
	EQA,
	EQAW,
	EQAX,
	EQI,
	EQIW,
	ESUB,
	EXA,
	EXH,
	EXX,
	EXR,	/* 7807 */
	GTA,
	GTAW,
	GTAX,
	GTI,
	GTIW,
	HALT,
	INR,
	INRW,
	INX,
	JB,
	JEA,
	JMP,
	JR,
	JRE,
	LBCD,
	LDAW,
	LDAX,
	LDEAX,
	LDED,
	LHLD,
	LSPD,
	LTA,
	LTAW,
	LTAX,
	LTI,
	LTIW,
	LXI,
	MOV,
	MUL,
	MVI,
	MVIW,
	MVIX,
	NEA,
	NEAW,
	NEAX,
	NEGA,
	NEI,
	NEIW,
	NOP,
	NOT,	/* 7807 */
	OFFA,
	OFFAW,
	OFFAX,
	OFFI,
	OFFIW,
	ONA,
	ONAW,
	ONAX,
	ONI,
	ONIW,
	OR,	/* 7807 */
	ORA,
	ORAW,
	ORAX,
	ORI,
	ORIW,
	POP,
	PUSH,
	RET,
	RETI,
	RETS,
	RLD,
	RLL,
	RLR,
	RRD,
	SBB,
	SBBW,
	SBBX,
	SBCD,
	SBI,
	SDED,
	SETB,	/* 7807 */
	SHLD,
	SK,
	SKIT,
	SKN,
	SKNIT,
	SLL,
	SLLC,
	SLR,
	SLRC,
	SOFTI,
	SSPD,
	STAW,
	STAX,
	STC,
	STEAX,
	STOP,
	SUB,
	SUBNB,
	SUBNBW,
	SUBNBX,
	SUBW,
	SUBX,
	SUI,
	SUINB,
	TABLE,
	XOR,	/* 7807 */
	XRA,
	XRAW,
	XRAX,
	XRI
};

static const char* token[] =
{
	"",
	"illegal",
	"ACI",
	"ADC",
	"ADCW",
	"ADCX",
	"ADD",
	"ADDNC",
	"ADDNCW",
	"ADDNCX",
	"ADDW",
	"ADDX",
	"ADI",
	"ADINC",
	"ANA",
	"ANAW",
	"ANAX",
	"AND",
	"ANI",
	"ANIW",
	"BIT",
	"BLOCK",
	"CALB",
	"CALF",
	"CALL",
	"CALT",
	"CLC",
	"CLR",	/* 7807 */
	"CMC",	/* 7807 */
	"DAA",
	"DADC",
	"DADD",
	"DADDNC",
	"DAN",
	"DCR",
	"DCRW",
	"DCX",
	"DEQ",
	"DGT",
	"DI",
	"DIV",
	"DLT",
	"DMOV",
	"DNE",
	"DOFF",
	"DON",
	"DOR",
	"DRLL",
	"DRLR",
	"DSBB",
	"DSLL",
	"DSLR",
	"DSUB",
	"DSUBNB",
	"DXR",
	"EADD",
	"EI",
	"EQA",
	"EQAW",
	"EQAX",
	"EQI",
	"EQIW",
	"ESUB",
	"EXA",
	"EXH",
	"EXX",
	"EXR",	/* 7807 */
	"GTA",
	"GTAW",
	"GTAX",
	"GTI",
	"GTIW",
	"HALT",
	"INR",
	"INRW",
	"INX",
	"JB",
	"JEA",
	"JMP",
	"JR",
	"JRE",
	"LBCD",
	"LDAW",
	"LDAX",
	"LDEAX",
	"LDED",
	"LHLD",
	"LSPD",
	"LTA",
	"LTAW",
	"LTAX",
	"LTI",
	"LTIW",
	"LXI",
	"MOV",
	"MUL",
	"MVI",
	"MVIW",
	"MVIX",
	"NEA",
	"NEAW",
	"NEAX",
	"NEGA",
	"NEI",
	"NEIW",
	"NOP",
	"NOT",	/* 7807 */
	"OFFA",
	"OFFAW",
	"OFFAX",
	"OFFI",
	"OFFIW",
	"ONA",
	"ONAW",
	"ONAX",
	"ONI",
	"ONIW",
	"OR",	/* 7807 */
	"ORA",
	"ORAW",
	"ORAX",
	"ORI",
	"ORIW",
	"POP",
	"PUSH",
	"RET",
	"RETI",
	"RETS",
	"RLD",
	"RLL",
	"RLR",
	"RRD",
	"SBB",
	"SBBW",
	"SBBX",
	"SBCD",
	"SBI",
	"SDED",
	"SETB",	/* 7807 */
	"SHLD",
	"SK",
	"SKIT",
	"SKN",
	"SKNIT",
	"SLL",
	"SLLC",
	"SLR",
	"SLRC",
	"SOFTI",
	"SSPD",
	"STAW",
	"STAX",
	"STC",
	"STEAX",
	"STOP",
	"SUB",
	"SUBNB",
	"SUBNBW",
	"SUBNBX",
	"SUBW",
	"SUBX",
	"SUI",
	"SUINB",
	"TABLE",
	"XOR",	/* 7807 */
	"XRA",
	"XRAW",
	"XRAX",
	"XRI"
};


/* prefix 48 */
static struct dasm_s dasm48_7810[256] =
{
	{illegal,0, 	 2, 8}, /* 00: 0100 1000 0000 0000                      */
	{SLRC,"A",       2, 8}, /* 01: 0100 1000 0000 0001                      */
	{SLRC,"B",       2, 8}, /* 02: 0100 1000 0000 0010                      */
	{SLRC,"C",       2, 8}, /* 03: 0100 1000 0000 0011                      */
	{illegal,0, 	 2, 8}, /* 04: 0100 1000 0000 0100                      */
	{SLLC,"A",       2, 8}, /* 05: 0100 1000 0000 0101                      */
	{SLLC,"B",       2, 8}, /* 06: 0100 1000 0000 0110                      */
	{SLLC,"C",       2, 8}, /* 07: 0100 1000 0000 0111                      */
	{SK,"NV",        2, 8}, /* 08: 0100 1000 0000 1000                      */
	{illegal,0, 	 2, 8}, /* 09: 0100 1000 0000 1001                      */
	{SK,"CY",        2, 8}, /* 0a: 0100 1000 0000 1010                      */
	{SK,"HC",        2, 8}, /* 0b: 0100 1000 0000 1011                      */
	{SK,"Z",         2, 8}, /* 0c: 0100 1000 0000 1100                      */
	{illegal,0, 	 2, 8}, /* 0d: 0100 1000 0000 1101                      */
	{illegal,0, 	 2, 8}, /* 0e: 0100 1000 0000 1110                      */
	{illegal,0, 	 2, 8}, /* 0f: 0100 1000 0000 1111                      */

	{illegal,0, 	 2, 8}, /* 10: 0100 1000 0001 0000                      */
	{illegal,0, 	 2, 8}, /* 11: 0100 1000 0001 0001                      */
	{illegal,0, 	 2, 8}, /* 12: 0100 1000 0001 0010                      */
	{illegal,0, 	 2, 8}, /* 13: 0100 1000 0001 0011                      */
	{illegal,0, 	 2, 8}, /* 14: 0100 1000 0001 0100                      */
	{illegal,0, 	 2, 8}, /* 15: 0100 1000 0001 0101                      */
	{illegal,0, 	 2, 8}, /* 16: 0100 1000 0001 0110                      */
	{illegal,0, 	 2, 8}, /* 17: 0100 1000 0001 0111                      */
	{SKN,"NV",       2, 8}, /* 18: 0100 1000 0001 1000                      */
	{illegal,0, 	 2, 8}, /* 19: 0100 1000 0001 1001                      */
	{SKN,"CY",       2, 8}, /* 1a: 0100 1000 0001 1010                      */
	{SKN,"HC",       2, 8}, /* 1b: 0100 1000 0001 1011                      */
	{SKN,"Z",        2, 8}, /* 1c: 0100 1000 0001 1100                      */
	{illegal,0, 	 2, 8}, /* 1d: 0100 1000 0001 1101                      */
	{illegal,0, 	 2, 8}, /* 1e: 0100 1000 0001 1110                      */
	{illegal,0, 	 2, 8}, /* 1f: 0100 1000 0001 1111                      */

	{illegal,0, 	 2, 8}, /* 20: 0100 1000 0010 0000                      */
	{SLR,"A",        2, 8}, /* 21: 0100 1000 0010 0001                      */
	{SLR,"B",        2, 8}, /* 22: 0100 1000 0010 0010                      */
	{SLR,"C",        2, 8}, /* 23: 0100 1000 0010 0011                      */
	{illegal,0, 	 2, 8}, /* 24: 0100 1000 0010 0100                      */
	{SLL,"A",        2, 8}, /* 25: 0100 1000 0010 0101                      */
	{SLL,"B",        2, 8}, /* 26: 0100 1000 0010 0110                      */
	{SLL,"C",        2, 8}, /* 27: 0100 1000 0010 0111                      */
	{JEA,0, 		 2, 8}, /* 28: 0100 1000 0010 1000                      */
	{CALB,0,		 2,17}, /* 29: 0100 1000 0010 1001                      */
	{CLC,0, 		 2, 8}, /* 2a: 0100 1000 0010 1010                      */
	{STC,0, 		 2, 8}, /* 2b: 0100 1000 0010 1011                      */
	{illegal,0, 	 2,32}, /* 2c: 0100 1000 0010 1100                      */
	{MUL,"A",        2,32}, /* 2d: 0100 1000 0010 1101                      */
	{MUL,"B",        2,32}, /* 2e: 0100 1000 0010 1110                      */
	{MUL,"C",        2,32}, /* 2f: 0100 1000 0010 1111                      */

	{illegal,0, 	 2, 8}, /* 30: 0100 1000 0011 0000                      */
	{RLR,"A",        2, 8}, /* 31: 0100 1000 0011 0001                      */
	{RLR,"B",        2, 8}, /* 32: 0100 1000 0011 0010                      */
	{RLR,"C",        2, 8}, /* 33: 0100 1000 0011 0011                      */
	{illegal,0, 	 2, 8}, /* 34: 0100 1000 0011 0100                      */
	{RLL,"A",        2, 8}, /* 35: 0100 1000 0011 0101                      */
	{RLL,"B",        2, 8}, /* 36: 0100 1000 0011 0110                      */
	{RLL,"C",        2, 8}, /* 37: 0100 1000 0011 0111                      */
	{RLD,0, 		 2,17}, /* 38: 0100 1000 0011 1000                      */
	{RRD,0, 		 2,17}, /* 39: 0100 1000 0011 1001                      */
	{NEGA,0,		 2, 8}, /* 3a: 0100 1000 0011 1010                      */
	{HALT,0,		 2,12}, /* 3b: 0100 1000 0011 1011                      */
	{illegal,0, 	 2,59}, /* 3c: 0100 1000 0011 1100                      */
	{DIV,"A",        2,59}, /* 3d: 0100 1000 0011 1101                      */
	{DIV,"B",        2,59}, /* 3e: 0100 1000 0011 1110                      */
	{DIV,"C",        2,59}, /* 3f: 0100 1000 0011 1111                      */

	{SKIT,"NMI",     2, 8}, /* 40: 0100 1000 0100 0000                      */
	{SKIT,"FT0",     2, 8}, /* 41: 0100 1000 0100 0001                      */
	{SKIT,"FT1",     2, 8}, /* 42: 0100 1000 0100 0010                      */
	{SKIT,"F1",      2, 8}, /* 43: 0100 1000 0100 0011                      */
	{SKIT,"F2",      2, 8}, /* 44: 0100 1000 0100 0100                      */
	{SKIT,"FE0",     2, 8}, /* 45: 0100 1000 0100 0101                      */
	{SKIT,"FE1",     2, 8}, /* 46: 0100 1000 0100 0110                      */
	{SKIT,"FEIN",    2, 8}, /* 47: 0100 1000 0100 0111                      */
	{SKIT,"FAD",     2, 8}, /* 48: 0100 1000 0100 1000                      */
	{SKIT,"FSR",     2, 8}, /* 49: 0100 1000 0100 1001                      */
	{SKIT,"FST",     2, 8}, /* 4a: 0100 1000 0100 1010                      */
	{SKIT,"ER",      2, 8}, /* 4b: 0100 1000 0100 1011                      */
	{SKIT,"OV",      2, 8}, /* 4c: 0100 1000 0100 1100                      */
	{illegal,0, 	 2, 8}, /* 4d: 0100 1000 0100 1101                      */
	{illegal,0, 	 2, 8}, /* 4e: 0100 1000 0100 1110                      */
	{illegal,0, 	 2, 8}, /* 4f: 0100 1000 0100 1111                      */

	{SKIT,"AN4",     2, 8}, /* 50: 0100 1000 0101 0000                      */
	{SKIT,"AN5",     2, 8}, /* 51: 0100 1000 0101 0001                      */
	{SKIT,"AN6",     2, 8}, /* 52: 0100 1000 0101 0010                      */
	{SKIT,"AN7",     2, 8}, /* 53: 0100 1000 0101 0011                      */
	{SKIT,"SB",      2, 8}, /* 54: 0100 1000 0101 0100                      */
	{illegal,0, 	 2, 8}, /* 55: 0100 1000 0101 0101                      */
	{illegal,0, 	 2, 8}, /* 56: 0100 1000 0101 0110                      */
	{illegal,0, 	 2, 8}, /* 57: 0100 1000 0101 0111                      */
	{illegal,0, 	 2, 8}, /* 58: 0100 1000 0101 1000                      */
	{illegal,0, 	 2, 8}, /* 59: 0100 1000 0101 1001                      */
	{illegal,0, 	 2, 8}, /* 5a: 0100 1000 0101 1010                      */
	{illegal,0, 	 2, 8}, /* 5b: 0100 1000 0101 1011                      */
	{illegal,0, 	 2, 8}, /* 5c: 0100 1000 0101 1100                      */
	{illegal,0, 	 2, 8}, /* 5d: 0100 1000 0101 1101                      */
	{illegal,0, 	 2, 8}, /* 5e: 0100 1000 0101 1110                      */
	{illegal,0, 	 2, 8}, /* 5f: 0100 1000 0101 1111                      */

	{SKNIT,"NMI",    2, 8}, /* 60: 0100 1000 0110 0000                      */
	{SKNIT,"FT0",    2, 8}, /* 61: 0100 1000 0110 0001                      */
	{SKNIT,"FT1",    2, 8}, /* 62: 0100 1000 0110 0010                      */
	{SKNIT,"F1",     2, 8}, /* 63: 0100 1000 0110 0011                      */
	{SKNIT,"F2",     2, 8}, /* 64: 0100 1000 0110 0100                      */
	{SKNIT,"FE0",    2, 8}, /* 65: 0100 1000 0110 0101                      */
	{SKNIT,"FE1",    2, 8}, /* 66: 0100 1000 0110 0110                      */
	{SKNIT,"FEIN",   2, 8}, /* 67: 0100 1000 0110 0111                      */
	{SKNIT,"FAD",    2, 8}, /* 68: 0100 1000 0110 1000                      */
	{SKNIT,"FSR",    2, 8}, /* 69: 0100 1000 0110 1001                      */
	{SKNIT,"FST",    2, 8}, /* 6a: 0100 1000 0110 1010                      */
	{SKNIT,"ER",     2, 8}, /* 6b: 0100 1000 0110 1011                      */
	{SKNIT,"OV",     2, 8}, /* 6c: 0100 1000 0110 1100                      */
	{illegal,0, 	 2, 8}, /* 6d: 0100 1000 0110 1101                      */
	{illegal,0, 	 2, 8}, /* 6e: 0100 1000 0110 1110                      */
	{illegal,0, 	 2, 8}, /* 6f: 0100 1000 0110 1111                      */

	{SKNIT,"AN4",    2, 8}, /* 70: 0100 1000 0111 0000                      */
	{SKNIT,"AN5",    2, 8}, /* 71: 0100 1000 0111 0001                      */
	{SKNIT,"AN6",    2, 8}, /* 72: 0100 1000 0111 0010                      */
	{SKNIT,"AN7",    2, 8}, /* 73: 0100 1000 0111 0011                      */
	{SKNIT,"SB",     2, 8}, /* 74: 0100 1000 0111 0100                      */
	{illegal,0, 	 2, 8}, /* 75: 0100 1000 0111 0101                      */
	{illegal,0, 	 2, 8}, /* 76: 0100 1000 0111 0110                      */
	{illegal,0, 	 2, 8}, /* 77: 0100 1000 0111 0111                      */
	{illegal,0, 	 2, 8}, /* 78: 0100 1000 0111 1000                      */
	{illegal,0, 	 2, 8}, /* 79: 0100 1000 0111 1001                      */
	{illegal,0, 	 2, 8}, /* 7a: 0100 1000 0111 1010                      */
	{illegal,0, 	 2, 8}, /* 7b: 0100 1000 0111 1011                      */
	{illegal,0, 	 2, 8}, /* 7c: 0100 1000 0111 1100                      */
	{illegal,0, 	 2, 8}, /* 7d: 0100 1000 0111 1101                      */
	{illegal,0, 	 2, 8}, /* 7e: 0100 1000 0111 1110                      */
	{illegal,0, 	 2, 8}, /* 7f: 0100 1000 0111 1111                      */

	{illegal,0, 	 2, 8}, /* 80: 0100 1000 1000 0000                      */
	{illegal,0, 	 2, 8}, /* 81: 0100 1000 1000 0001                      */
	{LDEAX,"(DE)",   2,14}, /* 82: 0100 1000 1000 0010                      */
	{LDEAX,"(HL)",   2,14}, /* 83: 0100 1000 1000 0011                      */
	{LDEAX,"(DE++)", 2,14}, /* 84: 0100 1000 1000 0100                      */
	{LDEAX,"(HL++)", 2,14}, /* 85: 0100 1000 1000 0101                      */
	{illegal,0, 	 2, 8}, /* 86: 0100 1000 1000 0110                      */
	{illegal,0, 	 2, 8}, /* 87: 0100 1000 1000 0111                      */
	{illegal,0, 	 2, 8}, /* 88: 0100 1000 1000 1000                      */
	{illegal,0, 	 2, 8}, /* 89: 0100 1000 1000 1001                      */
	{illegal,0, 	 2, 8}, /* 8a: 0100 1000 1000 1010                      */
	{LDEAX,"(DE+%b)",3,20}, /* 8b: 0100 1000 1000 1011 xxxx xxxx            */
	{LDEAX,"(HL+A)", 2,20}, /* 8c: 0100 1000 1000 1100                      */
	{LDEAX,"(HL+B)", 2,20}, /* 8d: 0100 1000 1000 1101                      */
	{LDEAX,"(HL+EA)",2,20}, /* 8e: 0100 1000 1000 1110                      */
	{LDEAX,"(HL+%b)",3,20}, /* 8f: 0100 1000 1000 1111 xxxx xxxx            */

	{illegal,0, 	 2, 8}, /* 90: 0100 1000 1000 0000                      */
	{illegal,0, 	 2, 8}, /* 91: 0100 1000 1000 0001                      */
	{STEAX,"(DE)",   2,14}, /* 92: 0100 1000 1000 0010                      */
	{STEAX,"(HL)",   2,14}, /* 93: 0100 1000 1000 0011                      */
	{STEAX,"(DE++)", 2,14}, /* 94: 0100 1000 1000 0100                      */
	{STEAX,"(HL++)", 2,14}, /* 95: 0100 1000 1000 0101                      */
	{illegal,0, 	 2, 8}, /* 96: 0100 1000 1000 0110                      */
	{illegal,0, 	 2, 8}, /* 97: 0100 1000 1000 0111                      */
	{illegal,0, 	 2, 8}, /* 98: 0100 1000 1000 1000                      */
	{illegal,0, 	 2, 8}, /* 99: 0100 1000 1000 1001                      */
	{illegal,0, 	 2, 8}, /* 9a: 0100 1000 1000 1010                      */
	{STEAX,"(DE+%b)",3,20}, /* 9b: 0100 1000 1000 1011 xxxx xxxx            */
	{STEAX,"(HL+A)", 2,20}, /* 9c: 0100 1000 1000 1100                      */
	{STEAX,"(HL+B)", 2,20}, /* 9d: 0100 1000 1000 1101                      */
	{STEAX,"(HL+EA)",2,20}, /* 9e: 0100 1000 1000 1110                      */
	{STEAX,"(HL+%b)",3,20}, /* 9f: 0100 1000 1000 1111 xxxx xxxx            */

	{DSLR,"EA",      2, 8}, /* a0: 0100 1000 1010 0000                      */
	{illegal,0, 	 2, 8}, /* a1: 0100 1000 1010 0001                      */
	{illegal,0, 	 2, 8}, /* a2: 0100 1000 1010 0010                      */
	{illegal,0, 	 2, 8}, /* a3: 0100 1000 1010 0011                      */
	{DSLL,"EA",      2, 8}, /* a4: 0100 1000 1010 0100                      */
	{illegal,0, 	 2, 8}, /* a5: 0100 1000 1010 0101                      */
	{illegal,0, 	 2, 8}, /* a6: 0100 1000 1010 0110                      */
	{illegal,0, 	 2, 8}, /* a7: 0100 1000 1010 0111                      */
	{TABLE,0,		 2,17}, /* a8: 0100 1000 1010 1000                      */
	{illegal,0, 	 2, 8}, /* a9: 0100 1000 1010 1001                      */
	{illegal,0, 	 2, 8}, /* aa: 0100 1000 1010 1010                      */
	{illegal,0, 	 2, 8}, /* ab: 0100 1000 1010 1011                      */
	{illegal,0, 	 2, 8}, /* ac: 0100 1000 1010 1100                      */
	{illegal,0, 	 2, 8}, /* ad: 0100 1000 1010 1101                      */
	{illegal,0, 	 2, 8}, /* ae: 0100 1000 1010 1110                      */
	{illegal,0, 	 2, 8}, /* af: 0100 1000 1010 1111                      */

	{DRLR,"EA",      2, 8}, /* b0: 0100 1000 1011 0000                      */
	{illegal,0, 	 2, 8}, /* b1: 0100 1000 1011 0001                      */
	{illegal,0, 	 2, 8}, /* b2: 0100 1000 1011 0010                      */
	{illegal,0, 	 2, 8}, /* b3: 0100 1000 1011 0011                      */
	{DRLL,"EA",      2, 8}, /* b4: 0100 1000 1011 0100                      */
	{illegal,0, 	 2, 8}, /* b5: 0100 1000 1011 0101                      */
	{illegal,0, 	 2, 8}, /* b6: 0100 1000 1011 0110                      */
	{illegal,0, 	 2, 8}, /* b7: 0100 1000 1011 0111                      */
	{illegal,0, 	 2, 8}, /* b8: 0100 1000 1011 1000                      */
	{illegal,0, 	 2, 8}, /* b9: 0100 1000 1011 1001                      */
	{illegal,0, 	 2, 8}, /* ba: 0100 1000 1011 1010                      */
	{STOP,0,		 2,12}, /* bb: 0100 1000 1011 1011                      */	/* 7810 */
	{illegal,0, 	 2, 8}, /* bc: 0100 1000 1011 1100                      */
	{illegal,0, 	 2, 8}, /* bd: 0100 1000 1011 1101                      */
	{illegal,0, 	 2, 8}, /* be: 0100 1000 1011 1110                      */
	{illegal,0, 	 2, 8}, /* bf: 0100 1000 1011 1111                      */

	{DMOV,"EA,ECNT", 2,14}, /* c0: 0100 1000 1100 0000                      */
	{DMOV,"EA,ECPT", 2,14}, /* c1: 0100 1000 1100 0001                      */	/* 7810 */
	{illegal,0, 	 2, 8}, /* c2: 0100 1000 1100 0010                      */
	{illegal,0, 	 2, 8}, /* c3: 0100 1000 1100 0011                      */
	{illegal,0, 	 2, 8}, /* c4: 0100 1000 1100 0100                      */
	{illegal,0, 	 2, 8}, /* c5: 0100 1000 1100 0101                      */
	{illegal,0, 	 2, 8}, /* c6: 0100 1000 1100 0110                      */
	{illegal,0, 	 2, 8}, /* c7: 0100 1000 1100 0111                      */
	{illegal,0, 	 2, 8}, /* c8: 0100 1000 1100 1000                      */
	{illegal,0, 	 2, 8}, /* c9: 0100 1000 1100 1001                      */
	{illegal,0, 	 2, 8}, /* ca: 0100 1000 1100 1010                      */
	{illegal,0, 	 2, 8}, /* cb: 0100 1000 1100 1011                      */
	{illegal,0, 	 2, 8}, /* cc: 0100 1000 1100 1100                      */
	{illegal,0, 	 2, 8}, /* cd: 0100 1000 1100 1101                      */
	{illegal,0, 	 2, 8}, /* ce: 0100 1000 1100 1110                      */
	{illegal,0, 	 2, 8}, /* cf: 0100 1000 1100 1111                      */

	{illegal,0, 	 2, 8}, /* d0: 0100 1000 1101 0000                      */
	{illegal,0, 	 2, 8}, /* d1: 0100 1000 1101 0001                      */
	{DMOV,"ETM0,EA", 2,14}, /* d2: 0100 1000 1101 0010                      */
	{DMOV,"ETM1,EA", 2,14}, /* d3: 0100 1000 1101 0011                      */
	{illegal,0, 	 2, 8}, /* d4: 0100 1000 1101 0100                      */
	{illegal,0, 	 2, 8}, /* d5: 0100 1000 1101 0101                      */
	{illegal,0, 	 2, 8}, /* d6: 0100 1000 1101 0110                      */
	{illegal,0, 	 2, 8}, /* d7: 0100 1000 1101 0111                      */
	{illegal,0, 	 2, 8}, /* d8: 0100 1000 1101 1000                      */
	{illegal,0, 	 2, 8}, /* d9: 0100 1000 1101 1001                      */
	{illegal,0, 	 2, 8}, /* da: 0100 1000 1101 1010                      */
	{illegal,0, 	 2, 8}, /* db: 0100 1000 1101 1011                      */
	{illegal,0, 	 2, 8}, /* dc: 0100 1000 1101 1100                      */
	{illegal,0, 	 2, 8}, /* dd: 0100 1000 1101 1101                      */
	{illegal,0, 	 2, 8}, /* de: 0100 1000 1101 1110                      */
	{illegal,0, 	 2, 8}, /* df: 0100 1000 1101 1111                      */

	{illegal,0, 	 2, 8}, /* e0: 0100 1000 1110 0000                      */
	{illegal,0, 	 2, 8}, /* e1: 0100 1000 1110 0001                      */
	{illegal,0, 	 2, 8}, /* e2: 0100 1000 1110 0010                      */
	{illegal,0, 	 2, 8}, /* e3: 0100 1000 1110 0011                      */
	{illegal,0, 	 2, 8}, /* e4: 0100 1000 1110 0100                      */
	{illegal,0, 	 2, 8}, /* e5: 0100 1000 1110 0101                      */
	{illegal,0, 	 2, 8}, /* e6: 0100 1000 1110 0110                      */
	{illegal,0, 	 2, 8}, /* e7: 0100 1000 1110 0111                      */
	{illegal,0, 	 2, 8}, /* e8: 0100 1000 1110 1000                      */
	{illegal,0, 	 2, 8}, /* e9: 0100 1000 1110 1001                      */
	{illegal,0, 	 2, 8}, /* ea: 0100 1000 1110 1010                      */
	{illegal,0, 	 2, 8}, /* eb: 0100 1000 1110 1011                      */
	{illegal,0, 	 2, 8}, /* ec: 0100 1000 1110 1100                      */
	{illegal,0, 	 2, 8}, /* ed: 0100 1000 1110 1101                      */
	{illegal,0, 	 2, 8}, /* ee: 0100 1000 1110 1110                      */
	{illegal,0, 	 2, 8}, /* ef: 0100 1000 1110 1111                      */

	{illegal,0, 	 2, 8}, /* f0: 0100 1000 1111 0000                      */
	{illegal,0, 	 2, 8}, /* f1: 0100 1000 1111 0001                      */
	{illegal,0, 	 2, 8}, /* f2: 0100 1000 1111 0010                      */
	{illegal,0, 	 2, 8}, /* f3: 0100 1000 1111 0011                      */
	{illegal,0, 	 2, 8}, /* f4: 0100 1000 1111 0100                      */
	{illegal,0, 	 2, 8}, /* f5: 0100 1000 1111 0101                      */
	{illegal,0, 	 2, 8}, /* f6: 0100 1000 1111 0110                      */
	{illegal,0, 	 2, 8}, /* f7: 0100 1000 1111 0111                      */
	{illegal,0, 	 2, 8}, /* f8: 0100 1000 1111 1000                      */
	{illegal,0, 	 2, 8}, /* f9: 0100 1000 1111 1001                      */
	{illegal,0, 	 2, 8}, /* fa: 0100 1000 1111 1010                      */
	{illegal,0, 	 2, 8}, /* fb: 0100 1000 1111 1011                      */
	{illegal,0, 	 2, 8}, /* fc: 0100 1000 1111 1100                      */
	{illegal,0, 	 2, 8}, /* fd: 0100 1000 1111 1101                      */
	{illegal,0, 	 2, 8}, /* fe: 0100 1000 1111 1110                      */
	{illegal,0, 	 2, 8}	/* ff: 0100 1000 1111 1111                      */
};

static struct dasm_s dasm48_7807[256] =
{
	{illegal,0, 	 2, 8}, /* 00: 0100 1000 0000 0000                      */
	{SLRC,"A",       2, 8}, /* 01: 0100 1000 0000 0001                      */
	{SLRC,"B",       2, 8}, /* 02: 0100 1000 0000 0010                      */
	{SLRC,"C",       2, 8}, /* 03: 0100 1000 0000 0011                      */
	{illegal,0, 	 2, 8}, /* 04: 0100 1000 0000 0100                      */
	{SLLC,"A",       2, 8}, /* 05: 0100 1000 0000 0101                      */
	{SLLC,"B",       2, 8}, /* 06: 0100 1000 0000 0110                      */
	{SLLC,"C",       2, 8}, /* 07: 0100 1000 0000 0111                      */
	{SK,"NV",        2, 8}, /* 08: 0100 1000 0000 1000                      */
	{illegal,0, 	 2, 8}, /* 09: 0100 1000 0000 1001                      */
	{SK,"CY",        2, 8}, /* 0a: 0100 1000 0000 1010                      */
	{SK,"HC",        2, 8}, /* 0b: 0100 1000 0000 1011                      */
	{SK,"Z",         2, 8}, /* 0c: 0100 1000 0000 1100                      */
	{illegal,0, 	 2, 8}, /* 0d: 0100 1000 0000 1101                      */
	{illegal,0, 	 2, 8}, /* 0e: 0100 1000 0000 1110                      */
	{illegal,0, 	 2, 8}, /* 0f: 0100 1000 0000 1111                      */

	{illegal,0, 	 2, 8}, /* 10: 0100 1000 0001 0000                      */
	{illegal,0, 	 2, 8}, /* 11: 0100 1000 0001 0001                      */
	{illegal,0, 	 2, 8}, /* 12: 0100 1000 0001 0010                      */
	{illegal,0, 	 2, 8}, /* 13: 0100 1000 0001 0011                      */
	{illegal,0, 	 2, 8}, /* 14: 0100 1000 0001 0100                      */
	{illegal,0, 	 2, 8}, /* 15: 0100 1000 0001 0101                      */
	{illegal,0, 	 2, 8}, /* 16: 0100 1000 0001 0110                      */
	{illegal,0, 	 2, 8}, /* 17: 0100 1000 0001 0111                      */
	{SKN,"NV",       2, 8}, /* 18: 0100 1000 0001 1000                      */
	{illegal,0, 	 2, 8}, /* 19: 0100 1000 0001 1001                      */
	{SKN,"CY",       2, 8}, /* 1a: 0100 1000 0001 1010                      */
	{SKN,"HC",       2, 8}, /* 1b: 0100 1000 0001 1011                      */
	{SKN,"Z",        2, 8}, /* 1c: 0100 1000 0001 1100                      */
	{illegal,0, 	 2, 8}, /* 1d: 0100 1000 0001 1101                      */
	{illegal,0, 	 2, 8}, /* 1e: 0100 1000 0001 1110                      */
	{illegal,0, 	 2, 8}, /* 1f: 0100 1000 0001 1111                      */

	{illegal,0, 	 2, 8}, /* 20: 0100 1000 0010 0000                      */
	{SLR,"A",        2, 8}, /* 21: 0100 1000 0010 0001                      */
	{SLR,"B",        2, 8}, /* 22: 0100 1000 0010 0010                      */
	{SLR,"C",        2, 8}, /* 23: 0100 1000 0010 0011                      */
	{illegal,0, 	 2, 8}, /* 24: 0100 1000 0010 0100                      */
	{SLL,"A",        2, 8}, /* 25: 0100 1000 0010 0101                      */
	{SLL,"B",        2, 8}, /* 26: 0100 1000 0010 0110                      */
	{SLL,"C",        2, 8}, /* 27: 0100 1000 0010 0111                      */
	{JEA,0, 		 2, 8}, /* 28: 0100 1000 0010 1000                      */
	{CALB,0,		 2,17}, /* 29: 0100 1000 0010 1001                      */
	{CLC,0, 		 2, 8}, /* 2a: 0100 1000 0010 1010                      */
	{STC,0, 		 2, 8}, /* 2b: 0100 1000 0010 1011                      */
	{illegal,0, 	 2,32}, /* 2c: 0100 1000 0010 1100                      */
	{MUL,"A",        2,32}, /* 2d: 0100 1000 0010 1101                      */
	{MUL,"B",        2,32}, /* 2e: 0100 1000 0010 1110                      */
	{MUL,"C",        2,32}, /* 2f: 0100 1000 0010 1111                      */

	{illegal,0, 	 2, 8}, /* 30: 0100 1000 0011 0000                      */
	{RLR,"A",        2, 8}, /* 31: 0100 1000 0011 0001                      */
	{RLR,"B",        2, 8}, /* 32: 0100 1000 0011 0010                      */
	{RLR,"C",        2, 8}, /* 33: 0100 1000 0011 0011                      */
	{illegal,0, 	 2, 8}, /* 34: 0100 1000 0011 0100                      */
	{RLL,"A",        2, 8}, /* 35: 0100 1000 0011 0101                      */
	{RLL,"B",        2, 8}, /* 36: 0100 1000 0011 0110                      */
	{RLL,"C",        2, 8}, /* 37: 0100 1000 0011 0111                      */
	{RLD,0, 		 2,17}, /* 38: 0100 1000 0011 1000                      */
	{RRD,0, 		 2,17}, /* 39: 0100 1000 0011 1001                      */
	{NEGA,0,		 2, 8}, /* 3a: 0100 1000 0011 1010                      */
	{HALT,0,		 2,12}, /* 3b: 0100 1000 0011 1011                      */
	{illegal,0, 	 2,59}, /* 3c: 0100 1000 0011 1100                      */
	{DIV,"A",        2,59}, /* 3d: 0100 1000 0011 1101                      */
	{DIV,"B",        2,59}, /* 3e: 0100 1000 0011 1110                      */
	{DIV,"C",        2,59}, /* 3f: 0100 1000 0011 1111                      */

	{SKIT,"NMI",     2, 8}, /* 40: 0100 1000 0100 0000                      */
	{SKIT,"FT0",     2, 8}, /* 41: 0100 1000 0100 0001                      */
	{SKIT,"FT1",     2, 8}, /* 42: 0100 1000 0100 0010                      */
	{SKIT,"F1",      2, 8}, /* 43: 0100 1000 0100 0011                      */
	{SKIT,"F2",      2, 8}, /* 44: 0100 1000 0100 0100                      */
	{SKIT,"FE0",     2, 8}, /* 45: 0100 1000 0100 0101                      */
	{SKIT,"FE1",     2, 8}, /* 46: 0100 1000 0100 0110                      */
	{SKIT,"FEIN",    2, 8}, /* 47: 0100 1000 0100 0111                      */
	{SKIT,"FAD",     2, 8}, /* 48: 0100 1000 0100 1000                      */
	{SKIT,"FSR",     2, 8}, /* 49: 0100 1000 0100 1001                      */
	{SKIT,"FST",     2, 8}, /* 4a: 0100 1000 0100 1010                      */
	{SKIT,"ER",      2, 8}, /* 4b: 0100 1000 0100 1011                      */
	{SKIT,"OV",      2, 8}, /* 4c: 0100 1000 0100 1100                      */
	{illegal,0, 	 2, 8}, /* 4d: 0100 1000 0100 1101                      */
	{illegal,0, 	 2, 8}, /* 4e: 0100 1000 0100 1110                      */
	{illegal,0, 	 2, 8}, /* 4f: 0100 1000 0100 1111                      */

	{SKIT,"AN4",     2, 8}, /* 50: 0100 1000 0101 0000                      */
	{SKIT,"AN5",     2, 8}, /* 51: 0100 1000 0101 0001                      */
	{SKIT,"AN6",     2, 8}, /* 52: 0100 1000 0101 0010                      */
	{SKIT,"AN7",     2, 8}, /* 53: 0100 1000 0101 0011                      */
	{SKIT,"SB",      2, 8}, /* 54: 0100 1000 0101 0100                      */
	{illegal,0, 	 2, 8}, /* 55: 0100 1000 0101 0101                      */
	{illegal,0, 	 2, 8}, /* 56: 0100 1000 0101 0110                      */
	{illegal,0, 	 2, 8}, /* 57: 0100 1000 0101 0111                      */
	{illegal,0, 	 2, 8}, /* 58: 0100 1000 0101 1000                      */
	{illegal,0, 	 2, 8}, /* 59: 0100 1000 0101 1001                      */
	{illegal,0, 	 2, 8}, /* 5a: 0100 1000 0101 1010                      */
	{illegal,0, 	 2, 8}, /* 5b: 0100 1000 0101 1011                      */
	{illegal,0, 	 2, 8}, /* 5c: 0100 1000 0101 1100                      */
	{illegal,0, 	 2, 8}, /* 5d: 0100 1000 0101 1101                      */
	{illegal,0, 	 2, 8}, /* 5e: 0100 1000 0101 1110                      */
	{illegal,0, 	 2, 8}, /* 5f: 0100 1000 0101 1111                      */

	{SKNIT,"NMI",    2, 8}, /* 60: 0100 1000 0110 0000                      */
	{SKNIT,"FT0",    2, 8}, /* 61: 0100 1000 0110 0001                      */
	{SKNIT,"FT1",    2, 8}, /* 62: 0100 1000 0110 0010                      */
	{SKNIT,"F1",     2, 8}, /* 63: 0100 1000 0110 0011                      */
	{SKNIT,"F2",     2, 8}, /* 64: 0100 1000 0110 0100                      */
	{SKNIT,"FE0",    2, 8}, /* 65: 0100 1000 0110 0101                      */
	{SKNIT,"FE1",    2, 8}, /* 66: 0100 1000 0110 0110                      */
	{SKNIT,"FEIN",   2, 8}, /* 67: 0100 1000 0110 0111                      */
	{SKNIT,"FAD",    2, 8}, /* 68: 0100 1000 0110 1000                      */
	{SKNIT,"FSR",    2, 8}, /* 69: 0100 1000 0110 1001                      */
	{SKNIT,"FST",    2, 8}, /* 6a: 0100 1000 0110 1010                      */
	{SKNIT,"ER",     2, 8}, /* 6b: 0100 1000 0110 1011                      */
	{SKNIT,"OV",     2, 8}, /* 6c: 0100 1000 0110 1100                      */
	{illegal,0, 	 2, 8}, /* 6d: 0100 1000 0110 1101                      */
	{illegal,0, 	 2, 8}, /* 6e: 0100 1000 0110 1110                      */
	{illegal,0, 	 2, 8}, /* 6f: 0100 1000 0110 1111                      */

	{SKNIT,"AN4",    2, 8}, /* 70: 0100 1000 0111 0000                      */
	{SKNIT,"AN5",    2, 8}, /* 71: 0100 1000 0111 0001                      */
	{SKNIT,"AN6",    2, 8}, /* 72: 0100 1000 0111 0010                      */
	{SKNIT,"AN7",    2, 8}, /* 73: 0100 1000 0111 0011                      */
	{SKNIT,"SB",     2, 8}, /* 74: 0100 1000 0111 0100                      */
	{illegal,0, 	 2, 8}, /* 75: 0100 1000 0111 0101                      */
	{illegal,0, 	 2, 8}, /* 76: 0100 1000 0111 0110                      */
	{illegal,0, 	 2, 8}, /* 77: 0100 1000 0111 0111                      */
	{illegal,0, 	 2, 8}, /* 78: 0100 1000 0111 1000                      */
	{illegal,0, 	 2, 8}, /* 79: 0100 1000 0111 1001                      */
	{illegal,0, 	 2, 8}, /* 7a: 0100 1000 0111 1010                      */
	{illegal,0, 	 2, 8}, /* 7b: 0100 1000 0111 1011                      */
	{illegal,0, 	 2, 8}, /* 7c: 0100 1000 0111 1100                      */
	{illegal,0, 	 2, 8}, /* 7d: 0100 1000 0111 1101                      */
	{illegal,0, 	 2, 8}, /* 7e: 0100 1000 0111 1110                      */
	{illegal,0, 	 2, 8}, /* 7f: 0100 1000 0111 1111                      */

	{illegal,0, 	 2, 8}, /* 80: 0100 1000 1000 0000                      */
	{illegal,0, 	 2, 8}, /* 81: 0100 1000 1000 0001                      */
	{LDEAX,"(DE)",   2,14}, /* 82: 0100 1000 1000 0010                      */
	{LDEAX,"(HL)",   2,14}, /* 83: 0100 1000 1000 0011                      */
	{LDEAX,"(DE++)", 2,14}, /* 84: 0100 1000 1000 0100                      */
	{LDEAX,"(HL++)", 2,14}, /* 85: 0100 1000 1000 0101                      */
	{illegal,0, 	 2, 8}, /* 86: 0100 1000 1000 0110                      */
	{illegal,0, 	 2, 8}, /* 87: 0100 1000 1000 0111                      */
	{illegal,0, 	 2, 8}, /* 88: 0100 1000 1000 1000                      */
	{illegal,0, 	 2, 8}, /* 89: 0100 1000 1000 1001                      */
	{illegal,0, 	 2, 8}, /* 8a: 0100 1000 1000 1010                      */
	{LDEAX,"(DE+%b)",3,20}, /* 8b: 0100 1000 1000 1011 xxxx xxxx            */
	{LDEAX,"(HL+A)", 2,20}, /* 8c: 0100 1000 1000 1100                      */
	{LDEAX,"(HL+B)", 2,20}, /* 8d: 0100 1000 1000 1101                      */
	{LDEAX,"(HL+EA)",2,20}, /* 8e: 0100 1000 1000 1110                      */
	{LDEAX,"(HL+%b)",3,20}, /* 8f: 0100 1000 1000 1111 xxxx xxxx            */

	{illegal,0, 	 2, 8}, /* 90: 0100 1000 1000 0000                      */
	{illegal,0, 	 2, 8}, /* 91: 0100 1000 1000 0001                      */
	{STEAX,"(DE)",   2,14}, /* 92: 0100 1000 1000 0010                      */
	{STEAX,"(HL)",   2,14}, /* 93: 0100 1000 1000 0011                      */
	{STEAX,"(DE++)", 2,14}, /* 94: 0100 1000 1000 0100                      */
	{STEAX,"(HL++)", 2,14}, /* 95: 0100 1000 1000 0101                      */
	{illegal,0, 	 2, 8}, /* 96: 0100 1000 1000 0110                      */
	{illegal,0, 	 2, 8}, /* 97: 0100 1000 1000 0111                      */
	{illegal,0, 	 2, 8}, /* 98: 0100 1000 1000 1000                      */
	{illegal,0, 	 2, 8}, /* 99: 0100 1000 1000 1001                      */
	{illegal,0, 	 2, 8}, /* 9a: 0100 1000 1000 1010                      */
	{STEAX,"(DE+%b)",3,20}, /* 9b: 0100 1000 1000 1011 xxxx xxxx            */
	{STEAX,"(HL+A)", 2,20}, /* 9c: 0100 1000 1000 1100                      */
	{STEAX,"(HL+B)", 2,20}, /* 9d: 0100 1000 1000 1101                      */
	{STEAX,"(HL+EA)",2,20}, /* 9e: 0100 1000 1000 1110                      */
	{STEAX,"(HL+%b)",3,20}, /* 9f: 0100 1000 1000 1111 xxxx xxxx            */

	{DSLR,"EA",      2, 8}, /* a0: 0100 1000 1010 0000                      */
	{illegal,0, 	 2, 8}, /* a1: 0100 1000 1010 0001                      */
	{illegal,0, 	 2, 8}, /* a2: 0100 1000 1010 0010                      */
	{illegal,0, 	 2, 8}, /* a3: 0100 1000 1010 0011                      */
	{DSLL,"EA",      2, 8}, /* a4: 0100 1000 1010 0100                      */
	{illegal,0, 	 2, 8}, /* a5: 0100 1000 1010 0101                      */
	{illegal,0, 	 2, 8}, /* a6: 0100 1000 1010 0110                      */
	{illegal,0, 	 2, 8}, /* a7: 0100 1000 1010 0111                      */
	{TABLE,0,		 2,17}, /* a8: 0100 1000 1010 1000                      */
	{illegal,0, 	 2, 8}, /* a9: 0100 1000 1010 1001                      */
	{CMC,0, 		 2, 8}, /* aa: 0100 1000 1010 1010                      */	/* 7807 */
	{illegal,0, 	 2, 8}, /* ab: 0100 1000 1010 1011                      */
	{EXA,0, 		 2, 8}, /* ac: 0100 1000 1010 1100                      */	/* 7807 */
	{EXR,0, 		 2, 8}, /* ad: 0100 1000 1010 1101                      */	/* 7807 */
	{EXH,0, 		 2, 8}, /* ae: 0100 1000 1010 1110                      */	/* 7807 */
	{EXX,0, 		 2, 8}, /* af: 0100 1000 1010 1111                      */	/* 7807 */

	{DRLR,"EA",      2, 8}, /* b0: 0100 1000 1011 0000                      */
	{illegal,0, 	 2, 8}, /* b1: 0100 1000 1011 0001                      */
	{illegal,0, 	 2, 8}, /* b2: 0100 1000 1011 0010                      */
	{illegal,0, 	 2, 8}, /* b3: 0100 1000 1011 0011                      */
	{DRLL,"EA",      2, 8}, /* b4: 0100 1000 1011 0100                      */
	{illegal,0, 	 2, 8}, /* b5: 0100 1000 1011 0101                      */
	{illegal,0, 	 2, 8}, /* b6: 0100 1000 1011 0110                      */
	{illegal,0, 	 2, 8}, /* b7: 0100 1000 1011 0111                      */
	{illegal,0, 	 2, 8}, /* b8: 0100 1000 1011 1000                      */
	{illegal,0, 	 2, 8}, /* b9: 0100 1000 1011 1001                      */
	{illegal,0, 	 2, 8}, /* ba: 0100 1000 1011 1010                      */
	{illegal,0,		 2, 8}, /* bb: 0100 1000 1011 1011                      */
	{illegal,0, 	 2, 8}, /* bc: 0100 1000 1011 1100                      */
	{illegal,0, 	 2, 8}, /* bd: 0100 1000 1011 1101                      */
	{illegal,0, 	 2, 8}, /* be: 0100 1000 1011 1110                      */
	{illegal,0, 	 2, 8}, /* bf: 0100 1000 1011 1111                      */

	{DMOV,"EA,ECNT", 2,14}, /* c0: 0100 1000 1100 0000                      */
	{DMOV,"EA,ECPT0",2,14}, /* c1: 0100 1000 1100 0001                      */	/* 7807 */
	{DMOV,"EA,ECPT1",2,14}, /* c2: 0100 1000 1100 0010                      */	/* 7807 */
	{illegal,0, 	 2, 8}, /* c3: 0100 1000 1100 0011                      */
	{illegal,0, 	 2, 8}, /* c4: 0100 1000 1100 0100                      */
	{illegal,0, 	 2, 8}, /* c5: 0100 1000 1100 0101                      */
	{illegal,0, 	 2, 8}, /* c6: 0100 1000 1100 0110                      */
	{illegal,0, 	 2, 8}, /* c7: 0100 1000 1100 0111                      */
	{illegal,0, 	 2, 8}, /* c8: 0100 1000 1100 1000                      */
	{illegal,0, 	 2, 8}, /* c9: 0100 1000 1100 1001                      */
	{illegal,0, 	 2, 8}, /* ca: 0100 1000 1100 1010                      */
	{illegal,0, 	 2, 8}, /* cb: 0100 1000 1100 1011                      */
	{illegal,0, 	 2, 8}, /* cc: 0100 1000 1100 1100                      */
	{illegal,0, 	 2, 8}, /* cd: 0100 1000 1100 1101                      */
	{illegal,0, 	 2, 8}, /* ce: 0100 1000 1100 1110                      */
	{illegal,0, 	 2, 8}, /* cf: 0100 1000 1100 1111                      */

	{illegal,0, 	 2, 8}, /* d0: 0100 1000 1101 0000                      */
	{illegal,0, 	 2, 8}, /* d1: 0100 1000 1101 0001                      */
	{DMOV,"ETM0,EA", 2,14}, /* d2: 0100 1000 1101 0010                      */
	{DMOV,"ETM1,EA", 2,14}, /* d3: 0100 1000 1101 0011                      */
	{illegal,0, 	 2, 8}, /* d4: 0100 1000 1101 0100                      */
	{illegal,0, 	 2, 8}, /* d5: 0100 1000 1101 0101                      */
	{illegal,0, 	 2, 8}, /* d6: 0100 1000 1101 0110                      */
	{illegal,0, 	 2, 8}, /* d7: 0100 1000 1101 0111                      */
	{illegal,0, 	 2, 8}, /* d8: 0100 1000 1101 1000                      */
	{illegal,0, 	 2, 8}, /* d9: 0100 1000 1101 1001                      */
	{illegal,0, 	 2, 8}, /* da: 0100 1000 1101 1010                      */
	{illegal,0, 	 2, 8}, /* db: 0100 1000 1101 1011                      */
	{illegal,0, 	 2, 8}, /* dc: 0100 1000 1101 1100                      */
	{illegal,0, 	 2, 8}, /* dd: 0100 1000 1101 1101                      */
	{illegal,0, 	 2, 8}, /* de: 0100 1000 1101 1110                      */
	{illegal,0, 	 2, 8}, /* df: 0100 1000 1101 1111                      */

	{illegal,0, 	 2, 8}, /* e0: 0100 1000 1110 0000                      */
	{illegal,0, 	 2, 8}, /* e1: 0100 1000 1110 0001                      */
	{illegal,0, 	 2, 8}, /* e2: 0100 1000 1110 0010                      */
	{illegal,0, 	 2, 8}, /* e3: 0100 1000 1110 0011                      */
	{illegal,0, 	 2, 8}, /* e4: 0100 1000 1110 0100                      */
	{illegal,0, 	 2, 8}, /* e5: 0100 1000 1110 0101                      */
	{illegal,0, 	 2, 8}, /* e6: 0100 1000 1110 0110                      */
	{illegal,0, 	 2, 8}, /* e7: 0100 1000 1110 0111                      */
	{illegal,0, 	 2, 8}, /* e8: 0100 1000 1110 1000                      */
	{illegal,0, 	 2, 8}, /* e9: 0100 1000 1110 1001                      */
	{illegal,0, 	 2, 8}, /* ea: 0100 1000 1110 1010                      */
	{illegal,0, 	 2, 8}, /* eb: 0100 1000 1110 1011                      */
	{illegal,0, 	 2, 8}, /* ec: 0100 1000 1110 1100                      */
	{illegal,0, 	 2, 8}, /* ed: 0100 1000 1110 1101                      */
	{illegal,0, 	 2, 8}, /* ee: 0100 1000 1110 1110                      */
	{illegal,0, 	 2, 8}, /* ef: 0100 1000 1110 1111                      */

	{illegal,0, 	 2, 8}, /* f0: 0100 1000 1111 0000                      */
	{illegal,0, 	 2, 8}, /* f1: 0100 1000 1111 0001                      */
	{illegal,0, 	 2, 8}, /* f2: 0100 1000 1111 0010                      */
	{illegal,0, 	 2, 8}, /* f3: 0100 1000 1111 0011                      */
	{illegal,0, 	 2, 8}, /* f4: 0100 1000 1111 0100                      */
	{illegal,0, 	 2, 8}, /* f5: 0100 1000 1111 0101                      */
	{illegal,0, 	 2, 8}, /* f6: 0100 1000 1111 0110                      */
	{illegal,0, 	 2, 8}, /* f7: 0100 1000 1111 0111                      */
	{illegal,0, 	 2, 8}, /* f8: 0100 1000 1111 1000                      */
	{illegal,0, 	 2, 8}, /* f9: 0100 1000 1111 1001                      */
	{illegal,0, 	 2, 8}, /* fa: 0100 1000 1111 1010                      */
	{illegal,0, 	 2, 8}, /* fb: 0100 1000 1111 1011                      */
	{illegal,0, 	 2, 8}, /* fc: 0100 1000 1111 1100                      */
	{illegal,0, 	 2, 8}, /* fd: 0100 1000 1111 1101                      */
	{illegal,0, 	 2, 8}, /* fe: 0100 1000 1111 1110                      */
	{illegal,0, 	 2, 8}	/* ff: 0100 1000 1111 1111                      */
};

/* prefix 4C */
static struct dasm_s  dasm4C_7810[256] =
{
	{illegal,0, 	 2, 8}, /* 00: 0100 1100 0000 0000                      */
	{illegal,0, 	 2, 8}, /* 01: 0100 1100 0000 0001                      */
	{illegal,0, 	 2, 8}, /* 02: 0100 1100 0000 0010                      */
	{illegal,0, 	 2, 8}, /* 03: 0100 1100 0000 0011                      */
	{illegal,0, 	 2, 8}, /* 04: 0100 1100 0000 0100                      */
	{illegal,0, 	 2, 8}, /* 05: 0100 1100 0000 0101                      */
	{illegal,0, 	 2, 8}, /* 06: 0100 1100 0000 0110                      */
	{illegal,0, 	 2, 8}, /* 07: 0100 1100 0000 0111                      */
	{illegal,0, 	 2, 8}, /* 08: 0100 1100 0000 1000                      */
	{illegal,0, 	 2, 8}, /* 09: 0100 1100 0000 1001                      */
	{illegal,0, 	 2, 8}, /* 0a: 0100 1100 0000 1010                      */
	{illegal,0, 	 2, 8}, /* 0b: 0100 1100 0000 1011                      */
	{illegal,0, 	 2, 8}, /* 0c: 0100 1100 0000 1100                      */
	{illegal,0, 	 2, 8}, /* 0d: 0100 1100 0000 1101                      */
	{illegal,0, 	 2, 8}, /* 0e: 0100 1100 0000 1110                      */
	{illegal,0, 	 2, 8}, /* 0f: 0100 1100 0000 1111                      */

	{illegal,0, 	 2, 8}, /* 10: 0100 1100 0001 0000                      */
	{illegal,0, 	 2, 8}, /* 11: 0100 1100 0001 0001                      */
	{illegal,0, 	 2, 8}, /* 12: 0100 1100 0001 0010                      */
	{illegal,0, 	 2, 8}, /* 13: 0100 1100 0001 0011                      */
	{illegal,0, 	 2, 8}, /* 14: 0100 1100 0001 0100                      */
	{illegal,0, 	 2, 8}, /* 15: 0100 1100 0001 0101                      */
	{illegal,0, 	 2, 8}, /* 16: 0100 1100 0001 0110                      */
	{illegal,0, 	 2, 8}, /* 17: 0100 1100 0001 0111                      */
	{illegal,0, 	 2, 8}, /* 18: 0100 1100 0001 1000                      */
	{illegal,0, 	 2, 8}, /* 19: 0100 1100 0001 1001                      */
	{illegal,0, 	 2, 8}, /* 1a: 0100 1100 0001 1010                      */
	{illegal,0, 	 2, 8}, /* 1b: 0100 1100 0001 1011                      */
	{illegal,0, 	 2, 8}, /* 1c: 0100 1100 0001 1100                      */
	{illegal,0, 	 2, 8}, /* 1d: 0100 1100 0001 1101                      */
	{illegal,0, 	 2, 8}, /* 1e: 0100 1100 0001 1110                      */
	{illegal,0, 	 2, 8}, /* 1f: 0100 1100 0001 1111                      */

	{illegal,0, 	 2, 8}, /* 20: 0100 1100 0010 0000                      */
	{illegal,0, 	 2, 8}, /* 21: 0100 1100 0010 0001                      */
	{illegal,0, 	 2, 8}, /* 22: 0100 1100 0010 0010                      */
	{illegal,0, 	 2, 8}, /* 23: 0100 1100 0010 0011                      */
	{illegal,0, 	 2, 8}, /* 24: 0100 1100 0010 0100                      */
	{illegal,0, 	 2, 8}, /* 25: 0100 1100 0010 0101                      */
	{illegal,0, 	 2, 8}, /* 26: 0100 1100 0010 0110                      */
	{illegal,0, 	 2, 8}, /* 27: 0100 1100 0010 0111                      */
	{illegal,0, 	 2, 8}, /* 28: 0100 1100 0010 1000                      */
	{illegal,0, 	 2, 8}, /* 29: 0100 1100 0010 1001                      */
	{illegal,0, 	 2, 8}, /* 2a: 0100 1100 0010 1010                      */
	{illegal,0, 	 2, 8}, /* 2b: 0100 1100 0010 1011                      */
	{illegal,0, 	 2, 8}, /* 2c: 0100 1100 0010 1100                      */
	{illegal,0, 	 2, 8}, /* 2d: 0100 1100 0010 1101                      */
	{illegal,0, 	 2, 8}, /* 2e: 0100 1100 0010 1110                      */
	{illegal,0, 	 2, 8}, /* 2f: 0100 1100 0010 1111                      */

	{illegal,0, 	 2, 8}, /* 30: 0100 1100 0011 0000                      */
	{illegal,0, 	 2, 8}, /* 31: 0100 1100 0011 0001                      */
	{illegal,0, 	 2, 8}, /* 32: 0100 1100 0011 0010                      */
	{illegal,0, 	 2, 8}, /* 33: 0100 1100 0011 0011                      */
	{illegal,0, 	 2, 8}, /* 34: 0100 1100 0011 0100                      */
	{illegal,0, 	 2, 8}, /* 35: 0100 1100 0011 0101                      */
	{illegal,0, 	 2, 8}, /* 36: 0100 1100 0011 0110                      */
	{illegal,0, 	 2, 8}, /* 37: 0100 1100 0011 0111                      */
	{illegal,0, 	 2, 8}, /* 38: 0100 1100 0011 1000                      */
	{illegal,0, 	 2, 8}, /* 39: 0100 1100 0011 1001                      */
	{illegal,0, 	 2, 8}, /* 3a: 0100 1100 0011 1010                      */
	{illegal,0, 	 2, 8}, /* 3b: 0100 1100 0011 1011                      */
	{illegal,0, 	 2, 8}, /* 3c: 0100 1100 0011 1100                      */
	{illegal,0, 	 2, 8}, /* 3d: 0100 1100 0011 1101                      */
	{illegal,0, 	 2, 8}, /* 3e: 0100 1100 0011 1110                      */
	{illegal,0, 	 2, 8}, /* 3f: 0100 1100 0011 1111                      */

	{illegal,0, 	 2, 8}, /* 40: 0100 1100 0100 0000                      */
	{illegal,0, 	 2, 8}, /* 41: 0100 1100 0100 0001                      */
	{illegal,0, 	 2, 8}, /* 42: 0100 1100 0100 0010                      */
	{illegal,0, 	 2, 8}, /* 43: 0100 1100 0100 0011                      */
	{illegal,0, 	 2, 8}, /* 44: 0100 1100 0100 0100                      */
	{illegal,0, 	 2, 8}, /* 45: 0100 1100 0100 0101                      */
	{illegal,0, 	 2, 8}, /* 46: 0100 1100 0100 0110                      */
	{illegal,0, 	 2, 8}, /* 47: 0100 1100 0100 0111                      */
	{illegal,0, 	 2, 8}, /* 48: 0100 1100 0100 1000                      */
	{illegal,0, 	 2, 8}, /* 49: 0100 1100 0100 1001                      */
	{illegal,0, 	 2, 8}, /* 4a: 0100 1100 0100 1010                      */
	{illegal,0, 	 2, 8}, /* 4b: 0100 1100 0100 1011                      */
	{illegal,0, 	 2, 8}, /* 4c: 0100 1100 0100 1100                      */
	{illegal,0, 	 2, 8}, /* 4d: 0100 1100 0100 1101                      */
	{illegal,0, 	 2, 8}, /* 4e: 0100 1100 0100 1110                      */
	{illegal,0, 	 2, 8}, /* 4f: 0100 1100 0100 1111                      */

	{illegal,0, 	 2, 8}, /* 50: 0100 1100 0101 0000                      */
	{illegal,0, 	 2, 8}, /* 51: 0100 1100 0101 0001                      */
	{illegal,0, 	 2, 8}, /* 52: 0100 1100 0101 0010                      */
	{illegal,0, 	 2, 8}, /* 53: 0100 1100 0101 0011                      */
	{illegal,0, 	 2, 8}, /* 54: 0100 1100 0101 0100                      */
	{illegal,0, 	 2, 8}, /* 55: 0100 1100 0101 0101                      */
	{illegal,0, 	 2, 8}, /* 56: 0100 1100 0101 0110                      */
	{illegal,0, 	 2, 8}, /* 57: 0100 1100 0101 0111                      */
	{illegal,0, 	 2, 8}, /* 58: 0100 1100 0101 1000                      */
	{illegal,0, 	 2, 8}, /* 59: 0100 1100 0101 1001                      */
	{illegal,0, 	 2, 8}, /* 5a: 0100 1100 0101 1010                      */
	{illegal,0, 	 2, 8}, /* 5b: 0100 1100 0101 1011                      */
	{illegal,0, 	 2, 8}, /* 5c: 0100 1100 0101 1100                      */
	{illegal,0, 	 2, 8}, /* 5d: 0100 1100 0101 1101                      */
	{illegal,0, 	 2, 8}, /* 5e: 0100 1100 0101 1110                      */
	{illegal,0, 	 2, 8}, /* 5f: 0100 1100 0101 1111                      */

	{illegal,0, 	 2, 8}, /* 60: 0100 1100 0110 0000                      */
	{illegal,0, 	 2, 8}, /* 61: 0100 1100 0110 0001                      */
	{illegal,0, 	 2, 8}, /* 62: 0100 1100 0110 0010                      */
	{illegal,0, 	 2, 8}, /* 63: 0100 1100 0110 0011                      */
	{illegal,0, 	 2, 8}, /* 64: 0100 1100 0110 0100                      */
	{illegal,0, 	 2, 8}, /* 65: 0100 1100 0110 0101                      */
	{illegal,0, 	 2, 8}, /* 66: 0100 1100 0110 0110                      */
	{illegal,0, 	 2, 8}, /* 67: 0100 1100 0110 0111                      */
	{illegal,0, 	 2, 8}, /* 68: 0100 1100 0110 1000                      */
	{illegal,0, 	 2, 8}, /* 69: 0100 1100 0110 1001                      */
	{illegal,0, 	 2, 8}, /* 6a: 0100 1100 0110 1010                      */
	{illegal,0, 	 2, 8}, /* 6b: 0100 1100 0110 1011                      */
	{illegal,0, 	 2, 8}, /* 6c: 0100 1100 0110 1100                      */
	{illegal,0, 	 2, 8}, /* 6d: 0100 1100 0110 1101                      */
	{illegal,0, 	 2, 8}, /* 6e: 0100 1100 0110 1110                      */
	{illegal,0, 	 2, 8}, /* 6f: 0100 1100 0110 1111                      */

	{illegal,0, 	 2, 8}, /* 70: 0100 1100 0111 0000                      */
	{illegal,0, 	 2, 8}, /* 71: 0100 1100 0111 0001                      */
	{illegal,0, 	 2, 8}, /* 72: 0100 1100 0111 0010                      */
	{illegal,0, 	 2, 8}, /* 73: 0100 1100 0111 0011                      */
	{illegal,0, 	 2, 8}, /* 74: 0100 1100 0111 0100                      */
	{illegal,0, 	 2, 8}, /* 75: 0100 1100 0111 0101                      */
	{illegal,0, 	 2, 8}, /* 76: 0100 1100 0111 0110                      */
	{illegal,0, 	 2, 8}, /* 77: 0100 1100 0111 0111                      */
	{illegal,0, 	 2, 8}, /* 78: 0100 1100 0111 1000                      */
	{illegal,0, 	 2, 8}, /* 79: 0100 1100 0111 1001                      */
	{illegal,0, 	 2, 8}, /* 7a: 0100 1100 0111 1010                      */
	{illegal,0, 	 2, 8}, /* 7b: 0100 1100 0111 1011                      */
	{illegal,0, 	 2, 8}, /* 7c: 0100 1100 0111 1100                      */
	{illegal,0, 	 2, 8}, /* 7d: 0100 1100 0111 1101                      */
	{illegal,0, 	 2, 8}, /* 7e: 0100 1100 0111 1110                      */
	{illegal,0, 	 2, 8}, /* 7f: 0100 1100 0111 1111                      */

	{illegal,0, 	 2, 8}, /* 80: 0100 1100 1000 0000                      */
	{illegal,0, 	 2, 8}, /* 81: 0100 1100 1000 0001                      */
	{illegal,0, 	 2, 8}, /* 82: 0100 1100 1000 0010                      */
	{illegal,0, 	 2, 8}, /* 83: 0100 1100 1000 0011                      */
	{illegal,0, 	 2, 8}, /* 84: 0100 1100 1000 0100                      */
	{illegal,0, 	 2, 8}, /* 85: 0100 1100 1000 0101                      */
	{illegal,0, 	 2, 8}, /* 86: 0100 1100 1000 0110                      */
	{illegal,0, 	 2, 8}, /* 87: 0100 1100 1000 0111                      */
	{illegal,0, 	 2, 8}, /* 88: 0100 1100 1000 1000                      */
	{illegal,0, 	 2, 8}, /* 89: 0100 1100 1000 1001                      */
	{illegal,0, 	 2, 8}, /* 8a: 0100 1100 1000 1010                      */
	{illegal,0, 	 2, 8}, /* 8b: 0100 1100 1000 1011                      */
	{illegal,0, 	 2, 8}, /* 8c: 0100 1100 1000 1100                      */
	{illegal,0, 	 2, 8}, /* 8d: 0100 1100 1000 1101                      */
	{illegal,0, 	 2, 8}, /* 8e: 0100 1100 1000 1110                      */
	{illegal,0, 	 2, 8}, /* 8f: 0100 1100 1000 1111                      */

	{illegal,0, 	 2, 8}, /* 90: 0100 1100 1001 0000                      */
	{illegal,0, 	 2, 8}, /* 91: 0100 1100 1001 0001                      */
	{illegal,0, 	 2, 8}, /* 92: 0100 1100 1001 0010                      */
	{illegal,0, 	 2, 8}, /* 93: 0100 1100 1001 0011                      */
	{illegal,0, 	 2, 8}, /* 94: 0100 1100 1001 0100                      */
	{illegal,0, 	 2, 8}, /* 95: 0100 1100 1001 0101                      */
	{illegal,0, 	 2, 8}, /* 96: 0100 1100 1001 0110                      */
	{illegal,0, 	 2, 8}, /* 97: 0100 1100 1001 0111                      */
	{illegal,0, 	 2, 8}, /* 98: 0100 1100 1001 1000                      */
	{illegal,0, 	 2, 8}, /* 99: 0100 1100 1001 1001                      */
	{illegal,0, 	 2, 8}, /* 9a: 0100 1100 1001 1010                      */
	{illegal,0, 	 2, 8}, /* 9b: 0100 1100 1001 1011                      */
	{illegal,0, 	 2, 8}, /* 9c: 0100 1100 1001 1100                      */
	{illegal,0, 	 2, 8}, /* 9d: 0100 1100 1001 1101                      */
	{illegal,0, 	 2, 8}, /* 9e: 0100 1100 1001 1110                      */
	{illegal,0, 	 2, 8}, /* 9f: 0100 1100 1001 1111                      */

	{illegal,0, 	 2, 8}, /* a0: 0100 1100 1010 0000                      */
	{illegal,0, 	 2, 8}, /* a1: 0100 1100 1010 0001                      */
	{illegal,0, 	 2, 8}, /* a2: 0100 1100 1010 0010                      */
	{illegal,0, 	 2, 8}, /* a3: 0100 1100 1010 0011                      */
	{illegal,0, 	 2, 8}, /* a4: 0100 1100 1010 0100                      */
	{illegal,0, 	 2, 8}, /* a5: 0100 1100 1010 0101                      */
	{illegal,0, 	 2, 8}, /* a6: 0100 1100 1010 0110                      */
	{illegal,0, 	 2, 8}, /* a7: 0100 1100 1010 0111                      */
	{illegal,0, 	 2, 8}, /* a8: 0100 1100 1010 1000                      */
	{illegal,0, 	 2, 8}, /* a9: 0100 1100 1010 1001                      */
	{illegal,0, 	 2, 8}, /* aa: 0100 1100 1010 1010                      */
	{illegal,0, 	 2, 8}, /* ab: 0100 1100 1010 1011                      */
	{illegal,0, 	 2, 8}, /* ac: 0100 1100 1010 1100                      */
	{illegal,0, 	 2, 8}, /* ad: 0100 1100 1010 1101                      */
	{illegal,0, 	 2, 8}, /* ae: 0100 1100 1010 1110                      */
	{illegal,0, 	 2, 8}, /* af: 0100 1100 1010 1111                      */

	{illegal,0, 	 2, 8}, /* b0: 0100 1100 1011 0000                      */
	{illegal,0, 	 2, 8}, /* b1: 0100 1100 1011 0001                      */
	{illegal,0, 	 2, 8}, /* b2: 0100 1100 1011 0010                      */
	{illegal,0, 	 2, 8}, /* b3: 0100 1100 1011 0011                      */
	{illegal,0, 	 2, 8}, /* b4: 0100 1100 1011 0100                      */
	{illegal,0, 	 2, 8}, /* b5: 0100 1100 1011 0101                      */
	{illegal,0, 	 2, 8}, /* b6: 0100 1100 1011 0110                      */
	{illegal,0, 	 2, 8}, /* b7: 0100 1100 1011 0111                      */
	{illegal,0, 	 2, 8}, /* b8: 0100 1100 1011 1000                      */
	{illegal,0, 	 2, 8}, /* b9: 0100 1100 1011 1001                      */
	{illegal,0, 	 2, 8}, /* ba: 0100 1100 1011 1010                      */
	{illegal,0, 	 2, 8}, /* bb: 0100 1100 1011 1011                      */
	{illegal,0, 	 2, 8}, /* bc: 0100 1100 1011 1100                      */
	{illegal,0, 	 2, 8}, /* bd: 0100 1100 1011 1101                      */
	{illegal,0, 	 2, 8}, /* be: 0100 1100 1011 1110                      */
	{illegal,0, 	 2, 8}, /* bf: 0100 1100 1011 1111                      */

	{MOV,"A,PA",     2,10}, /* c0: 0100 1100 1100 0000                      */
	{MOV,"A,PB",     2,10}, /* c1: 0100 1100 1100 0001                      */
	{MOV,"A,PC",     2,10}, /* c2: 0100 1100 1100 0010                      */
	{MOV,"A,PD",     2,10}, /* c3: 0100 1100 1100 0011                      */
	{illegal,0, 	 2,10}, /* c4: 0100 1100 1100 0100                      */
	{MOV,"A,PF",     2,10}, /* c5: 0100 1100 1100 0101                      */
	{MOV,"A,MKH",    2,10}, /* c6: 0100 1100 1100 0110                      */
	{MOV,"A,MKL",    2,10}, /* c7: 0100 1100 1100 0111                      */
	{MOV,"A,ANM",    2,10}, /* c8: 0100 1100 1100 1000                      */	/* 7810 */
	{MOV,"A,SMH",    2,10}, /* c9: 0100 1100 1100 1001                      */
	{illegal,0, 	 2,10}, /* ca: 0100 1100 1100 1010                      */
	{MOV,"A,EOM",    2,10}, /* cb: 0100 1100 1100 1011                      */
	{illegal,0, 	 2,10}, /* cc: 0100 1100 1100 1100                      */
	{MOV,"A,TMM",    2,10}, /* cd: 0100 1100 1100 1101                      */
	{illegal,0, 	 2,10}, /* ce: 0100 1100 1100 1110                      */
	{illegal,0, 	 2,10}, /* cf: 0100 1100 1100 1111                      */

	{illegal,0, 	 2,10}, /* d0: 0100 1100 1101 0000                      */
	{illegal,0, 	 2,10}, /* d1: 0100 1100 1101 0001                      */
	{illegal,0, 	 2,10}, /* d2: 0100 1100 1101 0010                      */
	{illegal,0, 	 2,10}, /* d3: 0100 1100 1101 0011                      */
	{illegal,0, 	 2,10}, /* d4: 0100 1100 1101 0100                      */
	{illegal,0, 	 2,10}, /* d5: 0100 1100 1101 0101                      */
	{illegal,0, 	 2,10}, /* d6: 0100 1100 1101 0110                      */
	{illegal,0, 	 2,10}, /* d7: 0100 1100 1101 0111                      */
	{illegal,0, 	 2,10}, /* d8: 0100 1100 1101 1000                      */
	{MOV,"A,RXB",    2,10}, /* d9: 0100 1100 1101 1001                      */
	{illegal,0, 	 2,10}, /* da: 0100 1100 1101 1010                      */
	{illegal,0, 	 2,10}, /* db: 0100 1100 1101 1011                      */
	{illegal,0, 	 2,10}, /* dc: 0100 1100 1101 1100                      */
	{illegal,0, 	 2,10}, /* dd: 0100 1100 1101 1101                      */
	{illegal,0, 	 2,10}, /* de: 0100 1100 1101 1110                      */
	{illegal,0, 	 2,10}, /* df: 0100 1100 1101 1111                      */

	{MOV,"A,CR0",    2,10}, /* e0: 0100 1100 1110 0000                      */	/* 7810 */
	{MOV,"A,CR1",    2,10}, /* e1: 0100 1100 1110 0001                      */	/* 7810 */
	{MOV,"A,CR2",    2,10}, /* e2: 0100 1100 1110 0010                      */	/* 7810 */
	{MOV,"A,CR3",    2,10}, /* e3: 0100 1100 1110 0011                      */	/* 7810 */
	{illegal,0, 	 2,10}, /* e4: 0100 1100 1110 0100                      */
	{illegal,0, 	 2,10}, /* e5: 0100 1100 1110 0101                      */
	{illegal,0, 	 2,10}, /* e6: 0100 1100 1110 0110                      */
	{illegal,0, 	 2,10}, /* e7: 0100 1100 1110 0111                      */
	{illegal,0, 	 2,10}, /* e8: 0100 1100 1110 1000                      */
	{illegal,0, 	 2,10}, /* e9: 0100 1100 1110 1001                      */
	{illegal,0, 	 2,10}, /* ea: 0100 1100 1110 1010                      */
	{illegal,0, 	 2,10}, /* eb: 0100 1100 1110 1011                      */
	{illegal,0, 	 2,10}, /* ec: 0100 1100 1110 1100                      */
	{illegal,0, 	 2,10}, /* ed: 0100 1100 1110 1101                      */
	{illegal,0, 	 2,10}, /* ee: 0100 1100 1110 1110                      */
	{illegal,0, 	 2,10}, /* ef: 0100 1100 1110 1111                      */

	{illegal,0, 	 2,10}, /* f0: 0100 1100 1111 0000                      */
	{illegal,0, 	 2,10}, /* f1: 0100 1100 1111 0001                      */
	{illegal,0, 	 2,10}, /* f2: 0100 1100 1111 0010                      */
	{illegal,0, 	 2,10}, /* f3: 0100 1100 1111 0011                      */
	{illegal,0, 	 2,10}, /* f4: 0100 1100 1111 0100                      */
	{illegal,0, 	 2,10}, /* f5: 0100 1100 1111 0101                      */
	{illegal,0, 	 2,10}, /* f6: 0100 1100 1111 0110                      */
	{illegal,0, 	 2,10}, /* f7: 0100 1100 1111 0111                      */
	{illegal,0, 	 2,10}, /* f8: 0100 1100 1111 1000                      */
	{illegal,0, 	 2,10}, /* f9: 0100 1100 1111 1001                      */
	{illegal,0, 	 2,10}, /* fa: 0100 1100 1111 1010                      */
	{illegal,0, 	 2,10}, /* fb: 0100 1100 1111 1011                      */
	{illegal,0, 	 2,10}, /* fc: 0100 1100 1111 1100                      */
	{illegal,0, 	 2,10}, /* fd: 0100 1100 1111 1101                      */
	{illegal,0, 	 2,10}, /* fe: 0100 1100 1111 1110                      */
	{illegal,0, 	 2,10}	/* ff: 0100 1100 1111 1111                      */
};

static struct dasm_s  dasm4C_7807[256] =
{
	{illegal,0, 	 2, 8}, /* 00: 0100 1100 0000 0000                      */
	{illegal,0, 	 2, 8}, /* 01: 0100 1100 0000 0001                      */
	{illegal,0, 	 2, 8}, /* 02: 0100 1100 0000 0010                      */
	{illegal,0, 	 2, 8}, /* 03: 0100 1100 0000 0011                      */
	{illegal,0, 	 2, 8}, /* 04: 0100 1100 0000 0100                      */
	{illegal,0, 	 2, 8}, /* 05: 0100 1100 0000 0101                      */
	{illegal,0, 	 2, 8}, /* 06: 0100 1100 0000 0110                      */
	{illegal,0, 	 2, 8}, /* 07: 0100 1100 0000 0111                      */
	{illegal,0, 	 2, 8}, /* 08: 0100 1100 0000 1000                      */
	{illegal,0, 	 2, 8}, /* 09: 0100 1100 0000 1001                      */
	{illegal,0, 	 2, 8}, /* 0a: 0100 1100 0000 1010                      */
	{illegal,0, 	 2, 8}, /* 0b: 0100 1100 0000 1011                      */
	{illegal,0, 	 2, 8}, /* 0c: 0100 1100 0000 1100                      */
	{illegal,0, 	 2, 8}, /* 0d: 0100 1100 0000 1101                      */
	{illegal,0, 	 2, 8}, /* 0e: 0100 1100 0000 1110                      */
	{illegal,0, 	 2, 8}, /* 0f: 0100 1100 0000 1111                      */

	{illegal,0, 	 2, 8}, /* 10: 0100 1100 0001 0000                      */
	{illegal,0, 	 2, 8}, /* 11: 0100 1100 0001 0001                      */
	{illegal,0, 	 2, 8}, /* 12: 0100 1100 0001 0010                      */
	{illegal,0, 	 2, 8}, /* 13: 0100 1100 0001 0011                      */
	{illegal,0, 	 2, 8}, /* 14: 0100 1100 0001 0100                      */
	{illegal,0, 	 2, 8}, /* 15: 0100 1100 0001 0101                      */
	{illegal,0, 	 2, 8}, /* 16: 0100 1100 0001 0110                      */
	{illegal,0, 	 2, 8}, /* 17: 0100 1100 0001 0111                      */
	{illegal,0, 	 2, 8}, /* 18: 0100 1100 0001 1000                      */
	{illegal,0, 	 2, 8}, /* 19: 0100 1100 0001 1001                      */
	{illegal,0, 	 2, 8}, /* 1a: 0100 1100 0001 1010                      */
	{illegal,0, 	 2, 8}, /* 1b: 0100 1100 0001 1011                      */
	{illegal,0, 	 2, 8}, /* 1c: 0100 1100 0001 1100                      */
	{illegal,0, 	 2, 8}, /* 1d: 0100 1100 0001 1101                      */
	{illegal,0, 	 2, 8}, /* 1e: 0100 1100 0001 1110                      */
	{illegal,0, 	 2, 8}, /* 1f: 0100 1100 0001 1111                      */

	{illegal,0, 	 2, 8}, /* 20: 0100 1100 0010 0000                      */
	{illegal,0, 	 2, 8}, /* 21: 0100 1100 0010 0001                      */
	{illegal,0, 	 2, 8}, /* 22: 0100 1100 0010 0010                      */
	{illegal,0, 	 2, 8}, /* 23: 0100 1100 0010 0011                      */
	{illegal,0, 	 2, 8}, /* 24: 0100 1100 0010 0100                      */
	{illegal,0, 	 2, 8}, /* 25: 0100 1100 0010 0101                      */
	{illegal,0, 	 2, 8}, /* 26: 0100 1100 0010 0110                      */
	{illegal,0, 	 2, 8}, /* 27: 0100 1100 0010 0111                      */
	{illegal,0, 	 2, 8}, /* 28: 0100 1100 0010 1000                      */
	{illegal,0, 	 2, 8}, /* 29: 0100 1100 0010 1001                      */
	{illegal,0, 	 2, 8}, /* 2a: 0100 1100 0010 1010                      */
	{illegal,0, 	 2, 8}, /* 2b: 0100 1100 0010 1011                      */
	{illegal,0, 	 2, 8}, /* 2c: 0100 1100 0010 1100                      */
	{illegal,0, 	 2, 8}, /* 2d: 0100 1100 0010 1101                      */
	{illegal,0, 	 2, 8}, /* 2e: 0100 1100 0010 1110                      */
	{illegal,0, 	 2, 8}, /* 2f: 0100 1100 0010 1111                      */

	{illegal,0, 	 2, 8}, /* 30: 0100 1100 0011 0000                      */
	{illegal,0, 	 2, 8}, /* 31: 0100 1100 0011 0001                      */
	{illegal,0, 	 2, 8}, /* 32: 0100 1100 0011 0010                      */
	{illegal,0, 	 2, 8}, /* 33: 0100 1100 0011 0011                      */
	{illegal,0, 	 2, 8}, /* 34: 0100 1100 0011 0100                      */
	{illegal,0, 	 2, 8}, /* 35: 0100 1100 0011 0101                      */
	{illegal,0, 	 2, 8}, /* 36: 0100 1100 0011 0110                      */
	{illegal,0, 	 2, 8}, /* 37: 0100 1100 0011 0111                      */
	{illegal,0, 	 2, 8}, /* 38: 0100 1100 0011 1000                      */
	{illegal,0, 	 2, 8}, /* 39: 0100 1100 0011 1001                      */
	{illegal,0, 	 2, 8}, /* 3a: 0100 1100 0011 1010                      */
	{illegal,0, 	 2, 8}, /* 3b: 0100 1100 0011 1011                      */
	{illegal,0, 	 2, 8}, /* 3c: 0100 1100 0011 1100                      */
	{illegal,0, 	 2, 8}, /* 3d: 0100 1100 0011 1101                      */
	{illegal,0, 	 2, 8}, /* 3e: 0100 1100 0011 1110                      */
	{illegal,0, 	 2, 8}, /* 3f: 0100 1100 0011 1111                      */

	{illegal,0, 	 2, 8}, /* 40: 0100 1100 0100 0000                      */
	{illegal,0, 	 2, 8}, /* 41: 0100 1100 0100 0001                      */
	{illegal,0, 	 2, 8}, /* 42: 0100 1100 0100 0010                      */
	{illegal,0, 	 2, 8}, /* 43: 0100 1100 0100 0011                      */
	{illegal,0, 	 2, 8}, /* 44: 0100 1100 0100 0100                      */
	{illegal,0, 	 2, 8}, /* 45: 0100 1100 0100 0101                      */
	{illegal,0, 	 2, 8}, /* 46: 0100 1100 0100 0110                      */
	{illegal,0, 	 2, 8}, /* 47: 0100 1100 0100 0111                      */
	{illegal,0, 	 2, 8}, /* 48: 0100 1100 0100 1000                      */
	{illegal,0, 	 2, 8}, /* 49: 0100 1100 0100 1001                      */
	{illegal,0, 	 2, 8}, /* 4a: 0100 1100 0100 1010                      */
	{illegal,0, 	 2, 8}, /* 4b: 0100 1100 0100 1011                      */
	{illegal,0, 	 2, 8}, /* 4c: 0100 1100 0100 1100                      */
	{illegal,0, 	 2, 8}, /* 4d: 0100 1100 0100 1101                      */
	{illegal,0, 	 2, 8}, /* 4e: 0100 1100 0100 1110                      */
	{illegal,0, 	 2, 8}, /* 4f: 0100 1100 0100 1111                      */

	{illegal,0, 	 2, 8}, /* 50: 0100 1100 0101 0000                      */
	{illegal,0, 	 2, 8}, /* 51: 0100 1100 0101 0001                      */
	{illegal,0, 	 2, 8}, /* 52: 0100 1100 0101 0010                      */
	{illegal,0, 	 2, 8}, /* 53: 0100 1100 0101 0011                      */
	{illegal,0, 	 2, 8}, /* 54: 0100 1100 0101 0100                      */
	{illegal,0, 	 2, 8}, /* 55: 0100 1100 0101 0101                      */
	{illegal,0, 	 2, 8}, /* 56: 0100 1100 0101 0110                      */
	{illegal,0, 	 2, 8}, /* 57: 0100 1100 0101 0111                      */
	{illegal,0, 	 2, 8}, /* 58: 0100 1100 0101 1000                      */
	{illegal,0, 	 2, 8}, /* 59: 0100 1100 0101 1001                      */
	{illegal,0, 	 2, 8}, /* 5a: 0100 1100 0101 1010                      */
	{illegal,0, 	 2, 8}, /* 5b: 0100 1100 0101 1011                      */
	{illegal,0, 	 2, 8}, /* 5c: 0100 1100 0101 1100                      */
	{illegal,0, 	 2, 8}, /* 5d: 0100 1100 0101 1101                      */
	{illegal,0, 	 2, 8}, /* 5e: 0100 1100 0101 1110                      */
	{illegal,0, 	 2, 8}, /* 5f: 0100 1100 0101 1111                      */

	{illegal,0, 	 2, 8}, /* 60: 0100 1100 0110 0000                      */
	{illegal,0, 	 2, 8}, /* 61: 0100 1100 0110 0001                      */
	{illegal,0, 	 2, 8}, /* 62: 0100 1100 0110 0010                      */
	{illegal,0, 	 2, 8}, /* 63: 0100 1100 0110 0011                      */
	{illegal,0, 	 2, 8}, /* 64: 0100 1100 0110 0100                      */
	{illegal,0, 	 2, 8}, /* 65: 0100 1100 0110 0101                      */
	{illegal,0, 	 2, 8}, /* 66: 0100 1100 0110 0110                      */
	{illegal,0, 	 2, 8}, /* 67: 0100 1100 0110 0111                      */
	{illegal,0, 	 2, 8}, /* 68: 0100 1100 0110 1000                      */
	{illegal,0, 	 2, 8}, /* 69: 0100 1100 0110 1001                      */
	{illegal,0, 	 2, 8}, /* 6a: 0100 1100 0110 1010                      */
	{illegal,0, 	 2, 8}, /* 6b: 0100 1100 0110 1011                      */
	{illegal,0, 	 2, 8}, /* 6c: 0100 1100 0110 1100                      */
	{illegal,0, 	 2, 8}, /* 6d: 0100 1100 0110 1101                      */
	{illegal,0, 	 2, 8}, /* 6e: 0100 1100 0110 1110                      */
	{illegal,0, 	 2, 8}, /* 6f: 0100 1100 0110 1111                      */

	{illegal,0, 	 2, 8}, /* 70: 0100 1100 0111 0000                      */
	{illegal,0, 	 2, 8}, /* 71: 0100 1100 0111 0001                      */
	{illegal,0, 	 2, 8}, /* 72: 0100 1100 0111 0010                      */
	{illegal,0, 	 2, 8}, /* 73: 0100 1100 0111 0011                      */
	{illegal,0, 	 2, 8}, /* 74: 0100 1100 0111 0100                      */
	{illegal,0, 	 2, 8}, /* 75: 0100 1100 0111 0101                      */
	{illegal,0, 	 2, 8}, /* 76: 0100 1100 0111 0110                      */
	{illegal,0, 	 2, 8}, /* 77: 0100 1100 0111 0111                      */
	{illegal,0, 	 2, 8}, /* 78: 0100 1100 0111 1000                      */
	{illegal,0, 	 2, 8}, /* 79: 0100 1100 0111 1001                      */
	{illegal,0, 	 2, 8}, /* 7a: 0100 1100 0111 1010                      */
	{illegal,0, 	 2, 8}, /* 7b: 0100 1100 0111 1011                      */
	{illegal,0, 	 2, 8}, /* 7c: 0100 1100 0111 1100                      */
	{illegal,0, 	 2, 8}, /* 7d: 0100 1100 0111 1101                      */
	{illegal,0, 	 2, 8}, /* 7e: 0100 1100 0111 1110                      */
	{illegal,0, 	 2, 8}, /* 7f: 0100 1100 0111 1111                      */

	{illegal,0, 	 2, 8}, /* 80: 0100 1100 1000 0000                      */
	{illegal,0, 	 2, 8}, /* 81: 0100 1100 1000 0001                      */
	{illegal,0, 	 2, 8}, /* 82: 0100 1100 1000 0010                      */
	{illegal,0, 	 2, 8}, /* 83: 0100 1100 1000 0011                      */
	{illegal,0, 	 2, 8}, /* 84: 0100 1100 1000 0100                      */
	{illegal,0, 	 2, 8}, /* 85: 0100 1100 1000 0101                      */
	{illegal,0, 	 2, 8}, /* 86: 0100 1100 1000 0110                      */
	{illegal,0, 	 2, 8}, /* 87: 0100 1100 1000 0111                      */
	{illegal,0, 	 2, 8}, /* 88: 0100 1100 1000 1000                      */
	{illegal,0, 	 2, 8}, /* 89: 0100 1100 1000 1001                      */
	{illegal,0, 	 2, 8}, /* 8a: 0100 1100 1000 1010                      */
	{illegal,0, 	 2, 8}, /* 8b: 0100 1100 1000 1011                      */
	{illegal,0, 	 2, 8}, /* 8c: 0100 1100 1000 1100                      */
	{illegal,0, 	 2, 8}, /* 8d: 0100 1100 1000 1101                      */
	{illegal,0, 	 2, 8}, /* 8e: 0100 1100 1000 1110                      */
	{illegal,0, 	 2, 8}, /* 8f: 0100 1100 1000 1111                      */

	{illegal,0, 	 2, 8}, /* 90: 0100 1100 1001 0000                      */
	{illegal,0, 	 2, 8}, /* 91: 0100 1100 1001 0001                      */
	{illegal,0, 	 2, 8}, /* 92: 0100 1100 1001 0010                      */
	{illegal,0, 	 2, 8}, /* 93: 0100 1100 1001 0011                      */
	{illegal,0, 	 2, 8}, /* 94: 0100 1100 1001 0100                      */
	{illegal,0, 	 2, 8}, /* 95: 0100 1100 1001 0101                      */
	{illegal,0, 	 2, 8}, /* 96: 0100 1100 1001 0110                      */
	{illegal,0, 	 2, 8}, /* 97: 0100 1100 1001 0111                      */
	{illegal,0, 	 2, 8}, /* 98: 0100 1100 1001 1000                      */
	{illegal,0, 	 2, 8}, /* 99: 0100 1100 1001 1001                      */
	{illegal,0, 	 2, 8}, /* 9a: 0100 1100 1001 1010                      */
	{illegal,0, 	 2, 8}, /* 9b: 0100 1100 1001 1011                      */
	{illegal,0, 	 2, 8}, /* 9c: 0100 1100 1001 1100                      */
	{illegal,0, 	 2, 8}, /* 9d: 0100 1100 1001 1101                      */
	{illegal,0, 	 2, 8}, /* 9e: 0100 1100 1001 1110                      */
	{illegal,0, 	 2, 8}, /* 9f: 0100 1100 1001 1111                      */

	{illegal,0, 	 2, 8}, /* a0: 0100 1100 1010 0000                      */
	{illegal,0, 	 2, 8}, /* a1: 0100 1100 1010 0001                      */
	{illegal,0, 	 2, 8}, /* a2: 0100 1100 1010 0010                      */
	{illegal,0, 	 2, 8}, /* a3: 0100 1100 1010 0011                      */
	{illegal,0, 	 2, 8}, /* a4: 0100 1100 1010 0100                      */
	{illegal,0, 	 2, 8}, /* a5: 0100 1100 1010 0101                      */
	{illegal,0, 	 2, 8}, /* a6: 0100 1100 1010 0110                      */
	{illegal,0, 	 2, 8}, /* a7: 0100 1100 1010 0111                      */
	{illegal,0, 	 2, 8}, /* a8: 0100 1100 1010 1000                      */
	{illegal,0, 	 2, 8}, /* a9: 0100 1100 1010 1001                      */
	{illegal,0, 	 2, 8}, /* aa: 0100 1100 1010 1010                      */
	{illegal,0, 	 2, 8}, /* ab: 0100 1100 1010 1011                      */
	{illegal,0, 	 2, 8}, /* ac: 0100 1100 1010 1100                      */
	{illegal,0, 	 2, 8}, /* ad: 0100 1100 1010 1101                      */
	{illegal,0, 	 2, 8}, /* ae: 0100 1100 1010 1110                      */
	{illegal,0, 	 2, 8}, /* af: 0100 1100 1010 1111                      */

	{illegal,0, 	 2, 8}, /* b0: 0100 1100 1011 0000                      */
	{illegal,0, 	 2, 8}, /* b1: 0100 1100 1011 0001                      */
	{illegal,0, 	 2, 8}, /* b2: 0100 1100 1011 0010                      */
	{illegal,0, 	 2, 8}, /* b3: 0100 1100 1011 0011                      */
	{illegal,0, 	 2, 8}, /* b4: 0100 1100 1011 0100                      */
	{illegal,0, 	 2, 8}, /* b5: 0100 1100 1011 0101                      */
	{illegal,0, 	 2, 8}, /* b6: 0100 1100 1011 0110                      */
	{illegal,0, 	 2, 8}, /* b7: 0100 1100 1011 0111                      */
	{illegal,0, 	 2, 8}, /* b8: 0100 1100 1011 1000                      */
	{illegal,0, 	 2, 8}, /* b9: 0100 1100 1011 1001                      */
	{illegal,0, 	 2, 8}, /* ba: 0100 1100 1011 1010                      */
	{illegal,0, 	 2, 8}, /* bb: 0100 1100 1011 1011                      */
	{illegal,0, 	 2, 8}, /* bc: 0100 1100 1011 1100                      */
	{illegal,0, 	 2, 8}, /* bd: 0100 1100 1011 1101                      */
	{illegal,0, 	 2, 8}, /* be: 0100 1100 1011 1110                      */
	{illegal,0, 	 2, 8}, /* bf: 0100 1100 1011 1111                      */

	{MOV,"A,PA",     2,10}, /* c0: 0100 1100 1100 0000                      */
	{MOV,"A,PB",     2,10}, /* c1: 0100 1100 1100 0001                      */
	{MOV,"A,PC",     2,10}, /* c2: 0100 1100 1100 0010                      */
	{MOV,"A,PD",     2,10}, /* c3: 0100 1100 1100 0011                      */
	{illegal,0, 	 2,10}, /* c4: 0100 1100 1100 0100                      */
	{MOV,"A,PF",     2,10}, /* c5: 0100 1100 1100 0101                      */
	{MOV,"A,MKH",    2,10}, /* c6: 0100 1100 1100 0110                      */
	{MOV,"A,MKL",    2,10}, /* c7: 0100 1100 1100 0111                      */
	{illegal,0,      2,10}, /* c8: 0100 1100 1100 1000                      */
	{MOV,"A,SMH",    2,10}, /* c9: 0100 1100 1100 1001                      */
	{illegal,0, 	 2,10}, /* ca: 0100 1100 1100 1010                      */
	{MOV,"A,EOM",    2,10}, /* cb: 0100 1100 1100 1011                      */
	{illegal,0, 	 2,10}, /* cc: 0100 1100 1100 1100                      */
	{MOV,"A,TMM",    2,10}, /* cd: 0100 1100 1100 1101                      */
	{MOV,"A,PT", 	 2,10}, /* ce: 0100 1100 1100 1110                      */	/* 7807 */
	{illegal,0, 	 2,10}, /* cf: 0100 1100 1100 1111                      */

	{illegal,0, 	 2,10}, /* d0: 0100 1100 1101 0000                      */
	{illegal,0, 	 2,10}, /* d1: 0100 1100 1101 0001                      */
	{illegal,0, 	 2,10}, /* d2: 0100 1100 1101 0010                      */
	{illegal,0, 	 2,10}, /* d3: 0100 1100 1101 0011                      */
	{illegal,0, 	 2,10}, /* d4: 0100 1100 1101 0100                      */
	{illegal,0, 	 2,10}, /* d5: 0100 1100 1101 0101                      */
	{illegal,0, 	 2,10}, /* d6: 0100 1100 1101 0110                      */
	{illegal,0, 	 2,10}, /* d7: 0100 1100 1101 0111                      */
	{illegal,0, 	 2,10}, /* d8: 0100 1100 1101 1000                      */
	{MOV,"A,RXB",    2,10}, /* d9: 0100 1100 1101 1001                      */
	{illegal,0, 	 2,10}, /* da: 0100 1100 1101 1010                      */
	{illegal,0, 	 2,10}, /* db: 0100 1100 1101 1011                      */
	{illegal,0, 	 2,10}, /* dc: 0100 1100 1101 1100                      */
	{illegal,0, 	 2,10}, /* dd: 0100 1100 1101 1101                      */
	{illegal,0, 	 2,10}, /* de: 0100 1100 1101 1110                      */
	{illegal,0, 	 2,10}, /* df: 0100 1100 1101 1111                      */

	{illegal,0, 	 2,10}, /* e0: 0100 1100 1110 0000                      */
	{illegal,0, 	 2,10}, /* e1: 0100 1100 1110 0001                      */
	{illegal,0, 	 2,10}, /* e2: 0100 1100 1110 0010                      */
	{illegal,0, 	 2,10}, /* e3: 0100 1100 1110 0011                      */
	{illegal,0, 	 2,10}, /* e4: 0100 1100 1110 0100                      */
	{illegal,0, 	 2,10}, /* e5: 0100 1100 1110 0101                      */
	{illegal,0, 	 2,10}, /* e6: 0100 1100 1110 0110                      */
	{illegal,0, 	 2,10}, /* e7: 0100 1100 1110 0111                      */
	{illegal,0, 	 2,10}, /* e8: 0100 1100 1110 1000                      */
	{illegal,0, 	 2,10}, /* e9: 0100 1100 1110 1001                      */
	{illegal,0, 	 2,10}, /* ea: 0100 1100 1110 1010                      */
	{illegal,0, 	 2,10}, /* eb: 0100 1100 1110 1011                      */
	{illegal,0, 	 2,10}, /* ec: 0100 1100 1110 1100                      */
	{illegal,0, 	 2,10}, /* ed: 0100 1100 1110 1101                      */
	{illegal,0, 	 2,10}, /* ee: 0100 1100 1110 1110                      */
	{illegal,0, 	 2,10}, /* ef: 0100 1100 1110 1111                      */

	{illegal,0, 	 2,10}, /* f0: 0100 1100 1111 0000                      */
	{illegal,0, 	 2,10}, /* f1: 0100 1100 1111 0001                      */
	{illegal,0, 	 2,10}, /* f2: 0100 1100 1111 0010                      */
	{illegal,0, 	 2,10}, /* f3: 0100 1100 1111 0011                      */
	{illegal,0, 	 2,10}, /* f4: 0100 1100 1111 0100                      */
	{illegal,0, 	 2,10}, /* f5: 0100 1100 1111 0101                      */
	{illegal,0, 	 2,10}, /* f6: 0100 1100 1111 0110                      */
	{illegal,0, 	 2,10}, /* f7: 0100 1100 1111 0111                      */
	{illegal,0, 	 2,10}, /* f8: 0100 1100 1111 1000                      */
	{illegal,0, 	 2,10}, /* f9: 0100 1100 1111 1001                      */
	{illegal,0, 	 2,10}, /* fa: 0100 1100 1111 1010                      */
	{illegal,0, 	 2,10}, /* fb: 0100 1100 1111 1011                      */
	{illegal,0, 	 2,10}, /* fc: 0100 1100 1111 1100                      */
	{illegal,0, 	 2,10}, /* fd: 0100 1100 1111 1101                      */
	{illegal,0, 	 2,10}, /* fe: 0100 1100 1111 1110                      */
	{illegal,0, 	 2,10}	/* ff: 0100 1100 1111 1111                      */
};

/* prefix 4D */
static struct dasm_s  dasm4D_7810[256] =
{
	{illegal,0, 	 2, 8}, /* 00: 0100 1101 0000 0000                      */
	{illegal,0, 	 2, 8}, /* 01: 0100 1101 0000 0001                      */
	{illegal,0, 	 2, 8}, /* 02: 0100 1101 0000 0010                      */
	{illegal,0, 	 2, 8}, /* 03: 0100 1101 0000 0011                      */
	{illegal,0, 	 2, 8}, /* 04: 0100 1101 0000 0100                      */
	{illegal,0, 	 2, 8}, /* 05: 0100 1101 0000 0101                      */
	{illegal,0, 	 2, 8}, /* 06: 0100 1101 0000 0110                      */
	{illegal,0, 	 2, 8}, /* 07: 0100 1101 0000 0111                      */
	{illegal,0, 	 2, 8}, /* 08: 0100 1101 0000 1000                      */
	{illegal,0, 	 2, 8}, /* 09: 0100 1101 0000 1001                      */
	{illegal,0, 	 2, 8}, /* 0a: 0100 1101 0000 1010                      */
	{illegal,0, 	 2, 8}, /* 0b: 0100 1101 0000 1011                      */
	{illegal,0, 	 2, 8}, /* 0c: 0100 1101 0000 1100                      */
	{illegal,0, 	 2, 8}, /* 0d: 0100 1101 0000 1101                      */
	{illegal,0, 	 2, 8}, /* 0e: 0100 1101 0000 1110                      */
	{illegal,0, 	 2, 8}, /* 0f: 0100 1101 0000 1111                      */

	{illegal,0, 	 2, 8}, /* 10: 0100 1101 0001 0000                      */
	{illegal,0, 	 2, 8}, /* 11: 0100 1101 0001 0001                      */
	{illegal,0, 	 2, 8}, /* 12: 0100 1101 0001 0010                      */
	{illegal,0, 	 2, 8}, /* 13: 0100 1101 0001 0011                      */
	{illegal,0, 	 2, 8}, /* 14: 0100 1101 0001 0100                      */
	{illegal,0, 	 2, 8}, /* 15: 0100 1101 0001 0101                      */
	{illegal,0, 	 2, 8}, /* 16: 0100 1101 0001 0110                      */
	{illegal,0, 	 2, 8}, /* 17: 0100 1101 0001 0111                      */
	{illegal,0, 	 2, 8}, /* 18: 0100 1101 0001 1000                      */
	{illegal,0, 	 2, 8}, /* 19: 0100 1101 0001 1001                      */
	{illegal,0, 	 2, 8}, /* 1a: 0100 1101 0001 1010                      */
	{illegal,0, 	 2, 8}, /* 1b: 0100 1101 0001 1011                      */
	{illegal,0, 	 2, 8}, /* 1c: 0100 1101 0001 1100                      */
	{illegal,0, 	 2, 8}, /* 1d: 0100 1101 0001 1101                      */
	{illegal,0, 	 2, 8}, /* 1e: 0100 1101 0001 1110                      */
	{illegal,0, 	 2, 8}, /* 1f: 0100 1101 0001 1111                      */

	{illegal,0, 	 2, 8}, /* 20: 0100 1101 0010 0000                      */
	{illegal,0, 	 2, 8}, /* 21: 0100 1101 0010 0001                      */
	{illegal,0, 	 2, 8}, /* 22: 0100 1101 0010 0010                      */
	{illegal,0, 	 2, 8}, /* 23: 0100 1101 0010 0011                      */
	{illegal,0, 	 2, 8}, /* 24: 0100 1101 0010 0100                      */
	{illegal,0, 	 2, 8}, /* 25: 0100 1101 0010 0101                      */
	{illegal,0, 	 2, 8}, /* 26: 0100 1101 0010 0110                      */
	{illegal,0, 	 2, 8}, /* 27: 0100 1101 0010 0111                      */
	{illegal,0, 	 2, 8}, /* 28: 0100 1101 0010 1000                      */
	{illegal,0, 	 2, 8}, /* 29: 0100 1101 0010 1001                      */
	{illegal,0, 	 2, 8}, /* 2a: 0100 1101 0010 1010                      */
	{illegal,0, 	 2, 8}, /* 2b: 0100 1101 0010 1011                      */
	{illegal,0, 	 2, 8}, /* 2c: 0100 1101 0010 1100                      */
	{illegal,0, 	 2, 8}, /* 2d: 0100 1101 0010 1101                      */
	{illegal,0, 	 2, 8}, /* 2e: 0100 1101 0010 1110                      */
	{illegal,0, 	 2, 8}, /* 2f: 0100 1101 0010 1111                      */

	{illegal,0, 	 2, 8}, /* 30: 0100 1101 0011 0000                      */
	{illegal,0, 	 2, 8}, /* 31: 0100 1101 0011 0001                      */
	{illegal,0, 	 2, 8}, /* 32: 0100 1101 0011 0010                      */
	{illegal,0, 	 2, 8}, /* 33: 0100 1101 0011 0011                      */
	{illegal,0, 	 2, 8}, /* 34: 0100 1101 0011 0100                      */
	{illegal,0, 	 2, 8}, /* 35: 0100 1101 0011 0101                      */
	{illegal,0, 	 2, 8}, /* 36: 0100 1101 0011 0110                      */
	{illegal,0, 	 2, 8}, /* 37: 0100 1101 0011 0111                      */
	{illegal,0, 	 2, 8}, /* 38: 0100 1101 0011 1000                      */
	{illegal,0, 	 2, 8}, /* 39: 0100 1101 0011 1001                      */
	{illegal,0, 	 2, 8}, /* 3a: 0100 1101 0011 1010                      */
	{illegal,0, 	 2, 8}, /* 3b: 0100 1101 0011 1011                      */
	{illegal,0, 	 2, 8}, /* 3c: 0100 1101 0011 1100                      */
	{illegal,0, 	 2, 8}, /* 3d: 0100 1101 0011 1101                      */
	{illegal,0, 	 2, 8}, /* 3e: 0100 1101 0011 1110                      */
	{illegal,0, 	 2, 8}, /* 3f: 0100 1101 0011 1111                      */

	{illegal,0, 	 2, 8}, /* 40: 0100 1101 0100 0000                      */
	{illegal,0, 	 2, 8}, /* 41: 0100 1101 0100 0001                      */
	{illegal,0, 	 2, 8}, /* 42: 0100 1101 0100 0010                      */
	{illegal,0, 	 2, 8}, /* 43: 0100 1101 0100 0011                      */
	{illegal,0, 	 2, 8}, /* 44: 0100 1101 0100 0100                      */
	{illegal,0, 	 2, 8}, /* 45: 0100 1101 0100 0101                      */
	{illegal,0, 	 2, 8}, /* 46: 0100 1101 0100 0110                      */
	{illegal,0, 	 2, 8}, /* 47: 0100 1101 0100 0111                      */
	{illegal,0, 	 2, 8}, /* 48: 0100 1101 0100 1000                      */
	{illegal,0, 	 2, 8}, /* 49: 0100 1101 0100 1001                      */
	{illegal,0, 	 2, 8}, /* 4a: 0100 1101 0100 1010                      */
	{illegal,0, 	 2, 8}, /* 4b: 0100 1101 0100 1011                      */
	{illegal,0, 	 2, 8}, /* 4c: 0100 1101 0100 1100                      */
	{illegal,0, 	 2, 8}, /* 4d: 0100 1101 0100 1101                      */
	{illegal,0, 	 2, 8}, /* 4e: 0100 1101 0100 1110                      */
	{illegal,0, 	 2, 8}, /* 4f: 0100 1101 0100 1111                      */

	{illegal,0, 	 2, 8}, /* 50: 0100 1101 0101 0000                      */
	{illegal,0, 	 2, 8}, /* 51: 0100 1101 0101 0001                      */
	{illegal,0, 	 2, 8}, /* 52: 0100 1101 0101 0010                      */
	{illegal,0, 	 2, 8}, /* 53: 0100 1101 0101 0011                      */
	{illegal,0, 	 2, 8}, /* 54: 0100 1101 0101 0100                      */
	{illegal,0, 	 2, 8}, /* 55: 0100 1101 0101 0101                      */
	{illegal,0, 	 2, 8}, /* 56: 0100 1101 0101 0110                      */
	{illegal,0, 	 2, 8}, /* 57: 0100 1101 0101 0111                      */
	{illegal,0, 	 2, 8}, /* 58: 0100 1101 0101 1000                      */
	{illegal,0, 	 2, 8}, /* 59: 0100 1101 0101 1001                      */
	{illegal,0, 	 2, 8}, /* 5a: 0100 1101 0101 1010                      */
	{illegal,0, 	 2, 8}, /* 5b: 0100 1101 0101 1011                      */
	{illegal,0, 	 2, 8}, /* 5c: 0100 1101 0101 1100                      */
	{illegal,0, 	 2, 8}, /* 5d: 0100 1101 0101 1101                      */
	{illegal,0, 	 2, 8}, /* 5e: 0100 1101 0101 1110                      */
	{illegal,0, 	 2, 8}, /* 5f: 0100 1101 0101 1111                      */

	{illegal,0, 	 2, 8}, /* 60: 0100 1101 0110 0000                      */
	{illegal,0, 	 2, 8}, /* 61: 0100 1101 0110 0001                      */
	{illegal,0, 	 2, 8}, /* 62: 0100 1101 0110 0010                      */
	{illegal,0, 	 2, 8}, /* 63: 0100 1101 0110 0011                      */
	{illegal,0, 	 2, 8}, /* 64: 0100 1101 0110 0100                      */
	{illegal,0, 	 2, 8}, /* 65: 0100 1101 0110 0101                      */
	{illegal,0, 	 2, 8}, /* 66: 0100 1101 0110 0110                      */
	{illegal,0, 	 2, 8}, /* 67: 0100 1101 0110 0111                      */
	{illegal,0, 	 2, 8}, /* 68: 0100 1101 0110 1000                      */
	{illegal,0, 	 2, 8}, /* 69: 0100 1101 0110 1001                      */
	{illegal,0, 	 2, 8}, /* 6a: 0100 1101 0110 1010                      */
	{illegal,0, 	 2, 8}, /* 6b: 0100 1101 0110 1011                      */
	{illegal,0, 	 2, 8}, /* 6c: 0100 1101 0110 1100                      */
	{illegal,0, 	 2, 8}, /* 6d: 0100 1101 0110 1101                      */
	{illegal,0, 	 2, 8}, /* 6e: 0100 1101 0110 1110                      */
	{illegal,0, 	 2, 8}, /* 6f: 0100 1101 0110 1111                      */

	{illegal,0, 	 2, 8}, /* 70: 0100 1101 0111 0000                      */
	{illegal,0, 	 2, 8}, /* 71: 0100 1101 0111 0001                      */
	{illegal,0, 	 2, 8}, /* 72: 0100 1101 0111 0010                      */
	{illegal,0, 	 2, 8}, /* 73: 0100 1101 0111 0011                      */
	{illegal,0, 	 2, 8}, /* 74: 0100 1101 0111 0100                      */
	{illegal,0, 	 2, 8}, /* 75: 0100 1101 0111 0101                      */
	{illegal,0, 	 2, 8}, /* 76: 0100 1101 0111 0110                      */
	{illegal,0, 	 2, 8}, /* 77: 0100 1101 0111 0111                      */
	{illegal,0, 	 2, 8}, /* 78: 0100 1101 0111 1000                      */
	{illegal,0, 	 2, 8}, /* 79: 0100 1101 0111 1001                      */
	{illegal,0, 	 2, 8}, /* 7a: 0100 1101 0111 1010                      */
	{illegal,0, 	 2, 8}, /* 7b: 0100 1101 0111 1011                      */
	{illegal,0, 	 2, 8}, /* 7c: 0100 1101 0111 1100                      */
	{illegal,0, 	 2, 8}, /* 7d: 0100 1101 0111 1101                      */
	{illegal,0, 	 2, 8}, /* 7e: 0100 1101 0111 1110                      */
	{illegal,0, 	 2, 8}, /* 7f: 0100 1101 0111 1111                      */

	{illegal,0, 	 2, 8}, /* 80: 0100 1101 1000 0000                      */
	{illegal,0, 	 2, 8}, /* 81: 0100 1101 1000 0001                      */
	{illegal,0, 	 2, 8}, /* 82: 0100 1101 1000 0010                      */
	{illegal,0, 	 2, 8}, /* 83: 0100 1101 1000 0011                      */
	{illegal,0, 	 2, 8}, /* 84: 0100 1101 1000 0100                      */
	{illegal,0, 	 2, 8}, /* 85: 0100 1101 1000 0101                      */
	{illegal,0, 	 2, 8}, /* 86: 0100 1101 1000 0110                      */
	{illegal,0, 	 2, 8}, /* 87: 0100 1101 1000 0111                      */
	{illegal,0, 	 2, 8}, /* 88: 0100 1101 1000 1000                      */
	{illegal,0, 	 2, 8}, /* 89: 0100 1101 1000 1001                      */
	{illegal,0, 	 2, 8}, /* 8a: 0100 1101 1000 1010                      */
	{illegal,0, 	 2, 8}, /* 8b: 0100 1101 1000 1011                      */
	{illegal,0, 	 2, 8}, /* 8c: 0100 1101 1000 1100                      */
	{illegal,0, 	 2, 8}, /* 8d: 0100 1101 1000 1101                      */
	{illegal,0, 	 2, 8}, /* 8e: 0100 1101 1000 1110                      */
	{illegal,0, 	 2, 8}, /* 8f: 0100 1101 1000 1111                      */

	{illegal,0, 	 2, 8}, /* 90: 0100 1101 1001 0000                      */
	{illegal,0, 	 2, 8}, /* 91: 0100 1101 1001 0001                      */
	{illegal,0, 	 2, 8}, /* 92: 0100 1101 1001 0010                      */
	{illegal,0, 	 2, 8}, /* 93: 0100 1101 1001 0011                      */
	{illegal,0, 	 2, 8}, /* 94: 0100 1101 1001 0100                      */
	{illegal,0, 	 2, 8}, /* 95: 0100 1101 1001 0101                      */
	{illegal,0, 	 2, 8}, /* 96: 0100 1101 1001 0110                      */
	{illegal,0, 	 2, 8}, /* 97: 0100 1101 1001 0111                      */
	{illegal,0, 	 2, 8}, /* 98: 0100 1101 1001 1000                      */
	{illegal,0, 	 2, 8}, /* 99: 0100 1101 1001 1001                      */
	{illegal,0, 	 2, 8}, /* 9a: 0100 1101 1001 1010                      */
	{illegal,0, 	 2, 8}, /* 9b: 0100 1101 1001 1011                      */
	{illegal,0, 	 2, 8}, /* 9c: 0100 1101 1001 1100                      */
	{illegal,0, 	 2, 8}, /* 9d: 0100 1101 1001 1101                      */
	{illegal,0, 	 2, 8}, /* 9e: 0100 1101 1001 1110                      */
	{illegal,0, 	 2, 8}, /* 9f: 0100 1101 1001 1111                      */

	{illegal,0, 	 2, 8}, /* a0: 0100 1101 1010 0000                      */
	{illegal,0, 	 2, 8}, /* a1: 0100 1101 1010 0001                      */
	{illegal,0, 	 2, 8}, /* a2: 0100 1101 1010 0010                      */
	{illegal,0, 	 2, 8}, /* a3: 0100 1101 1010 0011                      */
	{illegal,0, 	 2, 8}, /* a4: 0100 1101 1010 0100                      */
	{illegal,0, 	 2, 8}, /* a5: 0100 1101 1010 0101                      */
	{illegal,0, 	 2, 8}, /* a6: 0100 1101 1010 0110                      */
	{illegal,0, 	 2, 8}, /* a7: 0100 1101 1010 0111                      */
	{illegal,0, 	 2, 8}, /* a8: 0100 1101 1010 1000                      */
	{illegal,0, 	 2, 8}, /* a9: 0100 1101 1010 1001                      */
	{illegal,0, 	 2, 8}, /* aa: 0100 1101 1010 1010                      */
	{illegal,0, 	 2, 8}, /* ab: 0100 1101 1010 1011                      */
	{illegal,0, 	 2, 8}, /* ac: 0100 1101 1010 1100                      */
	{illegal,0, 	 2, 8}, /* ad: 0100 1101 1010 1101                      */
	{illegal,0, 	 2, 8}, /* ae: 0100 1101 1010 1110                      */
	{illegal,0, 	 2, 8}, /* af: 0100 1101 1010 1111                      */

	{illegal,0, 	 2, 8}, /* b0: 0100 1101 1011 0000                      */
	{illegal,0, 	 2, 8}, /* b1: 0100 1101 1011 0001                      */
	{illegal,0, 	 2, 8}, /* b2: 0100 1101 1011 0010                      */
	{illegal,0, 	 2, 8}, /* b3: 0100 1101 1011 0011                      */
	{illegal,0, 	 2, 8}, /* b4: 0100 1101 1011 0100                      */
	{illegal,0, 	 2, 8}, /* b5: 0100 1101 1011 0101                      */
	{illegal,0, 	 2, 8}, /* b6: 0100 1101 1011 0110                      */
	{illegal,0, 	 2, 8}, /* b7: 0100 1101 1011 0111                      */
	{illegal,0, 	 2, 8}, /* b8: 0100 1101 1011 1000                      */
	{illegal,0, 	 2, 8}, /* b9: 0100 1101 1011 1001                      */
	{illegal,0, 	 2, 8}, /* ba: 0100 1101 1011 1010                      */
	{illegal,0, 	 2, 8}, /* bb: 0100 1101 1011 1011                      */
	{illegal,0, 	 2, 8}, /* bc: 0100 1101 1011 1100                      */
	{illegal,0, 	 2, 8}, /* bd: 0100 1101 1011 1101                      */
	{illegal,0, 	 2, 8}, /* be: 0100 1101 1011 1110                      */
	{illegal,0, 	 2, 8}, /* bf: 0100 1101 1011 1111                      */

	{MOV,"PA,A",     2,10}, /* c0: 0100 1101 1100 0000                      */
	{MOV,"PB,A",     2,10}, /* c1: 0100 1101 1100 0001                      */
	{MOV,"PC,A",     2,10}, /* c2: 0100 1101 1100 0010                      */
	{MOV,"PD,A",     2,10}, /* c3: 0100 1101 1100 0011                      */
	{illegal,0, 	 2,10}, /* c4: 0100 1101 1100 0100                      */
	{MOV,"PF,A",     2,10}, /* c5: 0100 1101 1100 0101                      */
	{MOV,"MKH,A",    2,10}, /* c6: 0100 1101 1100 0110                      */
	{MOV,"MKL,A",    2,10}, /* c7: 0100 1101 1100 0111                      */
	{MOV,"ANM,A",    2,10}, /* c8: 0100 1101 1100 1000                      */	/* 7810 */
	{MOV,"SMH,A",    2,10}, /* c9: 0100 1101 1100 1001                      */
	{MOV,"SML,A",    2,10}, /* ca: 0100 1101 1100 1010                      */
	{MOV,"EOM,A",    2,10}, /* cb: 0100 1101 1100 1011                      */
	{MOV,"ETMM,A",   2,10}, /* cc: 0100 1101 1100 1100                      */
	{MOV,"TMM,A",    2,10}, /* cd: 0100 1101 1100 1101                      */
	{illegal,0, 	 2,10}, /* ce: 0100 1101 1100 1110                      */
	{illegal,0, 	 2,10}, /* cf: 0100 1101 1100 1111                      */

	{MOV,"MM,A",     2,10}, /* d0: 0100 1101 1101 0000                      */
	{MOV,"MCC,A",    2,10}, /* d1: 0100 1101 1101 0001                      */
	{MOV,"MA,A",     2,10}, /* d2: 0100 1101 1101 0010                      */
	{MOV,"MB,A",     2,10}, /* d3: 0100 1101 1101 0011                      */
	{MOV,"MC,A",     2,10}, /* d4: 0100 1101 1101 0100                      */
	{illegal,0, 	 2,10}, /* d5: 0100 1101 1101 0101                      */
	{illegal,0, 	 2,10}, /* d6: 0100 1101 1101 0110                      */
	{MOV,"MF,A",     2,10}, /* d7: 0100 1101 1101 0111                      */
	{MOV,"TXB,A",    2,10}, /* d8: 0100 1101 1101 1000                      */
	{illegal,0, 	 2,10}, /* d9: 0100 1101 1101 1001                      */
	{MOV,"TM0,A",    2,10}, /* da: 0100 1101 1101 1010                      */
	{MOV,"TM1,A",    2,10}, /* db: 0100 1101 1101 1011                      */
	{illegal,0, 	 2,10}, /* dc: 0100 1101 1101 1100                      */
	{illegal,0, 	 2,10}, /* dd: 0100 1101 1101 1101                      */
	{illegal,0, 	 2,10}, /* de: 0100 1101 1101 1110                      */
	{illegal,0, 	 2,10}, /* df: 0100 1101 1101 1111                      */

	{illegal,0, 	 2,10}, /* e0: 0100 1101 1110 0000                      */
	{illegal,0, 	 2,10}, /* e1: 0100 1101 1110 0001                      */
	{illegal,0, 	 2,10}, /* e2: 0100 1101 1110 0010                      */
	{illegal,0, 	 2,10}, /* e3: 0100 1101 1110 0011                      */
	{illegal,0, 	 2,10}, /* e4: 0100 1101 1110 0100                      */
	{illegal,0, 	 2,10}, /* e5: 0100 1101 1110 0101                      */
	{illegal,0, 	 2,10}, /* e6: 0100 1101 1110 0110                      */
	{illegal,0, 	 2,10}, /* e7: 0100 1101 1110 0111                      */
	{MOV,"ZCM,A",    2,10}, /* e8: 0100 1101 1110 1000                      */	/* 7810 */
	{illegal,0, 	 2,10}, /* e9: 0100 1101 1110 1001                      */
	{illegal,0, 	 2,10}, /* ea: 0100 1101 1110 1010                      */
	{illegal,0, 	 2,10}, /* eb: 0100 1101 1110 1011                      */
	{illegal,0, 	 2,10}, /* ec: 0100 1101 1110 1100                      */
	{illegal,0, 	 2,10}, /* ed: 0100 1101 1110 1101                      */
	{illegal,0, 	 2,10}, /* ee: 0100 1101 1110 1110                      */
	{illegal,0, 	 2,10}, /* ef: 0100 1101 1110 1111                      */

	{illegal,0, 	 2,10}, /* f0: 0100 1101 1111 0000                      */
	{illegal,0, 	 2,10}, /* f1: 0100 1101 1111 0001                      */
	{illegal,0, 	 2,10}, /* f2: 0100 1101 1111 0010                      */
	{illegal,0, 	 2,10}, /* f3: 0100 1101 1111 0011                      */
	{illegal,0, 	 2,10}, /* f4: 0100 1101 1111 0100                      */
	{illegal,0, 	 2,10}, /* f5: 0100 1101 1111 0101                      */
	{illegal,0, 	 2,10}, /* f6: 0100 1101 1111 0110                      */
	{illegal,0, 	 2,10}, /* f7: 0100 1101 1111 0111                      */
	{illegal,0, 	 2,10}, /* f8: 0100 1101 1111 1000                      */
	{illegal,0, 	 2,10}, /* f9: 0100 1101 1111 1001                      */
	{illegal,0, 	 2,10}, /* fa: 0100 1101 1111 1010                      */
	{illegal,0, 	 2,10}, /* fb: 0100 1101 1111 1011                      */
	{illegal,0, 	 2,10}, /* fc: 0100 1101 1111 1100                      */
	{illegal,0, 	 2,10}, /* fd: 0100 1101 1111 1101                      */
	{illegal,0, 	 2,10}, /* fe: 0100 1101 1111 1110                      */
	{illegal,0, 	 2,10}	/* ff: 0100 1101 1111 1111                      */
};

static struct dasm_s  dasm4D_7807[256] =
{
	{illegal,0, 	 2, 8}, /* 00: 0100 1101 0000 0000                      */
	{illegal,0, 	 2, 8}, /* 01: 0100 1101 0000 0001                      */
	{illegal,0, 	 2, 8}, /* 02: 0100 1101 0000 0010                      */
	{illegal,0, 	 2, 8}, /* 03: 0100 1101 0000 0011                      */
	{illegal,0, 	 2, 8}, /* 04: 0100 1101 0000 0100                      */
	{illegal,0, 	 2, 8}, /* 05: 0100 1101 0000 0101                      */
	{illegal,0, 	 2, 8}, /* 06: 0100 1101 0000 0110                      */
	{illegal,0, 	 2, 8}, /* 07: 0100 1101 0000 0111                      */
	{illegal,0, 	 2, 8}, /* 08: 0100 1101 0000 1000                      */
	{illegal,0, 	 2, 8}, /* 09: 0100 1101 0000 1001                      */
	{illegal,0, 	 2, 8}, /* 0a: 0100 1101 0000 1010                      */
	{illegal,0, 	 2, 8}, /* 0b: 0100 1101 0000 1011                      */
	{illegal,0, 	 2, 8}, /* 0c: 0100 1101 0000 1100                      */
	{illegal,0, 	 2, 8}, /* 0d: 0100 1101 0000 1101                      */
	{illegal,0, 	 2, 8}, /* 0e: 0100 1101 0000 1110                      */
	{illegal,0, 	 2, 8}, /* 0f: 0100 1101 0000 1111                      */

	{illegal,0, 	 2, 8}, /* 10: 0100 1101 0001 0000                      */
	{illegal,0, 	 2, 8}, /* 11: 0100 1101 0001 0001                      */
	{illegal,0, 	 2, 8}, /* 12: 0100 1101 0001 0010                      */
	{illegal,0, 	 2, 8}, /* 13: 0100 1101 0001 0011                      */
	{illegal,0, 	 2, 8}, /* 14: 0100 1101 0001 0100                      */
	{illegal,0, 	 2, 8}, /* 15: 0100 1101 0001 0101                      */
	{illegal,0, 	 2, 8}, /* 16: 0100 1101 0001 0110                      */
	{illegal,0, 	 2, 8}, /* 17: 0100 1101 0001 0111                      */
	{illegal,0, 	 2, 8}, /* 18: 0100 1101 0001 1000                      */
	{illegal,0, 	 2, 8}, /* 19: 0100 1101 0001 1001                      */
	{illegal,0, 	 2, 8}, /* 1a: 0100 1101 0001 1010                      */
	{illegal,0, 	 2, 8}, /* 1b: 0100 1101 0001 1011                      */
	{illegal,0, 	 2, 8}, /* 1c: 0100 1101 0001 1100                      */
	{illegal,0, 	 2, 8}, /* 1d: 0100 1101 0001 1101                      */
	{illegal,0, 	 2, 8}, /* 1e: 0100 1101 0001 1110                      */
	{illegal,0, 	 2, 8}, /* 1f: 0100 1101 0001 1111                      */

	{illegal,0, 	 2, 8}, /* 20: 0100 1101 0010 0000                      */
	{illegal,0, 	 2, 8}, /* 21: 0100 1101 0010 0001                      */
	{illegal,0, 	 2, 8}, /* 22: 0100 1101 0010 0010                      */
	{illegal,0, 	 2, 8}, /* 23: 0100 1101 0010 0011                      */
	{illegal,0, 	 2, 8}, /* 24: 0100 1101 0010 0100                      */
	{illegal,0, 	 2, 8}, /* 25: 0100 1101 0010 0101                      */
	{illegal,0, 	 2, 8}, /* 26: 0100 1101 0010 0110                      */
	{illegal,0, 	 2, 8}, /* 27: 0100 1101 0010 0111                      */
	{illegal,0, 	 2, 8}, /* 28: 0100 1101 0010 1000                      */
	{illegal,0, 	 2, 8}, /* 29: 0100 1101 0010 1001                      */
	{illegal,0, 	 2, 8}, /* 2a: 0100 1101 0010 1010                      */
	{illegal,0, 	 2, 8}, /* 2b: 0100 1101 0010 1011                      */
	{illegal,0, 	 2, 8}, /* 2c: 0100 1101 0010 1100                      */
	{illegal,0, 	 2, 8}, /* 2d: 0100 1101 0010 1101                      */
	{illegal,0, 	 2, 8}, /* 2e: 0100 1101 0010 1110                      */
	{illegal,0, 	 2, 8}, /* 2f: 0100 1101 0010 1111                      */

	{illegal,0, 	 2, 8}, /* 30: 0100 1101 0011 0000                      */
	{illegal,0, 	 2, 8}, /* 31: 0100 1101 0011 0001                      */
	{illegal,0, 	 2, 8}, /* 32: 0100 1101 0011 0010                      */
	{illegal,0, 	 2, 8}, /* 33: 0100 1101 0011 0011                      */
	{illegal,0, 	 2, 8}, /* 34: 0100 1101 0011 0100                      */
	{illegal,0, 	 2, 8}, /* 35: 0100 1101 0011 0101                      */
	{illegal,0, 	 2, 8}, /* 36: 0100 1101 0011 0110                      */
	{illegal,0, 	 2, 8}, /* 37: 0100 1101 0011 0111                      */
	{illegal,0, 	 2, 8}, /* 38: 0100 1101 0011 1000                      */
	{illegal,0, 	 2, 8}, /* 39: 0100 1101 0011 1001                      */
	{illegal,0, 	 2, 8}, /* 3a: 0100 1101 0011 1010                      */
	{illegal,0, 	 2, 8}, /* 3b: 0100 1101 0011 1011                      */
	{illegal,0, 	 2, 8}, /* 3c: 0100 1101 0011 1100                      */
	{illegal,0, 	 2, 8}, /* 3d: 0100 1101 0011 1101                      */
	{illegal,0, 	 2, 8}, /* 3e: 0100 1101 0011 1110                      */
	{illegal,0, 	 2, 8}, /* 3f: 0100 1101 0011 1111                      */

	{illegal,0, 	 2, 8}, /* 40: 0100 1101 0100 0000                      */
	{illegal,0, 	 2, 8}, /* 41: 0100 1101 0100 0001                      */
	{illegal,0, 	 2, 8}, /* 42: 0100 1101 0100 0010                      */
	{illegal,0, 	 2, 8}, /* 43: 0100 1101 0100 0011                      */
	{illegal,0, 	 2, 8}, /* 44: 0100 1101 0100 0100                      */
	{illegal,0, 	 2, 8}, /* 45: 0100 1101 0100 0101                      */
	{illegal,0, 	 2, 8}, /* 46: 0100 1101 0100 0110                      */
	{illegal,0, 	 2, 8}, /* 47: 0100 1101 0100 0111                      */
	{illegal,0, 	 2, 8}, /* 48: 0100 1101 0100 1000                      */
	{illegal,0, 	 2, 8}, /* 49: 0100 1101 0100 1001                      */
	{illegal,0, 	 2, 8}, /* 4a: 0100 1101 0100 1010                      */
	{illegal,0, 	 2, 8}, /* 4b: 0100 1101 0100 1011                      */
	{illegal,0, 	 2, 8}, /* 4c: 0100 1101 0100 1100                      */
	{illegal,0, 	 2, 8}, /* 4d: 0100 1101 0100 1101                      */
	{illegal,0, 	 2, 8}, /* 4e: 0100 1101 0100 1110                      */
	{illegal,0, 	 2, 8}, /* 4f: 0100 1101 0100 1111                      */

	{illegal,0, 	 2, 8}, /* 50: 0100 1101 0101 0000                      */
	{illegal,0, 	 2, 8}, /* 51: 0100 1101 0101 0001                      */
	{illegal,0, 	 2, 8}, /* 52: 0100 1101 0101 0010                      */
	{illegal,0, 	 2, 8}, /* 53: 0100 1101 0101 0011                      */
	{illegal,0, 	 2, 8}, /* 54: 0100 1101 0101 0100                      */
	{illegal,0, 	 2, 8}, /* 55: 0100 1101 0101 0101                      */
	{illegal,0, 	 2, 8}, /* 56: 0100 1101 0101 0110                      */
	{illegal,0, 	 2, 8}, /* 57: 0100 1101 0101 0111                      */
	{illegal,0, 	 2, 8}, /* 58: 0100 1101 0101 1000                      */
	{illegal,0, 	 2, 8}, /* 59: 0100 1101 0101 1001                      */
	{illegal,0, 	 2, 8}, /* 5a: 0100 1101 0101 1010                      */
	{illegal,0, 	 2, 8}, /* 5b: 0100 1101 0101 1011                      */
	{illegal,0, 	 2, 8}, /* 5c: 0100 1101 0101 1100                      */
	{illegal,0, 	 2, 8}, /* 5d: 0100 1101 0101 1101                      */
	{illegal,0, 	 2, 8}, /* 5e: 0100 1101 0101 1110                      */
	{illegal,0, 	 2, 8}, /* 5f: 0100 1101 0101 1111                      */

	{illegal,0, 	 2, 8}, /* 60: 0100 1101 0110 0000                      */
	{illegal,0, 	 2, 8}, /* 61: 0100 1101 0110 0001                      */
	{illegal,0, 	 2, 8}, /* 62: 0100 1101 0110 0010                      */
	{illegal,0, 	 2, 8}, /* 63: 0100 1101 0110 0011                      */
	{illegal,0, 	 2, 8}, /* 64: 0100 1101 0110 0100                      */
	{illegal,0, 	 2, 8}, /* 65: 0100 1101 0110 0101                      */
	{illegal,0, 	 2, 8}, /* 66: 0100 1101 0110 0110                      */
	{illegal,0, 	 2, 8}, /* 67: 0100 1101 0110 0111                      */
	{illegal,0, 	 2, 8}, /* 68: 0100 1101 0110 1000                      */
	{illegal,0, 	 2, 8}, /* 69: 0100 1101 0110 1001                      */
	{illegal,0, 	 2, 8}, /* 6a: 0100 1101 0110 1010                      */
	{illegal,0, 	 2, 8}, /* 6b: 0100 1101 0110 1011                      */
	{illegal,0, 	 2, 8}, /* 6c: 0100 1101 0110 1100                      */
	{illegal,0, 	 2, 8}, /* 6d: 0100 1101 0110 1101                      */
	{illegal,0, 	 2, 8}, /* 6e: 0100 1101 0110 1110                      */
	{illegal,0, 	 2, 8}, /* 6f: 0100 1101 0110 1111                      */

	{illegal,0, 	 2, 8}, /* 70: 0100 1101 0111 0000                      */
	{illegal,0, 	 2, 8}, /* 71: 0100 1101 0111 0001                      */
	{illegal,0, 	 2, 8}, /* 72: 0100 1101 0111 0010                      */
	{illegal,0, 	 2, 8}, /* 73: 0100 1101 0111 0011                      */
	{illegal,0, 	 2, 8}, /* 74: 0100 1101 0111 0100                      */
	{illegal,0, 	 2, 8}, /* 75: 0100 1101 0111 0101                      */
	{illegal,0, 	 2, 8}, /* 76: 0100 1101 0111 0110                      */
	{illegal,0, 	 2, 8}, /* 77: 0100 1101 0111 0111                      */
	{illegal,0, 	 2, 8}, /* 78: 0100 1101 0111 1000                      */
	{illegal,0, 	 2, 8}, /* 79: 0100 1101 0111 1001                      */
	{illegal,0, 	 2, 8}, /* 7a: 0100 1101 0111 1010                      */
	{illegal,0, 	 2, 8}, /* 7b: 0100 1101 0111 1011                      */
	{illegal,0, 	 2, 8}, /* 7c: 0100 1101 0111 1100                      */
	{illegal,0, 	 2, 8}, /* 7d: 0100 1101 0111 1101                      */
	{illegal,0, 	 2, 8}, /* 7e: 0100 1101 0111 1110                      */
	{illegal,0, 	 2, 8}, /* 7f: 0100 1101 0111 1111                      */

	{illegal,0, 	 2, 8}, /* 80: 0100 1101 1000 0000                      */
	{illegal,0, 	 2, 8}, /* 81: 0100 1101 1000 0001                      */
	{illegal,0, 	 2, 8}, /* 82: 0100 1101 1000 0010                      */
	{illegal,0, 	 2, 8}, /* 83: 0100 1101 1000 0011                      */
	{illegal,0, 	 2, 8}, /* 84: 0100 1101 1000 0100                      */
	{illegal,0, 	 2, 8}, /* 85: 0100 1101 1000 0101                      */
	{illegal,0, 	 2, 8}, /* 86: 0100 1101 1000 0110                      */
	{illegal,0, 	 2, 8}, /* 87: 0100 1101 1000 0111                      */
	{illegal,0, 	 2, 8}, /* 88: 0100 1101 1000 1000                      */
	{illegal,0, 	 2, 8}, /* 89: 0100 1101 1000 1001                      */
	{illegal,0, 	 2, 8}, /* 8a: 0100 1101 1000 1010                      */
	{illegal,0, 	 2, 8}, /* 8b: 0100 1101 1000 1011                      */
	{illegal,0, 	 2, 8}, /* 8c: 0100 1101 1000 1100                      */
	{illegal,0, 	 2, 8}, /* 8d: 0100 1101 1000 1101                      */
	{illegal,0, 	 2, 8}, /* 8e: 0100 1101 1000 1110                      */
	{illegal,0, 	 2, 8}, /* 8f: 0100 1101 1000 1111                      */

	{illegal,0, 	 2, 8}, /* 90: 0100 1101 1001 0000                      */
	{illegal,0, 	 2, 8}, /* 91: 0100 1101 1001 0001                      */
	{illegal,0, 	 2, 8}, /* 92: 0100 1101 1001 0010                      */
	{illegal,0, 	 2, 8}, /* 93: 0100 1101 1001 0011                      */
	{illegal,0, 	 2, 8}, /* 94: 0100 1101 1001 0100                      */
	{illegal,0, 	 2, 8}, /* 95: 0100 1101 1001 0101                      */
	{illegal,0, 	 2, 8}, /* 96: 0100 1101 1001 0110                      */
	{illegal,0, 	 2, 8}, /* 97: 0100 1101 1001 0111                      */
	{illegal,0, 	 2, 8}, /* 98: 0100 1101 1001 1000                      */
	{illegal,0, 	 2, 8}, /* 99: 0100 1101 1001 1001                      */
	{illegal,0, 	 2, 8}, /* 9a: 0100 1101 1001 1010                      */
	{illegal,0, 	 2, 8}, /* 9b: 0100 1101 1001 1011                      */
	{illegal,0, 	 2, 8}, /* 9c: 0100 1101 1001 1100                      */
	{illegal,0, 	 2, 8}, /* 9d: 0100 1101 1001 1101                      */
	{illegal,0, 	 2, 8}, /* 9e: 0100 1101 1001 1110                      */
	{illegal,0, 	 2, 8}, /* 9f: 0100 1101 1001 1111                      */

	{illegal,0, 	 2, 8}, /* a0: 0100 1101 1010 0000                      */
	{illegal,0, 	 2, 8}, /* a1: 0100 1101 1010 0001                      */
	{illegal,0, 	 2, 8}, /* a2: 0100 1101 1010 0010                      */
	{illegal,0, 	 2, 8}, /* a3: 0100 1101 1010 0011                      */
	{illegal,0, 	 2, 8}, /* a4: 0100 1101 1010 0100                      */
	{illegal,0, 	 2, 8}, /* a5: 0100 1101 1010 0101                      */
	{illegal,0, 	 2, 8}, /* a6: 0100 1101 1010 0110                      */
	{illegal,0, 	 2, 8}, /* a7: 0100 1101 1010 0111                      */
	{illegal,0, 	 2, 8}, /* a8: 0100 1101 1010 1000                      */
	{illegal,0, 	 2, 8}, /* a9: 0100 1101 1010 1001                      */
	{illegal,0, 	 2, 8}, /* aa: 0100 1101 1010 1010                      */
	{illegal,0, 	 2, 8}, /* ab: 0100 1101 1010 1011                      */
	{illegal,0, 	 2, 8}, /* ac: 0100 1101 1010 1100                      */
	{illegal,0, 	 2, 8}, /* ad: 0100 1101 1010 1101                      */
	{illegal,0, 	 2, 8}, /* ae: 0100 1101 1010 1110                      */
	{illegal,0, 	 2, 8}, /* af: 0100 1101 1010 1111                      */

	{illegal,0, 	 2, 8}, /* b0: 0100 1101 1011 0000                      */
	{illegal,0, 	 2, 8}, /* b1: 0100 1101 1011 0001                      */
	{illegal,0, 	 2, 8}, /* b2: 0100 1101 1011 0010                      */
	{illegal,0, 	 2, 8}, /* b3: 0100 1101 1011 0011                      */
	{illegal,0, 	 2, 8}, /* b4: 0100 1101 1011 0100                      */
	{illegal,0, 	 2, 8}, /* b5: 0100 1101 1011 0101                      */
	{illegal,0, 	 2, 8}, /* b6: 0100 1101 1011 0110                      */
	{illegal,0, 	 2, 8}, /* b7: 0100 1101 1011 0111                      */
	{illegal,0, 	 2, 8}, /* b8: 0100 1101 1011 1000                      */
	{illegal,0, 	 2, 8}, /* b9: 0100 1101 1011 1001                      */
	{illegal,0, 	 2, 8}, /* ba: 0100 1101 1011 1010                      */
	{illegal,0, 	 2, 8}, /* bb: 0100 1101 1011 1011                      */
	{illegal,0, 	 2, 8}, /* bc: 0100 1101 1011 1100                      */
	{illegal,0, 	 2, 8}, /* bd: 0100 1101 1011 1101                      */
	{illegal,0, 	 2, 8}, /* be: 0100 1101 1011 1110                      */
	{illegal,0, 	 2, 8}, /* bf: 0100 1101 1011 1111                      */

	{MOV,"PA,A",     2,10}, /* c0: 0100 1101 1100 0000                      */
	{MOV,"PB,A",     2,10}, /* c1: 0100 1101 1100 0001                      */
	{MOV,"PC,A",     2,10}, /* c2: 0100 1101 1100 0010                      */
	{MOV,"PD,A",     2,10}, /* c3: 0100 1101 1100 0011                      */
	{illegal,0, 	 2,10}, /* c4: 0100 1101 1100 0100                      */
	{MOV,"PF,A",     2,10}, /* c5: 0100 1101 1100 0101                      */
	{MOV,"MKH,A",    2,10}, /* c6: 0100 1101 1100 0110                      */
	{MOV,"MKL,A",    2,10}, /* c7: 0100 1101 1100 0111                      */
	{illegal,0,      2,10}, /* c8: 0100 1101 1100 1000                      */
	{MOV,"SMH,A",    2,10}, /* c9: 0100 1101 1100 1001                      */
	{MOV,"SML,A",    2,10}, /* ca: 0100 1101 1100 1010                      */
	{MOV,"EOM,A",    2,10}, /* cb: 0100 1101 1100 1011                      */
	{MOV,"ETMM,A",   2,10}, /* cc: 0100 1101 1100 1100                      */
	{MOV,"TMM,A",    2,10}, /* cd: 0100 1101 1100 1101                      */
	{illegal,0, 	 2,10}, /* ce: 0100 1101 1100 1110                      */
	{illegal,0, 	 2,10}, /* cf: 0100 1101 1100 1111                      */

	{MOV,"MM,A",     2,10}, /* d0: 0100 1101 1101 0000                      */
	{MOV,"MCC,A",    2,10}, /* d1: 0100 1101 1101 0001                      */
	{MOV,"MA,A",     2,10}, /* d2: 0100 1101 1101 0010                      */
	{MOV,"MB,A",     2,10}, /* d3: 0100 1101 1101 0011                      */
	{MOV,"MC,A",     2,10}, /* d4: 0100 1101 1101 0100                      */
	{illegal,0, 	 2,10}, /* d5: 0100 1101 1101 0101                      */
	{illegal,0, 	 2,10}, /* d6: 0100 1101 1101 0110                      */
	{MOV,"MF,A",     2,10}, /* d7: 0100 1101 1101 0111                      */
	{MOV,"TXB,A",    2,10}, /* d8: 0100 1101 1101 1000                      */
	{illegal,0, 	 2,10}, /* d9: 0100 1101 1101 1001                      */
	{MOV,"TM0,A",    2,10}, /* da: 0100 1101 1101 1010                      */
	{MOV,"TM1,A",    2,10}, /* db: 0100 1101 1101 1011                      */
	{illegal,0, 	 2,10}, /* dc: 0100 1101 1101 1100                      */
	{illegal,0, 	 2,10}, /* dd: 0100 1101 1101 1101                      */
	{illegal,0, 	 2,10}, /* de: 0100 1101 1101 1110                      */
	{illegal,0, 	 2,10}, /* df: 0100 1101 1101 1111                      */

	{illegal,0, 	 2,10}, /* e0: 0100 1101 1110 0000                      */
	{illegal,0, 	 2,10}, /* e1: 0100 1101 1110 0001                      */
	{illegal,0, 	 2,10}, /* e2: 0100 1101 1110 0010                      */
	{illegal,0, 	 2,10}, /* e3: 0100 1101 1110 0011                      */
	{illegal,0, 	 2,10}, /* e4: 0100 1101 1110 0100                      */
	{MOV,"MT,A", 	 2,10}, /* e5: 0100 1101 1110 0101                      */	/* 7807 */
	{illegal,0, 	 2,10}, /* e6: 0100 1101 1110 0110                      */
	{illegal,0, 	 2,10}, /* e7: 0100 1101 1110 0111                      */
	{illegal,0, 	 2,10}, /* e8: 0100 1101 1110 1000                      */
	{illegal,0, 	 2,10}, /* e9: 0100 1101 1110 1001                      */
	{illegal,0, 	 2,10}, /* ea: 0100 1101 1110 1010                      */
	{illegal,0, 	 2,10}, /* eb: 0100 1101 1110 1011                      */
	{illegal,0, 	 2,10}, /* ec: 0100 1101 1110 1100                      */
	{illegal,0, 	 2,10}, /* ed: 0100 1101 1110 1101                      */
	{illegal,0, 	 2,10}, /* ee: 0100 1101 1110 1110                      */
	{illegal,0, 	 2,10}, /* ef: 0100 1101 1110 1111                      */

	{illegal,0, 	 2,10}, /* f0: 0100 1101 1111 0000                      */
	{illegal,0, 	 2,10}, /* f1: 0100 1101 1111 0001                      */
	{illegal,0, 	 2,10}, /* f2: 0100 1101 1111 0010                      */
	{illegal,0, 	 2,10}, /* f3: 0100 1101 1111 0011                      */
	{illegal,0, 	 2,10}, /* f4: 0100 1101 1111 0100                      */
	{illegal,0, 	 2,10}, /* f5: 0100 1101 1111 0101                      */
	{illegal,0, 	 2,10}, /* f6: 0100 1101 1111 0110                      */
	{illegal,0, 	 2,10}, /* f7: 0100 1101 1111 0111                      */
	{illegal,0, 	 2,10}, /* f8: 0100 1101 1111 1000                      */
	{illegal,0, 	 2,10}, /* f9: 0100 1101 1111 1001                      */
	{illegal,0, 	 2,10}, /* fa: 0100 1101 1111 1010                      */
	{illegal,0, 	 2,10}, /* fb: 0100 1101 1111 1011                      */
	{illegal,0, 	 2,10}, /* fc: 0100 1101 1111 1100                      */
	{illegal,0, 	 2,10}, /* fd: 0100 1101 1111 1101                      */
	{illegal,0, 	 2,10}, /* fe: 0100 1101 1111 1110                      */
	{illegal,0, 	 2,10}	/* ff: 0100 1101 1111 1111                      */
};

/* prefix 60 */
static struct dasm_s  dasm60[256] =
{
	{illegal,0, 	 2, 8}, /* 00: 0110 0000 0000 0000                      */
	{illegal,0, 	 2, 8}, /* 01: 0110 0000 0000 0001                      */
	{illegal,0, 	 2, 8}, /* 02: 0110 0000 0000 0010                      */
	{illegal,0, 	 2, 8}, /* 03: 0110 0000 0000 0011                      */
	{illegal,0, 	 2, 8}, /* 04: 0110 0000 0000 0100                      */
	{illegal,0, 	 2, 8}, /* 05: 0110 0000 0000 0101                      */
	{illegal,0, 	 2, 8}, /* 06: 0110 0000 0000 0110                      */
	{illegal,0, 	 2, 8}, /* 07: 0110 0000 0000 0111                      */
	{ANA,"V,A",      2, 8}, /* 08: 0110 0000 0000 1000                      */
	{ANA,"A,A",      2, 8}, /* 09: 0110 0000 0000 1001                      */
	{ANA,"B,A",      2, 8}, /* 0a: 0110 0000 0000 1010                      */
	{ANA,"C,A",      2, 8}, /* 0b: 0110 0000 0000 1011                      */
	{ANA,"D,A",      2, 8}, /* 0c: 0110 0000 0000 1100                      */
	{ANA,"E,A",      2, 8}, /* 0d: 0110 0000 0000 1101                      */
	{ANA,"H,A",      2, 8}, /* 0e: 0110 0000 0000 1110                      */
	{ANA,"L,A",      2, 8}, /* 0f: 0110 0000 0000 1111                      */

	{XRA,"V,A",      2, 8}, /* 10: 0110 0000 0001 0000                      */
	{XRA,"A,A",      2, 8}, /* 11: 0110 0000 0001 0001                      */
	{XRA,"B,A",      2, 8}, /* 12: 0110 0000 0001 0010                      */
	{XRA,"C,A",      2, 8}, /* 13: 0110 0000 0001 0011                      */
	{XRA,"D,A",      2, 8}, /* 14: 0110 0000 0001 0100                      */
	{XRA,"E,A",      2, 8}, /* 15: 0110 0000 0001 0101                      */
	{XRA,"H,A",      2, 8}, /* 16: 0110 0000 0001 0110                      */
	{XRA,"L,A",      2, 8}, /* 17: 0110 0000 0001 0111                      */
	{ORA,"V,A",      2, 8}, /* 18: 0110 0000 0001 1000                      */
	{ORA,"A,A",      2, 8}, /* 19: 0110 0000 0001 1001                      */
	{ORA,"B,A",      2, 8}, /* 1a: 0110 0000 0001 1010                      */
	{ORA,"C,A",      2, 8}, /* 1b: 0110 0000 0001 1011                      */
	{ORA,"D,A",      2, 8}, /* 1c: 0110 0000 0001 1100                      */
	{ORA,"E,A",      2, 8}, /* 1d: 0110 0000 0001 1101                      */
	{ORA,"H,A",      2, 8}, /* 1e: 0110 0000 0001 1110                      */
	{ORA,"L,A",      2, 8}, /* 1f: 0110 0000 0001 1111                      */

	{ADDNC,"V,A",    2, 8}, /* 20: 0110 0000 0010 0000                      */
	{ADDNC,"A,A",    2, 8}, /* 21: 0110 0000 0010 0001                      */
	{ADDNC,"B,A",    2, 8}, /* 22: 0110 0000 0010 0010                      */
	{ADDNC,"C,A",    2, 8}, /* 23: 0110 0000 0010 0011                      */
	{ADDNC,"D,A",    2, 8}, /* 24: 0110 0000 0010 0100                      */
	{ADDNC,"E,A",    2, 8}, /* 25: 0110 0000 0010 0101                      */
	{ADDNC,"H,A",    2, 8}, /* 26: 0110 0000 0010 0110                      */
	{ADDNC,"L,A",    2, 8}, /* 27: 0110 0000 0010 0111                      */
	{GTA,"V,A",      2, 8}, /* 28: 0110 0000 0010 1000                      */
	{GTA,"A,A",      2, 8}, /* 29: 0110 0000 0010 1001                      */
	{GTA,"B,A",      2, 8}, /* 2a: 0110 0000 0010 1010                      */
	{GTA,"C,A",      2, 8}, /* 2b: 0110 0000 0010 1011                      */
	{GTA,"D,A",      2, 8}, /* 2c: 0110 0000 0010 1100                      */
	{GTA,"E,A",      2, 8}, /* 2d: 0110 0000 0010 1101                      */
	{GTA,"H,A",      2, 8}, /* 2e: 0110 0000 0010 1110                      */
	{GTA,"L,A",      2, 8}, /* 2f: 0110 0000 0010 1111                      */

	{SUBNB,"V,A",    2, 8}, /* 30: 0110 0000 0011 0000                      */
	{SUBNB,"A,A",    2, 8}, /* 31: 0110 0000 0011 0001                      */
	{SUBNB,"B,A",    2, 8}, /* 32: 0110 0000 0011 0010                      */
	{SUBNB,"C,A",    2, 8}, /* 33: 0110 0000 0011 0011                      */
	{SUBNB,"D,A",    2, 8}, /* 34: 0110 0000 0011 0100                      */
	{SUBNB,"E,A",    2, 8}, /* 35: 0110 0000 0011 0101                      */
	{SUBNB,"H,A",    2, 8}, /* 36: 0110 0000 0011 0110                      */
	{SUBNB,"L,A",    2, 8}, /* 37: 0110 0000 0011 0111                      */
	{LTA,"V,A",      2, 8}, /* 38: 0110 0000 0011 1000                      */
	{LTA,"A,A",      2, 8}, /* 39: 0110 0000 0011 1001                      */
	{LTA,"B,A",      2, 8}, /* 3a: 0110 0000 0011 1010                      */
	{LTA,"C,A",      2, 8}, /* 3b: 0110 0000 0011 1011                      */
	{LTA,"D,A",      2, 8}, /* 3c: 0110 0000 0011 1100                      */
	{LTA,"E,A",      2, 8}, /* 3d: 0110 0000 0011 1101                      */
	{LTA,"H,A",      2, 8}, /* 3e: 0110 0000 0011 1110                      */
	{LTA,"L,A",      2, 8}, /* 3f: 0110 0000 0011 1111                      */

	{ADD,"V,A",      2, 8}, /* 40: 0110 0000 0100 0000                      */
	{ADD,"A,A",      2, 8}, /* 41: 0110 0000 0100 0001                      */
	{ADD,"B,A",      2, 8}, /* 42: 0110 0000 0100 0010                      */
	{ADD,"C,A",      2, 8}, /* 43: 0110 0000 0100 0011                      */
	{ADD,"D,A",      2, 8}, /* 44: 0110 0000 0100 0100                      */
	{ADD,"E,A",      2, 8}, /* 45: 0110 0000 0100 0101                      */
	{ADD,"H,A",      2, 8}, /* 46: 0110 0000 0100 0110                      */
	{ADD,"L,A",      2, 8}, /* 47: 0110 0000 0100 0111                      */
	{illegal,0, 	 2, 8}, /* 48: 0110 0000 0100 1000                      */
	{illegal,0, 	 2, 8}, /* 49: 0110 0000 0100 1001                      */
	{illegal,0, 	 2, 8}, /* 4a: 0110 0000 0100 1010                      */
	{illegal,0, 	 2, 8}, /* 4b: 0110 0000 0100 1011                      */
	{illegal,0, 	 2, 8}, /* 4c: 0110 0000 0100 1100                      */
	{illegal,0, 	 2, 8}, /* 4d: 0110 0000 0100 1101                      */
	{illegal,0, 	 2, 8}, /* 4e: 0110 0000 0100 1110                      */
	{illegal,0, 	 2, 8}, /* 4f: 0110 0000 0100 1111                      */

	{ADC,"V,A",      2, 8}, /* 50: 0110 0000 0101 0000                      */
	{ADC,"A,A",      2, 8}, /* 51: 0110 0000 0101 0001                      */
	{ADC,"B,A",      2, 8}, /* 52: 0110 0000 0101 0010                      */
	{ADC,"C,A",      2, 8}, /* 53: 0110 0000 0101 0011                      */
	{ADC,"D,A",      2, 8}, /* 54: 0110 0000 0101 0100                      */
	{ADC,"E,A",      2, 8}, /* 55: 0110 0000 0101 0101                      */
	{ADC,"H,A",      2, 8}, /* 56: 0110 0000 0101 0110                      */
	{ADC,"L,A",      2, 8}, /* 57: 0110 0000 0101 0111                      */
	{illegal,0, 	 2, 8}, /* 58: 0110 0000 0101 1000                      */
	{illegal,0, 	 2, 8}, /* 59: 0110 0000 0101 1001                      */
	{illegal,0, 	 2, 8}, /* 5a: 0110 0000 0101 1010                      */
	{illegal,0, 	 2, 8}, /* 5b: 0110 0000 0101 1011                      */
	{illegal,0, 	 2, 8}, /* 5c: 0110 0000 0101 1100                      */
	{illegal,0, 	 2, 8}, /* 5d: 0110 0000 0101 1101                      */
	{illegal,0, 	 2, 8}, /* 5e: 0110 0000 0101 1110                      */
	{illegal,0, 	 2, 8}, /* 5f: 0110 0000 0101 1111                      */

	{SUB,"V,A",      2, 8}, /* 60: 0110 0000 0110 0000                      */
	{SUB,"A,A",      2, 8}, /* 61: 0110 0000 0110 0001                      */
	{SUB,"B,A",      2, 8}, /* 62: 0110 0000 0110 0010                      */
	{SUB,"C,A",      2, 8}, /* 63: 0110 0000 0110 0011                      */
	{SUB,"D,A",      2, 8}, /* 64: 0110 0000 0110 0100                      */
	{SUB,"E,A",      2, 8}, /* 65: 0110 0000 0110 0101                      */
	{SUB,"H,A",      2, 8}, /* 66: 0110 0000 0110 0110                      */
	{SUB,"L,A",      2, 8}, /* 67: 0110 0000 0110 0111                      */
	{NEA,"V,A",      2, 8}, /* 68: 0110 0000 0110 1000                      */
	{NEA,"A,A",      2, 8}, /* 69: 0110 0000 0110 1001                      */
	{NEA,"B,A",      2, 8}, /* 6a: 0110 0000 0110 1010                      */
	{NEA,"C,A",      2, 8}, /* 6b: 0110 0000 0110 1011                      */
	{NEA,"D,A",      2, 8}, /* 6c: 0110 0000 0110 1100                      */
	{NEA,"E,A",      2, 8}, /* 6d: 0110 0000 0110 1101                      */
	{NEA,"H,A",      2, 8}, /* 6e: 0110 0000 0110 1110                      */
	{NEA,"L,A",      2, 8}, /* 6f: 0110 0000 0110 1111                      */

	{SBB,"V,A",      2, 8}, /* 70: 0110 0000 0111 0000                      */
	{SBB,"A,A",      2, 8}, /* 71: 0110 0000 0111 0001                      */
	{SBB,"B,A",      2, 8}, /* 72: 0110 0000 0111 0010                      */
	{SBB,"C,A",      2, 8}, /* 73: 0110 0000 0111 0011                      */
	{SBB,"D,A",      2, 8}, /* 74: 0110 0000 0111 0100                      */
	{SBB,"E,A",      2, 8}, /* 75: 0110 0000 0111 0101                      */
	{SBB,"H,A",      2, 8}, /* 76: 0110 0000 0111 0110                      */
	{SBB,"L,A",      2, 8}, /* 77: 0110 0000 0111 0111                      */
	{EQA,"V,A",      2, 8}, /* 78: 0110 0000 0111 1000                      */
	{EQA,"A,A",      2, 8}, /* 79: 0110 0000 0111 1001                      */
	{EQA,"B,A",      2, 8}, /* 7a: 0110 0000 0111 1010                      */
	{EQA,"C,A",      2, 8}, /* 7b: 0110 0000 0111 1011                      */
	{EQA,"D,A",      2, 8}, /* 7c: 0110 0000 0111 1100                      */
	{EQA,"E,A",      2, 8}, /* 7d: 0110 0000 0111 1101                      */
	{EQA,"H,A",      2, 8}, /* 7e: 0110 0000 0111 1110                      */
	{EQA,"L,A",      2, 8}, /* 7f: 0110 0000 0111 1111                      */

	{illegal,0, 	 2, 8}, /* 80: 0110 0000 1000 0000                      */
	{illegal,0, 	 2, 8}, /* 81: 0110 0000 1000 0001                      */
	{illegal,0, 	 2, 8}, /* 82: 0110 0000 1000 0010                      */
	{illegal,0, 	 2, 8}, /* 83: 0110 0000 1000 0011                      */
	{illegal,0, 	 2, 8}, /* 84: 0110 0000 1000 0100                      */
	{illegal,0, 	 2, 8}, /* 85: 0110 0000 1000 0101                      */
	{illegal,0, 	 2, 8}, /* 86: 0110 0000 1000 0110                      */
	{illegal,0, 	 2, 8}, /* 87: 0110 0000 1000 0111                      */
	{ANA,"A,V",      2, 8}, /* 88: 0110 0000 1000 1000                      */
	{ANA,"A,A",      2, 8}, /* 89: 0110 0000 1000 1001                      */
	{ANA,"A,B",      2, 8}, /* 8a: 0110 0000 1000 1010                      */
	{ANA,"A,C",      2, 8}, /* 8b: 0110 0000 1000 1011                      */
	{ANA,"A,D",      2, 8}, /* 8c: 0110 0000 1000 1100                      */
	{ANA,"A,E",      2, 8}, /* 8d: 0110 0000 1000 1101                      */
	{ANA,"A,H",      2, 8}, /* 8e: 0110 0000 1000 1110                      */
	{ANA,"A,L",      2, 8}, /* 8f: 0110 0000 1000 1111                      */

	{XRA,"A,V",      2, 8}, /* 90: 0110 0000 1001 0000                      */
	{XRA,"A,A",      2, 8}, /* 91: 0110 0000 1001 0001                      */
	{XRA,"A,B",      2, 8}, /* 92: 0110 0000 1001 0010                      */
	{XRA,"A,C",      2, 8}, /* 93: 0110 0000 1001 0011                      */
	{XRA,"A,D",      2, 8}, /* 94: 0110 0000 1001 0100                      */
	{XRA,"A,E",      2, 8}, /* 95: 0110 0000 1001 0101                      */
	{XRA,"A,H",      2, 8}, /* 96: 0110 0000 1001 0110                      */
	{XRA,"A,L",      2, 8}, /* 97: 0110 0000 1001 0111                      */
	{ORA,"A,V",      2, 8}, /* 98: 0110 0000 1001 1000                      */
	{ORA,"A,A",      2, 8}, /* 99: 0110 0000 1001 1001                      */
	{ORA,"A,B",      2, 8}, /* 9a: 0110 0000 1001 1010                      */
	{ORA,"A,C",      2, 8}, /* 9b: 0110 0000 1001 1011                      */
	{ORA,"A,D",      2, 8}, /* 9c: 0110 0000 1001 1100                      */
	{ORA,"A,E",      2, 8}, /* 9d: 0110 0000 1001 1101                      */
	{ORA,"A,H",      2, 8}, /* 9e: 0110 0000 1001 1110                      */
	{ORA,"A,L",      2, 8}, /* 9f: 0110 0000 1001 1111                      */

	{ADDNC,"A,V",    2, 8}, /* a0: 0110 0000 1010 0000                      */
	{ADDNC,"A,A",    2, 8}, /* a1: 0110 0000 1010 0001                      */
	{ADDNC,"A,B",    2, 8}, /* a2: 0110 0000 1010 0010                      */
	{ADDNC,"A,C",    2, 8}, /* a3: 0110 0000 1010 0011                      */
	{ADDNC,"A,D",    2, 8}, /* a4: 0110 0000 1010 0100                      */
	{ADDNC,"A,E",    2, 8}, /* a5: 0110 0000 1010 0101                      */
	{ADDNC,"A,H",    2, 8}, /* a6: 0110 0000 1010 0110                      */
	{ADDNC,"A,L",    2, 8}, /* a7: 0110 0000 1010 0111                      */
	{GTA,"A,V",      2, 8}, /* a8: 0110 0000 1010 1000                      */
	{GTA,"A,A",      2, 8}, /* a9: 0110 0000 1010 1001                      */
	{GTA,"A,B",      2, 8}, /* aa: 0110 0000 1010 1010                      */
	{GTA,"A,C",      2, 8}, /* ab: 0110 0000 1010 1011                      */
	{GTA,"A,D",      2, 8}, /* ac: 0110 0000 1010 1100                      */
	{GTA,"A,E",      2, 8}, /* ad: 0110 0000 1010 1101                      */
	{GTA,"A,H",      2, 8}, /* ae: 0110 0000 1010 1110                      */
	{GTA,"A,L",      2, 8}, /* af: 0110 0000 1010 1111                      */

	{SUBNB,"A,V",    2, 8}, /* b0: 0110 0000 1011 0000                      */
	{SUBNB,"A,A",    2, 8}, /* b1: 0110 0000 1011 0001                      */
	{SUBNB,"A,B",    2, 8}, /* b2: 0110 0000 1011 0010                      */
	{SUBNB,"A,C",    2, 8}, /* b3: 0110 0000 1011 0011                      */
	{SUBNB,"A,D",    2, 8}, /* b4: 0110 0000 1011 0100                      */
	{SUBNB,"A,E",    2, 8}, /* b5: 0110 0000 1011 0101                      */
	{SUBNB,"A,H",    2, 8}, /* b6: 0110 0000 1011 0110                      */
	{SUBNB,"A,L",    2, 8}, /* b7: 0110 0000 1011 0111                      */
	{LTA,"A,V",      2, 8}, /* b8: 0110 0000 1011 1000                      */
	{LTA,"A,A",      2, 8}, /* b9: 0110 0000 1011 1001                      */
	{LTA,"A,B",      2, 8}, /* ba: 0110 0000 1011 1010                      */
	{LTA,"A,C",      2, 8}, /* bb: 0110 0000 1011 1011                      */
	{LTA,"A,D",      2, 8}, /* bc: 0110 0000 1011 1100                      */
	{LTA,"A,E",      2, 8}, /* bd: 0110 0000 1011 1101                      */
	{LTA,"A,H",      2, 8}, /* be: 0110 0000 1011 1110                      */
	{LTA,"A,L",      2, 8}, /* bf: 0110 0000 1011 1111                      */

	{ADD,"A,V",      2, 8}, /* c0: 0110 0000 1100 0000                      */
	{ADD,"A,A",      2, 8}, /* c1: 0110 0000 1100 0001                      */
	{ADD,"A,B",      2, 8}, /* c2: 0110 0000 1100 0010                      */
	{ADD,"A,C",      2, 8}, /* c3: 0110 0000 1100 0011                      */
	{ADD,"A,D",      2, 8}, /* c4: 0110 0000 1100 0100                      */
	{ADD,"A,E",      2, 8}, /* c5: 0110 0000 1100 0101                      */
	{ADD,"A,H",      2, 8}, /* c6: 0110 0000 1100 0110                      */
	{ADD,"A,L",      2, 8}, /* c7: 0110 0000 1100 0111                      */
	{ONA,"A,V",      2, 8}, /* c8: 0110 0000 1100 1000                      */
	{ONA,"A,A",      2, 8}, /* c9: 0110 0000 1100 1001                      */
	{ONA,"A,B",      2, 8}, /* ca: 0110 0000 1100 1010                      */
	{ONA,"A,C",      2, 8}, /* cb: 0110 0000 1100 1011                      */
	{ONA,"A,D",      2, 8}, /* cc: 0110 0000 1100 1100                      */
	{ONA,"A,E",      2, 8}, /* cd: 0110 0000 1100 1101                      */
	{ONA,"A,H",      2, 8}, /* ce: 0110 0000 1100 1110                      */
	{ONA,"A,L",      2, 8}, /* cf: 0110 0000 1100 1111                      */

	{ADC,"A,V",      2, 8}, /* d0: 0110 0000 1101 0000                      */
	{ADC,"A,A",      2, 8}, /* d1: 0110 0000 1101 0001                      */
	{ADC,"A,B",      2, 8}, /* d2: 0110 0000 1101 0010                      */
	{ADC,"A,C",      2, 8}, /* d3: 0110 0000 1101 0011                      */
	{ADC,"A,D",      2, 8}, /* d4: 0110 0000 1101 0100                      */
	{ADC,"A,E",      2, 8}, /* d5: 0110 0000 1101 0101                      */
	{ADC,"A,H",      2, 8}, /* d6: 0110 0000 1101 0110                      */
	{ADC,"A,L",      2, 8}, /* d7: 0110 0000 1101 0111                      */
	{OFFA,"A,V",     2, 8}, /* d8: 0110 0000 1101 1000                      */
	{OFFA,"A,A",     2, 8}, /* d9: 0110 0000 1101 1001                      */
	{OFFA,"A,B",     2, 8}, /* da: 0110 0000 1101 1010                      */
	{OFFA,"A,C",     2, 8}, /* db: 0110 0000 1101 1011                      */
	{OFFA,"A,D",     2, 8}, /* dc: 0110 0000 1101 1100                      */
	{OFFA,"A,E",     2, 8}, /* dd: 0110 0000 1101 1101                      */
	{OFFA,"A,H",     2, 8}, /* de: 0110 0000 1101 1110                      */
	{OFFA,"A,L",     2, 8}, /* df: 0110 0000 1101 1111                      */

	{SUB,"A,V",      2, 8}, /* e0: 0110 0000 1110 0000                      */
	{SUB,"A,A",      2, 8}, /* e1: 0110 0000 1110 0001                      */
	{SUB,"A,B",      2, 8}, /* e2: 0110 0000 1110 0010                      */
	{SUB,"A,C",      2, 8}, /* e3: 0110 0000 1110 0011                      */
	{SUB,"A,D",      2, 8}, /* e4: 0110 0000 1110 0100                      */
	{SUB,"A,E",      2, 8}, /* e5: 0110 0000 1110 0101                      */
	{SUB,"A,H",      2, 8}, /* e6: 0110 0000 1110 0110                      */
	{SUB,"A,L",      2, 8}, /* e7: 0110 0000 1110 0111                      */
	{NEA,"A,V",      2, 8}, /* e8: 0110 0000 1110 1000                      */
	{NEA,"A,A",      2, 8}, /* e9: 0110 0000 1110 1001                      */
	{NEA,"A,B",      2, 8}, /* ea: 0110 0000 1110 1010                      */
	{NEA,"A,C",      2, 8}, /* eb: 0110 0000 1110 1011                      */
	{NEA,"A,D",      2, 8}, /* ec: 0110 0000 1110 1100                      */
	{NEA,"A,E",      2, 8}, /* ed: 0110 0000 1110 1101                      */
	{NEA,"A,H",      2, 8}, /* ee: 0110 0000 1110 1110                      */
	{NEA,"A,L",      2, 8}, /* ef: 0110 0000 1110 1111                      */

	{SBB,"A,V",      2, 8}, /* f0: 0110 0000 1111 0000                      */
	{SBB,"A,A",      2, 8}, /* f1: 0110 0000 1111 0001                      */
	{SBB,"A,B",      2, 8}, /* f2: 0110 0000 1111 0010                      */
	{SBB,"A,C",      2, 8}, /* f3: 0110 0000 1111 0011                      */
	{SBB,"A,D",      2, 8}, /* f4: 0110 0000 1111 0100                      */
	{SBB,"A,E",      2, 8}, /* f5: 0110 0000 1111 0101                      */
	{SBB,"A,H",      2, 8}, /* f6: 0110 0000 1111 0110                      */
	{SBB,"A,L",      2, 8}, /* f7: 0110 0000 1111 0111                      */
	{EQA,"A,V",      2, 8}, /* f8: 0110 0000 1111 1000                      */
	{EQA,"A,A",      2, 8}, /* f9: 0110 0000 1111 1001                      */
	{EQA,"A,B",      2, 8}, /* fa: 0110 0000 1111 1010                      */
	{EQA,"A,C",      2, 8}, /* fb: 0110 0000 1111 1011                      */
	{EQA,"A,D",      2, 8}, /* fc: 0110 0000 1111 1100                      */
	{EQA,"A,E",      2, 8}, /* fd: 0110 0000 1111 1101                      */
	{EQA,"A,H",      2, 8}, /* fe: 0110 0000 1111 1110                      */
	{EQA,"A,L",      2, 8}  /* ff: 0110 0000 1111 1111                      */
};

/* prefix 64 */
static struct dasm_s  dasm64_7810[256] =
{
	{MVI,"PA,%b",    3,14}, /* 00: 0110 0100 0000 0000 xxxx xxxx            */
	{MVI,"PB,%b",    3,14}, /* 01: 0110 0100 0000 0001 xxxx xxxx            */
	{MVI,"PC,%b",    3,14}, /* 02: 0110 0100 0000 0010 xxxx xxxx            */
	{MVI,"PD,%b",    3,14}, /* 03: 0110 0100 0000 0011 xxxx xxxx            */
	{illegal,0, 	 3,14}, /* 04: 0110 0100 0000 0100 xxxx xxxx            */
	{MVI,"PF,%b",    3,14}, /* 05: 0110 0100 0000 0101 xxxx xxxx            */
	{MVI,"MKH,%b",   3,14}, /* 06: 0110 0100 0000 0110 xxxx xxxx            */
	{MVI,"MKL,%b",   3,14}, /* 07: 0110 0100 0000 0111 xxxx xxxx            */
	{ANI,"PA,%b",    3,20}, /* 08: 0110 0100 0000 1000 xxxx xxxx            */
	{ANI,"PB,%b",    3,20}, /* 09: 0110 0100 0000 1001 xxxx xxxx            */
	{ANI,"PC,%b",    3,20}, /* 0a: 0110 0100 0000 1010 xxxx xxxx            */
	{ANI,"PD,%b",    3,20}, /* 0b: 0110 0100 0000 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 0c: 0110 0100 0000 1100 xxxx xxxx            */
	{ANI,"PF,%b",    3,20}, /* 0d: 0110 0100 0000 1101 xxxx xxxx            */
	{ANI,"MKH,%b",   3,20}, /* 0e: 0110 0100 0000 1110 xxxx xxxx            */
	{ANI,"MKL,%b",   3,20}, /* 0f: 0110 0100 0000 1111 xxxx xxxx            */

	{XRI,"PA,%b",    3,20}, /* 10: 0110 0100 0001 0000 xxxx xxxx            */
	{XRI,"PB,%b",    3,20}, /* 11: 0110 0100 0001 0001 xxxx xxxx            */
	{XRI,"PC,%b",    3,20}, /* 12: 0110 0100 0001 0010 xxxx xxxx            */
	{XRI,"PD,%b",    3,20}, /* 13: 0110 0100 0001 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 14: 0110 0100 0001 0100 xxxx xxxx            */
	{XRI,"PF,%b",    3,20}, /* 15: 0110 0100 0001 0101 xxxx xxxx            */
	{XRI,"MKH,%b",   3,20}, /* 16: 0110 0100 0001 0110 xxxx xxxx            */
	{XRI,"MKL,%b",   3,20}, /* 17: 0110 0100 0001 0111 xxxx xxxx            */
	{ORI,"PA,%b",    3,20}, /* 18: 0110 0100 0001 1000 xxxx xxxx            */
	{ORI,"PB,%b",    3,20}, /* 19: 0110 0100 0001 1001 xxxx xxxx            */
	{ORI,"PC,%b",    3,20}, /* 1a: 0110 0100 0001 1010 xxxx xxxx            */
	{ORI,"PD,%b",    3,20}, /* 1b: 0110 0100 0001 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 1c: 0110 0100 0001 1100 xxxx xxxx            */
	{ORI,"PF,%b",    3,20}, /* 1d: 0110 0100 0001 1101 xxxx xxxx            */
	{ORI,"MKH,%b",   3,20}, /* 1e: 0110 0100 0001 1110 xxxx xxxx            */
	{ORI,"MKL,%b",   3,20}, /* 1f: 0110 0100 0001 1111 xxxx xxxx            */

	{ADINC,"PA,%b",  3,20}, /* 20: 0110 0100 0010 0000 xxxx xxxx            */
	{ADINC,"PB,%b",  3,20}, /* 21: 0110 0100 0010 0001 xxxx xxxx            */
	{ADINC,"PC,%b",  3,20}, /* 22: 0110 0100 0010 0010 xxxx xxxx            */
	{ADINC,"PD,%b",  3,20}, /* 23: 0110 0100 0010 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 24: 0110 0100 0010 0100 xxxx xxxx            */
	{ADINC,"PF,%b",  3,20}, /* 25: 0110 0100 0010 0101 xxxx xxxx            */
	{ADINC,"MKH,%b", 3,20}, /* 26: 0110 0100 0010 0110 xxxx xxxx            */
	{ADINC,"MKL,%b", 3,20}, /* 27: 0110 0100 0010 0111 xxxx xxxx            */
	{GTI,"PA,%b",    3,20}, /* 28: 0110 0100 0010 1000 xxxx xxxx            */
	{GTI,"PB,%b",    3,20}, /* 29: 0110 0100 0010 1001 xxxx xxxx            */
	{GTI,"PC,%b",    3,20}, /* 2a: 0110 0100 0010 1010 xxxx xxxx            */
	{GTI,"PD,%b",    3,20}, /* 2b: 0110 0100 0010 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 2c: 0110 0100 0010 1100 xxxx xxxx            */
	{GTI,"PF,%b",    3,20}, /* 2d: 0110 0100 0010 1101 xxxx xxxx            */
	{GTI,"MKH,%b",   3,20}, /* 2e: 0110 0100 0010 1110 xxxx xxxx            */
	{GTI,"MKL,%b",   3,20}, /* 2f: 0110 0100 0010 1111 xxxx xxxx            */

	{SUINB,"PA,%b",  3,20}, /* 30: 0110 0100 0011 0000 xxxx xxxx            */
	{SUINB,"PB,%b",  3,20}, /* 31: 0110 0100 0011 0001 xxxx xxxx            */
	{SUINB,"PC,%b",  3,20}, /* 32: 0110 0100 0011 0010 xxxx xxxx            */
	{SUINB,"PD,%b",  3,20}, /* 33: 0110 0100 0011 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 34: 0110 0100 0011 0100 xxxx xxxx            */
	{SUINB,"PF,%b",  3,20}, /* 35: 0110 0100 0011 0101 xxxx xxxx            */
	{SUINB,"MKH,%b", 3,20}, /* 36: 0110 0100 0011 0110 xxxx xxxx            */
	{SUINB,"MKL,%b", 3,20}, /* 37: 0110 0100 0011 0111 xxxx xxxx            */
	{LTI,"PA,%b",    3,20}, /* 38: 0110 0100 0011 1000 xxxx xxxx            */
	{LTI,"PB,%b",    3,20}, /* 39: 0110 0100 0011 1001 xxxx xxxx            */
	{LTI,"PC,%b",    3,20}, /* 3a: 0110 0100 0011 1010 xxxx xxxx            */
	{LTI,"PD,%b",    3,20}, /* 3b: 0110 0100 0011 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 3c: 0110 0100 0011 1100 xxxx xxxx            */
	{LTI,"PF,%b",    3,20}, /* 3d: 0110 0100 0011 1101 xxxx xxxx            */
	{LTI,"MKH,%b",   3,20}, /* 3e: 0110 0100 0011 1110 xxxx xxxx            */
	{LTI,"MKL,%b",   3,20}, /* 3f: 0110 0100 0011 1111 xxxx xxxx            */

	{ADI,"PA,%b",    3,20}, /* 40: 0110 0100 0100 0000 xxxx xxxx            */
	{ADI,"PB,%b",    3,20}, /* 41: 0110 0100 0100 0001 xxxx xxxx            */
	{ADI,"PC,%b",    3,20}, /* 42: 0110 0100 0100 0010 xxxx xxxx            */
	{ADI,"PD,%b",    3,20}, /* 43: 0110 0100 0100 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 44: 0110 0100 0100 0100 xxxx xxxx            */
	{ADI,"PF,%b",    3,20}, /* 45: 0110 0100 0100 0101 xxxx xxxx            */
	{ADI,"MKH,%b",   3,20}, /* 46: 0110 0100 0100 0110 xxxx xxxx            */
	{ADI,"MKL,%b",   3,20}, /* 47: 0110 0100 0100 0111 xxxx xxxx            */
	{ONI,"PA,%b",    3,20}, /* 48: 0110 0100 0100 1000 xxxx xxxx            */
	{ONI,"PB,%b",    3,20}, /* 49: 0110 0100 0100 1001 xxxx xxxx            */
	{ONI,"PC,%b",    3,20}, /* 4a: 0110 0100 0100 1010 xxxx xxxx            */
	{ONI,"PD,%b",    3,20}, /* 4b: 0110 0100 0100 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 4c: 0110 0100 0100 1100 xxxx xxxx            */
	{ONI,"PF,%b",    3,20}, /* 4d: 0110 0100 0100 1101 xxxx xxxx            */
	{ONI,"MKH,%b",   3,20}, /* 4e: 0110 0100 0100 1110 xxxx xxxx            */
	{ONI,"MKL,%b",   3,20}, /* 4f: 0110 0100 0100 1111 xxxx xxxx            */

	{ACI,"PA,%b",    3,20}, /* 50: 0110 0100 0101 0000 xxxx xxxx            */
	{ACI,"PB,%b",    3,20}, /* 51: 0110 0100 0101 0001 xxxx xxxx            */
	{ACI,"PC,%b",    3,20}, /* 52: 0110 0100 0101 0010 xxxx xxxx            */
	{ACI,"PD,%b",    3,20}, /* 53: 0110 0100 0101 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 54: 0110 0100 0101 0100 xxxx xxxx            */
	{ACI,"PF,%b",    3,20}, /* 55: 0110 0100 0101 0101 xxxx xxxx            */
	{ACI,"MKH,%b",   3,20}, /* 56: 0110 0100 0101 0110 xxxx xxxx            */
	{ACI,"MKL,%b",   3,20}, /* 57: 0110 0100 0101 0111 xxxx xxxx            */
	{OFFI,"PA,%b",   3,20}, /* 58: 0110 0100 0101 1000 xxxx xxxx            */
	{OFFI,"PB,%b",   3,20}, /* 59: 0110 0100 0101 1001 xxxx xxxx            */
	{OFFI,"PC,%b",   3,20}, /* 5a: 0110 0100 0101 1010 xxxx xxxx            */
	{OFFI,"PD,%b",   3,20}, /* 5b: 0110 0100 0101 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 5c: 0110 0100 0101 1100 xxxx xxxx            */
	{OFFI,"PF,%b",   3,20}, /* 5d: 0110 0100 0101 1101 xxxx xxxx            */
	{OFFI,"MKH,%b",  3,20}, /* 5e: 0110 0100 0101 1110 xxxx xxxx            */
	{OFFI,"MKL,%b",  3,20}, /* 5f: 0110 0100 0101 1111 xxxx xxxx            */

	{SUI,"PA,%b",    3,20}, /* 60: 0110 0100 0110 0000 xxxx xxxx            */
	{SUI,"PB,%b",    3,20}, /* 61: 0110 0100 0110 0001 xxxx xxxx            */
	{SUI,"PC,%b",    3,20}, /* 62: 0110 0100 0110 0010 xxxx xxxx            */
	{SUI,"PD,%b",    3,20}, /* 63: 0110 0100 0110 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 64: 0110 0100 0110 0100 xxxx xxxx            */
	{SUI,"PF,%b",    3,20}, /* 65: 0110 0100 0110 0101 xxxx xxxx            */
	{SUI,"MKH,%b",   3,20}, /* 66: 0110 0100 0110 0110 xxxx xxxx            */
	{SUI,"MKL,%b",   3,20}, /* 67: 0110 0100 0110 0111 xxxx xxxx            */
	{NEI,"PA,%b",    3,20}, /* 68: 0110 0100 0110 1000 xxxx xxxx            */
	{NEI,"PB,%b",    3,20}, /* 69: 0110 0100 0110 1001 xxxx xxxx            */
	{NEI,"PC,%b",    3,20}, /* 6a: 0110 0100 0110 1010 xxxx xxxx            */
	{NEI,"PD,%b",    3,20}, /* 6b: 0110 0100 0110 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 6c: 0110 0100 0110 1100 xxxx xxxx            */
	{NEI,"PF,%b",    3,20}, /* 6d: 0110 0100 0110 1101 xxxx xxxx            */
	{NEI,"MKH,%b",   3,20}, /* 6e: 0110 0100 0110 1110 xxxx xxxx            */
	{NEI,"MKL,%b",   3,20}, /* 6f: 0110 0100 0110 1111 xxxx xxxx            */

	{SBI,"PA,%b",    3,20}, /* 70: 0110 0100 0111 0000 xxxx xxxx            */
	{SBI,"PB,%b",    3,20}, /* 71: 0110 0100 0111 0001 xxxx xxxx            */
	{SBI,"PC,%b",    3,20}, /* 72: 0110 0100 0111 0010 xxxx xxxx            */
	{SBI,"PD,%b",    3,20}, /* 73: 0110 0100 0111 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 74: 0110 0100 0111 0100 xxxx xxxx            */
	{SBI,"PF,%b",    3,20}, /* 75: 0110 0100 0111 0101 xxxx xxxx            */
	{SBI,"MKH,%b",   3,20}, /* 76: 0110 0100 0111 0110 xxxx xxxx            */
	{SBI,"MKL,%b",   3,20}, /* 77: 0110 0100 0111 0111 xxxx xxxx            */
	{EQI,"PA,%b",    3,20}, /* 78: 0110 0100 0111 1000 xxxx xxxx            */
	{EQI,"PB,%b",    3,20}, /* 79: 0110 0100 0111 1001 xxxx xxxx            */
	{EQI,"PC,%b",    3,20}, /* 7a: 0110 0100 0111 1010 xxxx xxxx            */
	{EQI,"PD,%b",    3,20}, /* 7b: 0110 0100 0111 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 7c: 0110 0100 0111 1100 xxxx xxxx            */
	{EQI,"PF,%b",    3,20}, /* 7d: 0110 0100 0111 1101 xxxx xxxx            */
	{EQI,"MKH,%b",   3,20}, /* 7e: 0110 0100 0111 1110 xxxx xxxx            */
	{EQI,"MKL,%b",   3,20}, /* 7f: 0110 0100 0111 1111 xxxx xxxx            */

	{MVI,"ANM,%b",   3,14}, /* 80: 0110 0100 1000 0000 xxxx xxxx            */	/* 7810 */
	{MVI,"SMH,%b",   3,14}, /* 81: 0110 0100 1000 0001 xxxx xxxx            */
	{illegal,0, 	 3,14}, /* 82: 0110 0100 1000 0010 xxxx xxxx            */
	{MVI,"EOM,%b",   3,14}, /* 83: 0110 0100 1000 0011 xxxx xxxx            */
	{illegal,0, 	 3,14}, /* 84: 0110 0100 1000 0100 xxxx xxxx            */
	{MVI,"TMM,%b",   3,14}, /* 85: 0110 0100 1000 0101 xxxx xxxx            */
	{illegal,0, 	 3,14}, /* 86: 0110 0100 1000 0110 xxxx xxxx            */
	{illegal,0, 	 3,14}, /* 87: 0110 0100 1000 0111 xxxx xxxx            */
	{ANI,"ANM,%b",   3,20}, /* 88: 0110 0100 1000 1000 xxxx xxxx            */	/* 7810 */
	{ANI,"SMH,%b",   3,20}, /* 89: 0110 0100 1000 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 8a: 0110 0100 1000 1010 xxxx xxxx            */
	{ANI,"EOM,%b",   3,20}, /* 8b: 0110 0100 1000 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 8c: 0110 0100 1000 1100 xxxx xxxx            */
	{ANI,"TMM,%b",   3,20}, /* 8d: 0110 0100 1000 1101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 8e: 0110 0100 1000 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 8f: 0110 0100 1000 1111 xxxx xxxx            */

	{XRI,"ANM,%b",   3,20}, /* 90: 0110 0100 1001 0000 xxxx xxxx            */	/* 7810 */
	{XRI,"SMH,%b",   3,20}, /* 91: 0110 0100 1001 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 92: 0110 0100 1001 0010 xxxx xxxx            */
	{XRI,"EOM,%b",   3,20}, /* 93: 0110 0100 1001 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 94: 0110 0100 1001 0100 xxxx xxxx            */
	{XRI,"TMM,%b",   3,20}, /* 95: 0110 0100 1001 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 96: 0110 0100 1001 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 97: 0110 0100 1001 0111 xxxx xxxx            */
	{ORI,"ANM,%b",   3,20}, /* 98: 0110 0100 1001 1000 xxxx xxxx            */	/* 7810 */
	{ORI,"SMH,%b",   3,20}, /* 99: 0110 0100 1001 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 9a: 0110 0100 1001 1010 xxxx xxxx            */
	{ORI,"EOM,%b",   3,20}, /* 9b: 0110 0100 1001 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 9c: 0110 0100 1001 1100 xxxx xxxx            */
	{ORI,"TMM,%b",   3,20}, /* 9d: 0110 0100 1001 1101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 9e: 0110 0100 1001 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 9f: 0110 0100 1001 1111 xxxx xxxx            */

	{ADINC,"ANM,%b", 3,20}, /* a0: 0110 0100 1010 0000 xxxx xxxx            */	/* 7810 */
	{ADINC,"SMH,%b", 3,20}, /* a1: 0110 0100 1010 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* a2: 0110 0100 1010 0010 xxxx xxxx            */
	{ADINC,"EOM,%b", 3,20}, /* a3: 0110 0100 1010 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* a4: 0110 0100 1010 0100 xxxx xxxx            */
	{ADINC,"TMM,%b", 3,20}, /* a5: 0110 0100 1010 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* a6: 0110 0100 1010 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* a7: 0110 0100 1010 0111 xxxx xxxx            */
	{GTI,"ANM,%b",   3,20}, /* a8: 0110 0100 1010 1000 xxxx xxxx            */	/* 7810 */
	{GTI,"SMH,%b",   3,20}, /* a9: 0110 0100 1010 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* aa: 0110 0100 1010 1010 xxxx xxxx            */
	{GTI,"EOM,%b",   3,20}, /* ab: 0110 0100 1010 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ac: 0110 0100 1010 1100 xxxx xxxx            */
	{GTI,"TMM,%b",   3,20}, /* ad: 0110 0100 1010 1101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ae: 0110 0100 1010 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* af: 0110 0100 1010 1111 xxxx xxxx            */

	{SUINB,"ANM,%b", 3,20}, /* b0: 0110 0100 1011 0000 xxxx xxxx            */	/* 7810 */
	{SUINB,"SMH,%b", 3,20}, /* b1: 0110 0100 1011 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* b2: 0110 0100 1011 0010 xxxx xxxx            */
	{SUINB,"EOM,%b", 3,20}, /* b3: 0110 0100 1011 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* b4: 0110 0100 1011 0100 xxxx xxxx            */
	{SUINB,"TMM,%b", 3,20}, /* b5: 0110 0100 1011 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* b6: 0110 0100 1011 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* b7: 0110 0100 1011 0111 xxxx xxxx            */
	{LTI,"ANM,%b",   3,20}, /* b8: 0110 0100 1011 1000 xxxx xxxx            */	/* 7810 */
	{LTI,"SMH,%b",   3,20}, /* b9: 0110 0100 1011 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ba: 0110 0100 1011 1010 xxxx xxxx            */
	{LTI,"EOM,%b",   3,20}, /* bb: 0110 0100 1011 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* bc: 0110 0100 1011 1100 xxxx xxxx            */
	{LTI,"TMM,%b",   3,20}, /* bd: 0110 0100 1011 1101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* be: 0110 0100 1011 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* bf: 0110 0100 1011 1111 xxxx xxxx            */

	{ADI,"ANM,%b",   3,20}, /* c0: 0110 0100 1100 0000 xxxx xxxx            */	/* 7810 */
	{ADI,"SMH,%b",   3,20}, /* c1: 0110 0100 1100 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* c2: 0110 0100 1100 0010 xxxx xxxx            */
	{ADI,"EOM,%b",   3,20}, /* c3: 0110 0100 1100 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* c4: 0110 0100 1100 0100 xxxx xxxx            */
	{ADI,"TMM,%b",   3,20}, /* c5: 0110 0100 1100 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* c6: 0110 0100 1100 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* c7: 0110 0100 1100 0111 xxxx xxxx            */
	{ONI,"ANM,%b",   3,20}, /* c8: 0110 0100 1100 1000 xxxx xxxx            */	/* 7810 */
	{ONI,"SMH,%b",   3,20}, /* c9: 0110 0100 1100 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ca: 0110 0100 1100 1010 xxxx xxxx            */
	{ONI,"EOM,%b",   3,20}, /* cb: 0110 0100 1100 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* cc: 0110 0100 1100 1100 xxxx xxxx            */
	{ONI,"TMM,%b",   3,20}, /* cd: 0110 0100 1100 1101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ce: 0110 0100 1100 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* cf: 0110 0100 1100 1111 xxxx xxxx            */

	{ACI,"ANM,%b",   3,20}, /* d0: 0110 0100 1101 0000 xxxx xxxx            */	/* 7810 */
	{ACI,"SMH,%b",   3,20}, /* d1: 0110 0100 1101 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* d2: 0110 0100 1101 0010 xxxx xxxx            */
	{ACI,"EOM,%b",   3,20}, /* d3: 0110 0100 1101 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* d4: 0110 0100 1101 0100 xxxx xxxx            */
	{ACI,"TMM,%b",   3,20}, /* d5: 0110 0100 1101 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* d6: 0110 0100 1101 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* d7: 0110 0100 1101 0111 xxxx xxxx            */
	{OFFI,"ANM,%b",  3,20}, /* d8: 0110 0100 1101 1000 xxxx xxxx            */	/* 7810 */
	{OFFI,"SMH,%b",  3,20}, /* d9: 0110 0100 1101 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* da: 0110 0100 1101 1010 xxxx xxxx            */
	{OFFI,"EOM,%b",  3,20}, /* db: 0110 0100 1101 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* dc: 0110 0100 1101 1100 xxxx xxxx            */
	{OFFI,"TMM,%b",  3,20}, /* dd: 0110 0100 1101 1101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* de: 0110 0100 1101 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* df: 0110 0100 1101 1111 xxxx xxxx            */

	{SUI,"ANM,%b",   3,20}, /* e0: 0110 0100 1110 0000 xxxx xxxx            */	/* 7810 */
	{SUI,"SMH,%b",   3,20}, /* e1: 0110 0100 1110 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* e2: 0110 0100 1110 0010 xxxx xxxx            */
	{SUI,"EOM,%b",   3,20}, /* e3: 0110 0100 1110 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* e4: 0110 0100 1110 0100 xxxx xxxx            */
	{SUI,"TMM,%b",   3,20}, /* e5: 0110 0100 1110 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* e6: 0110 0100 1110 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* e7: 0110 0100 1110 0111 xxxx xxxx            */
	{NEI,"ANM,%b",   3,20}, /* e8: 0110 0100 1110 1000 xxxx xxxx            */	/* 7810 */
	{NEI,"SMH,%b",   3,20}, /* e9: 0110 0100 1110 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ea: 0110 0100 1110 1010 xxxx xxxx            */
	{NEI,"EOM,%b",   3,20}, /* eb: 0110 0100 1110 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ec: 0110 0100 1110 1100 xxxx xxxx            */
	{NEI,"TMM,%b",   3,20}, /* ed: 0110 0100 1110 1101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ee: 0110 0100 1110 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ef: 0110 0100 1110 1111 xxxx xxxx            */

	{SBI,"ANM,%b",   3,20}, /* f0: 0110 0100 1111 0000 xxxx xxxx            */	/* 7810 */
	{SBI,"SMH,%b",   3,20}, /* f1: 0110 0100 1111 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* f2: 0110 0100 1111 0010 xxxx xxxx            */
	{SBI,"EOM,%b",   3,20}, /* f3: 0110 0100 1111 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* f4: 0110 0100 1111 0100 xxxx xxxx            */
	{SBI,"TMM,%b",   3,20}, /* f5: 0110 0100 1111 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* f6: 0110 0100 1111 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* f7: 0110 0100 1111 0111 xxxx xxxx            */
	{EQI,"ANM,%b",   3,20}, /* f8: 0110 0100 1111 1000 xxxx xxxx            */	/* 7810 */
	{EQI,"SMH,%b",   3,20}, /* f9: 0110 0100 1111 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* fa: 0110 0100 1111 1010 xxxx xxxx            */
	{EQI,"EOM,%b",   3,20}, /* fb: 0110 0100 1111 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* fc: 0110 0100 1111 1100 xxxx xxxx            */
	{EQI,"TMM,%b",   3,20}, /* fd: 0110 0100 1111 1101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* fe: 0110 0100 1111 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}	/* ff: 0110 0100 1111 1111 xxxx xxxx            */
};

static struct dasm_s  dasm64_7807[256] =
{
	{MVI,"PA,%b",    3,14}, /* 00: 0110 0100 0000 0000 xxxx xxxx            */
	{MVI,"PB,%b",    3,14}, /* 01: 0110 0100 0000 0001 xxxx xxxx            */
	{MVI,"PC,%b",    3,14}, /* 02: 0110 0100 0000 0010 xxxx xxxx            */
	{MVI,"PD,%b",    3,14}, /* 03: 0110 0100 0000 0011 xxxx xxxx            */
	{illegal,0, 	 3,14}, /* 04: 0110 0100 0000 0100 xxxx xxxx            */
	{MVI,"PF,%b",    3,14}, /* 05: 0110 0100 0000 0101 xxxx xxxx            */
	{MVI,"MKH,%b",   3,14}, /* 06: 0110 0100 0000 0110 xxxx xxxx            */
	{MVI,"MKL,%b",   3,14}, /* 07: 0110 0100 0000 0111 xxxx xxxx            */
	{ANI,"PA,%b",    3,20}, /* 08: 0110 0100 0000 1000 xxxx xxxx            */
	{ANI,"PB,%b",    3,20}, /* 09: 0110 0100 0000 1001 xxxx xxxx            */
	{ANI,"PC,%b",    3,20}, /* 0a: 0110 0100 0000 1010 xxxx xxxx            */
	{ANI,"PD,%b",    3,20}, /* 0b: 0110 0100 0000 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 0c: 0110 0100 0000 1100 xxxx xxxx            */
	{ANI,"PF,%b",    3,20}, /* 0d: 0110 0100 0000 1101 xxxx xxxx            */
	{ANI,"MKH,%b",   3,20}, /* 0e: 0110 0100 0000 1110 xxxx xxxx            */
	{ANI,"MKL,%b",   3,20}, /* 0f: 0110 0100 0000 1111 xxxx xxxx            */

	{XRI,"PA,%b",    3,20}, /* 10: 0110 0100 0001 0000 xxxx xxxx            */
	{XRI,"PB,%b",    3,20}, /* 11: 0110 0100 0001 0001 xxxx xxxx            */
	{XRI,"PC,%b",    3,20}, /* 12: 0110 0100 0001 0010 xxxx xxxx            */
	{XRI,"PD,%b",    3,20}, /* 13: 0110 0100 0001 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 14: 0110 0100 0001 0100 xxxx xxxx            */
	{XRI,"PF,%b",    3,20}, /* 15: 0110 0100 0001 0101 xxxx xxxx            */
	{XRI,"MKH,%b",   3,20}, /* 16: 0110 0100 0001 0110 xxxx xxxx            */
	{XRI,"MKL,%b",   3,20}, /* 17: 0110 0100 0001 0111 xxxx xxxx            */
	{ORI,"PA,%b",    3,20}, /* 18: 0110 0100 0001 1000 xxxx xxxx            */
	{ORI,"PB,%b",    3,20}, /* 19: 0110 0100 0001 1001 xxxx xxxx            */
	{ORI,"PC,%b",    3,20}, /* 1a: 0110 0100 0001 1010 xxxx xxxx            */
	{ORI,"PD,%b",    3,20}, /* 1b: 0110 0100 0001 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 1c: 0110 0100 0001 1100 xxxx xxxx            */
	{ORI,"PF,%b",    3,20}, /* 1d: 0110 0100 0001 1101 xxxx xxxx            */
	{ORI,"MKH,%b",   3,20}, /* 1e: 0110 0100 0001 1110 xxxx xxxx            */
	{ORI,"MKL,%b",   3,20}, /* 1f: 0110 0100 0001 1111 xxxx xxxx            */

	{ADINC,"PA,%b",  3,20}, /* 20: 0110 0100 0010 0000 xxxx xxxx            */
	{ADINC,"PB,%b",  3,20}, /* 21: 0110 0100 0010 0001 xxxx xxxx            */
	{ADINC,"PC,%b",  3,20}, /* 22: 0110 0100 0010 0010 xxxx xxxx            */
	{ADINC,"PD,%b",  3,20}, /* 23: 0110 0100 0010 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 24: 0110 0100 0010 0100 xxxx xxxx            */
	{ADINC,"PF,%b",  3,20}, /* 25: 0110 0100 0010 0101 xxxx xxxx            */
	{ADINC,"MKH,%b", 3,20}, /* 26: 0110 0100 0010 0110 xxxx xxxx            */
	{ADINC,"MKL,%b", 3,20}, /* 27: 0110 0100 0010 0111 xxxx xxxx            */
	{GTI,"PA,%b",    3,20}, /* 28: 0110 0100 0010 1000 xxxx xxxx            */
	{GTI,"PB,%b",    3,20}, /* 29: 0110 0100 0010 1001 xxxx xxxx            */
	{GTI,"PC,%b",    3,20}, /* 2a: 0110 0100 0010 1010 xxxx xxxx            */
	{GTI,"PD,%b",    3,20}, /* 2b: 0110 0100 0010 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 2c: 0110 0100 0010 1100 xxxx xxxx            */
	{GTI,"PF,%b",    3,20}, /* 2d: 0110 0100 0010 1101 xxxx xxxx            */
	{GTI,"MKH,%b",   3,20}, /* 2e: 0110 0100 0010 1110 xxxx xxxx            */
	{GTI,"MKL,%b",   3,20}, /* 2f: 0110 0100 0010 1111 xxxx xxxx            */

	{SUINB,"PA,%b",  3,20}, /* 30: 0110 0100 0011 0000 xxxx xxxx            */
	{SUINB,"PB,%b",  3,20}, /* 31: 0110 0100 0011 0001 xxxx xxxx            */
	{SUINB,"PC,%b",  3,20}, /* 32: 0110 0100 0011 0010 xxxx xxxx            */
	{SUINB,"PD,%b",  3,20}, /* 33: 0110 0100 0011 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 34: 0110 0100 0011 0100 xxxx xxxx            */
	{SUINB,"PF,%b",  3,20}, /* 35: 0110 0100 0011 0101 xxxx xxxx            */
	{SUINB,"MKH,%b", 3,20}, /* 36: 0110 0100 0011 0110 xxxx xxxx            */
	{SUINB,"MKL,%b", 3,20}, /* 37: 0110 0100 0011 0111 xxxx xxxx            */
	{LTI,"PA,%b",    3,20}, /* 38: 0110 0100 0011 1000 xxxx xxxx            */
	{LTI,"PB,%b",    3,20}, /* 39: 0110 0100 0011 1001 xxxx xxxx            */
	{LTI,"PC,%b",    3,20}, /* 3a: 0110 0100 0011 1010 xxxx xxxx            */
	{LTI,"PD,%b",    3,20}, /* 3b: 0110 0100 0011 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 3c: 0110 0100 0011 1100 xxxx xxxx            */
	{LTI,"PF,%b",    3,20}, /* 3d: 0110 0100 0011 1101 xxxx xxxx            */
	{LTI,"MKH,%b",   3,20}, /* 3e: 0110 0100 0011 1110 xxxx xxxx            */
	{LTI,"MKL,%b",   3,20}, /* 3f: 0110 0100 0011 1111 xxxx xxxx            */

	{ADI,"PA,%b",    3,20}, /* 40: 0110 0100 0100 0000 xxxx xxxx            */
	{ADI,"PB,%b",    3,20}, /* 41: 0110 0100 0100 0001 xxxx xxxx            */
	{ADI,"PC,%b",    3,20}, /* 42: 0110 0100 0100 0010 xxxx xxxx            */
	{ADI,"PD,%b",    3,20}, /* 43: 0110 0100 0100 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 44: 0110 0100 0100 0100 xxxx xxxx            */
	{ADI,"PF,%b",    3,20}, /* 45: 0110 0100 0100 0101 xxxx xxxx            */
	{ADI,"MKH,%b",   3,20}, /* 46: 0110 0100 0100 0110 xxxx xxxx            */
	{ADI,"MKL,%b",   3,20}, /* 47: 0110 0100 0100 0111 xxxx xxxx            */
	{ONI,"PA,%b",    3,20}, /* 48: 0110 0100 0100 1000 xxxx xxxx            */
	{ONI,"PB,%b",    3,20}, /* 49: 0110 0100 0100 1001 xxxx xxxx            */
	{ONI,"PC,%b",    3,20}, /* 4a: 0110 0100 0100 1010 xxxx xxxx            */
	{ONI,"PD,%b",    3,20}, /* 4b: 0110 0100 0100 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 4c: 0110 0100 0100 1100 xxxx xxxx            */
	{ONI,"PF,%b",    3,20}, /* 4d: 0110 0100 0100 1101 xxxx xxxx            */
	{ONI,"MKH,%b",   3,20}, /* 4e: 0110 0100 0100 1110 xxxx xxxx            */
	{ONI,"MKL,%b",   3,20}, /* 4f: 0110 0100 0100 1111 xxxx xxxx            */

	{ACI,"PA,%b",    3,20}, /* 50: 0110 0100 0101 0000 xxxx xxxx            */
	{ACI,"PB,%b",    3,20}, /* 51: 0110 0100 0101 0001 xxxx xxxx            */
	{ACI,"PC,%b",    3,20}, /* 52: 0110 0100 0101 0010 xxxx xxxx            */
	{ACI,"PD,%b",    3,20}, /* 53: 0110 0100 0101 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 54: 0110 0100 0101 0100 xxxx xxxx            */
	{ACI,"PF,%b",    3,20}, /* 55: 0110 0100 0101 0101 xxxx xxxx            */
	{ACI,"MKH,%b",   3,20}, /* 56: 0110 0100 0101 0110 xxxx xxxx            */
	{ACI,"MKL,%b",   3,20}, /* 57: 0110 0100 0101 0111 xxxx xxxx            */
	{OFFI,"PA,%b",   3,20}, /* 58: 0110 0100 0101 1000 xxxx xxxx            */
	{OFFI,"PB,%b",   3,20}, /* 59: 0110 0100 0101 1001 xxxx xxxx            */
	{OFFI,"PC,%b",   3,20}, /* 5a: 0110 0100 0101 1010 xxxx xxxx            */
	{OFFI,"PD,%b",   3,20}, /* 5b: 0110 0100 0101 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 5c: 0110 0100 0101 1100 xxxx xxxx            */
	{OFFI,"PF,%b",   3,20}, /* 5d: 0110 0100 0101 1101 xxxx xxxx            */
	{OFFI,"MKH,%b",  3,20}, /* 5e: 0110 0100 0101 1110 xxxx xxxx            */
	{OFFI,"MKL,%b",  3,20}, /* 5f: 0110 0100 0101 1111 xxxx xxxx            */

	{SUI,"PA,%b",    3,20}, /* 60: 0110 0100 0110 0000 xxxx xxxx            */
	{SUI,"PB,%b",    3,20}, /* 61: 0110 0100 0110 0001 xxxx xxxx            */
	{SUI,"PC,%b",    3,20}, /* 62: 0110 0100 0110 0010 xxxx xxxx            */
	{SUI,"PD,%b",    3,20}, /* 63: 0110 0100 0110 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 64: 0110 0100 0110 0100 xxxx xxxx            */
	{SUI,"PF,%b",    3,20}, /* 65: 0110 0100 0110 0101 xxxx xxxx            */
	{SUI,"MKH,%b",   3,20}, /* 66: 0110 0100 0110 0110 xxxx xxxx            */
	{SUI,"MKL,%b",   3,20}, /* 67: 0110 0100 0110 0111 xxxx xxxx            */
	{NEI,"PA,%b",    3,20}, /* 68: 0110 0100 0110 1000 xxxx xxxx            */
	{NEI,"PB,%b",    3,20}, /* 69: 0110 0100 0110 1001 xxxx xxxx            */
	{NEI,"PC,%b",    3,20}, /* 6a: 0110 0100 0110 1010 xxxx xxxx            */
	{NEI,"PD,%b",    3,20}, /* 6b: 0110 0100 0110 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 6c: 0110 0100 0110 1100 xxxx xxxx            */
	{NEI,"PF,%b",    3,20}, /* 6d: 0110 0100 0110 1101 xxxx xxxx            */
	{NEI,"MKH,%b",   3,20}, /* 6e: 0110 0100 0110 1110 xxxx xxxx            */
	{NEI,"MKL,%b",   3,20}, /* 6f: 0110 0100 0110 1111 xxxx xxxx            */

	{SBI,"PA,%b",    3,20}, /* 70: 0110 0100 0111 0000 xxxx xxxx            */
	{SBI,"PB,%b",    3,20}, /* 71: 0110 0100 0111 0001 xxxx xxxx            */
	{SBI,"PC,%b",    3,20}, /* 72: 0110 0100 0111 0010 xxxx xxxx            */
	{SBI,"PD,%b",    3,20}, /* 73: 0110 0100 0111 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 74: 0110 0100 0111 0100 xxxx xxxx            */
	{SBI,"PF,%b",    3,20}, /* 75: 0110 0100 0111 0101 xxxx xxxx            */
	{SBI,"MKH,%b",   3,20}, /* 76: 0110 0100 0111 0110 xxxx xxxx            */
	{SBI,"MKL,%b",   3,20}, /* 77: 0110 0100 0111 0111 xxxx xxxx            */
	{EQI,"PA,%b",    3,20}, /* 78: 0110 0100 0111 1000 xxxx xxxx            */
	{EQI,"PB,%b",    3,20}, /* 79: 0110 0100 0111 1001 xxxx xxxx            */
	{EQI,"PC,%b",    3,20}, /* 7a: 0110 0100 0111 1010 xxxx xxxx            */
	{EQI,"PD,%b",    3,20}, /* 7b: 0110 0100 0111 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 7c: 0110 0100 0111 1100 xxxx xxxx            */
	{EQI,"PF,%b",    3,20}, /* 7d: 0110 0100 0111 1101 xxxx xxxx            */
	{EQI,"MKH,%b",   3,20}, /* 7e: 0110 0100 0111 1110 xxxx xxxx            */
	{EQI,"MKL,%b",   3,20}, /* 7f: 0110 0100 0111 1111 xxxx xxxx            */

	{illegal,0, 	 3,20}, /* 80: 0110 0100 1000 0000 xxxx xxxx            */
	{MVI,"SMH,%b",   3,14}, /* 81: 0110 0100 1000 0001 xxxx xxxx            */
	{illegal,0, 	 3,14}, /* 82: 0110 0100 1000 0010 xxxx xxxx            */
	{MVI,"EOM,%b",   3,14}, /* 83: 0110 0100 1000 0011 xxxx xxxx            */
	{illegal,0, 	 3,14}, /* 84: 0110 0100 1000 0100 xxxx xxxx            */
	{MVI,"TMM,%b",   3,14}, /* 85: 0110 0100 1000 0101 xxxx xxxx            */
	{illegal,0, 	 3,14}, /* 86: 0110 0100 1000 0110 xxxx xxxx            */
	{illegal,0, 	 3,14}, /* 87: 0110 0100 1000 0111 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 88: 0110 0100 1000 1000 xxxx xxxx            */
	{ANI,"SMH,%b",   3,20}, /* 89: 0110 0100 1000 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 8a: 0110 0100 1000 1010 xxxx xxxx            */
	{ANI,"EOM,%b",   3,20}, /* 8b: 0110 0100 1000 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 8c: 0110 0100 1000 1100 xxxx xxxx            */
	{ANI,"TMM,%b",   3,20}, /* 8d: 0110 0100 1000 1101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 8e: 0110 0100 1000 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 8f: 0110 0100 1000 1111 xxxx xxxx            */

	{illegal,0, 	 3,20}, /* 90: 0110 0100 1001 0000 xxxx xxxx            */
	{XRI,"SMH,%b",   3,20}, /* 91: 0110 0100 1001 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 92: 0110 0100 1001 0010 xxxx xxxx            */
	{XRI,"EOM,%b",   3,20}, /* 93: 0110 0100 1001 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 94: 0110 0100 1001 0100 xxxx xxxx            */
	{XRI,"TMM,%b",   3,20}, /* 95: 0110 0100 1001 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 96: 0110 0100 1001 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 97: 0110 0100 1001 0111 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 98: 0110 0100 1001 1000 xxxx xxxx            */
	{ORI,"SMH,%b",   3,20}, /* 99: 0110 0100 1001 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 9a: 0110 0100 1001 1010 xxxx xxxx            */
	{ORI,"EOM,%b",   3,20}, /* 9b: 0110 0100 1001 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 9c: 0110 0100 1001 1100 xxxx xxxx            */
	{ORI,"TMM,%b",   3,20}, /* 9d: 0110 0100 1001 1101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 9e: 0110 0100 1001 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* 9f: 0110 0100 1001 1111 xxxx xxxx            */

	{illegal,0, 	 3,20}, /* a0: 0110 0100 1010 0000 xxxx xxxx            */
	{ADINC,"SMH,%b", 3,20}, /* a1: 0110 0100 1010 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* a2: 0110 0100 1010 0010 xxxx xxxx            */
	{ADINC,"EOM,%b", 3,20}, /* a3: 0110 0100 1010 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* a4: 0110 0100 1010 0100 xxxx xxxx            */
	{ADINC,"TMM,%b", 3,20}, /* a5: 0110 0100 1010 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* a6: 0110 0100 1010 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* a7: 0110 0100 1010 0111 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* a8: 0110 0100 1010 1000 xxxx xxxx            */
	{GTI,"SMH,%b",   3,20}, /* a9: 0110 0100 1010 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* aa: 0110 0100 1010 1010 xxxx xxxx            */
	{GTI,"EOM,%b",   3,20}, /* ab: 0110 0100 1010 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ac: 0110 0100 1010 1100 xxxx xxxx            */
	{GTI,"TMM,%b",   3,20}, /* ad: 0110 0100 1010 1101 xxxx xxxx            */
	{GTI,"PT,%b",    3,20}, /* ae: 0110 0100 1010 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* af: 0110 0100 1010 1111 xxxx xxxx            */

	{illegal,0, 	 3,20}, /* b0: 0110 0100 1011 0000 xxxx xxxx            */
	{SUINB,"SMH,%b", 3,20}, /* b1: 0110 0100 1011 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* b2: 0110 0100 1011 0010 xxxx xxxx            */
	{SUINB,"EOM,%b", 3,20}, /* b3: 0110 0100 1011 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* b4: 0110 0100 1011 0100 xxxx xxxx            */
	{SUINB,"TMM,%b", 3,20}, /* b5: 0110 0100 1011 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* b6: 0110 0100 1011 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* b7: 0110 0100 1011 0111 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* b8: 0110 0100 1011 1000 xxxx xxxx            */
	{LTI,"SMH,%b",   3,20}, /* b9: 0110 0100 1011 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ba: 0110 0100 1011 1010 xxxx xxxx            */
	{LTI,"EOM,%b",   3,20}, /* bb: 0110 0100 1011 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* bc: 0110 0100 1011 1100 xxxx xxxx            */
	{LTI,"TMM,%b",   3,20}, /* bd: 0110 0100 1011 1101 xxxx xxxx            */
	{LTI,"PT,%b",    3,20}, /* be: 0110 0100 1011 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* bf: 0110 0100 1011 1111 xxxx xxxx            */

	{illegal,0, 	 3,20}, /* c0: 0110 0100 1100 0000 xxxx xxxx            */
	{ADI,"SMH,%b",   3,20}, /* c1: 0110 0100 1100 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* c2: 0110 0100 1100 0010 xxxx xxxx            */
	{ADI,"EOM,%b",   3,20}, /* c3: 0110 0100 1100 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* c4: 0110 0100 1100 0100 xxxx xxxx            */
	{ADI,"TMM,%b",   3,20}, /* c5: 0110 0100 1100 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* c6: 0110 0100 1100 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* c7: 0110 0100 1100 0111 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* c8: 0110 0100 1100 1000 xxxx xxxx            */
	{ONI,"SMH,%b",   3,20}, /* c9: 0110 0100 1100 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ca: 0110 0100 1100 1010 xxxx xxxx            */
	{ONI,"EOM,%b",   3,20}, /* cb: 0110 0100 1100 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* cc: 0110 0100 1100 1100 xxxx xxxx            */
	{ONI,"TMM,%b",   3,20}, /* cd: 0110 0100 1100 1101 xxxx xxxx            */
	{ONI,"PT,%b",    3,20}, /* ce: 0110 0100 1100 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* cf: 0110 0100 1100 1111 xxxx xxxx            */

	{illegal,0, 	 3,20}, /* d0: 0110 0100 1101 0000 xxxx xxxx            */
	{ACI,"SMH,%b",   3,20}, /* d1: 0110 0100 1101 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* d2: 0110 0100 1101 0010 xxxx xxxx            */
	{ACI,"EOM,%b",   3,20}, /* d3: 0110 0100 1101 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* d4: 0110 0100 1101 0100 xxxx xxxx            */
	{ACI,"TMM,%b",   3,20}, /* d5: 0110 0100 1101 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* d6: 0110 0100 1101 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* d7: 0110 0100 1101 0111 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* d8: 0110 0100 1101 1000 xxxx xxxx            */
	{OFFI,"SMH,%b",  3,20}, /* d9: 0110 0100 1101 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* da: 0110 0100 1101 1010 xxxx xxxx            */
	{OFFI,"EOM,%b",  3,20}, /* db: 0110 0100 1101 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* dc: 0110 0100 1101 1100 xxxx xxxx            */
	{OFFI,"TMM,%b",  3,20}, /* dd: 0110 0100 1101 1101 xxxx xxxx            */
	{OFFI,"PT,%b",   3,20}, /* de: 0110 0100 1101 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* df: 0110 0100 1101 1111 xxxx xxxx            */

	{illegal,0, 	 3,20}, /* e0: 0110 0100 1110 0000 xxxx xxxx            */
	{SUI,"SMH,%b",   3,20}, /* e1: 0110 0100 1110 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* e2: 0110 0100 1110 0010 xxxx xxxx            */
	{SUI,"EOM,%b",   3,20}, /* e3: 0110 0100 1110 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* e4: 0110 0100 1110 0100 xxxx xxxx            */
	{SUI,"TMM,%b",   3,20}, /* e5: 0110 0100 1110 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* e6: 0110 0100 1110 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* e7: 0110 0100 1110 0111 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* e8: 0110 0100 1110 1000 xxxx xxxx            */
	{NEI,"SMH,%b",   3,20}, /* e9: 0110 0100 1110 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ea: 0110 0100 1110 1010 xxxx xxxx            */
	{NEI,"EOM,%b",   3,20}, /* eb: 0110 0100 1110 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ec: 0110 0100 1110 1100 xxxx xxxx            */
	{NEI,"TMM,%b",   3,20}, /* ed: 0110 0100 1110 1101 xxxx xxxx            */
	{NEI,"PT,%b",    3,20}, /* ee: 0110 0100 1110 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* ef: 0110 0100 1110 1111 xxxx xxxx            */

	{illegal,0, 	 3,20}, /* f0: 0110 0100 1111 0000 xxxx xxxx            */
	{SBI,"SMH,%b",   3,20}, /* f1: 0110 0100 1111 0001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* f2: 0110 0100 1111 0010 xxxx xxxx            */
	{SBI,"EOM,%b",   3,20}, /* f3: 0110 0100 1111 0011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* f4: 0110 0100 1111 0100 xxxx xxxx            */
	{SBI,"TMM,%b",   3,20}, /* f5: 0110 0100 1111 0101 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* f6: 0110 0100 1111 0110 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* f7: 0110 0100 1111 0111 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* f8: 0110 0100 1111 1000 xxxx xxxx            */
	{EQI,"SMH,%b",   3,20}, /* f9: 0110 0100 1111 1001 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* fa: 0110 0100 1111 1010 xxxx xxxx            */
	{EQI,"EOM,%b",   3,20}, /* fb: 0110 0100 1111 1011 xxxx xxxx            */
	{illegal,0, 	 3,20}, /* fc: 0110 0100 1111 1100 xxxx xxxx            */
	{EQI,"TMM,%b",   3,20}, /* fd: 0110 0100 1111 1101 xxxx xxxx            */
	{EQI,"PT,%b",    3,20}, /* fe: 0110 0100 1111 1110 xxxx xxxx            */
	{illegal,0, 	 3,20}	/* ff: 0110 0100 1111 1111 xxxx xxxx            */
};

/* prefix 70 */
static struct dasm_s  dasm70[256] =
{
	{illegal,0, 	 2, 8}, /* 00: 0111 0000 0000 0000                      */
	{illegal,0, 	 2, 8}, /* 01: 0111 0000 0000 0001                      */
	{illegal,0, 	 2, 8}, /* 02: 0111 0000 0000 0010                      */
	{illegal,0, 	 2, 8}, /* 03: 0111 0000 0000 0011                      */
	{illegal,0, 	 2, 8}, /* 04: 0111 0000 0000 0100                      */
	{illegal,0, 	 2, 8}, /* 05: 0111 0000 0000 0101                      */
	{illegal,0, 	 2, 8}, /* 06: 0111 0000 0000 0110                      */
	{illegal,0, 	 2, 8}, /* 07: 0111 0000 0000 0111                      */
	{illegal,0, 	 2, 8}, /* 08: 0111 0000 0000 1000                      */
	{illegal,0, 	 2, 8}, /* 09: 0111 0000 0000 1001                      */
	{illegal,0, 	 2, 8}, /* 0a: 0111 0000 0000 1010                      */
	{illegal,0, 	 2, 8}, /* 0b: 0111 0000 0000 1011                      */
	{illegal,0, 	 2, 8}, /* 0c: 0111 0000 0000 1100                      */
	{illegal,0, 	 2, 8}, /* 0d: 0111 0000 0000 1101                      */
	{SSPD,"%w",      4,20}, /* 0e: 0111 0000 0000 1110 llll llll hhhh hhhh  */
	{LSPD,"%w",      4,20}, /* 0f: 0111 0000 0000 1111 llll llll hhhh hhhh  */

	{illegal,0, 	 2, 8}, /* 10: 0111 0000 0001 0000                      */
	{illegal,0, 	 2, 8}, /* 11: 0111 0000 0001 0001                      */
	{illegal,0, 	 2, 8}, /* 12: 0111 0000 0001 0010                      */
	{illegal,0, 	 2, 8}, /* 13: 0111 0000 0001 0011                      */
	{illegal,0, 	 2, 8}, /* 14: 0111 0000 0001 0100                      */
	{illegal,0, 	 2, 8}, /* 15: 0111 0000 0001 0101                      */
	{illegal,0, 	 2, 8}, /* 16: 0111 0000 0001 0110                      */
	{illegal,0, 	 2, 8}, /* 17: 0111 0000 0001 0111                      */
	{illegal,0, 	 2, 8}, /* 18: 0111 0000 0001 1000                      */
	{illegal,0, 	 2, 8}, /* 19: 0111 0000 0001 1001                      */
	{illegal,0, 	 2, 8}, /* 1a: 0111 0000 0001 1010                      */
	{illegal,0, 	 2, 8}, /* 1b: 0111 0000 0001 1011                      */
	{illegal,0, 	 2, 8}, /* 1c: 0111 0000 0001 1100                      */
	{illegal,0, 	 2, 8}, /* 1d: 0111 0000 0001 1101                      */
	{SBCD,"%w",      4,20}, /* 1e: 0111 0000 0001 1110 llll llll hhhh hhhh  */
	{LBCD,"%w",      4,20}, /* 1f: 0111 0000 0001 1111 llll llll hhhh hhhh  */

	{illegal,0, 	 2, 8}, /* 20: 0111 0000 0010 0000                      */
	{illegal,0, 	 2, 8}, /* 21: 0111 0000 0010 0001                      */
	{illegal,0, 	 2, 8}, /* 22: 0111 0000 0010 0010                      */
	{illegal,0, 	 2, 8}, /* 23: 0111 0000 0010 0011                      */
	{illegal,0, 	 2, 8}, /* 24: 0111 0000 0010 0100                      */
	{illegal,0, 	 2, 8}, /* 25: 0111 0000 0010 0101                      */
	{illegal,0, 	 2, 8}, /* 26: 0111 0000 0010 0110                      */
	{illegal,0, 	 2, 8}, /* 27: 0111 0000 0010 0111                      */
	{illegal,0, 	 2, 8}, /* 28: 0111 0000 0010 1000                      */
	{illegal,0, 	 2, 8}, /* 29: 0111 0000 0010 1001                      */
	{illegal,0, 	 2, 8}, /* 2a: 0111 0000 0010 1010                      */
	{illegal,0, 	 2, 8}, /* 2b: 0111 0000 0010 1011                      */
	{illegal,0, 	 2, 8}, /* 2c: 0111 0000 0010 1100                      */
	{illegal,0, 	 2, 8}, /* 2d: 0111 0000 0010 1101                      */
	{SDED,"%w",      4,20}, /* 2e: 0111 0000 0010 1110 llll llll hhhh hhhh  */
	{LDED,"%w",      4,20}, /* 2f: 0111 0000 0010 1111 llll llll hhhh hhhh  */

	{illegal,0, 	 2, 8}, /* 30: 0111 0000 0011 0000                      */
	{illegal,0, 	 2, 8}, /* 31: 0111 0000 0011 0001                      */
	{illegal,0, 	 2, 8}, /* 32: 0111 0000 0011 0010                      */
	{illegal,0, 	 2, 8}, /* 33: 0111 0000 0011 0011                      */
	{illegal,0, 	 2, 8}, /* 34: 0111 0000 0011 0100                      */
	{illegal,0, 	 2, 8}, /* 35: 0111 0000 0011 0101                      */
	{illegal,0, 	 2, 8}, /* 36: 0111 0000 0011 0110                      */
	{illegal,0, 	 2, 8}, /* 37: 0111 0000 0011 0111                      */
	{illegal,0, 	 2, 8}, /* 38: 0111 0000 0011 1000                      */
	{illegal,0, 	 2, 8}, /* 39: 0111 0000 0011 1001                      */
	{illegal,0, 	 2, 8}, /* 3a: 0111 0000 0011 1010                      */
	{illegal,0, 	 2, 8}, /* 3b: 0111 0000 0011 1011                      */
	{illegal,0, 	 2, 8}, /* 3c: 0111 0000 0011 1100                      */
	{illegal,0, 	 2, 8}, /* 3d: 0111 0000 0011 1101                      */
	{SHLD,"%w",      4,20}, /* 3e: 0111 0000 0011 1110 llll llll hhhh hhhh  */
	{LHLD,"%w",      4,20}, /* 3f: 0111 0000 0011 1111 llll llll hhhh hhhh  */

	{EADD,"EA,V",    2,11}, /* 40: 0111 0000 0100 0000                      */
	{EADD,"EA,A",    2,11}, /* 41: 0111 0000 0100 0001                      */
	{EADD,"EA,B",    2,11}, /* 42: 0111 0000 0100 0010                      */
	{EADD,"EA,C",    2,11}, /* 43: 0111 0000 0100 0011                      */
	{illegal,0, 	 2, 8}, /* 44: 0111 0000 0100 0100                      */
	{illegal,0, 	 2, 8}, /* 45: 0111 0000 0100 0101                      */
	{illegal,0, 	 2, 8}, /* 46: 0111 0000 0100 0110                      */
	{illegal,0, 	 2, 8}, /* 47: 0111 0000 0100 0111                      */
	{illegal,0, 	 2, 8}, /* 48: 0111 0000 0100 1000                      */
	{illegal,0, 	 2, 8}, /* 49: 0111 0000 0100 1001                      */
	{illegal,0, 	 2, 8}, /* 4a: 0111 0000 0100 1010                      */
	{illegal,0, 	 2, 8}, /* 4b: 0111 0000 0100 1011                      */
	{illegal,0, 	 2, 8}, /* 4c: 0111 0000 0100 1100                      */
	{illegal,0, 	 2, 8}, /* 4d: 0111 0000 0100 1101                      */
	{illegal,0, 	 2, 8}, /* 4e: 0111 0000 0100 1110                      */
	{illegal,0, 	 2, 8}, /* 4f: 0111 0000 0100 1111                      */

	{illegal,0, 	 2, 8}, /* 50: 0111 0000 0101 0000                      */
	{illegal,0, 	 2, 8}, /* 51: 0111 0000 0101 0001                      */
	{illegal,0, 	 2, 8}, /* 52: 0111 0000 0101 0010                      */
	{illegal,0, 	 2, 8}, /* 53: 0111 0000 0101 0011                      */
	{illegal,0, 	 2, 8}, /* 54: 0111 0000 0101 0100                      */
	{illegal,0, 	 2, 8}, /* 55: 0111 0000 0101 0101                      */
	{illegal,0, 	 2, 8}, /* 56: 0111 0000 0101 0110                      */
	{illegal,0, 	 2, 8}, /* 57: 0111 0000 0101 0111                      */
	{illegal,0, 	 2, 8}, /* 58: 0111 0000 0101 1000                      */
	{illegal,0, 	 2, 8}, /* 59: 0111 0000 0101 1001                      */
	{illegal,0, 	 2, 8}, /* 5a: 0111 0000 0101 1010                      */
	{illegal,0, 	 2, 8}, /* 5b: 0111 0000 0101 1011                      */
	{illegal,0, 	 2, 8}, /* 5c: 0111 0000 0101 1100                      */
	{illegal,0, 	 2, 8}, /* 5d: 0111 0000 0101 1101                      */
	{illegal,0, 	 2, 8}, /* 5e: 0111 0000 0101 1110                      */
	{illegal,0, 	 2, 8}, /* 5f: 0111 0000 0101 1111                      */

	{ESUB,"EA,V",    2,11}, /* 60: 0111 0000 0110 0000                      */
	{ESUB,"EA,A",    2,11}, /* 61: 0111 0000 0110 0001                      */
	{ESUB,"EA,B",    2,11}, /* 62: 0111 0000 0110 0010                      */
	{ESUB,"EA,C",    2,11}, /* 63: 0111 0000 0110 0011                      */
	{illegal,0, 	 2, 8}, /* 64: 0111 0000 0110 0100                      */
	{illegal,0, 	 2, 8}, /* 65: 0111 0000 0110 0101                      */
	{illegal,0, 	 2, 8}, /* 66: 0111 0000 0110 0110                      */
	{illegal,0, 	 2, 8}, /* 67: 0111 0000 0110 0111                      */
	{MOV,"V,(%w)",   4,17}, /* 68: 0111 0000 0110 1000 llll llll hhhh hhhh  */
	{MOV,"A,(%w)",   4,17}, /* 69: 0111 0000 0110 1001 llll llll hhhh hhhh  */
	{MOV,"B,(%w)",   4,17}, /* 6a: 0111 0000 0110 1010 llll llll hhhh hhhh  */
	{MOV,"C,(%w)",   4,17}, /* 6b: 0111 0000 0110 1011 llll llll hhhh hhhh  */
	{MOV,"D,(%w)",   4,17}, /* 6c: 0111 0000 0110 1100 llll llll hhhh hhhh  */
	{MOV,"E,(%w)",   4,17}, /* 6d: 0111 0000 0110 1101 llll llll hhhh hhhh  */
	{MOV,"H,(%w)",   4,17}, /* 6e: 0111 0000 0110 1110 llll llll hhhh hhhh  */
	{MOV,"L,(%w)",   4,17}, /* 6f: 0111 0000 0110 1111 llll llll hhhh hhhh  */

	{illegal,0, 	 2, 8}, /* 70: 0111 0000 0111 0000                      */
	{illegal,0, 	 2, 8}, /* 71: 0111 0000 0111 0001                      */
	{illegal,0, 	 2, 8}, /* 72: 0111 0000 0111 0010                      */
	{illegal,0, 	 2, 8}, /* 73: 0111 0000 0111 0011                      */
	{illegal,0, 	 2, 8}, /* 74: 0111 0000 0111 0100                      */
	{illegal,0, 	 2, 8}, /* 75: 0111 0000 0111 0101                      */
	{illegal,0, 	 2, 8}, /* 76: 0111 0000 0111 0110                      */
	{illegal,0, 	 2, 8}, /* 77: 0111 0000 0111 0111                      */
	{MOV,"(%w),V",   4,17}, /* 78: 0111 0000 0111 1000 llll llll hhhh hhhh  */
	{MOV,"(%w),A",   4,17}, /* 79: 0111 0000 0111 1001 llll llll hhhh hhhh  */
	{MOV,"(%w),B",   4,17}, /* 7a: 0111 0000 0111 1010 llll llll hhhh hhhh  */
	{MOV,"(%w),C",   4,17}, /* 7b: 0111 0000 0111 1011 llll llll hhhh hhhh  */
	{MOV,"(%w),D",   4,17}, /* 7c: 0111 0000 0111 1100 llll llll hhhh hhhh  */
	{MOV,"(%w),E",   4,17}, /* 7d: 0111 0000 0111 1101 llll llll hhhh hhhh  */
	{MOV,"(%w),H",   4,17}, /* 7e: 0111 0000 0111 1110 llll llll hhhh hhhh  */
	{MOV,"(%w),L",   4,17}, /* 7f: 0111 0000 0111 1111 llll llll hhhh hhhh  */

	{illegal,0, 	 2, 8}, /* 80: 0111 0000 1000 0000                      */
	{illegal,0, 	 2, 8}, /* 81: 0111 0000 1000 0001                      */
	{illegal,0, 	 2, 8}, /* 82: 0111 0000 1000 0010                      */
	{illegal,0, 	 2, 8}, /* 83: 0111 0000 1000 0011                      */
	{illegal,0, 	 2, 8}, /* 84: 0111 0000 1000 0100                      */
	{illegal,0, 	 2, 8}, /* 85: 0111 0000 1000 0101                      */
	{illegal,0, 	 2, 8}, /* 86: 0111 0000 1000 0110                      */
	{illegal,0, 	 2, 8}, /* 87: 0111 0000 1000 0111                      */
	{illegal,0, 	 2,11}, /* 88: 0111 0000 1000 1000                      */
	{ANAX,"(BC)",    2,11}, /* 89: 0111 0000 1000 1001                      */
	{ANAX,"(DE)",    2,11}, /* 8a: 0111 0000 1000 1010                      */
	{ANAX,"(HL)",    2,11}, /* 8b: 0111 0000 1000 1011                      */
	{ANAX,"(DE+)",   2,11}, /* 8c: 0111 0000 1000 1100                      */
	{ANAX,"(HL+)",   2,11}, /* 8d: 0111 0000 1000 1101                      */
	{ANAX,"(DE-)",   2,11}, /* 8e: 0111 0000 1000 1110                      */
	{ANAX,"(HL-)",   2,11}, /* 8f: 0111 0000 1000 1111                      */

	{illegal,0, 	 2,11}, /* 90: 0111 0000 1001 0000                      */
	{XRAX,"(BC)",    2,11}, /* 91: 0111 0000 1001 0001                      */
	{XRAX,"(DE)",    2,11}, /* 92: 0111 0000 1001 0010                      */
	{XRAX,"(HL)",    2,11}, /* 93: 0111 0000 1001 0011                      */
	{XRAX,"(DE+)",   2,11}, /* 94: 0111 0000 1001 0100                      */
	{XRAX,"(HL+)",   2,11}, /* 95: 0111 0000 1001 0101                      */
	{XRAX,"(DE-)",   2,11}, /* 96: 0111 0000 1001 0110                      */
	{XRAX,"(HL-)",   2,11}, /* 97: 0111 0000 1001 0111                      */
	{illegal,0, 	 2, 8}, /* 98: 0111 0000 1001 1000                      */
	{ORAX,"(BC)", 	 2, 8}, /* 99: 0111 0000 1001 1001                      */
	{ORAX,"(DE)", 	 2, 8}, /* 9a: 0111 0000 1001 1010                      */
	{ORAX,"(HL)", 	 2, 8}, /* 9b: 0111 0000 1001 1011                      */
	{ORAX,"(DE+)", 	 2, 8}, /* 9c: 0111 0000 1001 1100                      */
	{ORAX,"(HL+)", 	 2, 8}, /* 9d: 0111 0000 1001 1101                      */
	{ORAX,"(DE-)", 	 2, 8}, /* 9e: 0111 0000 1001 1110                      */
	{ORAX,"(HL-)", 	 2, 8}, /* 9f: 0111 0000 1001 1111                      */

	{illegal,0, 	 2,11}, /* a0: 0111 0000 1010 0000                      */
	{ADDNCX,"(BC)",  2,11}, /* a1: 0111 0000 1010 0001                      */
	{ADDNCX,"(DE)",  2,11}, /* a2: 0111 0000 1010 0010                      */
	{ADDNCX,"(HL)",  2,11}, /* a3: 0111 0000 1010 0011                      */
	{ADDNCX,"(DE+)", 2,11}, /* a4: 0111 0000 1010 0100                      */
	{ADDNCX,"(HL+)", 2,11}, /* a5: 0111 0000 1010 0101                      */
	{ADDNCX,"(DE-)", 2,11}, /* a6: 0111 0000 1010 0110                      */
	{ADDNCX,"(HL-)", 2,11}, /* a7: 0111 0000 1010 0111                      */
	{illegal,0, 	 2,11}, /* a8: 0111 0000 1010 1000                      */
	{GTAX,"(BC)",    2,11}, /* a9: 0111 0000 1010 1001                      */
	{GTAX,"(DE)",    2,11}, /* aa: 0111 0000 1010 1010                      */
	{GTAX,"(HL)",    2,11}, /* ab: 0111 0000 1010 1011                      */
	{GTAX,"(DE+)",   2,11}, /* ac: 0111 0000 1010 1100                      */
	{GTAX,"(HL+)",   2,11}, /* ad: 0111 0000 1010 1101                      */
	{GTAX,"(DE-)",   2,11}, /* ae: 0111 0000 1010 1110                      */
	{GTAX,"(HL-)",   2,11}, /* af: 0111 0000 1010 1111                      */

	{illegal,0, 	 2,11}, /* b0: 0111 0000 1011 0000                      */
	{SUBNBX,"(BC)",  2,11}, /* b1: 0111 0000 1011 0001                      */
	{SUBNBX,"(DE)",  2,11}, /* b2: 0111 0000 1011 0010                      */
	{SUBNBX,"(HL)",  2,11}, /* b3: 0111 0000 1011 0011                      */
	{SUBNBX,"(DE+)", 2,11}, /* b4: 0111 0000 1011 0100                      */
	{SUBNBX,"(HL+)", 2,11}, /* b5: 0111 0000 1011 0101                      */
	{SUBNBX,"(DE-)", 2,11}, /* b6: 0111 0000 1011 0110                      */
	{SUBNBX,"(HL-)", 2,11}, /* b7: 0111 0000 1011 0111                      */
	{illegal,0, 	 2,11}, /* b8: 0111 0000 1011 1000                      */
	{LTAX,"(BC)",    2,11}, /* b9: 0111 0000 1011 1001                      */
	{LTAX,"(DE)",    2,11}, /* ba: 0111 0000 1011 1010                      */
	{LTAX,"(HL)",    2,11}, /* bb: 0111 0000 1011 1011                      */
	{LTAX,"(DE+)",   2,11}, /* bc: 0111 0000 1011 1100                      */
	{LTAX,"(HL+)",   2,11}, /* bd: 0111 0000 1011 1101                      */
	{LTAX,"(DE-)",   2,11}, /* be: 0111 0000 1011 1110                      */
	{LTAX,"(HL-)",   2,11}, /* bf: 0111 0000 1011 1111                      */

	{illegal,0, 	 2,11}, /* c0: 0111 0000 1100 0000                      */
	{ADDX,"(BC)",    2,11}, /* c1: 0111 0000 1100 0001                      */
	{ADDX,"(DE)",    2,11}, /* c2: 0111 0000 1100 0010                      */
	{ADDX,"(HL)",    2,11}, /* c3: 0111 0000 1100 0011                      */
	{ADDX,"(DE+)",   2,11}, /* c4: 0111 0000 1100 0100                      */
	{ADDX,"(HL+)",   2,11}, /* c5: 0111 0000 1100 0101                      */
	{ADDX,"(DE-)",   2,11}, /* c6: 0111 0000 1100 0110                      */
	{ADDX,"(HL-)",   2,11}, /* c7: 0111 0000 1100 0111                      */
	{illegal,0, 	 2,11}, /* c8: 0111 0000 1100 1000                      */
	{ONAX,"(BC)",    2,11}, /* c9: 0111 0000 1100 1001                      */
	{ONAX,"(DE)",    2,11}, /* ca: 0111 0000 1100 1010                      */
	{ONAX,"(HL)",    2,11}, /* cb: 0111 0000 1100 1011                      */
	{ONAX,"(DE+)",   2,11}, /* cc: 0111 0000 1100 1100                      */
	{ONAX,"(HL+)",   2,11}, /* cd: 0111 0000 1100 1101                      */
	{ONAX,"(DE-)",   2,11}, /* ce: 0111 0000 1100 1110                      */
	{ONAX,"(HL-)",   2,11}, /* cf: 0111 0000 1100 1111                      */

	{illegal,0, 	 2,11}, /* d0: 0111 0000 1101 0000                      */
	{ADCX,"(BC)",    2,11}, /* d1: 0111 0000 1101 0001                      */
	{ADCX,"(DE)",    2,11}, /* d2: 0111 0000 1101 0010                      */
	{ADCX,"(HL)",    2,11}, /* d3: 0111 0000 1101 0011                      */
	{ADCX,"(DE+)",   2,11}, /* d4: 0111 0000 1101 0100                      */
	{ADCX,"(HL+)",   2,11}, /* d5: 0111 0000 1101 0101                      */
	{ADCX,"(DE-)",   2,11}, /* d6: 0111 0000 1101 0110                      */
	{ADCX,"(HL-)",   2,11}, /* d7: 0111 0000 1101 0111                      */
	{illegal,0, 	 2,11}, /* d8: 0111 0000 1101 1000                      */
	{OFFAX,"(BC)",   2,11}, /* d9: 0111 0000 1101 1001                      */
	{OFFAX,"(DE)",   2,11}, /* da: 0111 0000 1101 1010                      */
	{OFFAX,"(HL)",   2,11}, /* db: 0111 0000 1101 1011                      */
	{OFFAX,"(DE+)",  2,11}, /* dc: 0111 0000 1101 1100                      */
	{OFFAX,"(HL+)",  2,11}, /* dd: 0111 0000 1101 1101                      */
	{OFFAX,"(DE-)",  2,11}, /* de: 0111 0000 1101 1110                      */
	{OFFAX,"(HL-)",  2,11}, /* df: 0111 0000 1101 1111                      */

	{illegal,0, 	 2,11}, /* e0: 0111 0000 1110 0000                      */
	{SUBX,"(BC)",    2,11}, /* e1: 0111 0000 1110 0001                      */
	{SUBX,"(DE)",    2,11}, /* e2: 0111 0000 1110 0010                      */
	{SUBX,"(HL)",    2,11}, /* e3: 0111 0000 1110 0011                      */
	{SUBX,"(DE+)",   2,11}, /* e4: 0111 0000 1110 0100                      */
	{SUBX,"(HL+)",   2,11}, /* e5: 0111 0000 1110 0101                      */
	{SUBX,"(DE-)",   2,11}, /* e6: 0111 0000 1110 0110                      */
	{SUBX,"(HL-)",   2,11}, /* e7: 0111 0000 1110 0111                      */
	{illegal,0, 	 2,11}, /* e8: 0111 0000 1110 1000                      */
	{NEAX,"(BC)",    2,11}, /* e9: 0111 0000 1110 1001                      */
	{NEAX,"(DE)",    2,11}, /* ea: 0111 0000 1110 1010                      */
	{NEAX,"(HL)",    2,11}, /* eb: 0111 0000 1110 1011                      */
	{NEAX,"(DE+)",   2,11}, /* ec: 0111 0000 1110 1100                      */
	{NEAX,"(HL+)",   2,11}, /* ed: 0111 0000 1110 1101                      */
	{NEAX,"(DE-)",   2,11}, /* ee: 0111 0000 1110 1110                      */
	{NEAX,"(HL-)",   2,11}, /* ef: 0111 0000 1110 1111                      */

	{illegal,0, 	 2,11}, /* f0: 0111 0000 1111 0000                      */
	{SBBX,"(BC)",    2,11}, /* f1: 0111 0000 1111 0001                      */
	{SBBX,"(DE)",    2,11}, /* f2: 0111 0000 1111 0010                      */
	{SBBX,"(HL)",    2,11}, /* f3: 0111 0000 1111 0011                      */
	{SBBX,"(DE+)",   2,11}, /* f4: 0111 0000 1111 0100                      */
	{SBBX,"(HL+)",   2,11}, /* f5: 0111 0000 1111 0101                      */
	{SBBX,"(DE-)",   2,11}, /* f6: 0111 0000 1111 0110                      */
	{SBBX,"(HL-)",   2,11}, /* f7: 0111 0000 1111 0111                      */
	{illegal,0, 	 2,11}, /* f8: 0111 0000 1111 1000                      */
	{EQAX,"(BC)",    2,11}, /* f9: 0111 0000 1111 1001                      */
	{EQAX,"(DE)",    2,11}, /* fa: 0111 0000 1111 1010                      */
	{EQAX,"(HL)",    2,11}, /* fb: 0111 0000 1111 1011                      */
	{EQAX,"(DE+)",   2,11}, /* fc: 0111 0000 1111 1100                      */
	{EQAX,"(HL+)",   2,11}, /* fd: 0111 0000 1111 1101                      */
	{EQAX,"(DE-)",   2,11}, /* fe: 0111 0000 1111 1110                      */
	{EQAX,"(HL-)",   2,11}  /* ff: 0111 0000 1111 1111                      */
};

/* prefix 74 */
static struct dasm_s  dasm74[256] =
{
	{illegal,0, 	 2, 8}, /* 00: 0111 0100 0000 0000                      */
	{illegal,0, 	 2, 8}, /* 01: 0111 0100 0000 0001                      */
	{illegal,0, 	 2, 8}, /* 02: 0111 0100 0000 0010                      */
	{illegal,0, 	 2, 8}, /* 03: 0111 0100 0000 0011                      */
	{illegal,0, 	 2, 8}, /* 04: 0111 0100 0000 0100                      */
	{illegal,0, 	 2, 8}, /* 05: 0111 0100 0000 0101                      */
	{illegal,0, 	 2, 8}, /* 06: 0111 0100 0000 0110                      */
	{illegal,0, 	 2, 8}, /* 07: 0111 0100 0000 0111                      */
	{ANI,"V,%b",     3,11}, /* 08: 0111 0100 0000 1000 xxxx xxxx            */
	{ANI,"A,%b",     3,11}, /* 09: 0111 0100 0000 1001 xxxx xxxx            */
	{ANI,"B,%b",     3,11}, /* 0a: 0111 0100 0000 1010 xxxx xxxx            */
	{ANI,"C,%b",     3,11}, /* 0b: 0111 0100 0000 1011 xxxx xxxx            */
	{ANI,"D,%b",     3,11}, /* 0c: 0111 0100 0000 1100 xxxx xxxx            */
	{ANI,"E,%b",     3,11}, /* 0d: 0111 0100 0000 1101 xxxx xxxx            */
	{ANI,"H,%b",     3,11}, /* 0e: 0111 0100 0000 1110 xxxx xxxx            */
	{ANI,"L,%b",     3,11}, /* 0f: 0111 0100 0000 1111 xxxx xxxx            */

	{XRI,"V,%b",     3,11}, /* 10: 0111 0100 0001 0000 xxxx xxxx            */
	{XRI,"A,%b",     3,11}, /* 11: 0111 0100 0001 0001 xxxx xxxx            */
	{XRI,"B,%b",     3,11}, /* 12: 0111 0100 0001 0010 xxxx xxxx            */
	{XRI,"C,%b",     3,11}, /* 13: 0111 0100 0001 0011 xxxx xxxx            */
	{XRI,"D,%b",     3,11}, /* 14: 0111 0100 0001 0100 xxxx xxxx            */
	{XRI,"E,%b",     3,11}, /* 15: 0111 0100 0001 0101 xxxx xxxx            */
	{XRI,"H,%b",     3,11}, /* 16: 0111 0100 0001 0110 xxxx xxxx            */
	{XRI,"L,%b",     3,11}, /* 17: 0111 0100 0001 0111 xxxx xxxx            */
	{ORI,"V,%b",     3,11}, /* 18: 0111 0100 0001 1000 xxxx xxxx            */
	{ORI,"A,%b",     3,11}, /* 19: 0111 0100 0001 1001 xxxx xxxx            */
	{ORI,"B,%b",     3,11}, /* 1a: 0111 0100 0001 1010 xxxx xxxx            */
	{ORI,"C,%b",     3,11}, /* 1b: 0111 0100 0001 1011 xxxx xxxx            */
	{ORI,"D,%b",     3,11}, /* 1c: 0111 0100 0001 1100 xxxx xxxx            */
	{ORI,"E,%b",     3,11}, /* 1d: 0111 0100 0001 1101 xxxx xxxx            */
	{ORI,"H,%b",     3,11}, /* 1e: 0111 0100 0001 1110 xxxx xxxx            */
	{ORI,"L,%b",     3,11}, /* 1f: 0111 0100 0001 1111 xxxx xxxx            */

	{ADINC,"V,%b",   3,11}, /* 20: 0111 0100 0010 0000 xxxx xxxx            */
	{ADINC,"A,%b",   3,11}, /* 21: 0111 0100 0010 0001 xxxx xxxx            */
	{ADINC,"B,%b",   3,11}, /* 22: 0111 0100 0010 0010 xxxx xxxx            */
	{ADINC,"C,%b",   3,11}, /* 23: 0111 0100 0010 0011 xxxx xxxx            */
	{ADINC,"D,%b",   3,11}, /* 24: 0111 0100 0010 0100 xxxx xxxx            */
	{ADINC,"E,%b",   3,11}, /* 25: 0111 0100 0010 0101 xxxx xxxx            */
	{ADINC,"H,%b",   3,11}, /* 26: 0111 0100 0010 0110 xxxx xxxx            */
	{ADINC,"L,%b",   3,11}, /* 27: 0111 0100 0010 0111 xxxx xxxx            */
	{GTI,"V,%b",     3,11}, /* 28: 0111 0100 0010 1000 xxxx xxxx            */
	{GTI,"A,%b",     3,11}, /* 29: 0111 0100 0010 1001 xxxx xxxx            */
	{GTI,"B,%b",     3,11}, /* 2a: 0111 0100 0010 1010 xxxx xxxx            */
	{GTI,"C,%b",     3,11}, /* 2b: 0111 0100 0010 1011 xxxx xxxx            */
	{GTI,"D,%b",     3,11}, /* 2c: 0111 0100 0010 1100 xxxx xxxx            */
	{GTI,"E,%b",     3,11}, /* 2d: 0111 0100 0010 1101 xxxx xxxx            */
	{GTI,"H,%b",     3,11}, /* 2e: 0111 0100 0010 1110 xxxx xxxx            */
	{GTI,"L,%b",     3,11}, /* 2f: 0111 0100 0010 1111 xxxx xxxx            */

	{SUINB,"V,%b",   3,11}, /* 30: 0111 0100 0011 0000 xxxx xxxx            */
	{SUINB,"A,%b",   3,11}, /* 31: 0111 0100 0011 0001 xxxx xxxx            */
	{SUINB,"B,%b",   3,11}, /* 32: 0111 0100 0011 0010 xxxx xxxx            */
	{SUINB,"C,%b",   3,11}, /* 33: 0111 0100 0011 0011 xxxx xxxx            */
	{SUINB,"D,%b",   3,11}, /* 34: 0111 0100 0011 0100 xxxx xxxx            */
	{SUINB,"E,%b",   3,11}, /* 35: 0111 0100 0011 0101 xxxx xxxx            */
	{SUINB,"H,%b",   3,11}, /* 36: 0111 0100 0011 0110 xxxx xxxx            */
	{SUINB,"L,%b",   3,11}, /* 37: 0111 0100 0011 0111 xxxx xxxx            */
	{LTI,"V,%b",     3,11}, /* 38: 0111 0100 0011 1000 xxxx xxxx            */
	{LTI,"A,%b",     3,11}, /* 39: 0111 0100 0011 1001 xxxx xxxx            */
	{LTI,"B,%b",     3,11}, /* 3a: 0111 0100 0011 1010 xxxx xxxx            */
	{LTI,"C,%b",     3,11}, /* 3b: 0111 0100 0011 1011 xxxx xxxx            */
	{LTI,"D,%b",     3,11}, /* 3c: 0111 0100 0011 1100 xxxx xxxx            */
	{LTI,"E,%b",     3,11}, /* 3d: 0111 0100 0011 1101 xxxx xxxx            */
	{LTI,"H,%b",     3,11}, /* 3e: 0111 0100 0011 1110 xxxx xxxx            */
	{LTI,"L,%b",     3,11}, /* 3f: 0111 0100 0011 1111 xxxx xxxx            */

	{ADI,"V,%b",     3,11}, /* 40: 0111 0100 0100 0000 xxxx xxxx            */
	{ADI,"A,%b",     3,11}, /* 41: 0111 0100 0100 0001 xxxx xxxx            */
	{ADI,"B,%b",     3,11}, /* 42: 0111 0100 0100 0010 xxxx xxxx            */
	{ADI,"C,%b",     3,11}, /* 43: 0111 0100 0100 0011 xxxx xxxx            */
	{ADI,"D,%b",     3,11}, /* 44: 0111 0100 0100 0100 xxxx xxxx            */
	{ADI,"E,%b",     3,11}, /* 45: 0111 0100 0100 0101 xxxx xxxx            */
	{ADI,"H,%b",     3,11}, /* 46: 0111 0100 0100 0110 xxxx xxxx            */
	{ADI,"L,%b",     3,11}, /* 47: 0111 0100 0100 0111 xxxx xxxx            */
	{ONI,"V,%b",     3,11}, /* 48: 0111 0100 0100 1000 xxxx xxxx            */
	{ONI,"A,%b",     3,11}, /* 49: 0111 0100 0100 1001 xxxx xxxx            */
	{ONI,"B,%b",     3,11}, /* 4a: 0111 0100 0100 1010 xxxx xxxx            */
	{ONI,"C,%b",     3,11}, /* 4b: 0111 0100 0100 1011 xxxx xxxx            */
	{ONI,"D,%b",     3,11}, /* 4c: 0111 0100 0100 1100 xxxx xxxx            */
	{ONI,"E,%b",     3,11}, /* 4d: 0111 0100 0100 1101 xxxx xxxx            */
	{ONI,"H,%b",     3,11}, /* 4e: 0111 0100 0100 1110 xxxx xxxx            */
	{ONI,"L,%b",     3,11}, /* 4f: 0111 0100 0100 1111 xxxx xxxx            */

	{ACI,"V,%b",     3,11}, /* 50: 0111 0100 0101 0000 xxxx xxxx            */
	{ACI,"A,%b",     3,11}, /* 51: 0111 0100 0101 0001 xxxx xxxx            */
	{ACI,"B,%b",     3,11}, /* 52: 0111 0100 0101 0010 xxxx xxxx            */
	{ACI,"C,%b",     3,11}, /* 53: 0111 0100 0101 0011 xxxx xxxx            */
	{ACI,"D,%b",     3,11}, /* 54: 0111 0100 0101 0100 xxxx xxxx            */
	{ACI,"E,%b",     3,11}, /* 55: 0111 0100 0101 0101 xxxx xxxx            */
	{ACI,"H,%b",     3,11}, /* 56: 0111 0100 0101 0110 xxxx xxxx            */
	{ACI,"L,%b",     3,11}, /* 57: 0111 0100 0101 0111 xxxx xxxx            */
	{OFFI,"V,%b",    3,11}, /* 58: 0111 0100 0101 1000 xxxx xxxx            */
	{OFFI,"A,%b",    3,11}, /* 59: 0111 0100 0101 1001 xxxx xxxx            */
	{OFFI,"B,%b",    3,11}, /* 5a: 0111 0100 0101 1010 xxxx xxxx            */
	{OFFI,"C,%b",    3,11}, /* 5b: 0111 0100 0101 1011 xxxx xxxx            */
	{OFFI,"D,%b",    3,11}, /* 5c: 0111 0100 0101 1100 xxxx xxxx            */
	{OFFI,"E,%b",    3,11}, /* 5d: 0111 0100 0101 1101 xxxx xxxx            */
	{OFFI,"H,%b",    3,11}, /* 5e: 0111 0100 0101 1110 xxxx xxxx            */
	{OFFI,"L,%b",    3,11}, /* 5f: 0111 0100 0101 1111 xxxx xxxx            */

	{SUI,"V,%b",     3,11}, /* 60: 0111 0100 0110 0000 xxxx xxxx            */
	{SUI,"A,%b",     3,11}, /* 61: 0111 0100 0110 0001 xxxx xxxx            */
	{SUI,"B,%b",     3,11}, /* 62: 0111 0100 0110 0010 xxxx xxxx            */
	{SUI,"C,%b",     3,11}, /* 63: 0111 0100 0110 0011 xxxx xxxx            */
	{SUI,"D,%b",     3,11}, /* 64: 0111 0100 0110 0100 xxxx xxxx            */
	{SUI,"E,%b",     3,11}, /* 65: 0111 0100 0110 0101 xxxx xxxx            */
	{SUI,"H,%b",     3,11}, /* 66: 0111 0100 0110 0110 xxxx xxxx            */
	{SUI,"L,%b",     3,11}, /* 67: 0111 0100 0110 0111 xxxx xxxx            */
	{NEI,"V,%b",     3,11}, /* 68: 0111 0100 0110 1000 xxxx xxxx            */
	{NEI,"A,%b",     3,11}, /* 69: 0111 0100 0110 1001 xxxx xxxx            */
	{NEI,"B,%b",     3,11}, /* 6a: 0111 0100 0110 1010 xxxx xxxx            */
	{NEI,"C,%b",     3,11}, /* 6b: 0111 0100 0110 1011 xxxx xxxx            */
	{NEI,"D,%b",     3,11}, /* 6c: 0111 0100 0110 1100 xxxx xxxx            */
	{NEI,"E,%b",     3,11}, /* 6d: 0111 0100 0110 1101 xxxx xxxx            */
	{NEI,"H,%b",     3,11}, /* 6e: 0111 0100 0110 1110 xxxx xxxx            */
	{NEI,"L,%b",     3,11}, /* 6f: 0111 0100 0110 1111 xxxx xxxx            */

	{SBI,"V,%b",     3,11}, /* 70: 0111 0100 0111 0000 xxxx xxxx            */
	{SBI,"A,%b",     3,11}, /* 71: 0111 0100 0111 0001 xxxx xxxx            */
	{SBI,"B,%b",     3,11}, /* 72: 0111 0100 0111 0010 xxxx xxxx            */
	{SBI,"C,%b",     3,11}, /* 73: 0111 0100 0111 0011 xxxx xxxx            */
	{SBI,"D,%b",     3,11}, /* 74: 0111 0100 0111 0100 xxxx xxxx            */
	{SBI,"E,%b",     3,11}, /* 75: 0111 0100 0111 0101 xxxx xxxx            */
	{SBI,"H,%b",     3,11}, /* 76: 0111 0100 0111 0110 xxxx xxxx            */
	{SBI,"L,%b",     3,11}, /* 77: 0111 0100 0111 0111 xxxx xxxx            */
	{EQI,"V,%b",     3,11}, /* 78: 0111 0100 0111 1000 xxxx xxxx            */
	{EQI,"A,%b",     3,11}, /* 79: 0111 0100 0111 1001 xxxx xxxx            */
	{EQI,"B,%b",     3,11}, /* 7a: 0111 0100 0111 1010 xxxx xxxx            */
	{EQI,"C,%b",     3,11}, /* 7b: 0111 0100 0111 1011 xxxx xxxx            */
	{EQI,"D,%b",     3,11}, /* 7c: 0111 0100 0111 1100 xxxx xxxx            */
	{EQI,"E,%b",     3,11}, /* 7d: 0111 0100 0111 1101 xxxx xxxx            */
	{EQI,"H,%b",     3,11}, /* 7e: 0111 0100 0111 1110 xxxx xxxx            */
	{EQI,"L,%b",     3,11}, /* 7f: 0111 0100 0111 1111 xxxx xxxx            */

	{illegal,0, 	 2, 8}, /* 80: 0111 0100 1000 0000                      */
	{illegal,0, 	 2, 8}, /* 81: 0111 0100 1000 0001                      */
	{illegal,0, 	 2, 8}, /* 82: 0111 0100 1000 0010                      */
	{illegal,0, 	 2, 8}, /* 83: 0111 0100 1000 0011                      */
	{illegal,0, 	 2, 8}, /* 84: 0111 0100 1000 0100                      */
	{illegal,0, 	 2, 8}, /* 85: 0111 0100 1000 0101                      */
	{illegal,0, 	 2, 8}, /* 86: 0111 0100 1000 0110                      */
	{illegal,0, 	 2, 8}, /* 87: 0111 0100 1000 0111                      */
	{ANAW,"%a",      3,14}, /* 88: 0111 0100 1000 1000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* 89: 0111 0100 1000 1001                      */
	{illegal,0, 	 2, 8}, /* 8a: 0111 0100 1000 1010                      */
	{illegal,0, 	 2, 8}, /* 8b: 0111 0100 1000 1011                      */
	{illegal,0, 	 2, 8}, /* 8c: 0111 0100 1000 1100                      */
	{DAN,"EA,BC",    2,11}, /* 8d: 0111 0100 1000 1101                      */
	{DAN,"EA,DE",    2,11}, /* 8e: 0111 0100 1000 1110                      */
	{DAN,"EA,HL",    2,11}, /* 8f: 0111 0100 1000 1111                      */

	{XRAW,"%a",      3,14}, /* 90: 0111 0100 1001 0000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* 91: 0111 0100 1001 0001                      */
	{illegal,0, 	 2, 8}, /* 92: 0111 0100 1001 0010                      */
	{illegal,0, 	 2, 8}, /* 93: 0111 0100 1001 0011                      */
	{illegal,0, 	 2, 8}, /* 94: 0111 0100 1001 0100                      */
	{DXR,"EA,BC",    2,11}, /* 95: 0111 0100 1001 0101                      */
	{DXR,"EA,DE",    2,11}, /* 96: 0111 0100 1001 0110                      */
	{DXR,"EA,HL",    2,11}, /* 97: 0111 0100 1001 0111                      */
	{ORAW,"%a",      3,14}, /* 98: 0111 0100 1001 1000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* 99: 0111 0100 1001 1001                      */
	{illegal,0, 	 2, 8}, /* 9a: 0111 0100 1001 1010                      */
	{illegal,0, 	 2, 8}, /* 9b: 0111 0100 1001 1011                      */
	{illegal,0, 	 2, 8}, /* 9c: 0111 0100 1001 1100                      */
	{DOR,"EA,BC",    2,11}, /* 9d: 0111 0100 1001 1101                      */
	{DOR,"EA,DE",    2,11}, /* 9e: 0111 0100 1001 1110                      */
	{DOR,"EA,HL",    2,11}, /* 9f: 0111 0100 1001 1111                      */

	{ADDNCW,"%a",    3,14}, /* a0: 0111 0100 1010 0000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* a1: 0111 0100 1010 0001                      */
	{illegal,0, 	 2, 8}, /* a2: 0111 0100 1010 0010                      */
	{illegal,0, 	 2, 8}, /* a3: 0111 0100 1010 0011                      */
	{illegal,0, 	 2, 8}, /* a4: 0111 0100 1010 0100                      */
	{DADDNC,"EA,BC", 2,11}, /* a5: 0111 0100 1010 0101                      */
	{DADDNC,"EA,DE", 2,11}, /* a6: 0111 0100 1010 0110                      */
	{DADDNC,"EA,HL", 2,11}, /* a7: 0111 0100 1010 0111                      */
	{GTAW,"%a",      3,14}, /* a8: 0111 0100 1010 1000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* a9: 0111 0100 1010 1001                      */
	{illegal,0, 	 2, 8}, /* aa: 0111 0100 1010 1010                      */
	{illegal,0, 	 2, 8}, /* ab: 0111 0100 1010 1011                      */
	{illegal,0, 	 2, 8}, /* ac: 0111 0100 1010 1100                      */
	{DGT,"EA,BC",    2,11}, /* ad: 0111 0100 1010 1101                      */
	{DGT,"EA,DE",    2,11}, /* ae: 0111 0100 1010 1110                      */
	{DGT,"EA,HL",    2,11}, /* af: 0111 0100 1010 1111                      */

	{SUBNBW,"%a",    3,14}, /* b0: 0111 0100 1011 0000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* b1: 0111 0100 1011 0001                      */
	{illegal,0, 	 2, 8}, /* b2: 0111 0100 1011 0010                      */
	{illegal,0, 	 2, 8}, /* b3: 0111 0100 1011 0011                      */
	{illegal,0, 	 2, 8}, /* b4: 0111 0100 1011 0100                      */
	{DSUBNB,"EA,BC", 2,11}, /* b5: 0111 0100 1011 0101                      */
	{DSUBNB,"EA,DE", 2,11}, /* b6: 0111 0100 1011 0110                      */
	{DSUBNB,"EA,HL", 2,11}, /* b7: 0111 0100 1011 0111                      */
	{LTAW,"%a",      3,14}, /* b8: 0111 0100 1011 1000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* b9: 0111 0100 1011 1001                      */
	{illegal,0, 	 2, 8}, /* ba: 0111 0100 1011 1010                      */
	{illegal,0, 	 2, 8}, /* bb: 0111 0100 1011 1011                      */
	{illegal,0, 	 2, 8}, /* bc: 0111 0100 1011 1100                      */
	{DLT,"EA,BC",    2,11}, /* bd: 0111 0100 1011 1101                      */
	{DLT,"EA,DE",    2,11}, /* be: 0111 0100 1011 1110                      */
	{DLT,"EA,HL",    2,11}, /* bf: 0111 0100 1011 1111                      */

	{ADDW,"%a",      3,14}, /* c0: 0111 0100 1100 0000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* c1: 0111 0100 1100 0001                      */
	{illegal,0, 	 2, 8}, /* c2: 0111 0100 1100 0010                      */
	{illegal,0, 	 2, 8}, /* c3: 0111 0100 1100 0011                      */
	{illegal,0, 	 2, 8}, /* c4: 0111 0100 1100 0100                      */
	{DADD,"EA,BC",   2,11}, /* c5: 0111 0100 1100 0101                      */
	{DADD,"EA,DE",   2,11}, /* c6: 0111 0100 1100 0110                      */
	{DADD,"EA,HL",   2,11}, /* c7: 0111 0100 1100 0111                      */
	{ONAW,"%a",      3,14}, /* c8: 0111 0100 1100 1000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* c9: 0111 0100 1100 1001                      */
	{illegal,0, 	 2, 8}, /* ca: 0111 0100 1100 1010                      */
	{illegal,0, 	 2, 8}, /* cb: 0111 0100 1100 1011                      */
	{illegal,0, 	 2, 8}, /* cc: 0111 0100 1100 1100                      */
	{DON,"EA,BC",    2,11}, /* cd: 0111 0100 1100 1101                      */
	{DON,"EA,DE",    2,11}, /* ce: 0111 0100 1100 1110                      */
	{DON,"EA,HL",    2,11}, /* cf: 0111 0100 1100 1111                      */

	{ADCW,"%a",      3,14}, /* d0: 0111 0100 1101 0000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* d1: 0111 0100 1101 0001                      */
	{illegal,0, 	 2, 8}, /* d2: 0111 0100 1101 0010                      */
	{illegal,0, 	 2, 8}, /* d3: 0111 0100 1101 0011                      */
	{illegal,0, 	 2, 8}, /* d4: 0111 0100 1101 0100                      */
	{DADC,"EA,BC",   2,11}, /* d5: 0111 0100 1101 0101                      */
	{DADC,"EA,DE",   2,11}, /* d6: 0111 0100 1101 0110                      */
	{DADC,"EA,HL",   2,11}, /* d7: 0111 0100 1101 0111                      */
	{OFFAW,"%a",     3,14}, /* d8: 0111 0100 1101 1000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* d9: 0111 0100 1101 1001                      */
	{illegal,0, 	 2, 8}, /* da: 0111 0100 1101 1010                      */
	{illegal,0, 	 2, 8}, /* db: 0111 0100 1101 1011                      */
	{illegal,0, 	 2, 8}, /* dc: 0111 0100 1101 1100                      */
	{DOFF,"EA,BC",   2,11}, /* dd: 0111 0100 1101 1101                      */
	{DOFF,"EA,DE",   2,11}, /* de: 0111 0100 1101 1110                      */
	{DOFF,"EA,HL",   2,11}, /* df: 0111 0100 1101 1111                      */

	{SUBW,"%a",      3,14}, /* e0: 0111 0100 1110 0000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* e1: 0111 0100 1110 0001                      */
	{illegal,0, 	 2, 8}, /* e2: 0111 0100 1110 0010                      */
	{illegal,0, 	 2, 8}, /* e3: 0111 0100 1110 0011                      */
	{illegal,0, 	 2, 8}, /* e4: 0111 0100 1110 0100                      */
	{DSUB,"EA,BC",   2,11}, /* e5: 0111 0100 1110 0101                      */
	{DSUB,"EA,DE",   2,11}, /* e6: 0111 0100 1110 0110                      */
	{DSUB,"EA,HL",   2,11}, /* e7: 0111 0100 1110 0111                      */
	{NEAW,"%a",      3,14}, /* e8: 0111 0100 1110 1000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* e9: 0111 0100 1110 1001                      */
	{illegal,0, 	 2, 8}, /* ea: 0111 0100 1110 1010                      */
	{illegal,0, 	 2, 8}, /* eb: 0111 0100 1110 1011                      */
	{illegal,0, 	 2, 8}, /* ec: 0111 0100 1110 1100                      */
	{DNE,"EA,BC",    2,11}, /* ed: 0111 0100 1110 1101                      */
	{DNE,"EA,DE",    2,11}, /* ee: 0111 0100 1110 1110                      */
	{DNE,"EA,HL",    2,11}, /* ef: 0111 0100 1110 1111                      */

	{SBBW,"%a",      3,14}, /* f0: 0111 0100 1111 0000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* f1: 0111 0100 1111 0001                      */
	{illegal,0, 	 2, 8}, /* f2: 0111 0100 1111 0010                      */
	{illegal,0, 	 2, 8}, /* f3: 0111 0100 1111 0011                      */
	{illegal,0, 	 2, 8}, /* f4: 0111 0100 1111 0100                      */
	{DSBB,"EA,BC",   2,11}, /* f5: 0111 0100 1111 0101                      */
	{DSBB,"EA,DE",   2,11}, /* f6: 0111 0100 1111 0110                      */
	{DSBB,"EA,HL",   2,11}, /* f7: 0111 0100 1111 0111                      */
	{EQAW,"%a",      3,14}, /* f8: 0111 0100 1111 1000 oooo oooo            */
	{illegal,0, 	 2, 8}, /* f9: 0111 0100 1111 1001                      */
	{illegal,0, 	 2, 8}, /* fa: 0111 0100 1111 1010                      */
	{illegal,0, 	 2, 8}, /* fb: 0111 0100 1111 1011                      */
	{illegal,0, 	 2, 8}, /* fc: 0111 0100 1111 1100                      */
	{DEQ,"EA,BC",    2,11}, /* fd: 0111 0100 1111 1101                      */
	{DEQ,"EA,DE",    2,11}, /* fe: 0111 0100 1111 1110                      */
	{DEQ,"EA,HL",    2,11}  /* ff: 0111 0100 1111 1111                      */
};

/* main opcodes */
static struct dasm_s  dasmXX_7810[256] =
{
	{NOP,0, 		 1, 4}, /* 00: 0000 0000                                */
	{LDAW,"%a",      2,10}, /* 01: 0000 0001 oooo oooo                      */
	{INX,"SP",       1, 7}, /* 02: 0000 0010                                */
	{DCX,"SP",       1, 7}, /* 03: 0000 0011                                */
	{LXI,"SP,%w",    3,10}, /* 04: 0000 0100 llll llll hhhh hhhh            */
	{ANIW,"%a,%b",   3,19}, /* 05: 0000 0101 oooo oooo xxxx xxxx            */
	{illegal,0, 	 1, 4}, /* 06:                                          */
	{ANI,"A,%b",     2, 7}, /* 07: 0000 0111 xxxx xxxx                      */
	{MOV,"A,EAH",    1, 4}, /* 08: 0000 1000                                */
	{MOV,"A,EAL",    1, 4}, /* 09: 0000 1001                                */
	{MOV,"A,B",      1, 4}, /* 0a: 0000 1010                                */
	{MOV,"A,C",      1, 4}, /* 0b: 0000 1011                                */
	{MOV,"A,D",      1, 4}, /* 0c: 0000 1100                                */
	{MOV,"A,E",      1, 4}, /* 0d: 0000 1101                                */
	{MOV,"A,H",      1, 4}, /* 0e: 0000 1110                                */
	{MOV,"A,L",      1, 4}, /* 0f: 0000 1111                                */

	{EXA,0, 		 1, 4}, /* 10: 0001 0000                                */	/* 7810 */
	{EXX,0, 		 1, 4}, /* 11: 0001 0001                                */	/* 7810 */
	{INX,"BC",       1, 7}, /* 12: 0001 0010                                */
	{DCX,"BC",       1, 7}, /* 13: 0001 0011                                */
	{LXI,"BC,%w",    3,10}, /* 14: 0001 0100 llll llll hhhh hhhh            */
	{ORIW,"%a,%b",   3,19}, /* 15: 0001 0101 oooo oooo xxxx xxxx            */
	{XRI,"A,%b",     2, 7}, /* 16: 0001 0110 xxxx xxxx                      */
	{ORI,"A,%b",     2, 7}, /* 17: 0001 0111 xxxx xxxx                      */
	{MOV,"EAH,A",    1, 4}, /* 18: 0001 1000                                */
	{MOV,"EAL,A",    1, 4}, /* 19: 0001 1001                                */
	{MOV,"B,A",      1, 4}, /* 1a: 0001 1010                                */
	{MOV,"C,A",      1, 4}, /* 1b: 0001 1011                                */
	{MOV,"D,A",      1, 4}, /* 1c: 0001 1100                                */
	{MOV,"E,A",      1, 4}, /* 1d: 0001 1101                                */
	{MOV,"H,A",      1, 4}, /* 1e: 0001 1110                                */
	{MOV,"L,A",      1, 4}, /* 1f: 0001 1111                                */

	{INRW,"%a",      2,16}, /* 20: 0010 0000 oooo oooo                      */
	{JB,0,			 1, 4}, /* 21: 0010 0001                                */
	{INX,"DE",       1, 7}, /* 22: 0010 0010                                */
	{DCX,"DE",       1, 7}, /* 23: 0010 0011                                */
	{LXI,"DE,%w",    3,10}, /* 24: 0010 0100 llll llll hhhh hhhh            */
	{GTIW,"%a,%b",   3,19}, /* 25: 0010 0101 oooo oooo xxxx xxxx            */
	{ADINC,"A,%b",   2, 7}, /* 26: 0010 0110 xxxx xxxx                      */
	{GTI,"A,%b",     2, 7}, /* 27: 0010 0111 xxxx xxxx                      */
	{illegal,0, 	 1, 4}, /* 28: 0010 1000                                */
	{LDAX,"(BC)",    1, 7}, /* 29: 0010 1001                                */
	{LDAX,"(DE)",    1, 7}, /* 2a: 0010 1010                                */
	{LDAX,"(HL)",    1, 7}, /* 2b: 0010 1011                                */
	{LDAX,"(DE+)",   1, 7}, /* 2c: 0010 1100                                */
	{LDAX,"(HL+)",   1, 7}, /* 2d: 0010 1101                                */
	{LDAX,"(DE-)",   1, 7}, /* 2e: 0010 1110                                */
	{LDAX,"(HL-)",   1, 7}, /* 2f: 0010 1111                                */

	{DCRW,"%a",      2,16}, /* 30: 0011 0000 oooo oooo                      */
	{BLOCK,0,		 1,13}, /* 31: 0011 0001                                */	/* 7810 */
	{INX,"HL",       1, 7}, /* 32: 0011 0010                                */
	{DCX,"HL",       1, 7}, /* 33: 0011 0011                                */
	{LXI,"HL,%w",    3,10}, /* 34: 0011 0100 llll llll hhhh hhhh            */
	{LTIW,"%a,%b",   3,19}, /* 35: 0011 0101 oooo oooo xxxx xxxx            */
	{SUINB,"A,%b",   2, 7}, /* 36: 0011 0110 xxxx xxxx                      */
	{LTI,"A,%b",     2, 7}, /* 37: 0011 0111 xxxx xxxx                      */
	{illegal,0, 	 1, 4}, /* 38:                                          */
	{STAX,"(BC)",    1, 7}, /* 39: 0011 1001                                */
	{STAX,"(DE)",    1, 7}, /* 3a: 0011 1010                                */
	{STAX,"(HL)",    1, 7}, /* 3b: 0011 1011                                */
	{STAX,"(DE+)",   1, 7}, /* 3c: 0011 1100                                */
	{STAX,"(HL+)",   1, 7}, /* 3d: 0011 1101                                */
	{STAX,"(DE-)",   1, 7}, /* 3e: 0011 1110                                */
	{STAX,"(HL-)",   1, 7}, /* 3f: 0011 1111                                */

	{CALL,"%w",      3,16}, /* 40: 0100 0000 llll llll hhhh hhhh            */
	{INR,"A",        1, 4}, /* 41: 0100 0001                                */
	{INR,"B",        1, 4}, /* 42: 0100 0010                                */
	{INR,"C",        1, 4}, /* 43: 0100 0011                                */
	{LXI,"EA,%w",    3,10}, /* 44: 0100 0100 llll llll hhhh hhhh            */
	{ONIW,"%a,%b",   3,19}, /* 45: 0100 0101 oooo oooo xxxx xxxx            */
	{ADI,"A,%b",     2, 7}, /* 46: 0100 0110 xxxx xxxx                      */
	{ONI,"A,%b",     2, 7}, /* 47: 0100 0111 xxxx xxxx                      */
	{0,dasm48_7810,	 0, 0}, /* 48: prefix                                   */
	{MVIX,"BC,%b",   2,10}, /* 49: 0100 1001 xxxx xxxx                      */
	{MVIX,"DE,%b",   2,10}, /* 4a: 0100 1010 xxxx xxxx                      */
	{MVIX,"HL,%b",   2,10}, /* 4b: 0100 1011 xxxx xxxx                      */
	{0,dasm4C_7810,	 0, 0}, /* 4c: prefix                                   */
	{0,dasm4D_7810,	 0, 0}, /* 4d: prefix                                   */
	{JRE,"%d",       2,10}, /* 4e: 0100 111d dddd dddd                      */
	{JRE,"%d",       2,10}, /* 4f: 0100 111d dddd dddd                      */

	{EXH,0, 		 1, 4}, /* 50: 0101 0000                                */	/* 7810 */
	{DCR,"A",        1, 4}, /* 51: 0101 0001                                */
	{DCR,"B",        1, 4}, /* 52: 0101 0010                                */
	{DCR,"C",        1, 4}, /* 53: 0101 0011                                */
	{JMP,"%w",       3,10}, /* 54: 0101 0100 llll llll hhhh hhhh            */
	{OFFIW,"%a,%b",  3,19}, /* 55: 0101 0101 oooo oooo xxxx xxxx            */
	{ACI,"A,%b",     2, 7}, /* 56: 0101 0110 xxxx xxxx                      */
	{OFFI,"A,%b",    2, 7}, /* 57: 0101 0111 xxxx xxxx                      */
	{BIT,"0,%a",     2,10}, /* 58: 0101 1000 oooo oooo                      */	/* 7810 */
	{BIT,"1,%a",     2,10}, /* 59: 0101 1001 oooo oooo                      */	/* 7810 */
	{BIT,"2,%a",     2,10}, /* 5a: 0101 1010 oooo oooo                      */	/* 7810 */
	{BIT,"3,%a",     2,10}, /* 5b: 0101 1011 oooo oooo                      */	/* 7810 */
	{BIT,"4,%a",     2,10}, /* 5c: 0101 1100 oooo oooo                      */	/* 7810 */
	{BIT,"5,%a",     2,10}, /* 5d: 0101 1101 oooo oooo                      */	/* 7810 */
	{BIT,"6,%a",     2,10}, /* 5e: 0101 1110 oooo oooo                      */	/* 7810 */
	{BIT,"7,%a",     2,10}, /* 5f: 0101 1111 oooo oooo                      */	/* 7810 */

	{0,dasm60,		 0, 0}, /* 60: prefix                                   */
	{DAA,0, 		 1, 4}, /* 61: 0110 0001                                */
	{RETI,0,		 1,13}, /* 62: 0110 0010                                */
	{STAW,"%a",      2,10}, /* 63: 0110 0011 oooo oooo                      */
	{0,dasm64_7810,	 0, 0}, /* 64: prefix                                   */
	{NEIW,"%a,%b",   3,19}, /* 65: 0110 0101 oooo oooo xxxx xxxx            */
	{SUI,"A,%b",     2, 7}, /* 66: 0110 0110 xxxx xxxx                      */
	{NEI,"A,%b",     2, 7}, /* 67: 0110 0111 xxxx xxxx                      */
	{MVI,"V,%b",     2, 7}, /* 68: 0110 1000 xxxx xxxx                      */
	{MVI,"A,%b",     2, 7}, /* 69: 0110 1001 xxxx xxxx                      */
	{MVI,"B,%b",     2, 7}, /* 6a: 0110 1010 xxxx xxxx                      */
	{MVI,"C,%b",     2, 7}, /* 6b: 0110 1011 xxxx xxxx                      */
	{MVI,"D,%b",     2, 7}, /* 6c: 0110 1100 xxxx xxxx                      */
	{MVI,"E,%b",     2, 7}, /* 6d: 0110 1101 xxxx xxxx                      */
	{MVI,"H,%b",     2, 7}, /* 6e: 0110 1110 xxxx xxxx                      */
	{MVI,"L,%b",     2, 7}, /* 6f: 0110 1111 xxxx xxxx                      */

	{0,dasm70,		 0, 0}, /* 70: prefix                                   */
	{MVIW,"%a,%b",   3,13}, /* 71: 0111 0001 oooo oooo xxxx xxxx            */
	{SOFTI,0,		 1,16}, /* 72: 0111 0010                                */
	{illegal,0, 	 1, 0}, /* 73:                                          */
	{0,dasm74,		 0, 0}, /* 74: prefix                                   */
	{EQIW,"%a,%b",   3,19}, /* 75: 0111 0101 oooo oooo xxxx xxxx            */
	{SBI,"A,%b",     2, 7}, /* 76: 0111 0110 xxxx xxxx                      */
	{EQI,"A,%b",     2, 7}, /* 77: 0111 0111 xxxx xxxx                      */
	{CALF,"%f",      2,13}, /* 78: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 79: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 7a: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 7b: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 7c: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 7d: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 7e: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 7f: 0111 1ddd dddd dddd                      */

	{CALT,"%t",      1,16}, /* 80: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 81: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 82: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 83: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 84: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 85: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 86: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 87: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 88: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 89: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 8a: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 8b: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 8c: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 8d: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 8e: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 8f: 100t tttt                                */

	{CALT,"%t",      1,16}, /* 90: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 91: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 92: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 93: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 94: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 95: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 96: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 97: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 98: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 99: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 9a: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 9b: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 9c: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 9d: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 9e: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 9f: 100t tttt                                */

	{POP,"VA",       1,10}, /* a0: 1010 0000                                */
	{POP,"BC",       1,10}, /* a1: 1010 0001                                */
	{POP,"DE",       1,10}, /* a2: 1010 0010                                */
	{POP,"HL",       1,10}, /* a3: 1010 0011                                */
	{POP,"EA",       1,10}, /* a4: 1010 0100                                */
	{DMOV,"EA,BC",   1, 4}, /* a5: 1010 0101                                */
	{DMOV,"EA,DE",   1, 4}, /* a6: 1010 0110                                */
	{DMOV,"EA,HL",   1, 4}, /* a7: 1010 0111                                */
	{INX,"EA",       1, 7}, /* a8: 1010 1000                                */
	{DCX,"EA",       1, 7}, /* a9: 1010 1001                                */
	{EI,0,			 1, 4}, /* aa: 1010 1010                                */
	{LDAX,"(DE+%b)", 2,13}, /* ab: 1010 1011 dddd dddd                      */
	{LDAX,"(HL+A)",  1,13}, /* ac: 1010 1100                                */
	{LDAX,"(HL+B)",  1,13}, /* ad: 1010 1101                                */
	{LDAX,"(HL+EA)", 1,13}, /* ae: 1010 1110                                */
	{LDAX,"(HL+%b)", 2,13}, /* af: 1010 1111 dddd dddd                      */

	{PUSH,"VA",      1,13}, /* b0: 1011 0000                                */
	{PUSH,"BC",      1,13}, /* b1: 1011 0001                                */
	{PUSH,"DE",      1,13}, /* b2: 1011 0010                                */
	{PUSH,"HL",      1,13}, /* b3: 1011 0011                                */
	{PUSH,"EA",      1,13}, /* b4: 1011 0100                                */
	{DMOV,"BC,EA",   1, 4}, /* b5: 1011 0101                                */
	{DMOV,"DE,EA",   1, 4}, /* b6: 1011 0110                                */
	{DMOV,"HL,EA",   1, 4}, /* b7: 1011 0111                                */
	{RET,0, 		 1,10}, /* b8: 1011 1000                                */
	{RETS,0,		 1,10}, /* b9: 1011 1001                                */
	{DI,0,			 1, 4}, /* ba: 1011 1010                                */
	{STAX,"(DE+%b)", 2,13}, /* bb: 1011 1011 dddd dddd                      */
	{STAX,"(HL+A)",  1,13}, /* bc: 1011 1100                                */
	{STAX,"(HL+B)",  1,13}, /* bd: 1011 1101                                */
	{STAX,"(HL+EA)", 1,13}, /* be: 1011 1110                                */
	{STAX,"(HL+%b)", 2,13}, /* bf: 1011 1111 dddd dddd                      */

	{JR,"%o",        1,10}, /* c0: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c1: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c2: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c3: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c4: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c5: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c6: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c7: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c8: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c9: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ca: 11oo oooo                                */
	{JR,"%o",        1,10}, /* cb: 11oo oooo                                */
	{JR,"%o",        1,10}, /* cc: 11oo oooo                                */
	{JR,"%o",        1,10}, /* cd: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ce: 11oo oooo                                */
	{JR,"%o",        1,10}, /* cf: 11oo oooo                                */

	{JR,"%o",        1,10}, /* d0: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d1: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d2: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d3: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d4: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d5: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d6: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d7: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d8: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d9: 11oo oooo                                */
	{JR,"%o",        1,10}, /* da: 11oo oooo                                */
	{JR,"%o",        1,10}, /* db: 11oo oooo                                */
	{JR,"%o",        1,10}, /* dc: 11oo oooo                                */
	{JR,"%o",        1,10}, /* dd: 11oo oooo                                */
	{JR,"%o",        1,10}, /* de: 11oo oooo                                */
	{JR,"%o",        1,10}, /* df: 11oo oooo                                */

	{JR,"%o",        1,10}, /* e0: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e1: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e2: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e3: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e4: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e5: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e6: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e7: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e8: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e9: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ea: 11oo oooo                                */
	{JR,"%o",        1,10}, /* eb: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ec: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ed: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ee: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ef: 11oo oooo                                */

	{JR,"%o",        1,10}, /* f0: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f1: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f2: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f3: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f4: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f5: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f6: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f7: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f8: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f9: 11oo oooo                                */
	{JR,"%o",        1,10}, /* fa: 11oo oooo                                */
	{JR,"%o",        1,10}, /* fb: 11oo oooo                                */
	{JR,"%o",        1,10}, /* fc: 11oo oooo                                */
	{JR,"%o",        1,10}, /* fd: 11oo oooo                                */
	{JR,"%o",        1,10}, /* fe: 11oo oooo                                */
	{JR,"%o",        1,10}  /* ff: 11oo oooo                                */
};

static struct dasm_s  dasmXX_7807[256] =
{
	{NOP,0, 		 1, 4}, /* 00: 0000 0000                                */
	{LDAW,"%a",      2,10}, /* 01: 0000 0001 oooo oooo                      */
	{INX,"SP",       1, 7}, /* 02: 0000 0010                                */
	{DCX,"SP",       1, 7}, /* 03: 0000 0011                                */
	{LXI,"SP,%w",    3,10}, /* 04: 0000 0100 llll llll hhhh hhhh            */
	{ANIW,"%a,%b",   3,19}, /* 05: 0000 0101 oooo oooo xxxx xxxx            */
	{illegal,0, 	 1, 4}, /* 06:                                          */
	{ANI,"A,%b",     2, 7}, /* 07: 0000 0111 xxxx xxxx                      */
	{MOV,"A,EAH",    1, 4}, /* 08: 0000 1000                                */
	{MOV,"A,EAL",    1, 4}, /* 09: 0000 1001                                */
	{MOV,"A,B",      1, 4}, /* 0a: 0000 1010                                */
	{MOV,"A,C",      1, 4}, /* 0b: 0000 1011                                */
	{MOV,"A,D",      1, 4}, /* 0c: 0000 1100                                */
	{MOV,"A,E",      1, 4}, /* 0d: 0000 1101                                */
	{MOV,"A,H",      1, 4}, /* 0e: 0000 1110                                */
	{MOV,"A,L",      1, 4}, /* 0f: 0000 1111                                */

	{BLOCK,"D+",	 1,13}, /* 10: 0001 0000                                */	/* 7807 */
	{BLOCK,"D-",	 1,13}, /* 11: 0001 0001                                */	/* 7807 */
	{INX,"BC",       1, 7}, /* 12: 0001 0010                                */
	{DCX,"BC",       1, 7}, /* 13: 0001 0011                                */
	{LXI,"BC,%w",    3,10}, /* 14: 0001 0100 llll llll hhhh hhhh            */
	{ORIW,"%a,%b",   3,19}, /* 15: 0001 0101 oooo oooo xxxx xxxx            */
	{XRI,"A,%b",     2, 7}, /* 16: 0001 0110 xxxx xxxx                      */
	{ORI,"A,%b",     2, 7}, /* 17: 0001 0111 xxxx xxxx                      */
	{MOV,"EAH,A",    1, 4}, /* 18: 0001 1000                                */
	{MOV,"EAL,A",    1, 4}, /* 19: 0001 1001                                */
	{MOV,"B,A",      1, 4}, /* 1a: 0001 1010                                */
	{MOV,"C,A",      1, 4}, /* 1b: 0001 1011                                */
	{MOV,"D,A",      1, 4}, /* 1c: 0001 1100                                */
	{MOV,"E,A",      1, 4}, /* 1d: 0001 1101                                */
	{MOV,"H,A",      1, 4}, /* 1e: 0001 1110                                */
	{MOV,"L,A",      1, 4}, /* 1f: 0001 1111                                */

	{INRW,"%a",      2,16}, /* 20: 0010 0000 oooo oooo                      */
	{JB,0,			 1, 4}, /* 21: 0010 0001                                */
	{INX,"DE",       1, 7}, /* 22: 0010 0010                                */
	{DCX,"DE",       1, 7}, /* 23: 0010 0011                                */
	{LXI,"DE,%w",    3,10}, /* 24: 0010 0100 llll llll hhhh hhhh            */
	{GTIW,"%a,%b",   3,19}, /* 25: 0010 0101 oooo oooo xxxx xxxx            */
	{ADINC,"A,%b",   2, 7}, /* 26: 0010 0110 xxxx xxxx                      */
	{GTI,"A,%b",     2, 7}, /* 27: 0010 0111 xxxx xxxx                      */
	{illegal,0, 	 1, 4}, /* 28: 0010 1000                                */
	{LDAX,"(BC)",    1, 7}, /* 29: 0010 1001                                */
	{LDAX,"(DE)",    1, 7}, /* 2a: 0010 1010                                */
	{LDAX,"(HL)",    1, 7}, /* 2b: 0010 1011                                */
	{LDAX,"(DE+)",   1, 7}, /* 2c: 0010 1100                                */
	{LDAX,"(HL+)",   1, 7}, /* 2d: 0010 1101                                */
	{LDAX,"(DE-)",   1, 7}, /* 2e: 0010 1110                                */
	{LDAX,"(HL-)",   1, 7}, /* 2f: 0010 1111                                */

	{DCRW,"%a",      2,16}, /* 30: 0011 0000 oooo oooo                      */
	{AND,"CY,%i",	 2,10}, /* 31: 0011 0001 bbbb bbbb                      */	/* 7807 */
	{INX,"HL",       1, 7}, /* 32: 0011 0010                                */
	{DCX,"HL",       1, 7}, /* 33: 0011 0011                                */
	{LXI,"HL,%w",    3,10}, /* 34: 0011 0100 llll llll hhhh hhhh            */
	{LTIW,"%a,%b",   3,19}, /* 35: 0011 0101 oooo oooo xxxx xxxx            */
	{SUINB,"A,%b",   2, 7}, /* 36: 0011 0110 xxxx xxxx                      */
	{LTI,"A,%b",     2, 7}, /* 37: 0011 0111 xxxx xxxx                      */
	{illegal,0, 	 1, 4}, /* 38:                                          */
	{STAX,"(BC)",    1, 7}, /* 39: 0011 1001                                */
	{STAX,"(DE)",    1, 7}, /* 3a: 0011 1010                                */
	{STAX,"(HL)",    1, 7}, /* 3b: 0011 1011                                */
	{STAX,"(DE+)",   1, 7}, /* 3c: 0011 1100                                */
	{STAX,"(HL+)",   1, 7}, /* 3d: 0011 1101                                */
	{STAX,"(DE-)",   1, 7}, /* 3e: 0011 1110                                */
	{STAX,"(HL-)",   1, 7}, /* 3f: 0011 1111                                */

	{CALL,"%w",      3,16}, /* 40: 0100 0000 llll llll hhhh hhhh            */
	{INR,"A",        1, 4}, /* 41: 0100 0001                                */
	{INR,"B",        1, 4}, /* 42: 0100 0010                                */
	{INR,"C",        1, 4}, /* 43: 0100 0011                                */
	{LXI,"EA,%w",    3,10}, /* 44: 0100 0100 llll llll hhhh hhhh            */
	{ONIW,"%a,%b",   3,19}, /* 45: 0100 0101 oooo oooo xxxx xxxx            */
	{ADI,"A,%b",     2, 7}, /* 46: 0100 0110 xxxx xxxx                      */
	{ONI,"A,%b",     2, 7}, /* 47: 0100 0111 xxxx xxxx                      */
	{0,dasm48_7807,	 0, 0}, /* 48: prefix                                   */
	{MVIX,"BC,%b",   2,10}, /* 49: 0100 1001 xxxx xxxx                      */
	{MVIX,"DE,%b",   2,10}, /* 4a: 0100 1010 xxxx xxxx                      */
	{MVIX,"HL,%b",   2,10}, /* 4b: 0100 1011 xxxx xxxx                      */
	{0,dasm4C_7807,	 0, 0}, /* 4c: prefix                                   */
	{0,dasm4D_7807,	 0, 0}, /* 4d: prefix                                   */
	{JRE,"%d",       2,10}, /* 4e: 0100 111d dddd dddd                      */
	{JRE,"%d",       2,10}, /* 4f: 0100 111d dddd dddd                      */
	{SKN,"%i",		 2,10}, /* 50: 0101 0000 bbbb bbbb                      */	/* 7807 */
	{DCR,"A",        1, 4}, /* 51: 0101 0001                                */
	{DCR,"B",        1, 4}, /* 52: 0101 0010                                */
	{DCR,"C",        1, 4}, /* 53: 0101 0011                                */
	{JMP,"%w",       3,10}, /* 54: 0101 0100 llll llll hhhh hhhh            */
	{OFFIW,"%a,%b",  3,19}, /* 55: 0101 0101 oooo oooo xxxx xxxx            */
	{ACI,"A,%b",     2, 7}, /* 56: 0101 0110 xxxx xxxx                      */
	{OFFI,"A,%b",    2, 7}, /* 57: 0101 0111 xxxx xxxx                      */
	{SETB,"%i",      2,13}, /* 58: 0101 1000 bbbb bbbb                      */	/* 7807 */
	{NOT,"%i",       2,13}, /* 59: 0101 1001 bbbb bbbb                      */	/* 7807 */
	{MOV,"%i,CY",    2,13}, /* 5a: 0101 1010 bbbb bbbb                      */	/* 7807 */
	{CLR,"%i",       2,13}, /* 5b: 0101 1011 bbbb bbbb                      */	/* 7807 */
	{OR,"CY,%i",     2,10}, /* 5c: 0101 1100 bbbb bbbb                      */	/* 7807 */
	{SK,"%i",        2,10}, /* 5d: 0101 1101 bbbb bbbb                      */	/* 7807 */
	{XOR,"CY,%i",    2,10}, /* 5e: 0101 1110 bbbb bbbb                      */	/* 7807 */
	{MOV,"CY,%i",    2,10}, /* 5f: 0101 1111 bbbb bbbb                      */	/* 7807 */

	{0,dasm60,		 0, 0}, /* 60: prefix                                   */
	{DAA,0, 		 1, 4}, /* 61: 0110 0001                                */
	{RETI,0,		 1,13}, /* 62: 0110 0010                                */
	{STAW,"%a",      2,10}, /* 63: 0110 0011 oooo oooo                      */
	{0,dasm64_7807,	 0, 0}, /* 64: prefix                                   */
	{NEIW,"%a,%b",   3,19}, /* 65: 0110 0101 oooo oooo xxxx xxxx            */
	{SUI,"A,%b",     2, 7}, /* 66: 0110 0110 xxxx xxxx                      */
	{NEI,"A,%b",     2, 7}, /* 67: 0110 0111 xxxx xxxx                      */
	{MVI,"V,%b",     2, 7}, /* 68: 0110 1000 xxxx xxxx                      */
	{MVI,"A,%b",     2, 7}, /* 69: 0110 1001 xxxx xxxx                      */
	{MVI,"B,%b",     2, 7}, /* 6a: 0110 1010 xxxx xxxx                      */
	{MVI,"C,%b",     2, 7}, /* 6b: 0110 1011 xxxx xxxx                      */
	{MVI,"D,%b",     2, 7}, /* 6c: 0110 1100 xxxx xxxx                      */
	{MVI,"E,%b",     2, 7}, /* 6d: 0110 1101 xxxx xxxx                      */
	{MVI,"H,%b",     2, 7}, /* 6e: 0110 1110 xxxx xxxx                      */
	{MVI,"L,%b",     2, 7}, /* 6f: 0110 1111 xxxx xxxx                      */

	{0,dasm70,		 0, 0}, /* 70: prefix                                   */
	{MVIW,"%a,%b",   3,13}, /* 71: 0111 0001 oooo oooo xxxx xxxx            */
	{SOFTI,0,		 1,16}, /* 72: 0111 0010                                */
	{illegal,0, 	 1, 0}, /* 73:                                          */
	{0,dasm74,		 0, 0}, /* 74: prefix                                   */
	{EQIW,"%a,%b",   3,19}, /* 75: 0111 0101 oooo oooo xxxx xxxx            */
	{SBI,"A,%b",     2, 7}, /* 76: 0111 0110 xxxx xxxx                      */
	{EQI,"A,%b",     2, 7}, /* 77: 0111 0111 xxxx xxxx                      */
	{CALF,"%f",      2,13}, /* 78: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 79: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 7a: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 7b: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 7c: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 7d: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 7e: 0111 1ddd dddd dddd                      */
	{CALF,"%f",      2,13}, /* 7f: 0111 1ddd dddd dddd                      */

	{CALT,"%t",      1,16}, /* 80: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 81: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 82: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 83: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 84: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 85: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 86: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 87: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 88: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 89: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 8a: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 8b: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 8c: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 8d: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 8e: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 8f: 100t tttt                                */

	{CALT,"%t",      1,16}, /* 90: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 91: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 92: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 93: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 94: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 95: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 96: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 97: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 98: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 99: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 9a: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 9b: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 9c: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 9d: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 9e: 100t tttt                                */
	{CALT,"%t",      1,16}, /* 9f: 100t tttt                                */

	{POP,"VA",       1,10}, /* a0: 1010 0000                                */
	{POP,"BC",       1,10}, /* a1: 1010 0001                                */
	{POP,"DE",       1,10}, /* a2: 1010 0010                                */
	{POP,"HL",       1,10}, /* a3: 1010 0011                                */
	{POP,"EA",       1,10}, /* a4: 1010 0100                                */
	{DMOV,"EA,BC",   1, 4}, /* a5: 1010 0101                                */
	{DMOV,"EA,DE",   1, 4}, /* a6: 1010 0110                                */
	{DMOV,"EA,HL",   1, 4}, /* a7: 1010 0111                                */
	{INX,"EA",       1, 7}, /* a8: 1010 1000                                */
	{DCX,"EA",       1, 7}, /* a9: 1010 1001                                */
	{EI,0,			 1, 4}, /* aa: 1010 1010                                */
	{LDAX,"(DE+%b)", 2,13}, /* ab: 1010 1011 dddd dddd                      */
	{LDAX,"(HL+A)",  1,13}, /* ac: 1010 1100                                */
	{LDAX,"(HL+B)",  1,13}, /* ad: 1010 1101                                */
	{LDAX,"(HL+EA)", 1,13}, /* ae: 1010 1110                                */
	{LDAX,"(HL+%b)", 2,13}, /* af: 1010 1111 dddd dddd                      */

	{PUSH,"VA",      1,13}, /* b0: 1011 0000                                */
	{PUSH,"BC",      1,13}, /* b1: 1011 0001                                */
	{PUSH,"DE",      1,13}, /* b2: 1011 0010                                */
	{PUSH,"HL",      1,13}, /* b3: 1011 0011                                */
	{PUSH,"EA",      1,13}, /* b4: 1011 0100                                */
	{DMOV,"BC,EA",   1, 4}, /* b5: 1011 0101                                */
	{DMOV,"DE,EA",   1, 4}, /* b6: 1011 0110                                */
	{DMOV,"HL,EA",   1, 4}, /* b7: 1011 0111                                */
	{RET,0, 		 1,10}, /* b8: 1011 1000                                */
	{RETS,0,		 1,10}, /* b9: 1011 1001                                */
	{DI,0,			 1, 4}, /* ba: 1011 1010                                */
	{STAX,"(DE+%b)", 2,13}, /* bb: 1011 1011 dddd dddd                      */
	{STAX,"(HL+A)",  1,13}, /* bc: 1011 1100                                */
	{STAX,"(HL+B)",  1,13}, /* bd: 1011 1101                                */
	{STAX,"(HL+EA)", 1,13}, /* be: 1011 1110                                */
	{STAX,"(HL+%b)", 2,13}, /* bf: 1011 1111 dddd dddd                      */

	{JR,"%o",        1,10}, /* c0: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c1: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c2: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c3: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c4: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c5: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c6: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c7: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c8: 11oo oooo                                */
	{JR,"%o",        1,10}, /* c9: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ca: 11oo oooo                                */
	{JR,"%o",        1,10}, /* cb: 11oo oooo                                */
	{JR,"%o",        1,10}, /* cc: 11oo oooo                                */
	{JR,"%o",        1,10}, /* cd: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ce: 11oo oooo                                */
	{JR,"%o",        1,10}, /* cf: 11oo oooo                                */

	{JR,"%o",        1,10}, /* d0: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d1: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d2: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d3: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d4: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d5: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d6: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d7: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d8: 11oo oooo                                */
	{JR,"%o",        1,10}, /* d9: 11oo oooo                                */
	{JR,"%o",        1,10}, /* da: 11oo oooo                                */
	{JR,"%o",        1,10}, /* db: 11oo oooo                                */
	{JR,"%o",        1,10}, /* dc: 11oo oooo                                */
	{JR,"%o",        1,10}, /* dd: 11oo oooo                                */
	{JR,"%o",        1,10}, /* de: 11oo oooo                                */
	{JR,"%o",        1,10}, /* df: 11oo oooo                                */

	{JR,"%o",        1,10}, /* e0: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e1: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e2: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e3: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e4: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e5: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e6: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e7: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e8: 11oo oooo                                */
	{JR,"%o",        1,10}, /* e9: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ea: 11oo oooo                                */
	{JR,"%o",        1,10}, /* eb: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ec: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ed: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ee: 11oo oooo                                */
	{JR,"%o",        1,10}, /* ef: 11oo oooo                                */

	{JR,"%o",        1,10}, /* f0: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f1: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f2: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f3: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f4: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f5: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f6: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f7: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f8: 11oo oooo                                */
	{JR,"%o",        1,10}, /* f9: 11oo oooo                                */
	{JR,"%o",        1,10}, /* fa: 11oo oooo                                */
	{JR,"%o",        1,10}, /* fb: 11oo oooo                                */
	{JR,"%o",        1,10}, /* fc: 11oo oooo                                */
	{JR,"%o",        1,10}, /* fd: 11oo oooo                                */
	{JR,"%o",        1,10}, /* fe: 11oo oooo                                */
	{JR,"%o",        1,10}  /* ff: 11oo oooo                                */
};


/* register names for bit manipulation instructions */
const char *regname[32] =
{
	"illegal", "illegal", "illegal", "illegal",
	"illegal", "illegal", "illegal", "illegal",
	"illegal", "illegal", "illegal", "illegal",
	"illegal", "illegal", "illegal", "illegal",
	"PA",      "PB",      "PC",      "PD",
	"illegal", "PF",      "MKH",     "MKL",
	"illegal", "SMH",     "illegal", "EOM",
	"illegal", "TMM",     "PT",      "illegal"
};

static unsigned upd7810_get_reg(int reg) { union cpuinfo info; upd7810_get_info(CPUINFO_INT_REGISTER + (reg), &info); return info.i; }

unsigned Dasm( char *buffer, unsigned pc, struct dasm_s *dasmXX )
{
	UINT8 op = cpu_readop(pc++), op2, t;
	int offset;
	unsigned l, ea;
	const char *symbol;
	const char *a;

	t = dasmXX[op].token;
	a = dasmXX[op].args;
	l = dasmXX[op].oplen;

	/* 0 token means prefix opcode (use table from args) */
	if (0 == t)
	{
		struct dasm_s *p_dasm = (struct dasm_s *)a;

		op2 = cpu_readop(pc++);
		t = p_dasm[op2].token;
		a = p_dasm[op2].args;
		l = p_dasm[op2].oplen;
	}

	buffer += sprintf(buffer, "%-8.8s", token[t]);

	while (a && *a)
	{
		if ('%' == *a)
		{
			a++;
			switch (*a)
			{
			case 'a':   /* address V * 256 + offset */
				op2 = cpu_readop_arg(pc++);
				ea = upd7810_get_reg(UPD7810_V) * 256 + op2;
				symbol = set_ea_info(0, ea, EA_UINT8, EA_MEM_RD);
				buffer += sprintf(buffer, "%s", symbol);
				break;
			case 'b':   /* immediate byte */
				ea = cpu_readop_arg(pc++);
				symbol = set_ea_info(1, ea, EA_UINT8, EA_VALUE);
				buffer += sprintf(buffer, "%s", symbol);
				break;
			case 'w':   /* immediate word */
				ea = cpu_readop_arg(pc++);
				ea += cpu_readop_arg(pc++) << 8;
				symbol = set_ea_info(1, ea, EA_UINT16, EA_VALUE);
				buffer += sprintf(buffer, "%s", symbol);
				break;
			case 'd':   /* JRE address */
				op2 = cpu_readop(pc++);
				offset = (op & 1) ? -(256 - op2): + op2;
				symbol = set_ea_info(0, pc - 2, offset + 2, EA_REL_PC);
				buffer += sprintf(buffer, "%s", symbol);
				break;
			case 't':   /* CALT address */
				ea = 0x80 + 2 * (op & 0x1f);
				symbol = set_ea_info(0, ea, EA_DEFAULT, EA_ABS_PC);
				buffer += sprintf(buffer, "(%s)", symbol);
				break;
			case 'f':   /* CALF address */
				op2 = cpu_readop(pc++);
				ea = 0x800 + 0x100 * (op & 0x07) + op2;
				symbol = set_ea_info(0, ea, EA_DEFAULT, EA_ABS_PC);
				buffer += sprintf(buffer, "%s", symbol);
				break;
			case 'o':   /* JR offset */
				op2 = cpu_readop(pc++);
				offset = (INT8)(op << 2) >> 2;
				symbol = set_ea_info(0, pc - 2, offset + 1, EA_REL_PC);
				buffer += sprintf(buffer, "%s", symbol);
				break;
			case 'i':   /* bit manipulation */
				op2 = cpu_readop(pc++);
				buffer += sprintf(buffer, "%s,%d", regname[op2 & 0x1f], op2 >> 5);
				break;
			default:
				*buffer++ = *a;
			}
		}
		else
			*buffer++ = *a;
		a++;
	}
	*buffer = '\0';

	return l;
}

unsigned Dasm7810( char *buffer, unsigned pc )
{
	return Dasm( buffer, pc, dasmXX_7810 );
}

unsigned Dasm7807( char *buffer, unsigned pc )
{
	return Dasm( buffer, pc, dasmXX_7807 );
}

#endif	/* MAME_DEBUG */

