/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ID3IllegalFormatException;
import de.vdheide.mp3.NoID3TagException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ID3 {
    private final String encoding = "Cp437";
    private File mp3_file = null;
    private String title = null;
    private String artist = null;
    private String album = null;
    private String year = null;
    private Byte genre = null;
    private String comment = null;
    private Byte track = null;

    public ID3(File file) {
        this.mp3_file = file;
    }

    public String getTitle() throws NoID3TagException {
        try {
            this.checkIfRead(this.title);
        }
        catch (IOException iOException) {
            throw new NoID3TagException();
        }
        return this.title;
    }

    public String getArtist() throws NoID3TagException {
        try {
            this.checkIfRead(this.artist);
        }
        catch (IOException iOException) {
            throw new NoID3TagException();
        }
        return this.artist;
    }

    public String getAlbum() throws NoID3TagException {
        try {
            this.checkIfRead(this.album);
        }
        catch (IOException iOException) {
            throw new NoID3TagException();
        }
        return this.album;
    }

    public String getYear() throws NoID3TagException {
        try {
            this.checkIfRead(this.year);
        }
        catch (IOException iOException) {
            throw new NoID3TagException();
        }
        return this.year;
    }

    public int getGenre() throws NoID3TagException {
        if (this.genre == null) {
            try {
                this.readTag();
            }
            catch (IOException iOException) {
                throw new NoID3TagException();
            }
        }
        return this.genre.byteValue();
    }

    public String getComment() throws NoID3TagException {
        try {
            this.checkIfRead(this.comment);
            return this.comment;
        }
        catch (IOException iOException) {
            throw new NoID3TagException();
        }
    }

    public int getTrack() throws NoID3TagException {
        if (this.track == null) {
            try {
                this.readTag();
            }
            catch (IOException iOException) {
                throw new NoID3TagException();
            }
        }
        return this.track.byteValue();
    }

    public void readTag() throws NoID3TagException, IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.mp3_file, "r");
        if (!this.checkForTag()) {
            throw new NoID3TagException();
        }
        randomAccessFile.seek(randomAccessFile.length() - 125L);
        byte[] byArray = new byte[125];
        if (randomAccessFile.read(byArray, 0, 125) != 125) {
            // empty if block
        }
        String string = new String(byArray, 0, 125, "Cp437");
        this.title = string.substring(0, 30).trim();
        this.artist = string.substring(30, 60).trim();
        this.album = string.substring(60, 90).trim();
        this.year = string.substring(90, 94).trim();
        this.comment = string.substring(94, 123).trim();
        this.track = new Byte((byte)string.charAt(123));
        this.genre = new Byte((byte)string.charAt(124));
        randomAccessFile.close();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setArtist(String string) {
        this.artist = string;
    }

    public void setAlbum(String string) {
        this.album = string;
    }

    public void setYear(String string) {
        this.year = string;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setTrack(int n) throws ID3IllegalFormatException {
        if (n < 0 || n > 255) {
            throw new ID3IllegalFormatException();
        }
        this.track = new Byte((byte)n);
    }

    public void setGenre(int n) throws ID3IllegalFormatException {
        this.genre = new Byte((byte)n);
    }

    public void writeTag() throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.mp3_file, "rw");
        if (!this.checkForTag()) {
            randomAccessFile.seek(randomAccessFile.length());
        } else {
            randomAccessFile.seek(randomAccessFile.length() - 128L);
        }
        randomAccessFile.write(new String("TAG").getBytes("Cp437"));
        randomAccessFile.write(this.fillWithNills(this.title, 30).getBytes("Cp437"));
        randomAccessFile.write(this.fillWithNills(this.artist, 30).getBytes("Cp437"));
        randomAccessFile.write(this.fillWithNills(this.album, 30).getBytes("Cp437"));
        randomAccessFile.write(this.fillWithNills(this.year, 4).getBytes("Cp437"));
        randomAccessFile.write(this.fillWithNills(this.comment, 29).getBytes("Cp437"));
        if (this.track == null) {
            randomAccessFile.writeByte(0);
        } else {
            randomAccessFile.writeByte(this.track.byteValue());
        }
        if (this.genre == null) {
            randomAccessFile.writeByte(0);
        } else {
            randomAccessFile.writeByte(this.genre.byteValue());
        }
        randomAccessFile.close();
    }

    private void checkIfRead(String string) throws NoID3TagException, IOException {
        if (string == null) {
            this.readTag();
        }
    }

    public boolean checkForTag() throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.mp3_file, "r");
        if (randomAccessFile.length() < 129L) {
            return false;
        }
        long l = randomAccessFile.length() - 128L;
        randomAccessFile.seek(l);
        byte[] byArray = new byte[3];
        if (randomAccessFile.read(byArray, 0, 3) != 3) {
            throw new IOException("Read beyond end of file");
        }
        String string = new String(byArray, 0, 3, "Cp437");
        return string.equals("TAG");
    }

    private String fillWithNills(String string, int n) {
        if (string == null) {
            string = new String("");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = string.length() + 1;
        while (n2 <= n) {
            stringBuffer.append('\u0000');
            ++n2;
        }
        return stringBuffer.toString();
    }
}

