/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpOutputStream;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    protected static Hashtable connections = new Hashtable();
    protected HTTPConnection con;
    private String urlString;
    private String resource;
    private String method;
    private boolean method_set;
    private static NVPair[] default_headers = new NVPair[0];
    private NVPair[] headers;
    protected HTTPResponse resp;
    private boolean do_redir;
    private static Class redir_mod;
    private OutputStream output_stream;
    private static String non_proxy_hosts;
    private static String proxy_host;
    private static int proxy_port;
    private String[] hdr_keys;
    private String[] hdr_values;

    public HttpURLConnection(URL url) throws ProtocolNotSuppException, IOException {
        super(url);
        try {
            String hosts = System.getProperty("http.nonProxyHosts", "");
            if (!hosts.equalsIgnoreCase(non_proxy_hosts)) {
                connections.clear();
                non_proxy_hosts = hosts;
                String[] list = Util.splitProperty(hosts);
                int idx = 0;
                while (idx < list.length) {
                    HTTPConnection.dontProxyFor(list[idx]);
                    ++idx;
                }
            }
        }
        catch (ParseException pe) {
            throw new IOException(pe.toString());
        }
        catch (SecurityException securityException) {}
        try {
            String host = System.getProperty("http.proxyHost", "");
            int port = Integer.getInteger("http.proxyPort", -1);
            if (!host.equalsIgnoreCase(proxy_host) || port != proxy_port) {
                connections.clear();
                proxy_host = host;
                proxy_port = port;
                HTTPConnection.setProxyServer(host, port);
            }
        }
        catch (SecurityException securityException) {}
        this.con = this.getConnection(url);
        this.method = "GET";
        this.method_set = false;
        this.resource = url.getFile();
        this.headers = default_headers;
        this.do_redir = java.net.HttpURLConnection.getFollowRedirects();
        this.output_stream = null;
        this.urlString = url.toString();
    }

    protected HTTPConnection getConnection(URL url) throws ProtocolNotSuppException {
        String php = String.valueOf(url.getProtocol()) + ":" + url.getHost() + ":" + (url.getPort() != -1 ? url.getPort() : URI.defaultPort(url.getProtocol()));
        HTTPConnection con = (HTTPConnection)connections.get(php = php.toLowerCase());
        if (con != null) {
            return con;
        }
        con = new HTTPConnection(url);
        connections.put(php, con);
        return con;
    }

    public void setRequestMethod(String method) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Already connected!");
        }
        Log.write(128, "URLC:  (" + this.urlString + ") Setting request method: " + method);
        this.method = method.trim().toUpperCase();
        this.method_set = true;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public int getResponseCode() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        try {
            return this.resp.getStatusCode();
        }
        catch (ModuleException me) {
            throw new IOException(me.toString());
        }
    }

    public String getResponseMessage() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        try {
            return this.resp.getReasonLine();
        }
        catch (ModuleException me) {
            throw new IOException(me.toString());
        }
    }

    public String getHeaderField(String name) {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.resp.getHeader(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getHeaderFieldInt(String name, int def) {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.resp.getHeaderAsInt(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public long getHeaderFieldDate(String name, long def) {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.resp.getHeaderAsDate(name).getTime();
        }
        catch (Exception exception) {
            return def;
        }
    }

    public String getHeaderFieldKey(int n) {
        if (this.hdr_keys == null) {
            this.fill_hdr_arrays();
        }
        if (n >= 0 && n < this.hdr_keys.length) {
            return this.hdr_keys[n];
        }
        return null;
    }

    public String getHeaderField(int n) {
        if (this.hdr_values == null) {
            this.fill_hdr_arrays();
        }
        if (n >= 0 && n < this.hdr_values.length) {
            return this.hdr_values[n];
        }
        return null;
    }

    private void fill_hdr_arrays() {
        try {
            if (!this.connected) {
                this.connect();
            }
            int num = 1;
            Enumeration enumeration = this.resp.listHeaders();
            while (enumeration.hasMoreElements()) {
                ++num;
                enumeration.nextElement();
            }
            this.hdr_keys = new String[num];
            this.hdr_values = new String[num];
            enumeration = this.resp.listHeaders();
            int idx = 1;
            while (idx < num) {
                this.hdr_keys[idx] = (String)enumeration.nextElement();
                this.hdr_values[idx] = this.resp.getHeader(this.hdr_keys[idx]);
                ++idx;
            }
            this.hdr_values[0] = String.valueOf(this.resp.getVersion()) + " " + this.resp.getStatusCode() + " " + this.resp.getReasonLine();
        }
        catch (Exception exception) {
            this.hdr_values = new String[0];
            this.hdr_keys = this.hdr_values;
        }
    }

    public InputStream getInputStream() throws IOException {
        InputStream stream;
        if (!this.doInput) {
            throw new ProtocolException("Input not enabled! (use setDoInput(true))");
        }
        if (!this.connected) {
            this.connect();
        }
        try {
            stream = this.resp.getInputStream();
        }
        catch (ModuleException e) {
            throw new IOException(e.toString());
        }
        return stream;
    }

    public InputStream getErrorStream() {
        try {
            if (!this.doInput || !this.connected || this.resp.getStatusCode() < 300 || this.resp.getHeaderAsInt("Content-length") <= 0) {
                return null;
            }
            return this.resp.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.connected) {
            throw new ProtocolException("Already connected!");
        }
        if (!this.doOutput) {
            throw new ProtocolException("Output not enabled! (use setDoOutput(true))");
        }
        if (!this.method_set) {
            this.method = "POST";
        } else if (this.method.equals("HEAD") || this.method.equals("GET") || this.method.equals("TRACE")) {
            throw new ProtocolException("Method " + this.method + " does not support output!");
        }
        if (this.getRequestProperty("Content-type") == null) {
            this.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        }
        if (this.output_stream == null) {
            Log.write(128, "URLC:  (" + this.urlString + ") creating output stream");
            String cl = this.getRequestProperty("Content-Length");
            this.output_stream = cl != null ? new HttpOutputStream(Integer.parseInt(cl.trim())) : (this.getRequestProperty("Content-type").equals("application/x-www-form-urlencoded") ? new ByteArrayOutputStream(300) : new HttpOutputStream());
            if (this.output_stream instanceof HttpOutputStream) {
                this.connect();
            }
        }
        return this.output_stream;
    }

    public URL getURL() {
        if (this.connected) {
            try {
                return this.resp.getEffectiveURI().toURL();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.url;
    }

    public void setIfModifiedSince(long time) {
        super.setIfModifiedSince(time);
        this.setRequestProperty("If-Modified-Since", Util.httpDate(new Date(time)));
    }

    public void setRequestProperty(String name, String value) {
        Log.write(128, "URLC:  (" + this.urlString + ") Setting request property: " + name + " : " + value);
        int idx = 0;
        while (idx < this.headers.length) {
            if (this.headers[idx].getName().equalsIgnoreCase(name)) break;
            ++idx;
        }
        if (idx == this.headers.length) {
            this.headers = Util.resizeArray(this.headers, idx + 1);
        }
        this.headers[idx] = new NVPair(name, value);
    }

    public String getRequestProperty(String name) {
        int idx = 0;
        while (idx < this.headers.length) {
            if (this.headers[idx].getName().equalsIgnoreCase(name)) {
                return this.headers[idx].getValue();
            }
            ++idx;
        }
        return null;
    }

    public static void setDefaultRequestProperty(String name, String value) {
        Log.write(128, "URLC:  Setting default request property: " + name + " : " + value);
        int idx = 0;
        while (idx < default_headers.length) {
            if (default_headers[idx].getName().equalsIgnoreCase(name)) break;
            ++idx;
        }
        if (idx == default_headers.length) {
            default_headers = Util.resizeArray(default_headers, idx + 1);
        }
        HttpURLConnection.default_headers[idx] = new NVPair(name, value);
    }

    public static String getDefaultRequestProperty(String name) {
        int idx = 0;
        while (idx < default_headers.length) {
            if (default_headers[idx].getName().equalsIgnoreCase(name)) {
                return default_headers[idx].getValue();
            }
            ++idx;
        }
        return null;
    }

    public void setInstanceFollowRedirects(boolean set) {
        if (this.connected) {
            throw new IllegalStateException("Already connected!");
        }
        this.do_redir = set;
    }

    public boolean getInstanceFollowRedirects() {
        return this.do_redir;
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        Log.write(128, "URLC:  (" + this.urlString + ") Connecting ...");
        HTTPConnection hTTPConnection = this.con;
        synchronized (hTTPConnection) {
            this.con.setAllowUserInteraction(this.allowUserInteraction);
            if (this.do_redir) {
                this.con.addModule(redir_mod, 2);
            } else {
                this.con.removeModule(redir_mod);
            }
            try {
                this.resp = this.output_stream instanceof ByteArrayOutputStream ? this.con.ExtensionMethod(this.method, this.resource, ((ByteArrayOutputStream)this.output_stream).toByteArray(), this.headers) : this.con.ExtensionMethod(this.method, this.resource, (HttpOutputStream)this.output_stream, this.headers);
            }
            catch (ModuleException e) {
                throw new IOException(e.toString());
            }
        }
        this.connected = true;
    }

    public void disconnect() {
        Log.write(128, "URLC:  (" + this.urlString + ") Disconnecting ...");
        this.con.stop();
    }

    public boolean usingProxy() {
        return this.con.getProxyHost() != null;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.url + "]";
    }

    static {
        try {
            if (Boolean.getBoolean("HTTPClient.HttpURLConnection.AllowUI")) {
                URLConnection.setDefaultAllowUserInteraction(true);
            }
        }
        catch (SecurityException securityException) {}
        try {
            redir_mod = Class.forName("HTTPClient.RedirectionModule");
        }
        catch (ClassNotFoundException cnfe) {
            throw new NoClassDefFoundError(cnfe.getMessage());
        }
        try {
            String agent = System.getProperty("http.agent");
            if (agent != null) {
                HttpURLConnection.setDefaultRequestProperty("User-Agent", agent);
            }
        }
        catch (SecurityException securityException) {}
        non_proxy_hosts = "";
        proxy_host = "";
        proxy_port = -1;
    }
}

