/*
 * Decompiled with CFR 0.152.
 */
package ziga.gui;

import java.io.File;
import xnap.XNap;
import xnap.gui.XNapFrame;

public class WindowsDesktopIndicator {
    private XNapFrame frame;
    private int handler = 0;
    private int image = -1;

    public void exitApplication() {
        this.frame.doExit();
    }

    protected void finalize() {
        this.freeImage();
        this.nativeDisable();
    }

    protected void freeImage() {
        if (this.image != -1) {
            WindowsDesktopIndicator.nativeFreeImage(this.image);
        }
    }

    public String getString(String string) {
        if (string.equals("desktopIndicator.exit")) {
            return XNap.tr((String)"Exit");
        }
        if (string.equals("desktopIndicator.hide")) {
            return XNap.tr((String)"Hide XNap");
        }
        if (string.equals("desktopIndicator.show")) {
            return XNap.tr((String)"Show XNap");
        }
        return "";
    }

    public void hideFrame() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    public int isFrameVisible() {
        if (this.frame != null) {
            return this.frame.isVisible() ? 1 : 0;
        }
        return 0;
    }

    public void hide() {
        this.nativeHide();
    }

    public void load(String string, String string2) {
        File file = new File(string);
        if (file.exists()) {
            this.freeImage();
            this.image = WindowsDesktopIndicator.nativeLoadImage(file.getPath());
            this.show(string2);
            this.hide();
        }
    }

    public void show(String string) {
        if (this.image != -1) {
            this.nativeEnable(this.image, string);
        }
    }

    public void showFrame() {
        if (this.frame != null) {
            this.hide();
            this.frame.setVisible(true);
            this.frame.setState(0);
            this.frame.toFront();
            this.frame.requestFocus();
        }
    }

    private final synchronized native void nativeDisable();

    private final synchronized native void nativeEnable(int var1, String var2);

    private static final synchronized native void nativeFreeImage(int var0);

    private static final synchronized native int nativeLoadImage(String var0);

    private static final synchronized native int nativeLoadImageFromResource(int var0);

    private final synchronized native void nativeHide();

    public WindowsDesktopIndicator(XNapFrame xNapFrame) {
        this.frame = xNapFrame;
    }
}

