/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.cmdl;

import xnap.*;
import xnap.net.*;
import xnap.plugin.*;
import xnap.util.*;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

import java.io.*;
import java.net.*;
import java.util.*;

public class CommandLine implements CommandLineSupport, ListListener {

    //--- Data Field(s) ---

    private static Console console = Console.getInstance();
    private static ReadlineConsole icRLC = new ReadlineConsole();
    static {
	// make sure this is set before anybody starts installing
	// commands
	console.setConsole(icRLC);
    }
    private static Preferences prefs = Preferences.getInstance();
    private String[] args;
    private AbstractCommand[] commands = {
	new ExitCmd()
    };

    //--- Constructor(s) ---
    
    public  CommandLine(String[] args)
    {
	this.args = args;
    }
    
    public void run() 
    {		
	init();

	boolean ret = true;
	while (ret) {
	    String cmd = console.readln("XNap> ");
	    ret = Executer.parseCommand(cmd);
	}

	exit();
    }

    /**
     * Starts the command line.
     */
    public void init()
    {
	Executer.installHandler(this);

	String msg
            = "XNap " + XNap.VERSION + " (http://xnap.sourceforge.net).\n\n"
	    + "XNap comes with ABSOLUTELY NO WARRANTY; for details "
	    + "type 'readme'.\n"
	    + "This is free software, and you are welcome to redistribute it\n"
	    + "under certain conditions; type 'license' for details.\n\n"
	    + "Ready (h for help, q to exit)\n";
	console.println(msg);

	SearchManager.getInstance().addListListener(this);

	Updater.start();
	PluginManager.getInstance().enablePlugins(prefs.getEnabledPlugins());
    }

    public void elementAdded(ListEvent e)
    {
	ISearchContainer sc = (ISearchContainer)e.getElement();
	SearchResultCollector srCollector 
	    = new SearchResultCollector(sc.getDefaultGrouper());
	sc.setCollector(srCollector);
	sc.start();
    }

    public void elementRemoved(ListEvent e)
    {
    }

    public void exit()
    {
	icRLC.saveSettings();

	prefs.setEnabledPlugins(PluginManager.getInstance().disablePlugins());

	prefs.write();

	System.exit (0);
    }


    public AbstractCommand[] getCommands()
    {
	return commands;
    }

    protected class ExitCmd extends AbstractCommand
    {
	public ExitCmd()
	{
	    putValue(CMD, new String[] {"exit", "quit", "q"});
	    putValue(SHORT_HELP, "Exits the application.");
	}
	
	public boolean execute(String[] argv)
	{
	    exit();
	    return true;
	}
    }

}
