/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.*;
import xnap.cmdl.*;
import xnap.util.*;
import xnap.util.event.*;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;

public class ConsoleDialog extends DefaultDialog implements IConsole {
    
    //--- Data field(s) ---

    private static ConsoleDialog me = new ConsoleDialog();
	
    private JTabbedPane jtp;
    private ConsolePane cpConsole;
    private ConsolePane cpError;
    private DebugPanel jpDebug;

    //--- Constructor(s) ---
    
    private ConsoleDialog() 
    {
	super(BUTTON_APPLY);

        setTitle(XNap.tr("XNap Console"));
	setModal(false);

	jtp = new JTabbedPane();
	getMainPanel().setLayout(new BorderLayout());
	getMainPanel().add(jtp, BorderLayout.CENTER);

	// console
	cpConsole = new ConsolePane();
	jtp.addTab(XNap.tr("Console"), cpConsole);

	// debug
	jpDebug = new DebugPanel();
	jtp.addTab(XNap.tr("Debug"), jpDebug);

	// error.log
	cpError = new ConsolePane(false);
	jtp.addTab("error.log", cpError);
	
	// button
        JButton jbHide = new JButton(new HideAction());
	getButtonPanel().add(jbHide);

	setSize(600, 400);
    }

    // --- Methods ---

    public static ConsoleDialog getInstance()
    {
	return me;
    }

    public void apply()
    {
	jpDebug.apply();
    }

    public boolean isEchoing()
    {
	return false;
    }

    public static void showDialog(Component c, boolean showErrorLog)
    {
	if (c != null) {
	    me.setLocationRelativeTo(c);
	}

	me.updateErrorLog();
	if (showErrorLog) {
	    me.jtp.setSelectedComponent(me.cpError);
	}

	me.setVisible(true);
    }

    public static void showDialog(Component c)
    {
	showDialog(c, false);
    }

    public void printLine(String text)
    {
	cpConsole.appendLater(text);
    }

    public String readLine(String prompt)
    {
	return null;
    }

    public Completer getCompleter() 
    {
	return null;
    }

    public void updateErrorLog()
    {
	File f = Debug.getErrorFile();

	if (f == null)
	    return;

	StringBuffer sb = new StringBuffer();

	try {
	    BufferedReader in = new BufferedReader(new FileReader(f));
			
	    while (in.ready()) {
		sb.append(in.readLine() + "\n");

	    }
	}
	catch(IOException io) {
	}

	cpError.setText(sb.toString());
    }

    /**
     * Handles the hide button.
     */
    private class HideAction extends AbstractAction {

        public HideAction() 
	{
	    putValue(Action.NAME, XNap.tr("Hide"));
	    putValue(Action.SHORT_DESCRIPTION, XNap.tr("Hides this dialog."));
	}
	
        public void actionPerformed(ActionEvent event) 
	{
	    setVisible(false);
        }
	
    }

}
