/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.XNap;
import xnap.gui.util.GUIHelper;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import org.apache.log4j.Logger;

public class DefaultDialog extends JDialog 
{

    //--- Constant(s) ---

    public static int BUTTON_NONE = 0;
    public static int BUTTON_OKAY = 1;
    public static int BUTTON_APPLY = 2;
    public static int BUTTON_CANCEL = 4;
    public static int BUTTON_CLOSE = 8;

    //--- Data field(s) ---

    //protected static Logger logger = Logger.getLogger(DefaultDialog.class);

    protected ApplyAction acApply = new ApplyAction();
    protected CancelAction acCancel = new CancelAction();
    protected CloseAction acClose = new CloseAction();
    protected OkayAction acOkay = new OkayAction();
    protected boolean isOkay = false;
    protected JPanel jpButtons;
    protected JPanel jpMain;

    //--- Constructor(s) ---

    public DefaultDialog(int buttons, JComponent component, 
			 boolean exitOnEnter)
    {
	jpMain = new JPanel();

	if (component != null) {
	    setMainComponent(component);
	}

	jpButtons = new JPanel(new FlowLayout(FlowLayout.RIGHT));

	if ((buttons & BUTTON_OKAY) > 0) {
	    JButton jbOkay = new JButton(acOkay);
	    if (exitOnEnter) {
		GUIHelper.bindToKey(jbOkay,
				    KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,
							   0),
				    "okay");
	    }
	    jpButtons.add(jbOkay);
	}
	if ((buttons & BUTTON_CLOSE) > 0) {
	    jpButtons.add(new JButton(acClose));
	}
	if ((buttons & BUTTON_APPLY) > 0) {
	    jpButtons.add(new JButton(acApply));
	}
	if ((buttons & BUTTON_CANCEL) > 0) {
	    JButton jbCancel = new JButton(acCancel);
	    GUIHelper.bindToKey(jbCancel, 
				KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), 
				"cancel");
	    jpButtons.add(jbCancel);
	}

	JPanel jpFrame = new JPanel(new BorderLayout());
	jpFrame.setBorder(new EmptyBorder(5, 5, 5, 5));
	jpFrame.add(jpMain, BorderLayout.CENTER);
	jpFrame.add(jpButtons, BorderLayout.SOUTH);

	getContentPane().setLayout(new BorderLayout());
	getContentPane().add(jpFrame, BorderLayout.CENTER);

	setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new CloseListener());

	if (component != null) {
	    pack();
	}
    }

    public DefaultDialog(int buttons, JComponent component)
    {
	this(buttons, component, true);
    }

    public DefaultDialog(int buttons)
    {
	this(buttons, null);
    }
    
    public DefaultDialog(int buttons, boolean exitOnEnter)
    {
	this(buttons, null, exitOnEnter);
    }

    public DefaultDialog()
    {
	this(BUTTON_OKAY | BUTTON_CANCEL);
    }

    //--- Method(s) ---

    /**
     * Dialog is closed, if true is returned.
     */
    public void apply()
    {
    }

    public void close()
    {
	dispose();
    }

    public JPanel getButtonPanel()
    {
	return jpButtons;
    }

    public void setMainComponent(Component component)
    {
	getMainPanel().setLayout(new BorderLayout());
	getMainPanel().add(component, BorderLayout.CENTER);
    }
    
    public JPanel getMainPanel()
    {
	return jpMain;
    }

    public boolean isOkay()
    {
	return isOkay;
    }

    public void show(Component c)
    {
	if (c != null) {
	    setLocationRelativeTo(c);
	}
	show();
    }

    /**
     * Handles the apply button.
     */
    private class ApplyAction extends AbstractAction {

        public ApplyAction() 
	{
	    putValue(Action.NAME, XNap.tr("Apply"));
	    putValue(Action.SHORT_DESCRIPTION, XNap.tr("Applies changes."));
	}
	
        public void actionPerformed(ActionEvent event) 
	{
	    try {
		apply();
	    }
	    catch (IllegalArgumentException e) {
		JOptionPane.showMessageDialog
		    (DefaultDialog.this, e.getMessage(), 
		     XNap.tr("Illegal Value"), JOptionPane.ERROR_MESSAGE);
	    }
        }
	
    }

    /**
     * Handles the Cancel button.
     */
    private class CancelAction extends AbstractAction {

        public CancelAction()
	{
            putValue(Action.NAME, XNap.tr("Cancel"));
            putValue(Action.SHORT_DESCRIPTION, XNap.tr("Closes the dialog without saving changes."));
	}

        public void actionPerformed(ActionEvent event) 
	{
	    close();
	}
	
    }

    /**
     * Handle the Close button.
     */
    private class CloseAction extends AbstractAction {

        public CloseAction() 
	{
	    putValue(Action.NAME, XNap.tr("Close"));
	    putValue(Action.SHORT_DESCRIPTION, XNap.tr("Closes the dialog."));
	}
	
        public void actionPerformed(ActionEvent event) 
	{
	    close();
        }
	
    }

    /**
     * Handle the Okay button.
     */
    private class OkayAction extends AbstractAction {

        public OkayAction() 
	{
	    putValue(Action.NAME, XNap.tr("OK"));
	    putValue(Action.SHORT_DESCRIPTION, XNap.tr("Closes the dialog saving changes."));
	    putValue(Action.MNEMONIC_KEY, new Integer('O'));
	}
	
        public void actionPerformed(ActionEvent event) 
	{
	    try {
		apply();
		isOkay = true;
		close();
	    }
	    catch (IllegalArgumentException e) {
		JOptionPane.showMessageDialog
		    (DefaultDialog.this, e.getMessage(), 
		     XNap.tr("Illegal Value"), JOptionPane.ERROR_MESSAGE);
	    }
        }
	
    }

    private class CloseListener extends WindowAdapter
    {
	public void windowClosing (java.awt.event.WindowEvent evt) 
	{
	    close();
	}
    }

}
