/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.XNap;
import xnap.util.*;

import xnap.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;


public class FeedbackDialog extends JDialog
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    private static FeedbackDialog me = null;
    private static Preferences prefs = Preferences.getInstance();

    private JTextArea jtaInfo;
    private JTextField jtName;
    private JTextField jtEmail;
    private JTextField jtSubject;
    private JTextArea jtaText;
    private JCheckBox jcbIncErrorLog;

    private SendAction acSend = new SendAction();
    private CancelAction acCancel = new CancelAction();
    //--- Constructor(s) ---

    private FeedbackDialog() 
    {
	String intro = new String(XNap.tr("Feedback is very important to us. Please take a minute and send criticism, questions or everything else you think is important. Please don't forget to include your name and email address if you would like to get a reply! We understand English, German and some French.") + 
  "\n" + "(" + XNap.tr("Note, if you have a bug report or feature request, please consider using the tracker facilities at SourceForge (http://sourceforge.net/projects/xnap/) instead!") + ")");

	// info
        jtaInfo = new MultiLineLabel(intro);

	// text
	JPanel jpText = new JPanel(new GridBagLayout());

	GridBagHelper.addLabel(jpText, XNap.tr("Subject"));
	jtSubject = new JTextField(20);
	GridBagHelper.add(jpText, jtSubject);
	
	GridBagHelper.addLabel(jpText, XNap.tr("Feedback"));
        jtaText = new JTextArea(getSystemInfo(), 12, 40);
        jtaText.setLineWrap(true);
        jtaText.setWrapStyleWord(true);
        jtaText.setEditable (true);
	jtaText.setBorder(new EmptyBorder(5, 5, 5, 5));
	JScrollPane jspText = new JScrollPane(jtaText);
        GridBagHelper.addPanel(jpText, jspText);

	GridBagHelper.addLabel(jpText, XNap.tr("Your Name"));
        jtName = new JTextField(20);
        GridBagHelper.add(jpText, jtName);

	GridBagHelper.addLabel(jpText, XNap.tr("Your Email"));
        jtEmail = new JTextField(20);
        GridBagHelper.add(jpText, jtEmail);

	GridBagHelper.addLabel(jpText, "");
	String s = XNap.tr("Include error.log") + " (" +
	    Formatter.formatSize(Debug.getErrorFileSize()) + ")";
        jcbIncErrorLog = new JCheckBox(s, (Debug.getErrorFileSize() > 0));
        GridBagHelper.add(jpText, jcbIncErrorLog);

	/* button panel */
        JPanel jpButtons = new JPanel(new FlowLayout(FlowLayout.RIGHT));

	jpButtons.add(new JButton(new ErrorLogAction()));
	jpButtons.add(new JButton(acSend));
	jpButtons.add(new JButton(acCancel));

	/* content */
        setTitle(XNap.tr("Feedback"));

	setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
	addWindowListener(new CloseListener());

	getContentPane().setLayout(new GridBagLayout());
	GridBagHelper.add(getContentPane(), jtaInfo);
	GridBagHelper.addPanel(getContentPane(), jpText);
	GridBagHelper.add(getContentPane(), jpButtons);

	if (prefs.getRememberFeedback()) {
	    jtEmail.setText(prefs.getFeedbackEmail());
	    jtName.setText(prefs.getFeedbackName());
	}

        pack();

	jtSubject.grabFocus();
    }

    //--- Method(s) ---

    public static String getSystemInfo()
    {
	Properties p = System.getProperties();
	StringBuffer sb = new StringBuffer();
	sb.append("XNap ");
	sb.append(XNap.VERSION);
	sb.append(" (");
	sb.append(Locale.getDefault());
	sb.append(")\nOS : ");
	sb.append(p.get("os.name"));
	sb.append(" ");
	sb.append(p.get("os.version"));
	sb.append(" (");
	sb.append(p.get("os.arch"));
	sb.append(")\nJRE: ");
	sb.append(p.get("java.vendor"));
	sb.append(" ");
	sb.append(p.get("java.version"));
	sb.append("\n");

	return sb.toString();
    }

    public static void showDialog(Component c)
    {
	if (me == null) {
	    me = new FeedbackDialog();
	    if (c != null)
		me.setLocationRelativeTo(c);
	}
	me.show();
    }

    private class ErrorLogAction extends AbstractAction {

        public ErrorLogAction() {
            putValue(Action.NAME, XNap.tr("Show error.log"));
            putValue(Action.SHORT_DESCRIPTION,
		     XNap.tr("Opens the console dialog and shows the error.log"));
	    //putValue(Action.SMALL_ICON, XNap.getIcon("eraser.png"));
            putValue(Action.MNEMONIC_KEY, new Integer(KeyEvent.VK_E));
        }

        public void actionPerformed(ActionEvent event) {
	    ConsoleDialog.showDialog(FeedbackDialog.this, true);
	}

    }

    private class SendAction extends AbstractAction {

        public SendAction() {
            putValue(Action.NAME, XNap.tr("Send"));
            putValue(Action.SHORT_DESCRIPTION, 
		     XNap.tr("Sends your feedback to the XNap team. :-)"));
	    //putValue(Action.SMALL_ICON, XNap.getIcon("eraser.png"));
            putValue(Action.MNEMONIC_KEY, new Integer(KeyEvent.VK_S));
        }

        public void actionPerformed(ActionEvent event) 
	{
	    if (jtaText.getText().trim().length() == 0) {
		JOptionPane.showMessageDialog
		    (FeedbackDialog.this, XNap.tr("Can not send empty Feedback"),
		     XNap.tr("Send Feedback"), JOptionPane.ERROR_MESSAGE);
		return;
	    }

	    if (jtEmail.getText().trim().length() == 0) {
		Object[] message = new Object[] {
		    XNap.tr("You did not provide an Email address. "),
		    XNap.tr("We will not be able to answer. "),
		    XNap.tr("Really send feedback?")
		};
		int response = JOptionPane.showConfirmDialog
		    (FeedbackDialog.this, message, XNap.tr("Send Feedback"), 
		     JOptionPane.YES_NO_OPTION);

		if (response == JOptionPane.NO_OPTION) {
		    return;
		}
	    }
	
	    Thread t = new Thread(new SendWorker(), "SendFeedback");
	    t.start();
        }

    }

    private class CancelAction extends AbstractAction {

        public CancelAction() {
            putValue(Action.NAME, XNap.tr("Cancel"));
            putValue(Action.SHORT_DESCRIPTION, 
		     XNap.tr("Closes the dialog without sending feedback. :-("));
	    //putValue(Action.SMALL_ICON, XNap.getIcon("eraser.png"));
            putValue(Action.MNEMONIC_KEY, new Integer(KeyEvent.VK_C));
        }

        public void actionPerformed(ActionEvent event) {
	    dispose();
	    me = null;
	}

    }

    private class CloseListener extends WindowAdapter
    {
	public void windowClosing (java.awt.event.WindowEvent evt) {
	    dispose();
	    me = null;
	}
    }

    private class SendWorker implements Runnable {

	public void run()
	{
	    acSend.setEnabled(false);
	    acCancel.setEnabled(false);

	    setTitle(XNap.tr("Sending feedback..."));

	    if (prefs.getRememberFeedback()) {
		prefs.setFeedbackEmail(jtEmail.getText());
		prefs.setFeedbackName(jtName.getText());
	    }

	    String subject = URLEncoder.encode(jtSubject.getText().trim());
	    String name = URLEncoder.encode(jtName.getText().trim());
	    String email = URLEncoder.encode(jtEmail.getText().trim());
	    String msg = jtaText.getText().trim();
	    if (jcbIncErrorLog.isSelected() 
		&& Debug.getErrorFile() != null 
		&& Debug.getErrorFile().length() > 0) {
		try {
		    BufferedReader in = 
			new BufferedReader
			    (new FileReader(Debug.getErrorFile()));
			
		    msg += "\n\nerror.log:\n";
		    while (in.ready())
			msg += in.readLine() + "\n";
		}
		catch(Exception e) {
		}
	    }
	    msg = URLEncoder.encode(msg);

	    StringBuffer sb = new StringBuffer();
	    sb.append(prefs.getFeeedbackURL());
	    sb.append("?noresponse=1");
	    sb.append("&from=" + email);
	    sb.append("&subject=" + subject);
	    sb.append("&name=" + name);
	    sb.append("&message=" + msg);
	    String location = sb.toString();

	    boolean failed = false;
	    String response = "";
	    try {
		URL url = new URL(location);
		url.getContent();
	    }
	    catch(Exception e) {
		response = e.getMessage();
		failed = true;
	    }

	    if (failed) {
		JOptionPane.showMessageDialog
		    (FeedbackDialog.this, XNap.tr("Could not send feedback.") 
		     + response + ").", XNap.tr("Feedback"), 
		     JOptionPane.ERROR_MESSAGE);

		setTitle(XNap.tr("Feedback"));
	    }
	    else {
		JOptionPane.showMessageDialog
		    (FeedbackDialog.this, XNap.tr("Thank you."),
		     XNap.tr("Feedback"), 
		     JOptionPane.INFORMATION_MESSAGE);
			    
		dispose();
		me = null;
	    }

	    acSend.setEnabled(true);
	    acCancel.setEnabled(true);
	}
    }

}
