/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.XNap;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

import org.apache.log4j.Logger;

public class HistoryTextField extends JTextField
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    protected LinkedList history = new LinkedList();
    protected LinkedList future = new LinkedList();
    
    private static Logger logger = Logger.getLogger(HistoryTextField.class);
    
    //--- Constructor(s) ---
    
    public HistoryTextField(String text, int size)
    {
	super(text, size);

	addKeyListener(new KeyHandler());
    }

    //--- Method(s) ---
    
    //--- Inner Class(es) ---
    
    protected class KeyHandler extends KeyAdapter
    {
	public void keyPressed(KeyEvent e)
	{
	    int code = e.getKeyCode();
	    int modifiers = e.getModifiers();
	    
	    /* ENTER event: add item to history */
	    if (code == KeyEvent.VK_ENTER && getText().length() > 0) {
		/* if the user presses enter after an old history entry */
		if (future.size() > 0) {
		    history.addAll(future);
		    future.clear();
		}
		history.addLast(getText());
	    }
	    /* go back in history */
	    else if ((code == KeyEvent.VK_P 
		      && modifiers == InputEvent.CTRL_MASK) 
		     || code == KeyEvent.VK_UP) {
		if (history.size() > 0) {
		    if (getText().length() > 0) {
			future.addFirst(getText());
		    }
		    setText((String)history.removeLast());
		}
		else {
		    getToolkit().beep();
		}
	    }
	    /* go forward in history */
	    else if ((code == KeyEvent.VK_N
		     && modifiers == InputEvent.CTRL_MASK)
		     || code == KeyEvent.VK_DOWN) {
		if (future.size() > 0) {
		    if (getText().length() > 0) {
			history.addLast(getText());
		    }
		    setText((String)future.removeFirst());
		}
		else if (getText().length() > 0) {
		    history.addLast(getText());
		    setText("");
		}
		else {
		    getToolkit().beep();
		}
	    }
	    /* go to beginning of history */
	    else if ((code == KeyEvent.VK_LESS 
		      && modifiers == InputEvent.ALT_MASK)
		     || (code == KeyEvent.VK_HOME 
			 && modifiers == InputEvent.CTRL_MASK)) {
		if (history.size() > 0) {
		    if (getText().length() > 0) {
			history.addLast(getText());
		    }
		    future.addAll(0, history);
		    history.clear();
		    setText((String)future.removeFirst());
		}
		else {
		    getToolkit().beep();
		}
	    }
	    /* go to the end of future */
	    else if ((code == KeyEvent.VK_LESS && modifiers 
		      == InputEvent.ALT_MASK + InputEvent.SHIFT_MASK)
		     || (code == KeyEvent.VK_END
			 && modifiers == InputEvent.CTRL_MASK)) {
		if (future.size() > 0) {
		    if (getText().length() > 0) {
			future.addFirst(getText());
		    }
		    history.addAll(future);
		    future.clear();
		    setText("");
		}
		else if (getText().length() > 0) {
		    history.addLast(getText());
		    setText("");
		}
		else {
		    getToolkit().beep();
		}
	    }
	}
    }
}
