/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.util.Debug;

import java.awt.*;
import java.awt.event.*;
import java.io.File;
import javax.swing.*;

public abstract class ViewerPanel extends JPanel {

    //--- Constant(s) ---

    //--- Data field(s) ---

    /**
     * Child classes should set this to true, once finished reading the file.
     */
    protected boolean finished = false;

    /**
     * File that is currently displayed by panel.
     */
    private File file = null;

    /**
     * User status message.
     */
    private String status = null;

    //--- Constructor(s) ---

    public ViewerPanel(File file)
    {
	this.file = file;
    }

    public ViewerPanel()
    {
    }

    //--- Method(s) ---

    public File getFile()
    {
	return file;
    }

    public void setFile(File newValue)
    {
	file = newValue;
	finished = false;
	status = null;
    }

    public String getStatus()
    {
	if (status != null) {
	    return status;
	}
	else if (file != null) {
	    if (!finished) {
		return "Loading " + file.getName();
	    }
	    else {
		return "Finished loading " + file.getName();
	    }
	}

	return "";
    }

    public void setStatus(String newValue)
    {
	status = newValue;
    }

    /**
     * 
     */
    public abstract void display();

}
