/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.action;

import xnap.XNap;
import xnap.gui.XNapFrame;
import xnap.net.IUser;

import javax.swing.*;
import javax.swing.text.*;

public class ActionHelper
{
    
    //--- Constant(s) ---

    public static Action copyAction;
    static {
	copyAction = new DefaultEditorKit.CopyAction();
	copyAction.putValue(Action.NAME, XNap.tr("Copy"));
	copyAction.putValue(Action.SHORT_DESCRIPTION, 
			    XNap.tr("Copies selected text to clipboard."));
	copyAction.putValue(Action.SMALL_ICON, 
			    XNapFrame.getIcon("editcopy.png"));
    }
    public static Action cutAction;
    static {
	cutAction = new DefaultEditorKit.CutAction();
	cutAction.putValue(Action.NAME, XNap.tr("Cut"));
	cutAction.putValue(Action.SHORT_DESCRIPTION, 
			    XNap.tr("Moves selected text to clipboard."));
	cutAction.putValue(Action.SMALL_ICON, 
			    XNapFrame.getIcon("editcut.png"));
    }
    public static Action pasteAction;
    static {
	pasteAction = new DefaultEditorKit.PasteAction();
	pasteAction.putValue(Action.NAME, XNap.tr("Paste"));
	pasteAction.putValue(Action.SHORT_DESCRIPTION, 
			    XNap.tr("Pastes clipboard contents."));
	pasteAction.putValue(Action.SMALL_ICON, 
			    XNapFrame.getIcon("editpaste.png"));
    }
    
    //--- Data field(s) ---
    
    //--- Constructor(s) ---

    //--- Method(s) ---

    public static boolean shouldEnable(IUser[] users, Class actionClass) 
    {
	boolean isSupported = false;

	for (int i = 0; i < users.length; i++) {
	    isSupported |= users[i].isActionSupported(actionClass);
	}

	return isSupported;
    }

}

