/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.action;

import xnap.XNap;
import xnap.gui.UserEditorDialog;
import xnap.gui.XNapFrame;
import xnap.net.IUser;
import xnap.util.SearchManager;

import java.awt.event.*;
import javax.swing.*;

public class AddToHotlistAction extends AbstractAction 
{
    
    //--- Constant(s) ---
    
    //--- Data field(s) ---
    
    private IUser[] users;

    //--- Constructor(s) ---

    public AddToHotlistAction(IUser[] users)
    {
	this.users = users;

	putValue(Action.NAME, XNap.tr("Add to Hotlist"));
	putValue(Action.SHORT_DESCRIPTION, XNap.tr("Add selected users"));
	putValue(Action.SMALL_ICON, XNapFrame.getIcon("edit_add.png"));
	putValue(Action.MNEMONIC_KEY, new Integer('A'));
    }

    //--- Method(s) ---

    public void actionPerformed(ActionEvent event)
    {
	for (int i = 0; i < users.length; i++) {
	    users[i].setCategory(XNap.tr("Hotlist"));
	    users[i].setTemporary(false);
	}
    }

}

