/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.action;

import xnap.XNap;
import xnap.gui.XNapFrame;

import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * All calls need to be swing synchronized.
 */
public class FileActionManager {
    
    //--- Constant(s) ---

    public static final int ACTION_DO_NOTHING = 0;
    public static final int ACTION_COPY = 1;
    public static final int ACTION_MOVE = 2;

    //--- Data field(s) ---

    private static int action = 0;
    private static File[] files = null;
    private static LinkedList pasteActions = new LinkedList();

    //--- Constructor(s) ---

    //--- Method(s) ---

    public static void addPasteListener(PasteFileAction action)
    {
	pasteActions.add(action);
	action.setEnabled(getFiles() != null);
    }

    public static int getAction()
    {
	return action;
    }

    public static File[] getFiles()
    {
	return files;
    }

    public static void setFiles(File[] files, int action)
    {
	FileActionManager.files = files;
	FileActionManager.action = action;

	for (Iterator i = pasteActions.iterator(); i.hasNext();) {
	    ((PasteFileAction)i.next()).setEnabled(files != null);
	}
    }

    public static void unsetFiles()
    {
	setFiles(null, ACTION_DO_NOTHING);
    }

}





