/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.event;

import xnap.gui.XNapFrame;
import xnap.gui.event.MouseDragAdapter;

import org.apache.log4j.Logger;

import java.awt.*;
import java.awt.event.*;
import java.awt.dnd.*;
import java.awt.datatransfer.*;
import java.io.*;

import javax.swing.*;
import javax.swing.table.*;

public class DragFilesSupport 
    implements DragSourceListener, DragGestureListener
{
    //--- Constant(s) ---
    
    //--- Data field(s) ---

    protected DragSource dragSource = DragSource.getDefaultDragSource();
    protected FileCollector fc;

    private static Logger logger = Logger.getLogger(DragFilesSupport.class);

    //--- Constructor(s) ---
    
    /**
     * Constructs a new DragFilesSupport.
     */
    public DragFilesSupport(Component c, FileCollector fc)
    {
	this.fc = fc;
	DragGestureRecognizer dgr = new MouseDragAdapter
	    (dragSource, c, DnDConstants.ACTION_MOVE, this);
	// FIX ME: what does the next line do?
	// according to the java source, nothing
	//dgr.setSourceActions(dgr.getSourceActions() & ~InputEvent.BUTTON3_MASK);
    }
    
    //--- Method(s) ---

    public void dragDropEnd(DragSourceDropEvent event)
    {

    }

    public void dragEnter(DragSourceDragEvent event)
    {

    }

    public void dragExit(DragSourceEvent event)
    {

    }
    
    public void dragOver(DragSourceDragEvent event)
    {

    }

    public void dropActionChanged(DragSourceDragEvent event)
    {

    }

    public void dragGestureRecognized(DragGestureEvent event)
    {
	File files[] = fc.getFiles();
	
	if (files == null || files.length == 0)
	    return;
	
	TransferableFile t = new TransferableFile(files);

	try {
	    dragSource.startDrag(event, DragSource.DefaultMoveDrop, t, this);
	}
	catch (InvalidDnDOperationException ie) {
	    logger.debug("drag failed", ie);
	}
    }
}
