/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class AdvancedTransferPrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private JCheckBox jcbAutoResumeDownloads;

    private JCheckBox jcbLogTransfers;
    private FilePanel fpTransferLogFile;

    //--- Constructor(s) ---

    public AdvancedTransferPrefsPanel()
    {
	setLayout(new GridBagLayout());

	// auto resume
	jcbAutoResumeDownloads = new JCheckBox
            (XNap.tr("Resume downloads at startup", 1), 
	     prefs.getAutoResumeDownloads());
	GridBagHelper.add(this, jcbAutoResumeDownloads);

	// limit number of shared files per server
	JPanel jpLogTransfers = new JPanel(new GridBagLayout());
	jpLogTransfers.setBorder
	    (new TitledBorder(XNap.tr("Logging", 1)));
	GridBagHelper.add(this, jpLogTransfers);

	fpTransferLogFile = new FilePanel(prefs.getTransferLogFile(), 20);
	EnableAction ac 
	    = new EnableAction(XNap.tr("Log Transfers To File"), 
			       new Component[] { fpTransferLogFile }, 
			       prefs.getLogTransfersToFile());
	jcbLogTransfers = ac.getCheckBox();

	GridBagHelper.add(jpLogTransfers, jcbLogTransfers);
	GridBagHelper.add(jpLogTransfers, fpTransferLogFile);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	prefs.setAutoResumeDownloads(jcbAutoResumeDownloads.isSelected());

	prefs.setLogTransfersToFile(jcbLogTransfers.isSelected());
	prefs.setTransferLogFile(fpTransferLogFile.getFilename());
    }

    public Icon getIcon()
    {
	return XNapFrame.getIcon("connect_established.png");
    }

    public String getTitle()
    {
	return XNap.tr("Advanced");
    }

}
