/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.*;
import xnap.gui.text.EmacsKeyBindings;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class ApplicationPrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private JCheckBox jcShowIcons;
    private JCheckBox jcShowSplash;
    private JCheckBox jcShowTooltips;

    private ValidatedTextField jteMaxConsoleLines;
    private ValidatedTextField jteHistorySize;

    private JRadioButton jrbFocusAlways;
    private JRadioButton jrbFocusNever;

    //--- Constructor(s) ---

    public ApplicationPrefsPanel()
    {
		setLayout(new GridBagLayout());

        jcShowSplash = new JCheckBox(XNap.tr("Show Splash Screen",1),
                                     prefs.getShowSplash());
		GridBagHelper.add(this, jcShowSplash);

        jcShowIcons = new JCheckBox(XNap.tr("Display Icons", 1), 
									prefs.getShowIcons());
		GridBagHelper.add(this, jcShowIcons);

		jcShowTooltips = new JCheckBox(XNap.tr("Show Tooltips",1),
									   prefs.getShowToolTips());
		GridBagHelper.add(this, jcShowTooltips);

		JPanel jpSizes = new JPanel(new GridBagLayout());
		jpSizes.setBorder(new TitledBorder(XNap.tr("Number of Lines", 1)));
		GridBagHelper.add(this, jpSizes);

        GridBagHelper.addLabel(jpSizes, XNap.tr("Console"));
        jteMaxConsoleLines = new ValidatedTextField
			(prefs.getMaxConsoleLines() + "", 5, 
			 ValidatedTextField.NUMBERS_INT);
        GridBagHelper.add(jpSizes, jteMaxConsoleLines, false);

        GridBagHelper.addLabel(jpSizes, XNap.tr("History"));
        jteHistorySize = new ValidatedTextField
			(prefs.getSearchHistorySize() + "", 5, 
			 ValidatedTextField.NUMBERS_INT);
        GridBagHelper.add(jpSizes, jteHistorySize, false);

		JPanel jpFocusPolicies = new JPanel(new GridBagLayout());
		jpFocusPolicies.setBorder
			(new TitledBorder(XNap.tr("Global Focus Policy", 1)));
		GridBagHelper.add(this, jpFocusPolicies);

		ButtonGroup bg = new ButtonGroup();
		jrbFocusAlways = new JRadioButton(XNap.tr("Auto Focus New Windows"),
										  prefs.getFocusOnAllEvents());
		bg.add(jrbFocusAlways);
		GridBagHelper.add(jpFocusPolicies, jrbFocusAlways);

		jrbFocusNever = new JRadioButton(XNap.tr("Never Switch Focus"),
										 !prefs.getFocusOnAllEvents());
		bg.add(jrbFocusNever);
		GridBagHelper.add(jpFocusPolicies, jrbFocusNever);

		GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
		prefs.setShowIcons(jcShowIcons.isSelected());
		prefs.setShowSplash(jcShowSplash.isSelected());
		prefs.setShowToolTips(jcShowTooltips.isSelected());

		prefs.setMaxConsoleLines(jteMaxConsoleLines.getIntValue());
		prefs.setSearchHistorySize(jteHistorySize.getIntValue());

		prefs.setFocusOnAllEvents(jrbFocusAlways.isSelected());
    }

    public Icon getIcon()
    {
		return XNapFrame.getIcon("gohome.png");
    }

    public String getTitle()
    {
		return XNap.tr("Application");
    }

}



