/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.*;
import xnap.gui.text.EmacsKeyBindings;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class DialogPrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private JCheckBox jcShowCloseDialog;
    private JCheckBox jcShowDeleteFilesDialog;
    private JCheckBox jcShowDeleteDownloadsDialog;
    private JCheckBox jcShowMoveDialog;

    //--- Constructor(s) ---

    public DialogPrefsPanel()
    {
	setLayout(new GridBagLayout());

	JPanel jpDialogs = new JPanel(new GridBagLayout());
	jpDialogs.setBorder(new TitledBorder(XNap.tr("Dialogs", 1)));
	GridBagHelper.add(this, jpDialogs);

	jcShowCloseDialog = new JCheckBox
	    (XNap.tr("Confirm Close Application", 1), 
	     prefs.getShowCloseDialog());
        GridBagHelper.add(jpDialogs, jcShowCloseDialog);

	jcShowDeleteFilesDialog = 
	    new JCheckBox(XNap.tr("Confirm Delete Files", 1),
			  prefs.getShowDeleteFilesDialog());
	GridBagHelper.add(jpDialogs, jcShowDeleteFilesDialog);
	
	jcShowDeleteDownloadsDialog = 
	    new JCheckBox(XNap.tr("Confirm Delete Downloads", 1),
			  prefs.getShowDeleteDownloadsDialog());
	GridBagHelper.add(jpDialogs, jcShowDeleteDownloadsDialog);

	jcShowMoveDialog = new JCheckBox(XNap.tr("Confirm Move Files",1),
					 prefs.getShowMoveDialog());
	GridBagHelper.add(jpDialogs, jcShowMoveDialog);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	prefs.setShowCloseDialog(jcShowCloseDialog.isSelected());
	prefs.setShowDeleteFilesDialog(jcShowDeleteFilesDialog.isSelected());
	prefs.setShowDeleteDownloadsDialog
	    (jcShowDeleteDownloadsDialog.isSelected());
	prefs.setShowMoveDialog(jcShowMoveDialog.isSelected());
    }

    public Icon getIcon()
    {
	return XNapFrame.getIcon("gohome.png");
    }

    public String getTitle()
    {
	return XNap.tr("Confirm");
    }

}



