/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.*;
import xnap.gui.text.EmacsKeyBindings;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class GeneralPrefsPanel extends AbstractPreferencesPanel
{
    
    //--- Data field(s) ---

    private ValidatedTextField jteUsername;
    private ValidatedTextField jtePassword;
    private ValidatedTextField jteEmail;
    private ValidatedTextField jteMaxConsoleLines;
    private ValidatedTextField jteHistorySize;
    private JCheckBox jcShowSplash;
    private JCheckBox jcShowCloseDialog;
    private JCheckBox jcShowDeleteFilesDialog;
    private JCheckBox jcShowDeleteDownloadsDialog;
    private JCheckBox jcShowMoveDialog;
    private JCheckBox jcShowIcons;
    private JCheckBox jcAutoVersionCheck;
    private JCheckBox jcEmacsKeyBindings;
    private JComboBox jcbLanguage;
    private JCheckBox jcbAutoCompletion;

    //--- Constructor(s) ---

    public GeneralPrefsPanel()
    {
	setLayout(new GridBagLayout());

        GridBagHelper.addLabel(this, XNap.tr("Username"));
        jteUsername = new ValidatedTextField
	    (prefs.getUsername(), 20, ValidatedTextField.EMAIL);
        GridBagHelper.add(this, jteUsername);
	
        GridBagHelper.addLabel(this, XNap.tr("Password"));
        jtePassword = new ValidatedTextField
	    (prefs.getPassword(), 20, ValidatedTextField.EMAIL);
        GridBagHelper.add(this, jtePassword);

        GridBagHelper.addLabel(this, XNap.tr("Email"));

	/* this is just a crude approach, to only allow valid email addresses
	   someone would have to read RFC 2821 and RFC 2822.  */
        jteEmail = new ValidatedTextField
	    (prefs.getEmail(), 20, ValidatedTextField.EMAIL);
	GridBagHelper.add(this, jteEmail);

	GridBagHelper.addLabel(this, XNap.tr("Language"));
	jcbLanguage = new JComboBox();
	jcbLanguage.setRenderer(new LocaleCellRenderer());
	jcbLanguage.addItem(new Locale("", "", ""));
	for (int i = 0; i < XNap.LANGUAGES.length; i++) {
	    jcbLanguage.addItem(XNap.LANGUAGES[i]);
	    if (prefs.getLanguage().equals(XNap.LANGUAGES[i].getLanguage())) {
		// we have already added the "system default" locale
		jcbLanguage.setSelectedIndex(i + 1);
	    }
	}
	GridBagHelper.add(this, jcbLanguage, false);

	TwoColumnPanel jpSizes = new TwoColumnPanel();
	jpSizes.setBorder(new TitledBorder(XNap.tr("Number of Lines", 1)));

        GridBagHelper.addLabel(jpSizes.getLeft(), XNap.tr("Console"));
        jteMaxConsoleLines = new ValidatedTextField
	    (prefs.getMaxConsoleLines() + "", 5,
	     ValidatedTextField.NUMBERS_INT);
        GridBagHelper.add(jpSizes.getLeft(), jteMaxConsoleLines, false);

        GridBagHelper.addLabel(jpSizes.getRight(), XNap.tr("History"));
        jteHistorySize = new ValidatedTextField
	    (prefs.getSearchHistorySize() + "", 5, 
	     ValidatedTextField.NUMBERS_INT);
        GridBagHelper.add(jpSizes.getRight(), jteHistorySize, false);

	GridBagHelper.add(this, jpSizes);

	JPanel jpDialogs = new JPanel(new GridLayout(3, 2));
	jpDialogs.setBorder(new TitledBorder(XNap.tr("Show Dialogs", 1)));
	jcShowCloseDialog = new JCheckBox(XNap.tr("Confirm Close Application",
						  1), 
					  prefs.getShowCloseDialog());
        jpDialogs.add(jcShowCloseDialog);

	jcShowDeleteFilesDialog = 
	    new JCheckBox(XNap.tr("Confirm Delete Files",1),
			  prefs.getShowDeleteFilesDialog());
	jpDialogs.add(jcShowDeleteFilesDialog);
	
	jcShowDeleteDownloadsDialog = 
	    new JCheckBox(XNap.tr("Confirm Delete Downloads",1),
			  prefs.getShowDeleteDownloadsDialog());
	jpDialogs.add(jcShowDeleteDownloadsDialog);

	jcShowMoveDialog = new JCheckBox(XNap.tr("Confirm Move Files",1),
					 prefs.getShowMoveDialog());
	jpDialogs.add(jcShowMoveDialog);

        jcShowSplash = new JCheckBox(XNap.tr("Show Splash Screen",1),
                                     prefs.getShowSplash());
	jpDialogs.add(jcShowSplash);

	GridBagHelper.add(this, jpDialogs);
	
	JPanel jpMisc = new JPanel(new GridLayout(2, 2));
	jpMisc.setBorder(new TitledBorder(XNap.tr("Miscellaneous", 1)));

	jcAutoVersionCheck = new JCheckBox(XNap.tr("Check for New Version", 1),
                                           prefs.getAutoVersionCheck());
	jpMisc.add(jcAutoVersionCheck);

        jcShowIcons = new JCheckBox(XNap.tr("Display Icons", 1), 
				    prefs.getShowIcons());
	jpMisc.add(jcShowIcons);

	jcEmacsKeyBindings = 
	    new JCheckBox(XNap.tr("Use Emacs Keybindings", 1),
			  prefs.getUseEmacsKeyBindings());
	jcEmacsKeyBindings.setToolTipText(GUIHelper.tt(XNap.tr("Enables the essential Emacs keybindings to facilitate editing text.<br><small>(see FAQ for list of features)</small>")));
	jpMisc.add(jcEmacsKeyBindings);

	jcbAutoCompletion = new JCheckBox(XNap.tr("Auto Completion", 1),
					  prefs.getAutoComplete());
	jcbAutoCompletion.setToolTipText(GUIHelper.tt(XNap.tr("Activate completion of user input for all search fields which have a <b>history</b>.")));
	jpMisc.add(jcbAutoCompletion);

	GridBagHelper.add(this, jpMisc);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	prefs.setUsername(jteUsername.getText());
	prefs.setPassword(jtePassword.getText());
	prefs.setEmail(jteEmail.getText());
	prefs.setLanguage(((Locale)jcbLanguage.getSelectedItem()).getLanguage());
	prefs.setMaxConsoleLines(jteMaxConsoleLines.getIntValue());
	prefs.setSearchHistorySize(jteHistorySize.getIntValue());
	prefs.setShowSplash(jcShowSplash.isSelected());
	prefs.setShowCloseDialog(jcShowCloseDialog.isSelected());
	prefs.setShowDeleteFilesDialog(jcShowDeleteFilesDialog.isSelected());
	prefs.setShowDeleteDownloadsDialog
	    (jcShowDeleteDownloadsDialog.isSelected());
	prefs.setShowMoveDialog(jcShowMoveDialog.isSelected());
	prefs.setShowIcons(jcShowIcons.isSelected());
	prefs.setAutoVersionCheck(jcAutoVersionCheck.isSelected());
	prefs.setUseEmacsKeyBindings(jcEmacsKeyBindings.isSelected());
	prefs.setAutoComplete(jcbAutoCompletion.isSelected());
    }

    public Icon getIcon()
    {
	return XNapFrame.getIcon("gohome.png");
    }

    public String getTitle()
    {
	return XNap.tr("General");
    }

    protected class LocaleCellRenderer extends DefaultListCellRenderer
    {

	public Component getListCellRendererComponent
	    (JList list, Object val, int idx, boolean isSel, boolean hasFocus) 
	{
	    super.getListCellRendererComponent
		(list, val, idx, isSel, hasFocus);

	    String s = ((Locale)val).getDisplayLanguage();
	    setText((s.length() > 0) ? s : XNap.tr("System Default"));

	    return this;
	}
    }
}
