/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.*;
import xnap.plugin.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

public class PluginPrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private JComboBox jcbCategories;
    private DefaultListModel dlmPlugins;
    private JList jlPlugins;
    private JCheckBox jcbEnabled;
    private JLabel jlIcon;
    private MultiLineLabel jlDescription;
    private JLabel jlVersion;

    Hashtable categories = new Hashtable();

    //--- Constructor(s) ---

    public PluginPrefsPanel()
    {
	LinkedList netPlugins = new LinkedList();
	LinkedList viewerPlugins = new LinkedList();
	LinkedList otherPlugins = new LinkedList();
    
	IPlugin[] plugins = PluginManager.getInstance().getPlugins();
	for (int i = 0; i < plugins.length; i++) {
	    if (plugins[i] instanceof INetworkPlugin) {
		netPlugins.add(plugins[i]);
	    }
	    else if (plugins[i] instanceof IViewerPlugin) {
		viewerPlugins.add(plugins[i]);
	    }
	    else {
		otherPlugins.add(plugins[i]);
	    }
	}
	
	categories.put(XNap.tr("Network"), netPlugins);
	categories.put(XNap.tr("Viewers"), viewerPlugins);
	categories.put(XNap.tr("Other"), otherPlugins);

	initialize();
    }

    public void initialize()
    {
	setLayout(new GridBagLayout());

	JPanel jpInstPlugins = new JPanel(new GridBagLayout());
	jpInstPlugins.setBorder
	    (new TitledBorder(XNap.tr("Installed", 1)));

        GridBagHelper.addLabel(jpInstPlugins, XNap.tr("Category"));

        jcbCategories = new JComboBox(new Vector(categories.keySet()));
        GridBagHelper.add(jpInstPlugins, jcbCategories);
	
        GridBagHelper.addLabel(jpInstPlugins, XNap.tr("Plugin"));
	dlmPlugins = new DefaultListModel();
        jlPlugins = new JList(dlmPlugins);
	jlPlugins.setVisibleRowCount(4);
	// FIX: with jdk 1.3.1 the jlist size never shrinks, it only grows
	// when being resized
	JScrollPane jspPlugins = new JScrollPane(jlPlugins);
        GridBagHelper.add(jpInstPlugins, jspPlugins);

	GridBagHelper.addLabel(jpInstPlugins, "");
        jcbEnabled = new JCheckBox(XNap.tr("Enabled"));
	jcbEnabled.addActionListener(new PluginEnabler());
        GridBagHelper.add(jpInstPlugins, jcbEnabled);

	jlIcon = GridBagHelper.addLabel(jpInstPlugins, "");
	jlIcon.setHorizontalAlignment(SwingConstants.CENTER);
	jlIcon.setVerticalAlignment(SwingConstants.CENTER);

	jlDescription = new MultiLineLabel();
	GridBagHelper.add(jpInstPlugins, jlDescription);

	GridBagHelper.addLabel(jpInstPlugins, "");
	jlVersion = new JLabel();
	GridBagHelper.add(jpInstPlugins, jlVersion);

	jcbCategories.addActionListener(new PluginCategoryListener());
	jlPlugins.addListSelectionListener(new PluginListener());

        GridBagHelper.add(this, jpInstPlugins);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
    }

    public Icon getIcon()
    {
	return XNapFrame.getIcon("attach.png");
    }

    public String getTitle()
    {
	return XNap.tr("Plugins");
    }

    protected void updatePlugin()
    {
	IPlugin pl = (IPlugin)jlPlugins.getSelectedValue();
	
	if (pl != null) {
	    jcbEnabled.setSelected(pl.isEnabled());
	    if (pl instanceof IGUIPlugin) {
		jlIcon.setIcon(((IGUIPlugin)pl).getIcon());
	    }
	    if (pl instanceof IViewerPlugin) {
		jlIcon.setIcon(((IViewerPlugin)pl).getIcon());
	    }
	    jlDescription.setText(pl.getDescription());
	    jlVersion.setText(XNap.tr("Version", 0, 1) + 
			      pl.getVersion());

	    jcbEnabled.setEnabled(true);
	}
	else {
	    jcbEnabled.setSelected(false);
	    jlIcon.setIcon(null);
	    jlDescription.setText("");
	    jlVersion.setText("");

	    jcbEnabled.setEnabled(false);
	}
    }

    protected class PluginCategoryListener implements ActionListener
    {

	public PluginCategoryListener()
	{
	    actionPerformed(null);
	}

	public void actionPerformed(ActionEvent event)
	{
	    Object o = jcbCategories.getSelectedItem().toString();
	    LinkedList plugins = (LinkedList)categories.get(o);

	    dlmPlugins.removeAllElements();
	    for (Iterator i = plugins.iterator(); i.hasNext();) {
		dlmPlugins.addElement(i.next());
	    }

	    updatePlugin();
	}
    }

    protected class PluginListener implements ListSelectionListener
    {

	public PluginListener()
	{
	    valueChanged(null);
	}

	public void valueChanged(ListSelectionEvent e) 
	{
	    updatePlugin();
	}
    }

    protected class PluginEnabler implements ActionListener
    {

	public PluginEnabler()
	{
	}

	public void actionPerformed(ActionEvent event)
	{
	    IPlugin p = (IPlugin)jlPlugins.getSelectedValue();
	    if (p != null) {
		GUIPluginManager.getInstance().setEnabled
		    (p, jcbEnabled.isSelected());
	    }
	}
    }

}
