/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.GridBagHelper;
import xnap.gui.XNapFrame;
import xnap.util.Updater;
import xnap.util.audio.AudioSupport;
import xnap.util.audio.JMFPlayer;
import xnap.util.launcher.LauncherSupport;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class ProgramsPrefsPanel extends AbstractPreferencesPanel 
    implements ActionListener
{

    /**
     * Columns used for button groups.
     */
    public static final int ACTION_CMD = 0;
    public static final int TEXT = 1;
    public static final int OPT_VALUE = 2;

    //--- Data field(s) ---

    private ButtonGroup bgMP3PlayerType;
    private JTextField jteMP3PlayerCmd;

    private ButtonGroup bgFileLauncher;
    private JTextField jtfFileLauncherCmd;

    //--- Constructor(s) ---

    public ProgramsPrefsPanel()
    {
	setLayout(new GridBagLayout());

	// player
	JPanel jpMP3Player = new JPanel(new GridBagLayout());
	jpMP3Player.setBorder(new TitledBorder(XNap.tr("Mp3 Player", 1)));
	GridBagHelper.add(this, jpMP3Player);

	// player type
	bgMP3PlayerType = new ButtonGroup();
	JPanel jpMP3PlayerType = new JPanel(new GridLayout(0, 2));
	installButtonGroup(jpMP3PlayerType, bgMP3PlayerType, 
			   AudioSupport.PLAYERS);
	setSelected(bgMP3PlayerType, prefs.getMP3PlayerType());
	GridBagHelper.add(jpMP3Player, jpMP3PlayerType);

	// player command
        GridBagHelper.addLabel(jpMP3Player, XNap.tr("Command"));
        jteMP3PlayerCmd = new JTextField(20);
	setOpt(AudioSupport.PLAYERS, prefs.getMP3PlayerType().equals("other") ?
	       prefs.getMP3PlayerCmd() : "");
	setText(jteMP3PlayerCmd, bgMP3PlayerType, 
		prefs.getMP3PlayerType(), AudioSupport.PLAYERS);
	GridBagHelper.add(jpMP3Player, jteMP3PlayerCmd);
    
	// file launcher
	JPanel jpFileLauncher = new JPanel(new GridBagLayout());
	jpFileLauncher.setBorder(new TitledBorder
	    (XNap.tr("File Launcher", 1)));
	GridBagHelper.add(this, jpFileLauncher);

	// file launcher type
	bgFileLauncher = new ButtonGroup();
	JPanel jpFileLauncherType = new JPanel(new GridLayout(0, 2));
	installButtonGroup(jpFileLauncherType, bgFileLauncher, 
			   LauncherSupport.LAUNCHERS);
	setSelected(bgFileLauncher, prefs.getFileLauncherType());
	GridBagHelper.add(jpFileLauncher, jpFileLauncherType);

	// file launcher command
        GridBagHelper.addLabel(jpFileLauncher, XNap.tr("Command")); 
        jtfFileLauncherCmd = new JTextField(20);
	setOpt(LauncherSupport.LAUNCHERS, 
	       prefs.getFileLauncherType().equals("other") ?
	       prefs.getFileLauncherCmd() : "");
	setText(jtfFileLauncherCmd, bgFileLauncher, 
		prefs.getFileLauncherType(), LauncherSupport.LAUNCHERS);
	GridBagHelper.add(jpFileLauncher, jtfFileLauncherCmd);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void actionPerformed(ActionEvent event)
    {
	if (event.getSource() instanceof AbstractButton) {
	    ButtonModel bm = ((AbstractButton)event.getSource()).getModel();
	    if (bgMP3PlayerType.isSelected(bm)) {
		setText(jteMP3PlayerCmd, bgMP3PlayerType, 
			event.getActionCommand(), AudioSupport.PLAYERS);
	    }
	    else if (bgFileLauncher.isSelected(bm)) {
		setText(jtfFileLauncherCmd, bgFileLauncher, 
			event.getActionCommand(), LauncherSupport.LAUNCHERS);
	    }
	}
    }

    public void apply() 
    {
	prefs.setMP3PlayerType
	    (bgMP3PlayerType.getSelection().getActionCommand());
	prefs.setMP3PlayerCmd(jteMP3PlayerCmd.getText());

	prefs.setFileLauncherType
	    (bgFileLauncher.getSelection().getActionCommand());
	prefs.setFileLauncherCmd(jtfFileLauncherCmd.getText());
    }

    public Icon getIcon()
    {
	return XNapFrame.getSmallIcon("folder.png");
    }

    public String getTitle()
    {
	return XNap.tr("Programs");
    }

    public void installButtonGroup(JPanel jp, ButtonGroup bg, 
				   String[][] values)
    {
	for (int i = 0; i < values.length; i++) {
	    JRadioButton jrb = new JRadioButton(values[i][TEXT]);
	    jrb.setActionCommand(values[i][ACTION_CMD]);
	    jrb.addActionListener(this);
	    bg.add(jrb);
	    jp.add(jrb);

	    // FIX: well, this does not belong here
	    if (values[i][ACTION_CMD].equals("jmf")) {
		jrb.setEnabled(JMFPlayer.isAvailable());
	    }
	    else if (values[i][ACTION_CMD].equals("ziga.dll")) {
		jrb.setEnabled(Updater.isZigaDllLoaded());
	    }
	}
    }

    public void setSelected(ButtonGroup bg, String selected)
    {
	AbstractButton b = null;
	for (Enumeration e = bg.getElements(); e.hasMoreElements();) {
	    b = (AbstractButton)e.nextElement();
	    if (b.isEnabled() && b.getActionCommand().equals(selected)) {
		b.setSelected(true);
		return;
	    }
	}

	if (b != null) {
	    // select last checkbox as default
	    b.setSelected(true);
	}
    }

    public void setText(JTextField jtf, ButtonGroup bg, String selected, 
			String[][] values)
    {
	int i = 0;
	for (Enumeration e = bg.getElements(); e.hasMoreElements(); i++) {
	    AbstractButton b = (AbstractButton)e.nextElement();
	    if (b.getActionCommand().equals(selected)) {
		jtf.setEnabled(values[i][ACTION_CMD].equals("other"));
		jtf.setText(values[i][OPT_VALUE]);
		if (jtf.isEnabled()) {
		    jtf.requestFocus();
		}
		return;
	    }
	}
    }

    public void setOpt(String[][] array, String value)
    {
	for (int i = 0; i < array.length; i++) {
	    if (array[i][ACTION_CMD].equals("other")) {
		array[i][OPT_VALUE] = value;
		break;
	    }
	}
    }

}
