/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class TransferPrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private EnableAction acMaxDl;
    private ValidatedTextField jtMaxDl;

    private EnableAction acMaxUl;
    private ValidatedTextField jtMaxUl;

    private EnableAction acMaxDlPerUser;
    private ValidatedTextField jtMaxDlPerUser;

    private EnableAction acMaxUlPerUser;
    private ValidatedTextField jtMaxUlPerUser;

    private EnableAction acDlThrottle;
    private ValidatedTextField jtDlThrottle;

    private EnableAction acUlThrottle;
    private ValidatedTextField jtUlThrottle;

    //--- Constructor(s) ---

    public TransferPrefsPanel()
    {
	setLayout(new GridBagLayout());

	// limits
	JPanel jpLimits = new JPanel(new GridBagLayout());
	jpLimits.setBorder(new TitledBorder(XNap.tr("Limits", 1)));
	GridBagHelper.add(this, jpLimits);

        jtMaxDl = new ValidatedTextField
	    (prefs.getMaxDownloads() + "", 5, ValidatedTextField.NUMBERS_INT);
	acMaxDl = new EnableAction(XNap.tr("Maximum Downloads"), 
				   new Component[] { jtMaxDl },
				   prefs.getLimitDownloads());
        GridBagHelper.addComponent(jpLimits, acMaxDl.getCheckBox());
        GridBagHelper.add(jpLimits, jtMaxDl, false);

	jtMaxUl = new ValidatedTextField
	    (prefs.getMaxUploads() + "", 5, ValidatedTextField.NUMBERS_INT);
	acMaxUl = new EnableAction(XNap.tr("Maximum Uploads"), 
				   new Component[] { jtMaxUl },
				   prefs.getLimitUploads());
	GridBagHelper.addComponent(jpLimits, acMaxUl.getCheckBox());
	GridBagHelper.add(jpLimits, jtMaxUl, false);

	// user limits
	JPanel jpUserLimits = new JPanel(new GridBagLayout());
	jpUserLimits.setBorder(new TitledBorder(XNap.tr("User Limits", 1)));
	GridBagHelper.add(this, jpUserLimits);

        jtMaxDlPerUser = new ValidatedTextField
	    (prefs.getMaxDownloadsPerUser() + "", 5, 
	     ValidatedTextField.NUMBERS_INT);
	acMaxDlPerUser = new EnableAction(XNap.tr("Maximum Downloads Per User"), 
					  new Component[] { jtMaxDlPerUser },
					  prefs.getLimitDownloadsPerUser());
        GridBagHelper.addComponent(jpUserLimits, acMaxDlPerUser.getCheckBox());
        GridBagHelper.add(jpUserLimits, jtMaxDlPerUser, false);

	jtMaxUlPerUser = new ValidatedTextField
	    (prefs.getMaxUploadsPerUser() + "", 5, 
	     ValidatedTextField.NUMBERS_INT);
	acMaxUlPerUser = new EnableAction(XNap.tr("Maximum Uploads Per User"), 
					  new Component[] { jtMaxUlPerUser },
					  prefs.getLimitUploadsPerUser());
	GridBagHelper.addComponent(jpUserLimits, acMaxUlPerUser.getCheckBox());
	GridBagHelper.add(jpUserLimits, jtMaxUlPerUser, false);

	// throttle
	JPanel jpThrottle = new JPanel(new GridBagLayout());
	jpThrottle.setBorder(new TitledBorder(XNap.tr("Bandwidth Limitation", 1)));

	jtDlThrottle = new ValidatedTextField
	    (prefs.getDownloadThrottle() + "", 5, 
	     ValidatedTextField.NUMBERS_INT);
	acDlThrottle = new EnableAction(XNap.tr("Maximum Download Rate"), 
					new Component[] {jtDlThrottle},
					prefs.getThrottleDownloads());
	GridBagHelper.addComponent(jpThrottle, acDlThrottle.getCheckBox());
	GridBagHelper.addComponent(jpThrottle, jtDlThrottle);
	GridBagHelper.add(jpThrottle, new JLabel(XNap.tr("kb/s")));

	jtUlThrottle 
	    = new ValidatedTextField(prefs.getUploadThrottle() + "", 5, 
				     ValidatedTextField.NUMBERS_INT);
	acUlThrottle = new EnableAction(XNap.tr("Maximum Upload Rate"), 
					new Component[] {jtUlThrottle},
					prefs.getThrottleUploads());
	GridBagHelper.addComponent(jpThrottle, acUlThrottle.getCheckBox());
	GridBagHelper.addComponent(jpThrottle, jtUlThrottle);
	GridBagHelper.add(jpThrottle, new JLabel(XNap.tr("kb/s")));

	GridBagHelper.add(this, jpThrottle);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	prefs.setLimitDownloads(acMaxDl.isSelected());
	prefs.setMaxDownloads(jtMaxDl.getIntValue());

	prefs.setLimitUploads(acMaxUl.isSelected());
	prefs.setMaxUploads(jtMaxUl.getIntValue());

	prefs.setLimitDownloadsPerUser(acMaxDlPerUser.isSelected());
	prefs.setMaxDownloadsPerUser(jtMaxDlPerUser.getIntValue());

	prefs.setLimitUploadsPerUser(acMaxUlPerUser.isSelected());
	prefs.setMaxUploadsPerUser(jtMaxUlPerUser.getIntValue());

	prefs.setThrottleDownloads(acDlThrottle.isSelected());
	prefs.setDownloadThrottle(jtDlThrottle.getIntValue());

	prefs.setThrottleUploads(acUlThrottle.isSelected());
	prefs.setUploadThrottle(jtUlThrottle.getIntValue());
    }

    public Icon getIcon()
    {
	return XNapFrame.getIcon("connect_established.png");
    }

    public String getTitle()
    {
	return XNap.tr("Transfer");
    }

}
