/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui.table;

import xnap.XNap;
import xnap.gui.util.SwingSynchronizedCache;
import xnap.net.IUser;
import xnap.net.event.StatusChangeEvent;
import xnap.net.event.StatusChangeListener;
import xnap.user.UserManager;
import xnap.util.EventVector;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import org.apache.log4j.Logger;

public class ChatUserTableModel extends UserTableModel
    implements ListListener {

    //--- Constant(s) ---

    //--- Data field(s) ---

    private static Logger logger = Logger.getLogger(ChatUserTableModel.class);

    /**
     *
     */
    private Hashtable serverCountByUsers  = new Hashtable();
    
    //--- Constructor(s) ---

    public ChatUserTableModel(String name, EventVector list) 
    {
	super(name);

	SwingSynchronizedCache cache = new SwingSynchronizedCache(this);
	list.addListListener(cache);
    }

    //--- Method(s) ---

    public void elementAdded(ListEvent e) 
    {
	IUser u = (IUser)e.getElement();
	add(u);

	Integer i = (Integer)serverCountByUsers.get(u);
	i = new Integer((i == null) ? 1 : i.intValue() + 1);
	serverCountByUsers.put(u, i);
    }

    public void elementRemoved(ListEvent e) 
    {
	IUser u = (IUser)e.getElement();

	Integer i = (Integer)serverCountByUsers.get(u);
	if (i == null || i.intValue() <= 1) {
	    serverCountByUsers.remove(u);
	    remove(u);
	}
	else {
	    i = new Integer(i.intValue() - 1);
	    serverCountByUsers.put(u, i);
	}
    }

    //--- Inner Class(es) ---

    public static class IUserVector extends EventVector {

	public IUserVector()
	{
	}

	public void add(IUser u) 
	{
	    super.add(u);
	}

	public void remove(IUser u)
	{
	    super.remove(u);
	}

    }

}
