/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.table;

import xnap.net.*;
import xnap.net.event.*;
import xnap.util.*;
import xnap.util.event.*;

import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.swing.Timer;
import javax.swing.event.*;
import javax.swing.table.*;

public class FilteredTransferTableModel extends TransferTableModel {
    
    //--- Constant(s) ---
    
    //--- Data field(s) ---

    //--- Constructor(s) ---

    public FilteredTransferTableModel(TransferQueue queue, String table) 
    {
	super(queue, table, "", new FilteredQueue(queue));
    }

    //--- Method(s) ---

    /**
     * Inserts new items at top.
     */
    public void elementAdded(ListEvent e) 
    {
        ITransferContainer t = (ITransferContainer)e.getElement();
	t.addStatusChangeListener(this);
	rows.add(0, t);
        fireTableRowsInserted(0, 0);
    }

    //--- Inner Class(es) ---

    protected static class FilteredQueue extends EventVector 
	implements ListListener, StatusChangeListener {	

	public FilteredQueue(TransferQueue queue)
	{
	    queue.addListListener(this);
	}

	public void add(ITransferContainer t) 
	{
	    super.add(t);
	}

	public void elementAdded(ListEvent e) 
	{
	    ITransferContainer t = (ITransferContainer)e.getElement();
	    t.addStatusChangeListener(this);
	}
	
	public void elementRemoved(ListEvent e) 
	{
	    ITransferContainer t = (ITransferContainer)e.getElement();
	    t.removeStatusChangeListener(this);
	}
	
	public void remove(ITransferContainer t)
	{
	    super.remove(t);
	}

	/**
	 * Observes the transfers.
	 */
	public void statusChange(StatusChangeEvent e)
	{
	    ITransferContainer t = (ITransferContainer)e.getSource();	
	    if (contains(t)) {
		if (t.isDone()) {
		    remove(t);
		}
	    }
	    else {
		if (t.isRunning()) {
		    add(t);
		}
	    }
	}

    }

}
