/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.table;

import xnap.gui.XNapFrame;
import xnap.gui.util.GUIHelper;
import xnap.util.*;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;

public class ProgressCellRenderer extends DefaultTableCellRenderer {

    //--- Constant(s) ---

    //--- Data Field(s) ---

    protected double progress = 0;
    protected String text = "";
    private Preferences prefs = Preferences.getInstance();
    private Color runningColor = GUIHelper.getColor("progressRunning");
    private Color finishedColor = GUIHelper.getColor("progressFinished");

    //--- Constructor(s) ---

    public ProgressCellRenderer() 
    {
    }

    //--- Method(s) ---

    protected void setValue(Object value) 
    {
	if (value instanceof Progress) {
	    Progress p = (Progress)value;
	    progress = p.progress;
	    text = p.toString();
	    setToolTipText(Formatter.formatNumber(progress, 2) + "%" 
			   + ((text.length() == 0) ? "" : ", " + text));
	}

	super.setValue(null);
    }

    public void paint(Graphics g) 
    {
	super.paint(g);
	g.setColor(Color.black);
	g.drawRect(0, 0, getWidth() - 1, getHeight() - 1);

	g.setColor(Color.lightGray);
	g.drawRect(1, 1, getWidth() - 2, getHeight() - 2);
	if (progress > 0) {
	    int width = ((getWidth() - 2) * (int)progress) / 100;
	    int height = getHeight() - 2;

	    g.setColor((progress < 100) ? runningColor : finishedColor);
	    g.fillRect(1, 1, width, height);
	}

	if (text != null && text.length() > 0) {
	    FontMetrics fm = g.getFontMetrics();
	    int w = fm.stringWidth(text);

	    int x = (getWidth() - w) / 2;
	    int y = getHeight() - 3;

  	    g.setColor(getForeground());
  	    g.drawString(text, (x > 1) ? x : 1, y);
	}						
    }

}
