/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.theme;

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.*;

public abstract class Theme {

    //--- Constant(s) ---

    //--- Data field(s) ---
	
    protected String name;
    protected Object[] properties;
    
    //--- Constructor(s) ---

    public Theme(String name, Object[] properties)
    {
	this.name = name;
	this.properties = properties;
    }

    public Theme(String name)
    {
	this(name, null);
    }

    //--- Method(s) ---

    public boolean isConfigurable()
    {
	return false;
    }

    public String getClassName()
    {
	return getClass().getName();
    }	

    /**
     * Returns true, if theme should be reloaded.
     */
    public boolean showConfigurationDialog(Component parent)
    {
	return false;
    }

    public String getName()
    {
	return name;
    }
    
    public Object[] getProperties()
    {
	return properties;
    }

    public static Object[] createProperties(FontUIResource font)
    {
	Object[] array = new Object[] {
	    "Table.font", font, 
	    "TextPane.font", font, 
	    "TextArea.font", font, 
	    "TextField.font", font, 
	    "PasswordField.font", font, 
	    "EditorPane.font", font, 
	    "ProgressBar.font", font, 
	    
	    "MenuBar.font", font, 
	    "Menu.font", font, 
	    "MenuItem.font", font, 
	    "PopupMenu.font", font, 
	    "CheckBoxMenuItem.font", font, 
	    "RadioButtonMenuItem.font", font, 
	    
	    "CheckBox.font", font, 
	    "ComboBox.font", font, 
	    "Button.font", font, 
	    "Tree.font", font, 
	    "ScrollPane.font", font, 
	    "TabbedPane.font", font, 
	    "TitledBorder.font", font, 
	    "OptionPane.font", font, 
	    "ToolBar.font", font, 
	    "RadioButton.font", font, 
	    "ToggleButton.font", font, 
	    "ToolTip.font", font, 
	    "TableHeader.font", font, 
	    "Panel.font", font, 
	    "List.font", font, 
	    "ColorChooser.font", font, 
	    "Label.font", font, 
	    "Viewport.font", font, 
	};

	return array;
    }

    public String toString()
    {
	return getName();
    }

}
