/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.tree;

import xnap.util.Debug;

import javax.swing.JTree;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.io.File;
import java.util.*;

public abstract class AbstractTreeModel implements TreeModel
{

    // --- Data Field(s)

    protected String root;
    protected transient EventListenerList listenerList 
	= new EventListenerList();

    // --- Constructor(s) ---

    public AbstractTreeModel(String root)
    {
        this.root = root;
    }

    // --- Method(s)
    
    public abstract boolean isLeaf(Object node);

    public abstract int getChildCount(Object node);

    public abstract Object getChild(Object parent, int index);

    public abstract int getIndexOfChild(Object parent, Object child);

    public Object getRoot()
    {
        return root;
    }

    public void reload()
    {
	Object[] path = new Object[] { getRoot() };
	fireTreeStructureChanged(new TreeModelEvent(this, path));
    }

    public void valueForPathChanged(TreePath path, Object value)
    {
	Debug.log("AbstractTreeModel: valueForPath.. " + path + "," + value);
    }

    public void addTreeModelListener(TreeModelListener l)
    {
	listenerList.add(TreeModelListener.class, l);
    }

    public void removeTreeModelListener(TreeModelListener l)
    {
        listenerList.remove(TreeModelListener.class, l);
    }

    protected void fireTreeNodesInserted(TreeModelEvent e) {
	// Guaranteed to return a non-null array
	Object[] listeners = listenerList.getListenerList();
	// Process the listeners last to first, notifying
	// those that are interested in this event
	for (int i = listeners.length-2; i >= 0; i -= 2) {
	    if (listeners[i] == TreeModelListener.class) 
		((TreeModelListener)listeners[i+1]).treeNodesInserted(e);
	}
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e) {
	// Guaranteed to return a non-null array
	Object[] listeners = listenerList.getListenerList();
	// Process the listeners last to first, notifying
	// those that are interested in this event
	for (int i = listeners.length-2; i >= 0; i -= 2) {
	    if (listeners[i] == TreeModelListener.class) 
		((TreeModelListener)listeners[i+1]).treeNodesRemoved(e);
	    
	}
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
	// Guaranteed to return a non-null array
	Object[] listeners = listenerList.getListenerList();
	// Process the listeners last to first, notifying
	// those that are interested in this event
	for (int i = listeners.length-2; i >= 0; i -= 2) {
	    if (listeners[i] == TreeModelListener.class) 
		((TreeModelListener)listeners[i+1]).treeStructureChanged(e);
	    
	}
    }
}
