/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.net;

import xnap.io.*;
import xnap.util.*;

import java.io.*;
import java.net.*;
import java.util.*;

public abstract class AbstractUpload implements IUpload {

    //--- Constant(s) ---

    //--- Data field(s) ---

    protected long offset = 0;
    protected IUser user = null;
    protected File file = null;

    //--- Constructor(s) ---

    public AbstractUpload(IUser user)
    {
	this.user = user;
    }

    public AbstractUpload()
    {
    }

    //--- Method(s) ---

    public File getFile()
    {
	return file;
    }

    public long getOffset()
    {
	return offset;
    }

    public IUser getUser()
    {
	return user;
    }
}
