/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import xnap.util.Debug;

import java.io.*;
import java.net.*;

public class HttpConnection {

    //--- Data Field(s) ---

    private BufferedReader in = null;
    private HttpURLConnection connection = null;

    //--- Constructor(s) ---
	
    public HttpConnection()
    {
    }

    //--- Method(s) ---

    public void connect(URL url) throws IOException
    {
	connection = (HttpURLConnection)url.openConnection();
	if (connection.getResponseCode() == HttpURLConnection.HTTP_OK) {
	    in = new BufferedReader
		(new InputStreamReader(connection.getInputStream()));
	    
	} 
	else {
	    Debug.log("Closing connecting");
	    connection.disconnect();
	    throw new IOException(connection.getResponseMessage());
	}
    }

    public void connect(String location) throws IOException
    {
	connect(new URL(location));
    }

    public void close()
    {
	connection.disconnect();
    }

    public InputStream getInputStream() throws IOException
    {
	return connection.getInputStream();
    }

    public String nextLine()
    {
	if (in == null) {
	    return null;
	}

	String line = null;
        try {
            line = in.readLine();
        } 
	catch(IOException e) {
        }

	if (line == null) {
	    connection.disconnect();
	}

	return line;
    }

    public static void save(InputStream in, String filename) throws IOException
    {
	byte[] b = new byte[500];

	OutputStream out = new FileOutputStream(filename, false);

	int c = 0;
	while (c != -1) {
	    out.write(b, 0, c);
	    c = in.read(b);
	}

	out.close();
    }

}
