/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import xnap.plugin.INetworkPlugin;
import xnap.util.SearchFilter;

import java.io.File;

public interface ISearchResult {

    //--- Data field(s) ---

    //--- Method(s) ---

    /**
     * Returns the bitrate.
     */
    int getBitrate();

    /**
     * Returns true, if result can be grouped.
     */
    boolean canGroup();

    /**
     * Starts a new download. The object is responsible for adding the 
     * ITransferContainer to the DownloadQueue itself.
     *
     * @param filter the search filter that was used to find this result,
     *               can be used to find more sources
     * @param file file to resume from; null, if download is not resumed
     * @return true, if download was started; false, if operation failed
     */
    boolean download(SearchFilter filter, File file);

    /**
     * Returns the full filename. Used by <code>SearchFilter</code> for 
     * matching. 
     *
     * @see xnap.util.SearchFilter
     */
    String getFilename();

    /**
     * Returns the filesize.
     */
    long getFilesize();

    /**
     * Returns the frequency.
     */
    int getFrequency();

    /**
     * Returns a unique hash value. Not yet used.
     */
    String getHash();

    /**
     * Returns the length.
     */
    int getLength();

    /**
     * Returns the tokenized path without delimeters. Used for the browse tree.
     *
     * @return C:\Files\Share would be returned as 
     *         <code>new String[] { "C:", "Files", "Share" }</code>
     */
    String[] getPath();

    /**
     * Returns the originating plugin.
     */
    INetworkPlugin getPlugin();

    /**
     * Returns a score. This should somehow relate to the link speed. Return
     * 1 if unsure.
     *
     * @see xnap.net.SearchResultContainer
     */
    int getScore();

    /**
     * Returns the filename presented to the user.
     */
    String getShortFilename();

    /**
     * Returns the user.
     */
    IUser getUser();    

}
