/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.net;

import java.io.File;
import java.io.IOException;

public interface IUpload extends ITransfer {

    /**
     * Closes the connection.
     */
    void close();

    /**
     * Initializes a connection.
     */
    void connect() throws IOException;

    /**
     * Returns the file that is uploaded.
     *
     * @return file to upload, null if not known, yet
     */
    File getFile();

    /**
     * Returns the offset from where to start upload.
     */
    long getOffset();

    /**
     * Called by the upload queue if download was rejected.
     */
    void reject();

    /**
     * Uploads b.
     */
    void write(byte[] b, int len) throws IOException;

}
