/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import xnap.plugin.INetworkPlugin;
import xnap.util.*;

import java.util.*;

public class SearchResultContainer extends Observable {

    //--- Data field(s) ---

    private Vector results = new Vector();
    private int maxLinkSpeed = 0;
    private HashSet plugins = new HashSet();
    protected String status;

    //--- Constructor(s) ---

    public SearchResultContainer(ISearchResult sr) 
    {
	add(sr);
    }
    
    public SearchResultContainer() 
    {
    }
    
    //--- Method(s) ---

    public void add(ISearchResult sr)
    {
	results.add(sr);
	maxLinkSpeed = Math.max(sr.getUser().getLinkSpeed(), maxLinkSpeed);
	plugins.add(sr.getPlugin());
	broadcast();
    }

    public ISearchResult[] getSearchResults()
    {
	ISearchResult[] array 
	    = new ISearchResult[results.size()];
	System.arraycopy(results.toArray(), 0, array, 0, array.length);

	return array;
    }

    public int getBitrate()
    {
	return getResult().getBitrate();
    }

    public long getFilesize()
    {
	return getResult().getFilesize();
    }
    
    public int getFrequency()
    {
	return getResult().getFrequency();
    }

    public int getLength()
    {
	return getResult().getLength();
    }

    public int getLinkSpeed()
    {
	return maxLinkSpeed;
    }    

    public String getStatus()
    {
	return status;
    }

    public void setStatus(String newValue)
    {
	status = newValue;
	broadcast();
    }

    public String getPath()
    {
	String[] p = getResult().getPath();
	if (results.size() == 1 && p != null) {
	    return StringHelper.toString(p, "/");
	}
	else {
	    return "";
	}
    }
 
    public String getPlugin()
    {
	StringBuffer sb = new StringBuffer();
	for (Iterator i = plugins.iterator(); i.hasNext();) {
	    sb.append(i.next());
	    sb.append(" ");
	}
	return sb.toString();
    }

    public int getScore()
    {
	return results.size();
    }

    public String getShortFilename()
    {
	return getResult().getShortFilename();
    }

    public String getUsername()
    {
	if (results.size() == 1) {
	    return getResult().getUser().getName();
	}
	else {
	    return results.size() + " users";
	}
    }

    protected ISearchResult getResult()
    {
	return (ISearchResult)results.get(0);
    }

    public int size()
    {
	return results.size();
    }

    public String toString()
    {
	return getShortFilename() + ", " + getUsername();
    }

    protected void broadcast() 
    {
	setChanged();
	notifyObservers(this);
    }

}
