/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net.event;

import xnap.net.IUser;

import java.util.*;

public class ChannelSupport { 

    //--- Data field(s) ---

    private Object source;
    private Vector channelListeners = new Vector();

    //--- Constructor(s) ---
    
    public ChannelSupport(Object source)
    {
	this.source = source;
    }

    //--- Method(s) ---

    public void addChannelListener(ChannelListener l) {
        channelListeners.add(l);
    }

    public void removeChannelListener(ChannelListener l) {
        channelListeners.remove(l);
    }

    public void fireChannelClosed()
    {
        Object[] listeners = channelListeners.toArray();

	if (listeners != null) {
	    ChannelEvent event = new ChannelEvent(source);

	    for (int i = listeners.length - 1; i >= 0; i--) {
		((ChannelListener)listeners[i]).channelClosed(event);
	    }
	}
    }
        
    public void fireMessageReceived(IUser sender, String message, 
				    int messageType)
    {
        Object[] listeners = channelListeners.toArray();

	if (listeners != null) {
	    ChannelEvent event 
		= new ChannelEvent(source, sender, message, messageType);

	    for (int i = listeners.length - 1; i >= 0; i--) {
		((ChannelListener)listeners[i]).messageReceived(event);
	    }
	}
    }   

    public void fireMessageReceived(String message, int messageType)
    {
	fireMessageReceived(null, message, messageType);
    }

    public void fireUserAdded(IUser user)
    {
        Object[] listeners = channelListeners.toArray();

	if (listeners != null) {
	    ChannelEvent event 
		= new ChannelEvent(source, ChannelEvent.USER_ADDED, user);

	    for (int i = listeners.length - 1; i >= 0; i--) {
		((ChannelListener)listeners[i]).userAdded(event);
	    }
	}
    }   

    public void fireUserRemoved(IUser user)
    {
        Object[] listeners = channelListeners.toArray();

	if (listeners != null) {
	    ChannelEvent event 
		= new ChannelEvent(source, ChannelEvent.USER_REMOVED, user);

	    for (int i = listeners.length - 1; i >= 0; i--) {
		((ChannelListener)listeners[i]).userRemoved(event);
	    }
	}
    }   

    public void fireTopicChanged(String topic)
    {
        Object[] listeners = channelListeners.toArray();

	if (listeners != null) {
	    ChannelEvent event = new ChannelEvent(source, topic);

	    for (int i = listeners.length - 1; i >= 0; i--) {
		((ChannelListener)listeners[i]).topicChanged(event);
	    }
	}
    }   

}
