/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin;

import xnap.*;
import xnap.gui.*;
import xnap.util.*;

import java.io.File;
import java.util.*;

public class GUIPluginManager extends PluginManager
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    /**
     * Maps extensions to viewer plugin.
     */
    protected Hashtable viewers = new Hashtable();

    //--- Constructor(s) ---

    protected GUIPluginManager()
    {
    }

    //--- Method(s) ---

    public static synchronized PluginManager getInstance() {
	if (singleton == null) {
	    singleton = new GUIPluginManager();
	}

	return singleton;
    }

    /**
     * Convenience access for gui.
     */
    public static synchronized GUIPluginManager getGUIInstance() 
    {
	return (GUIPluginManager)getInstance();
    }

    public synchronized void setEnabled(IPlugin plugin, boolean newValue) 
    {
	if (newValue) {
	    SplashWindow.setText(XNap.tr("Loading", 0, 1) 
				 + plugin.getName() + " plugin");
	    SplashWindow.incProgress(10);
	}

	super.setEnabled(plugin, newValue);
    }

    public boolean isValidPlugin(Class c)
    {
	return true;//c.isAssignableFrom(IPlugin.class);
    }

    public synchronized void installViewer(String extension, 
					   IViewerPlugin viewer)
    {
	viewers.put(extension, viewer);
    }
	
    public synchronized void installViewer(String[] extensions, 
					   IViewerPlugin viewer)
    {
	for (int i = 0; i < extensions.length; i++) {
	    installViewer(extensions[i], viewer);
	}
    }

    public synchronized void removeViewer(String extension, 
					  IViewerPlugin viewer)
    {
	if (viewers.get(extension) == viewer) {
	    viewers.remove(extension);
	}
    }
    
    public synchronized void removeViewer(String[] extensions,
					  IViewerPlugin viewer)
    {
	for (int i = 0; i < extensions.length; i++) {
	    removeViewer(extensions[i], viewer);
	}
    }

    public synchronized ViewerPanel getViewer(File f)
    {
	String ext = FileHelper.extension(f.getName());
	IViewerPlugin p = (IViewerPlugin)viewers.get(ext);
	if (p != null) {
	    return p.handle(f);
	}
	
	return null;
    }

}
