/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift;

import xnap.XNap;

import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.StatusPanel;
import xnap.gui.XNapFrame;

import xnap.plugin.IGUIPlugin;

import xnap.plugin.gift.gui.DaemonPanel;
import xnap.plugin.gift.gui.GiftPreferencesPanel;
import xnap.plugin.gift.gui.StatsPanel;
import xnap.plugin.gift.net.Engine;
import xnap.plugin.gift.net.event.OfflineEvent;
import xnap.plugin.gift.net.event.OnlineEvent;
import xnap.plugin.gift.net.event.StatsEvent;

import xnap.util.event.StatusListener;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.*;


/**
 * DOCUMENT ME!
 *
 * @author $author$
 * @version $Revision: 1.12 $
 */
public class GUIPlugin extends Plugin implements IGUIPlugin
{
    //~ Instance fields --------------------------------------------------------

    private AbstractAction connectMenu;
    private AbstractAction disconnectMenu;
	private AbstractAction shutdownMenu;    
    private DaemonPanel daemonPanel;
    private JMenu menu = null;
    private JTabbedPane giftPane;
    private StatsPanel statsPanel;
    private StatusPanel statusPanel;

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new GUIPlugin object.
     */
    public GUIPlugin()
    {
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Icon getIcon()
    {
        return XNapFrame.getBigIcon("gift.png");
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public JMenu getMenu()
    {
        if (menu == null) {
            menu = new JMenu("giFT");
        }

        return menu;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public JComponent getPanel()
    {
        return giftPane;
    }

    /**
     * @see xnap.plugin.IGUIPlugin#getPreferencesIcon()
     */
    public Icon getPreferencesIcon()
    {
        return XNapFrame.getBigIcon("gift.png");
    }

    /**
     * @see xnap.plugin.IGUIPlugin#getPrefsPanels()
     */
    public AbstractPreferencesPanel[] getPrefsPanels()
    {
        return new AbstractPreferencesPanel[] { new GiftPreferencesPanel() };
    }

    /**
     * @see xnap.plugin.IGUIPlugin#setStatusListener(xnap.util.event.StatusListener)
     */
    public void setStatusListener(StatusListener listener)
    {
        daemonPanel.setStatusListener(listener);
        statsPanel.setStatusListener(listener);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public JComponent getStatusPanel()
    {
        return statusPanel;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public AbstractPreferencesPanel getWizardPanel()
    {
        return null;
    }

    /**
     * @see xnap.plugin.gift.net.event.listener.NetworkEventListener#attached(xnap.plugin.gift.net.event.OnlineEvent)
     */
    public void attached(OnlineEvent evt)
    {
        super.attached(evt);
        connectMenu.setEnabled(false);
        disconnectMenu.setEnabled(true);
        shutdownMenu.setEnabled(true);
        statusPanel.update();
    }

    /**
     * @see xnap.plugin.gift.net.event.listener.NetworkEventListener#detached(xnap.plugin.gift.net.event.OfflineEvent)
     */
    public void detached(OfflineEvent evt)
    {
        super.detached(evt);
        connectMenu.setEnabled(true);
        disconnectMenu.setEnabled(false);
        shutdownMenu.setEnabled(false);
        statusPanel.update();
    }

    /**
     * DOCUMENT ME!
     */
    public void start()
    {
        // panel
        giftPane = new JTabbedPane();

        daemonPanel = new DaemonPanel();
        giftPane.addTab("Daemon", daemonPanel);

        statsPanel = new StatsPanel();
        giftPane.add("Statistics", statsPanel);

        // menu
        menu = getMenu();
        menu.setMnemonic(KeyEvent.VK_G);

        menu.add(new JMenuItem(connectMenu = new ConnectToGiFTAction()));
        menu.add(new JMenuItem(disconnectMenu = new DisconnectFromGiFTAction()));
		menu.add(new JMenuItem(shutdownMenu = new ShutdownGiFTAction()));
        // stats updates
        statusPanel = new StatusPanel(this);

        super.start();
    }

    /**
     * @see xnap.plugin.gift.net.event.listener.NetworkEventListener#statsUpdate(xnap.plugin.gift.net.event.StatsEvent)
     */
    public void statsUpdate(StatsEvent evt)
    {
        super.statsUpdate(evt);
        statusPanel.update();
    }

    /**
     * DOCUMENT ME!
     */
    public void stop()
    {
        // fix me

        /*
        if (daemonPanel.isRunning()) {
            int ret = JOptionPane.showConfirmDialog
                (this, "The giFT daemon is still running. Do you want "
                 + "to stop it?", "giFT daemon", JOptionPane.YES_NO_OPTION);
            if (ret == JOptionPane.YES_OPTION)
                daemonPanel.stop();
        }
        */
        super.stop();
    }

    //~ Inner Classes ----------------------------------------------------------

    public class ConnectToGiFTAction extends AbstractAction
    {
        public ConnectToGiFTAction()
        {
            putValue(Action.NAME, XNap.tr("Startup") + "...");
            putValue(Action.SHORT_DESCRIPTION, XNap.tr("Connect to giFT Server"));
        }

        public void actionPerformed(ActionEvent event)
        {
            Engine.getInstance().start();
        }
    }

    public class DisconnectFromGiFTAction extends AbstractAction
    {
        public DisconnectFromGiFTAction()
        {
            putValue(Action.NAME, XNap.tr("Disconnect") + "...");
            putValue(Action.SHORT_DESCRIPTION,
                XNap.tr("Disconnect from giFT Server"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event)
        {
            Engine.getInstance().stop();
        }
    }

	public class ShutdownGiFTAction extends AbstractAction
	{
		public ShutdownGiFTAction()
		{
			putValue(Action.NAME, XNap.tr("Shutdown") + "...");
			putValue(Action.SHORT_DESCRIPTION,
				XNap.tr("Kill giFT Server"));
			this.setEnabled(false);
		}

		public void actionPerformed(ActionEvent event)
		{
			Engine.getInstance().quitGiFT();
		}
	}

}
