/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net.event;

/**
 * OnlineEvent
 *
 * @author <a href="mailto:tvanlessen@taval.de">Tammo van Lessen</a>
 * @version CVS $Id: OnlineEvent.java,v 1.1 2003/01/15 16:17:54 squig Exp $
 */
public class OnlineEvent extends Event {
    //~ Instance fields --------------------------------------------------------

    private String server;
    private String version;

    //~ Constructors -----------------------------------------------------------

    /**
     * Constructor for OnlineEvent.
     *
     * @param server
     * @param version
     */
    public OnlineEvent(String server, String version) {
        super();
        this.server = server;
        this.version = version;
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * Returns the server.
     *
     * @return String
     */
    public String getServer() {
        return server;
    }

    /**
     * Returns the version.
     *
     * @return String
     */
    public String getVersion() {
        return version;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return server + "-" + version + "@OnlineEvent";
    }
}
