/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gnutella;

import xnap.cmdl.*;
import xnap.plugin.*;
import xnap.net.*;
import xnap.util.*;
import xnap.plugin.gnutella.util.*;
import xnap.plugin.gnutella.net.*;

import java.util.*;

public class Plugin extends AbstractPlugin
    implements INetworkPlugin, CommandLineSupport
{
    
    //--- Constant(s) ---
    
    private static final AbstractCommand[] commands = {
    };
    
    //--- Data Field(s) ---

    private static Plugin singleton;
    private static ResourceBundle resources;

    private Preferences prefs = Preferences.getInstance();
    private GnuPreferences gnuPrefs = GnuPreferences.getInstance();
    
    //--- Constructor(s) ---

    public Plugin()
    {
	singleton = this;
	resources = 
	    ResourceBundle.getBundle("xnap.plugin.gnutella.resources.gnutella",
				     Locale.getDefault());
    }

    //--- Method(s) ---

    public void closeApp()
    {
	Connections.getInstance().saveToFile(gnuPrefs.getServentsFile()); 
	Connections.getInstance().die();
    }

    public AbstractCommand[] getCommands()
    {
	return commands;
    }

    public String getDescription()
    {
	return tr("Support for the Gnutella protocol.");
    }

    public static Plugin getInstance()
    {
	return singleton;
    }

    public static final ResourceBundle getMessagesBundle()
    {
	return resources;
    }

    public String getName()
    {
	return tr("Gnutella");
    }

    public String getVersion()
    {
	return "0.1";
    }

    public int getStatus()
    {
	if (Connections.getInstance().getConnectedCount() > 0) {
	    return STATUS_GREEN;
	}
	else {
	    return STATUS_RED;
	}
    }

    public String getStatusMessage()
    {
	return Connections.getInstance().getConnectedCount() 
	    + tr("Gnutella Hosts");
    }

    public void init()
    {
	Debug.log("gnutella: init");
    }

    public ISearch[] search(SearchFilter filter, int priority)
    {
	Debug.log("gnutella: search");
	Search search =  new Search(filter, priority,
				    prefs.getMaxSearchResults());
	return new ISearch[] { search };
    }

    public void start()
    {
	Debug.log("gnutella: start" + gnuPrefs.getUseAutoconnector());
	Connections.getInstance().init();
	Connections.getInstance().setEnabled(gnuPrefs.getUseAutoconnector());
	super.start();
    }

    public void stop()
    {
	super.stop();
	Debug.log("gnutella: stop");
	Connections.getInstance().saveToFile(gnuPrefs.getServentsFile()); 
	Connections.getInstance().die();
    }
    
    public static final String tr(String text)
    {
	try {
	    return getMessagesBundle().getString(text);
	}
	catch (MissingResourceException e) {
	    return text;
	}
    }
}
