/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gnutella.gui;

import xnap.gui.*;
import xnap.plugin.gnutella.util.*;

import java.awt.*;
import javax.swing.*;

public class PreferencesPanel extends AbstractPreferencesPanel {

    //--- Data Field(s) ----

    private ValidatedTextField jteLocalPort;
    private ValidatedTextField jteMaxConnections;
    private JCheckBox jcUseAutoconnector;
    
    private GnuPreferences gnuPrefs = GnuPreferences.getInstance();
    
    //--- Constructor(s) ---

    public PreferencesPanel()
    {
	this.setLayout(new GridBagLayout());

        GridBagHelper.addLabel(this, "Local Port");
        jteLocalPort 
	    = new ValidatedTextField(gnuPrefs.getLocalPort() + "",
				     ValidatedTextField.NUMBERS_INT);
        GridBagHelper.add(this, jteLocalPort);

	GridBagHelper.addLabel(this, "");
	jcUseAutoconnector = new JCheckBox("Use Autoconnector On Startup",
					   gnuPrefs.getUseAutoconnector());
	GridBagHelper.add(this, jcUseAutoconnector);

	GridBagHelper.addLabel(this, "Autoconnector Threshold");
	jteMaxConnections = new ValidatedTextField
	    (gnuPrefs.getMaxConnections() + "", ValidatedTextField.NUMBERS_INT);
	GridBagHelper.add(this, jteMaxConnections);

	GridBagHelper.addVerticalSpacer(this);

    }

    //--- Method(s) ---

    public void apply()
    {
	gnuPrefs.setLocalPort(jteLocalPort.getIntValue());
	gnuPrefs.setUseAutoconnector(jcUseAutoconnector.isSelected());
	gnuPrefs.setMaxConnections(jteMaxConnections.getIntValue());
    }
}
