/*
 * 04/02/2001
 *
 * DataInputStream.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.io;

import java.io.InputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.EOFException;

/**
 *
 * @version 0.1 06/22/2001
 * @author Frederik Zimmer
 */

public class DataInputStream extends FilterInputStream 
{
    
    public DataInputStream(InputStream in) 
    {
	super(in);
    }

    public final byte readByte() 
	throws IOException 
    {
	int b = in.read();
	if (b < 0)
	    throw new EOFException();
	return (byte) b;
    }
    
    public final int readUByte() throws IOException
    {
	int b = in.read();
	if (b < 0) {
	    throw new EOFException();
	}
	return b & 0xff;
    }


    public final short readShort() 
	throws IOException 
    {
	InputStream in = this.in;
	int b1 = in.read();
	int b2 = in.read();
	if ((b1 | b2) < 0)
	    throw new EOFException();
	return (short)((b1 & 0xff) | ((b2 & 0xff) << 8));
    }

    public final int readUShort() throws IOException
    {
	InputStream in = this.in;
	int b1 = in.read();
	int b2 = in.read();
	if ((b1 | b2) < 0) {
	    throw new EOFException();
	}
	return ((b1 & 0xff) | ((b2 & 0xff) << 8));
    }

    public final char readChar() 
	throws IOException 
    {
	InputStream in = this.in;
	int b1 = in.read();
	int b2 = in.read();
	if ((b1 | b2) < 0)
	    throw new EOFException();
	return (char)((b1 & 0xff) | ((b2 & 0xff) << 8));
    }

    public final int readInt() 
	throws IOException 
    {
	InputStream in = this.in;
	int b1 = in.read();
	int b2 = in.read();
	int b3 = in.read();
	int b4 = in.read();
	if ((b1 | b2 | b3 | b4) < 0)
	    throw new EOFException();
	return ((b1 & 0xff) | ((b2 & 0xff) << 8) | ((b3 & 0xff) << 16) 
		| ((b4 & 0xff) << 24));
    }

    /*public final long readLong() throws IOException {
      InputStream in = this.in;
      return ((long)(readInt()) << 32) + (readInt() & 0xFFFFFFFFL);
      }*/
	
    public final void readFully(byte b[]) 
	throws IOException 
    {
	readFully(b, 0, b.length);
    }
    
    public final void readFully(byte b[], int offset, int length) 
	throws IOException 
    {
	InputStream in = this.in;
	int len = 0;
		
	while(length > offset) {
	    len = in.read(b, offset, length - offset);
	    if (len < 0) {
		throw new EOFException();
	    }
	    offset += len;	
	}
    }
}
