/*
 * 04/02/2001
 *
 * DescriptorHeader.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.net;

import xnap.util.*;
import xnap.plugin.gnutella.io.*;

import java.io.IOException;
import java.io.EOFException;



/**
 *
 * @version 0.1 09/20/2001
 * @author Frederik Zimmer
 */

public class DescriptorHeader 
{
    private static final int HEADER_LENGTH = 23;
    
    public static final byte PING 		= (byte) 0x00;
    public static final byte PONG 		= (byte) 0x01;
    public static final byte BYE 		= (byte) 0x02;
    public static final byte PUSH 		= (byte) 0x40;
    public static final byte QUERY 		= (byte) 0x80;
    public static final byte QUERY_HIT 	= (byte) 0x81;
    
    public static byte TTL = 7;
    public static byte HOPS = 0;
    
    protected GUID messageID;
    protected byte payloadDescriptor;	
    protected byte ttl;
    protected byte hops;
    protected int payloadLength;
	
    public DescriptorHeader(GUID messageID, byte payloadDescriptor, 
			    int payloadLength) 
    {
	this.messageID = messageID;
	this.payloadDescriptor = payloadDescriptor;
	ttl = TTL;
	hops = HOPS;
	this.payloadLength = payloadLength;
    }
    
    public DescriptorHeader(DataInputStream in) 
	throws IOException 
    {
	read(in);
	if (ttl + hops > TTL+3) {
	    //vielleicht fehlermeldung
	    int tmpTtl;
	    tmpTtl = (TTL+3) - hops;
	    ttl = (tmpTtl < 0) ? 0 : (byte) tmpTtl;
	}
    }
    
    public void write(DataOutputStream out) 
	throws IOException {
	out.write(messageID.getBytes());
	out.writeByte(payloadDescriptor);
	out.writeByte(ttl);
	out.writeByte(hops);
	out.writeInt(payloadLength);
    }
	
    public void read(DataInputStream in) 
	throws IOException 
    {
	
	byte[] guid = new byte[16];
	
	in.readFully(guid);
	messageID = new GUID(guid);
	payloadDescriptor = in.readByte();
	ttl = in.readByte();
	//  Debug.log("TTL " + ttl);
	hops = in.readByte();
	//  Debug.log("HOPS " + hops);
	payloadLength = in.readInt();
    }
	
    public void decrementTTL() {
	ttl--;
	hops++;
    }
    
}
