/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gnutella.net;

import xnap.util.*;
import xnap.io.*;

import java.io.*;
import java.net.*;
import java.util.*;

public class ListenerThread extends Thread {

    //--- Data field(s) ---

    private ServerSocket serverSocket;
    private int port;
    private Vector sockets = new Vector();
    private boolean die = false;
    private Object lock = new Object();

    //--- Constructor(s) ---
    
    public ListenerThread(int firstPort) 
    {
	this(firstPort, 65535);
    }

    public ListenerThread(int firstPort, int lastPort) 
    {
	int i;
	
	// bind to next free port
	serverSocket = null;
	for (i = firstPort; i <= lastPort; i++) {
	    try {
		serverSocket = new ServerSocket(i);
		break;
	    }
	    catch (IOException e) {
	    }
	}

	// could not find free port
	if (serverSocket == null) {
	    Debug.log("gnutella listener: could not create socket");
	    port = 0;
	}
	else {
	    Debug.log("gnutella listener: set socket to " + i);
	    port = i;
	}
	
	if (port > 0)
	    start();
    }
    
    //--- Method(s) ---
    
    private Socket findDownloadSocket(int index, String filename, GUID guid)
    {
	for (int i = 0; i < sockets.size(); i++)
	    {
		DownloadSocket s = (DownloadSocket)sockets.elementAt(i);
		if (s.equals(index, filename, guid))
		    {
			sockets.removeElementAt(i);
			return s.socket;
		    }
	    }
	return null;
    }
    
    public void die() 
    {
        die = true;
    }
    
    public int getPort()
    {
	return port;
    }


    private void handleSocket(Socket s)
    {
	InputStream in = null;
	OutputStream out = null;

	try {
	    in = s.getInputStream();
	    out = s.getOutputStream();

	    Debug.log("gnutella: incoming connect to listener");
		      

	    ReadLineReader rlr = new ReadLineReader(in);

	    String response = rlr.readLine();

	    if (response == null)
		return;

	    Debug.log("response: " + response);
	    
	    if (response.indexOf("GNUTELLA") != -1) {
		Connections.getInstance().addServent(response, s);
	    }
	    else if (response.indexOf("GET") != -1) {
		//  Upload u = new Upload(s, response);
		//  		UploadQueue.getInstance().add(u);
	    }
	    else if (response.indexOf("GIV") != -1) {
		/* GIV 583:585A824E58A93E5BFFFD1C1D5BAD8D00/Comedy - Jerry Seinfeld - Classic Lines from Seinfeld (all characters).mp3 */
		StringTokenizer t = new StringTokenizer(response, " :/");
		
		if (t.countTokens() < 4) {
		    Debug.log("gnutella: firewalled download failed");
		    throw (new IOException());
		}
		
		/* skip "GIV" */
		t.nextToken();
		
		int index;
		try {
		    index = Integer.parseInt(t.nextToken());
		}
		catch (NumberFormatException e) {
		    Debug.log(e);
		    throw (new IOException());
		}    
		
		GUID guid;
		try {
		    guid = GUID.parseGUID(t.nextToken());
		}
		catch (NumberFormatException e) {
		    Debug.log(e);
		    throw (new IOException());
		}
		
		
		t = new StringTokenizer(response, "/");
		t.nextToken();

		String filename  = t.nextToken();

		/* read additional \n */
		rlr.readLine();

		sockets.addElement(new DownloadSocket(s, index, filename, 
						      guid));
		synchronized (lock) {
		    lock.notifyAll();
		}
	    }
	} 
	catch (IOException e) {
	    Debug.log("gnutella listener: invalid request");
	    try {
		if (in != null)
		    in.close();
		if (out != null)
		    out.close();
		if (s != null)
		    s.close();
	    }
	    catch (IOException e2) {
	    }
	}
    }

    public void run() 
    {
	try {
	    serverSocket.setSoTimeout(1000);
	}
	catch(SocketException e) {
	}

        while(!die) {
	    Socket socket = null;
	    try {
		socket = serverSocket.accept();
	    } catch(IOException e) {
		continue;
	    }
	    
	    if (socket != null)
		handleSocket(socket);
	}
	
	try {
	    serverSocket.close();
	} 
	catch(IOException e) {
	}
	port = 0;
    }

    public Socket waitForDownloadSocket(int index, String filename, 
					GUID guid, long timeout)
    {
	Socket s;

	if ((s = findDownloadSocket(index, filename, guid)) != null)
	    return s;

	long startTime = System.currentTimeMillis();
	while (System.currentTimeMillis() - startTime < timeout)
	    {		
		synchronized (lock) {
		    try {
			lock.wait(timeout);
		    } catch (InterruptedException e) {
		    }
		}

		if ((s = findDownloadSocket(index, filename, guid)) != null)
		    return s;
	    }
	
	return null;
    }
}
