/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/**
 * If you hack around, make sure all pathes are returned with a trailing
 * file separator and all values are initialized to something other than
 * null.
 *
 * Most important, keep all preferences sorted alphabetically everywhere.
 */
package xnap.plugin.gnutella.util;

import xnap.XNap;
import xnap.util.*;

public class GnuPreferences extends PluginPreferencesSupport {

    //--- Data field(s) ---

    private static GnuPreferences singleton = null;

    //--- Constructor(s) ---

    private GnuPreferences()
    {
	super("plugin.gnutella");

	setDefault("cleanDisconnected", "true");
	setDefault("localPort", "6346");
	setDefault("maxConnections", "8");
	setDefault("serventsFile", "gnutella-hosts");
	setDefault("useAutoconnector", "true");
    }

    //--- Method(s) ---

    public static synchronized GnuPreferences getInstance()
    {
	if (singleton == null) {
	    singleton = new GnuPreferences();
	}

	return singleton;
    }

    public void destroy() {
	singleton = null;
    }

    public boolean getCleanDisconnected() {
	return getBoolean("cleanDisconnected");
    }

    public void setCleanDisconnected(boolean newValue) {
	set("cleanDisconnected", newValue);
    }
    
    public int getLocalPort() {
        return getInt("localPort");
    }

    public void setLocalPort(int newValue) {
	set("localPort", newValue);
    }

    public int getMaxConnections()
    {
	return getInt("maxConnections");
    }

    public void setMaxConnections(int newValue)
    {
	set("maxConnections", newValue);
    }

    public String getServentsFile() {
	return FileHelper.getHomeDir() + "gnutella-hosts";
    }

    public boolean getUseAutoconnector() {
	return getBoolean("useAutoconnector");
    }

    public void setUseAutoconnector(boolean newValue) {
	set("useAutoconnector", newValue);
    }
}
